/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plancalc.source.loadhandler.impl;

import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.ReduceGroupFunctionWithCollector;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.plancalc.algo.PlanDataSplitReduceGroupFunction;
import kd.mmc.mds.common.plancalc.source.loadhandler.LoadDataHandler;

public class VrdsLoadDataHandler
implements LoadDataHandler {
    private final Object sourcenameId;
    private final Date outlookDate;
    private final List<String> extFields;
    private boolean splitDay;

    public VrdsLoadDataHandler(Object sourcenameId, Date outlookDate, List<String> extFields) {
        this.sourcenameId = sourcenameId;
        this.outlookDate = outlookDate;
        this.extFields = extFields;
    }

    @Override
    public DataSetX loadData(JobSession session) {
        DynamicObject vrds;
        String cytype;
        QFilter qFilter = new QFilter("fcvrnnum", "=", this.sourcenameId);
        qFilter.and(new QFilter("detailentity.datenode", "<=", (Object)this.outlookDate));
        String sql = "id,detailentity.materialid as fmaterialid,detailentity.baseunit as fbaseunitid,detailentity.datenode as fdatenode,detailentity.fcqty as ffcqty,detailentity.prodorg as fprodorg,detailentity.baseunit.precision as fprecision,detailentity.baseunit.precisionaccount as fprecisionaccount";
        if (this.extFields != null && !this.extFields.isEmpty()) {
            String extFieldSql = String.join((CharSequence)",", this.extFields);
            sql = sql.concat(",").concat(extFieldSql);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"sourceVrdsData", (String)"mds_data", (String)sql, (QFilter[])new QFilter[]{qFilter}, null);
        if (this.isSplitDay() && ("1".equals(cytype = (vrds = BusinessDataServiceHelper.loadSingle((Object)this.sourcenameId, (String)"mds_vrds", (String)"cytype")).getString("cytype")) || "3".equals(cytype))) {
            RowMeta rowMeta = dataSet.getRowMeta();
            dataSet = dataSet.reduceGroup((ReduceGroupFunctionWithCollector)new PlanDataSplitReduceGroupFunction(rowMeta, cytype));
        }
        DataSetInput dataSetInput = new DataSetInput(dataSet);
        return session.fromInput((Input)dataSetInput);
    }

    public boolean isSplitDay() {
        return this.splitDay;
    }

    public void setSplitDay(boolean splitDay) {
        this.splitDay = splitDay;
    }
}

