/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plandata;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.validate.BillStatus;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.operate.MutexHelper;
import kd.bos.list.IListView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.plandata.PlanDataFieldsSetter;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;

public class FCPlanDataHelper {
    public static Object createPlanData(DynamicObject multiData, StringBuilder msg) {
        if (multiData == null) {
            msg.append(ResManager.loadKDString((String)"\u521b\u5efa\u5355\u636e\u5931\u8d25\uff0c\u5b50\u5355\u636e\u4e3a\u7a7a\u3002", (String)"FCPlanDataHelper_0", (String)"mmc-mds-common", (Object[])new Object[0]));
            return null;
        }
        DynamicObject version = multiData.getDynamicObject("fcvrnnum");
        if (version == null) {
            msg.append(ResManager.loadKDString((String)"\u521b\u5efa\u5355\u636e\u5931\u8d25\uff0c\u7248\u672c\u4e3a\u7a7a\u3002", (String)"FCPlanDataHelper_1", (String)"mmc-mds-common", (Object[])new Object[0]));
            return null;
        }
        QFilter filter = new QFilter("fcvrnnum", "=", version.getPkValue());
        DynamicObject mds_plandata = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)"id,billstatus", (QFilter[])new QFilter[]{filter});
        boolean mutex = MutexHelper.require((String)"mds_vrds", (Object)version.getPkValue(), (String)"importdata", (boolean)true, (StringBuilder)msg);
        if (!mutex) {
            StringBuilder sb2 = FCPlanDataHelper.getCreateErrMsg(version);
            msg.setLength(0);
            msg.append((CharSequence)sb2);
            return null;
        }
        if (mds_plandata == null) {
            mds_plandata = BusinessDataServiceHelper.newDynamicObject((String)"mds_plandata");
            mds_plandata.set("fcvrnnum", (Object)version);
            mds_plandata.set("billno", version.get("number"));
            mds_plandata.set("invaldate", multiData.get("invaldate"));
            mds_plandata.set("org", multiData.get("org"));
            mds_plandata.set("billstatus", multiData.get("billstatus"));
            mds_plandata.set("enablestatus", multiData.get("enablestatus"));
            mds_plandata.set("creator", multiData.get("creator"));
            mds_plandata.set("createtime", multiData.get("createtime"));
            mds_plandata.set("modifier", multiData.get("modifier"));
            mds_plandata.set("modifytime", multiData.get("modifytime"));
            mds_plandata.set("billno", multiData.get("billno"));
            FCPlanDataHelper.addDateentity2Target(multiData.getDynamicObjectCollection("dateentity"), mds_plandata);
            FCPlanDataHelper.validateParentDateEntity(mds_plandata);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mds_plandata});
        } else {
            String parentBillstatus = mds_plandata.getString("billstatus");
            if (!"A".equals(parentBillstatus)) {
                msg.append(ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u5df2\u63d0\u4ea4\uff0c\u65e0\u6cd5\u4fdd\u5b58\u3002", (String)"FCPlanDataHelper_2", (String)"mmc-mds-common", (Object[])new Object[0]));
                MutexHelper.release((String)"mds_vrds", (String)"importdata", (String)String.valueOf(version.getPkValue()));
                return null;
            }
            if (FCPlanDataHelper.isChangeParentDate(multiData, mds_plandata.getPkValue())) {
                FCPlanDataHelper.overrideParentDateEntry(multiData, mds_plandata.getPkValue());
            }
        }
        MutexHelper.release((String)"mds_vrds", (String)"importdata", (String)String.valueOf(version.getPkValue()));
        return mds_plandata.getPkValue();
    }

    public static StringBuilder getCreateErrMsg(DynamicObject vrds) {
        String fcvrnnum = vrds.getString("number");
        StringBuilder sb = new StringBuilder();
        DynamicObject[] locks = FCPlanDataHelper.getDataLocks(vrds.get("id"), "mds_vrds", "importdata");
        if (locks != null && locks.length > 0) {
            DynamicObject lock = locks[0];
            String userName = lock.getString("user.name");
            sb.append(String.format(ResManager.loadKDString((String)"\u7528\u6237%1$s\u6b63\u5728\u521b\u5efa\u7248\u672c\u7f16\u7801\u4e3a'%2$s'\u7684\u5355\u636e\uff0c\u8bf7\u7a0d\u540e\u518d\u64cd\u4f5c\u3002", (String)"FCPlanDataHelper_15", (String)"mmc-mds-common", (Object[])new Object[0]), userName, fcvrnnum));
        }
        return sb;
    }

    public static Object createChildPlanData(Object versionPk, Object creatorId) {
        return FCPlanDataHelper.createChildPlanData(versionPk, creatorId, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object createChildPlanData(Object versionPk, Object creatorId, DynamicObject parentPlandata) {
        if (versionPk == null) {
            return null;
        }
        if (creatorId instanceof String) {
            creatorId = Long.valueOf((String)creatorId);
        }
        QFilter filter = new QFilter("fcvrnnum", "=", versionPk);
        QFilter filter2 = new QFilter("creator", "=", creatorId);
        DLock dLock = DLock.create((String)(versionPk + "_createChildPlanData"));
        dLock.lock();
        try {
            DynamicObject childPlandata;
            if (parentPlandata == null) {
                DynamicObject parentPlandataId = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)"id", (QFilter[])new QFilter[]{filter});
                if (parentPlandataId == null) {
                    Object var7_7 = null;
                    return var7_7;
                }
                parentPlandata = BusinessDataServiceHelper.loadSingle((Object)parentPlandataId.getPkValue(), (String)"mds_plandata");
            }
            if ((childPlandata = BusinessDataServiceHelper.loadSingle((String)"mds_mdsplandatamulti", (String)"id", (QFilter[])new QFilter[]{filter, filter2})) == null) {
                DynamicObject data = BusinessDataServiceHelper.newDynamicObject((String)"mds_mdsplandatamulti");
                data.set("fcvrnnum", parentPlandata.get("fcvrnnum"));
                data.set("invaldate", parentPlandata.get("invaldate"));
                data.set("org", parentPlandata.get("org"));
                data.set("billstatus", (Object)"A");
                data.set("enablestatus", (Object)"A");
                data.set("creator", creatorId);
                data.set("createtime", (Object)new Date());
                data.set("modifier", creatorId);
                data.set("modifytime", (Object)new Date());
                data.set("billno", parentPlandata.get("billno"));
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{data});
                Object object = data.getPkValue();
                return object;
            }
            Object object = childPlandata.getPkValue();
            return object;
        }
        finally {
            dLock.unlock();
        }
    }

    public static DynamicObjectCollection loadParentDateentity(Object vrn) {
        if (vrn instanceof DynamicObject) {
            Object pk = ((DynamicObject)vrn).getPkValue();
            QFilter filter = new QFilter("fcvrnnum", "=", pk);
            filter.and("id", "!=", (Object)0);
            DynamicObject mds_plandataquery = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)"id", (QFilter[])new QFilter[]{filter});
            if (mds_plandataquery != null) {
                DynamicObject mds_plandata = BusinessDataServiceHelper.loadSingle((Object)mds_plandataquery.getPkValue(), (String)"mds_plandata");
                return mds_plandata.getDynamicObjectCollection("dateentity");
            }
        }
        return null;
    }

    public static boolean isChangeParentDate(DynamicObject multiData, Object plandataPk) {
        Date date;
        String field;
        DynamicObject mds_plandataObj = BusinessDataServiceHelper.loadSingle((Object)plandataPk, (String)"mds_plandata");
        FCPlanDataHelper.validateParentDateEntity(mds_plandataObj);
        DynamicObjectCollection childDateentity = multiData.getDynamicObjectCollection("dateentity");
        DynamicObjectCollection parentDateentity = mds_plandataObj.getDynamicObjectCollection("dateentity");
        if (childDateentity == null || childDateentity.isEmpty()) {
            return false;
        }
        if (parentDateentity == null || parentDateentity.isEmpty()) {
            return true;
        }
        if (childDateentity.size() > parentDateentity.size()) {
            return true;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, String> parentDateentityMap = new HashMap<String, String>(32);
        for (DynamicObject entity : parentDateentity) {
            field = entity.getString("fieldkey");
            date = entity.getDate("targetdate");
            parentDateentityMap.put(field, sdf.format(date));
        }
        for (DynamicObject entity : childDateentity) {
            String parentDateStr;
            field = entity.getString("fieldkey");
            date = entity.getDate("targetdate");
            String dateStr = sdf.format(date);
            if (StringUtils.equals((CharSequence)dateStr, (CharSequence)(parentDateStr = (String)parentDateentityMap.get(field)))) continue;
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void overrideParentDateEntry(DynamicObject multiData, Object parentPkValue) {
        DynamicObject mds_plandataObj = BusinessDataServiceHelper.loadSingle((Object)parentPkValue, (String)"mds_plandata");
        DynamicObjectCollection childDateentity = multiData.getDynamicObjectCollection("dateentity");
        DynamicObjectCollection parentDateentity = mds_plandataObj.getDynamicObjectCollection("dateentity");
        DynamicObjectCollection entryentity = mds_plandataObj.getDynamicObjectCollection("entryentity");
        if (parentDateentity == null || childDateentity == null) {
            return;
        }
        if (childDateentity.isEmpty()) {
            return;
        }
        if (parentDateentity.isEmpty()) {
            FCPlanDataHelper.addDateentity2Target(childDateentity, mds_plandataObj);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mds_plandataObj});
            return;
        }
        HashSet<String> allQty = new HashSet<String>(256);
        DataEntityPropertyCollection properties = entryentity.getDynamicObjectType().getProperties();
        for (IDataEntityProperty property : properties) {
            String field = property.getName();
            if (!field.startsWith("qty")) continue;
            allQty.add(field);
        }
        HashSet<String> allDataStr = new HashSet<String>(256);
        HashMap<Object, String> parentDateentityFieldRelDateMap = new HashMap<Object, String>(32);
        HashMap<String, Object> parentDateentityDateRelFieldMap = new HashMap<String, Object>(32);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        for (DynamicObject entity : parentDateentity) {
            String field = entity.getString("fieldkey");
            Date date = entity.getDate("targetdate");
            String dateStr = sdf.format(date);
            parentDateentityFieldRelDateMap.put(field, dateStr);
            parentDateentityDateRelFieldMap.put(dateStr, field);
            allDataStr.add(dateStr);
            allQty.remove(field);
        }
        HashMap<String, String> childDateentityDateRelFieldMap = new HashMap<String, String>(32);
        HashMap<String, DynamicObject> childDateentityDateRelDynMap = new HashMap<String, DynamicObject>(32);
        for (DynamicObject entity : childDateentity) {
            String field = entity.getString("fieldkey");
            Date date = entity.getDate("targetdate");
            String dateStr = sdf.format(date);
            childDateentityDateRelFieldMap.put(dateStr, field);
            childDateentityDateRelDynMap.put(dateStr, entity);
            allDataStr.add(dateStr);
        }
        DynamicObjectCollection addDateentity = new DynamicObjectCollection(parentDateentity.getDynamicObjectType(), (Object)mds_plandataObj);
        HashMap<String, String> childEntryentityChangeMap = new HashMap<String, String>(32);
        if (allDataStr.size() > 150) {
            throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u8f74\u8d85\u8fc7150\u5217\u3002", (String)"FCPlanDataHelper_6", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        for (String dateStr : allDataStr) {
            String childField;
            String parentField = (String)parentDateentityDateRelFieldMap.get(dateStr);
            if (StringUtils.equals((CharSequence)parentField, (CharSequence)(childField = (String)childDateentityDateRelFieldMap.get(dateStr)))) continue;
            if (parentField == null) {
                DynamicObject oldDateentity = (DynamicObject)childDateentityDateRelDynMap.get(dateStr);
                DynamicObject newdate = FCPlanDataHelper.createNewDate(oldDateentity, parentDateentity.getDynamicObjectType());
                String fieldkey = newdate.getString("fieldkey");
                String parentDate = (String)parentDateentityFieldRelDateMap.get(fieldkey);
                if (parentDate != null) {
                    Iterator it = allQty.iterator();
                    if (!it.hasNext()) throw new KDBizException(ResManager.loadKDString((String)"\u65f6\u95f4\u8f74\u8d85\u8fc7150\u5217\u3002", (String)"FCPlanDataHelper_6", (String)"mmc-mds-common", (Object[])new Object[0]));
                    parentField = (String)it.next();
                    childEntryentityChangeMap.put(childField, parentField);
                    newdate.set("fieldkey", (Object)parentField);
                    it.remove();
                    parentDateentityFieldRelDateMap.put(parentField, dateStr);
                    parentDateentityDateRelFieldMap.put(dateStr, parentField);
                } else {
                    allQty.remove(childField);
                    parentDateentityFieldRelDateMap.put(childField, dateStr);
                    parentDateentityDateRelFieldMap.put(dateStr, childField);
                }
                addDateentity.add((Object)newdate);
                continue;
            }
            if (childField == null) continue;
            childEntryentityChangeMap.put(childField, parentField);
        }
        FCPlanDataHelper.addDateentity2Target(addDateentity, mds_plandataObj);
        FCPlanDataHelper.overrideChildEntryentity(childEntryentityChangeMap, multiData);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mds_plandataObj});
    }

    private static void overrideChildEntryentity(Map<String, String> childEntryentityChangeMap, DynamicObject multiData) {
        DynamicObjectCollection entryentity = multiData.getDynamicObjectCollection("entryentity");
        DataEntityPropertyCollection properties = entryentity.getDynamicObjectType().getProperties();
        for (DynamicObject entry : entryentity) {
            String sourceField;
            HashMap<String, Object> oldFieldRelVal = new HashMap<String, Object>(256);
            for (IDataEntityProperty property : properties) {
                String field = property.getName();
                Object val = entry.get(field);
                oldFieldRelVal.put(field, val);
            }
            Set<Map.Entry<String, String>> entrySet = childEntryentityChangeMap.entrySet();
            for (Map.Entry<String, String> e : entrySet) {
                sourceField = e.getKey();
                entry.set(sourceField, (Object)0);
            }
            for (Map.Entry<String, String> e : entrySet) {
                sourceField = e.getKey();
                String targetField = e.getValue();
                Object val = oldFieldRelVal.get(sourceField);
                entry.set(targetField, val);
            }
        }
    }

    public static void addDateentity2Target(DynamicObjectCollection addDateentity, DynamicObject targetObj) {
        DynamicObjectCollection targrtDateentity = targetObj.getDynamicObjectCollection("dateentity");
        for (DynamicObject date : addDateentity) {
            DynamicObject newdate = FCPlanDataHelper.createNewDate(date, targrtDateentity.getDynamicObjectType());
            targrtDateentity.add((Object)newdate);
        }
        targetObj.set("dateentity", (Object)targrtDateentity);
        FCPlanDataHelper.validateParentDateEntity(targetObj);
    }

    private static void validateParentDateEntity(DynamicObject parentObj) {
        DynamicObjectCollection parentDateentity = parentObj.getDynamicObjectCollection("dateentity");
        DynamicObject version = parentObj.getDynamicObject("fcvrnnum");
        HashSet<String> fieldSet = new HashSet<String>(128);
        HashSet<String> failSet = new HashSet<String>(128);
        for (DynamicObject date : parentDateentity) {
            String fieldkey = date.getString("fieldkey");
            if (fieldSet.add(fieldkey)) continue;
            failSet.add(fieldkey);
        }
        if (!failSet.isEmpty()) {
            MutexHelper.release((String)"mds_vrds", (String)"importdata", (String)(version.getPkValue() + ""));
            throw new KDBizException(String.format(ResManager.loadKDString((String)"%s\u65f6\u95f4\u8f74\u6784\u5efa\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u521b\u5efa\u5355\u636e\u3002", (String)"FCPlanDataHelper_12", (String)"mmc-mds-common", (Object[])new Object[0]), failSet));
        }
    }

    public static DynamicObject createNewDate(DynamicObject oldDateentity, DynamicObjectType dynamicObjectType) {
        DynamicObject newdate = new DynamicObject(dynamicObjectType);
        Object id = oldDateentity.getPkValue();
        String fieldkey = oldDateentity.getString("fieldkey");
        Date targetdate = oldDateentity.getDate("targetdate");
        Boolean deliverycolumn = oldDateentity.getBoolean("deliverycolumn");
        newdate.set("id", id);
        newdate.set("fieldkey", (Object)fieldkey);
        newdate.set("targetdate", (Object)targetdate);
        newdate.set("deliverycolumn", (Object)deliverycolumn);
        return newdate;
    }

    public static DynamicObject clearHistoryDate(DynamicObject plandata) {
        Date now = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(now);
        DynamicObject fcvrnnum = plandata.getDynamicObject("fcvrnnum");
        fcvrnnum = BusinessDataServiceHelper.loadSingle((Object)fcvrnnum.getPkValue(), (String)"mds_vrds");
        String cytype = fcvrnnum.getString("cytype");
        if ("1".equals(cytype)) {
            calendar.add(5, -56);
        } else if ("3".equals(cytype)) {
            calendar.add(2, -8);
        } else {
            calendar.add(5, -8);
        }
        Date before7days = calendar.getTime();
        if (plandata != null) {
            DynamicObjectCollection dateentity = plandata.getDynamicObjectCollection("dateentity");
            DynamicObjectCollection entryentity = plandata.getDynamicObjectCollection("entryentity");
            Iterator it = dateentity.iterator();
            while (it.hasNext()) {
                DynamicObject dateEntry = (DynamicObject)it.next();
                boolean deliverycolumn = dateEntry.getBoolean("deliverycolumn");
                if (deliverycolumn) continue;
                Date date = dateEntry.getDate("targetdate");
                String fieldkey = dateEntry.getString("fieldkey");
                if (before7days.getTime() <= date.getTime()) continue;
                boolean delete = true;
                for (DynamicObject entry : entryentity) {
                    BigDecimal val = entry.getBigDecimal(fieldkey);
                    if (val.compareTo(BigDecimal.ZERO) <= 0) continue;
                    delete = false;
                }
                if (!delete) continue;
                it.remove();
            }
        }
        return plandata;
    }

    public static void clearHistoryDateAndSave(Object vrn) {
        if (vrn instanceof DynamicObject) {
            Object pk = ((DynamicObject)vrn).getPkValue();
            QFilter filter = new QFilter("fcvrnnum", "=", pk);
            filter.and("id", "!=", (Object)0);
            DynamicObject mds_plandataquery = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)"id", (QFilter[])new QFilter[]{filter});
            if (mds_plandataquery != null) {
                DynamicObject mds_plandata = BusinessDataServiceHelper.loadSingle((Object)mds_plandataquery.getPkValue(), (String)"mds_plandata");
                FCPlanDataHelper.clearHistoryDate(mds_plandata);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{mds_plandata});
            }
        }
    }

    public static boolean checkIsDataLock(Object dataId, String entityNumber, String operationKey) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("objectid", "=", dataId));
        qFilters.add(new QFilter("entitykey", "=", (Object)entityNumber));
        qFilters.add(new QFilter("operationkey", "=", (Object)operationKey));
        boolean exists = QueryServiceHelper.exists((String)"bos_datalock", (QFilter[])qFilters.toArray(new QFilter[0]));
        return exists;
    }

    public static DynamicObject[] getDataLocks(Object dataId, String entityNumber, String operationKey) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        qFilters.add(new QFilter("objectid", "=", (Object)String.valueOf(dataId)));
        qFilters.add(new QFilter("entitykey", "=", (Object)entityNumber));
        qFilters.add(new QFilter("operationkey", "=", (Object)operationKey));
        return BusinessDataServiceHelper.load((String)"bos_datalock", (String)"user,entitykey,objectid", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static List<String> getUniqueFieldList(Object fcvrnnumPk, boolean isParent) {
        ArrayList<String> list = new ArrayList<String>(16);
        DynamicObject mds_vrds = BusinessDataServiceHelper.loadSingleFromCache((Object)fcvrnnumPk, (String)"mds_vrds");
        if (mds_vrds != null) {
            String inputcontrol = mds_vrds.getString("inputcontrol");
            String vertype = mds_vrds.getString("vertype");
            List<String> uniqueKey = PlanDataFieldsSetter.getUniqueKey(mds_vrds.getString("vertype"));
            if (FCPlanDataHelper.checkDefault(inputcontrol, vertype)) {
                list.addAll(uniqueKey);
                if (isParent) {
                    list.add("edituser");
                }
            } else {
                if (StringUtils.isEmpty((CharSequence)inputcontrol)) {
                    list.addAll(uniqueKey);
                    if (isParent) {
                        list.add("edituser");
                    }
                    return list;
                }
                if ("no".equals(inputcontrol)) {
                    return list;
                }
                if ("material_org".equals(inputcontrol)) {
                    list.addAll(uniqueKey);
                    if (isParent) {
                        list.add("edituser");
                    }
                    return list;
                }
                if ("material".equals(inputcontrol)) {
                    list.add("material");
                    if (isParent) {
                        list.add("edituser");
                    }
                    return list;
                }
            }
        }
        return list;
    }

    private static boolean checkDefault(String inputcontrol, String vertype) {
        boolean flag = true;
        if (StringUtils.isEmpty((CharSequence)inputcontrol)) {
            return flag;
        }
        if ("0".equals(vertype)) {
            if (!"material".equals(inputcontrol)) {
                flag = false;
            }
        } else if (!"material_org".equals(inputcontrol)) {
            flag = false;
        }
        return flag;
    }

    public static DynamicObject[] getDatasLocks(List<Object> dataIds, String entityNumber, String operationKey) {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(3);
        if (dataIds != null && !dataIds.isEmpty()) {
            LinkedList<Object> dataStrIds = new LinkedList<Object>();
            for (Object dataId : dataIds) {
                dataStrIds.add(dataId + "");
            }
            dataIds = dataStrIds;
        }
        qFilters.add(new QFilter("objectid", "in", dataIds));
        qFilters.add(new QFilter("entitykey", "=", (Object)entityNumber));
        qFilters.add(new QFilter("operationkey", "=", (Object)operationKey));
        return BusinessDataServiceHelper.load((String)"bos_datalock", (String)"user,entitykey,objectid", (QFilter[])qFilters.toArray(new QFilter[0]));
    }

    public static String translateFiled(String field) {
        if ("material.number".equals(field)) {
            return ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"FCPlanDataHelper_8", (String)"mmc-mds-common", (Object[])new Object[0]);
        }
        if ("prodorg.number".equals(field)) {
            return ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7", (String)"FCPlanDataHelper_9", (String)"mmc-mds-common", (Object[])new Object[0]);
        }
        if ("edituser.number".equals(field)) {
            return ResManager.loadKDString((String)"\u5f55\u5165\u4eba", (String)"FCPlanDataHelper_10", (String)"mmc-mds-common", (Object[])new Object[0]);
        }
        if ("configid.id".equals(field)) {
            return ResManager.loadKDString((String)"\u914d\u7f6e\u53f7", (String)"FCPlanDataHelper_14", (String)"mmc-mds-common", (Object[])new Object[0]);
        }
        return "";
    }

    public static String checkUnique(Object fcvrnnumPk, DynamicObjectCollection entryentity, boolean isParent) {
        List<String> uniqueFieldList = FCPlanDataHelper.getUniqueFieldList(fcvrnnumPk, isParent);
        HashSet<String> uniqueSet = new HashSet<String>();
        HashSet<String> repeatSet = new HashSet<String>();
        if (uniqueFieldList.isEmpty()) {
            return "";
        }
        for (DynamicObject entry : entryentity) {
            StringBuilder keySb = new StringBuilder();
            for (String field : uniqueFieldList) {
                DynamicProperty property = entry.getDynamicObjectType().getProperty(field);
                String filedVal = entry.getString(field);
                if (property instanceof FlexProp) {
                    filedVal = entry.getString(field + ".value");
                } else if (property instanceof BasedataProp) {
                    try {
                        filedVal = entry.getString(field + ".number");
                        if (StringUtils.isBlank((CharSequence)filedVal)) {
                            filedVal = entry.getString(field + ".id");
                        }
                    }
                    catch (Exception e) {
                        filedVal = entry.getString(field + ".id");
                    }
                }
                String cName = property.getDisplayName().toString();
                keySb.append(cName).append(":'").append(filedVal).append("' ");
            }
            String key = keySb.toString();
            if (uniqueSet.add(key)) continue;
            repeatSet.add(key);
        }
        if (!repeatSet.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"%s\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FCPlanDataHelper_13", (String)"mmc-mds-common", (Object[])new Object[0]), ((Object)repeatSet).toString());
        }
        return "";
    }

    public static void changeConfirmationStatus(Object id, IFormView view) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mds_plandata");
        String billstatus = dynamicObject.getString("billstatus");
        if (StringUtils.equals((CharSequence)billstatus, (CharSequence)BillStatus.C.name())) {
            dynamicObject.set("billstatus", (Object)BillStatus.A.name());
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{dynamicObject});
            if (view instanceof IListView) {
                ((IListView)view).refresh();
            }
        }
        PlanDataToFcDataTranUtil.tranPlanDataToFcDataStatus(dynamicObject.getDynamicObject("fcvrnnum").getString("number"));
    }

    public static void clearOtherData(DynamicObject dynamicObject) {
        DynamicObjectCollection entryentity;
        if (dynamicObject != null && (entryentity = dynamicObject.getDynamicObjectCollection("entryentity")) != null) {
            DataEntityPropertyCollection properties = entryentity.getDynamicObjectType().getProperties();
            HashSet<String> fieldNameSet = new HashSet<String>(16);
            fieldNameSet.add("level0");
            fieldNameSet.add("level1");
            fieldNameSet.add("level2");
            fieldNameSet.add("level3");
            fieldNameSet.add("level4");
            fieldNameSet.add("summary");
            fieldNameSet.add("hisqty1");
            fieldNameSet.add("hisqty2");
            fieldNameSet.add("hisqty3");
            fieldNameSet.add("hisqty4");
            fieldNameSet.add("hisqty5");
            fieldNameSet.add("hisqty6");
            fieldNameSet.add("hisqty7");
            fieldNameSet.add("hisqty8");
            fieldNameSet.add("hisqty9");
            LinkedList<IDataEntityProperty> proList = new LinkedList<IDataEntityProperty>();
            for (IDataEntityProperty pro : properties) {
                if (!fieldNameSet.contains(pro.getName())) continue;
                proList.add(pro);
            }
            for (DynamicObject entry : entryentity) {
                for (IDataEntityProperty pro : proList) {
                    if (!(pro instanceof ISimpleProperty)) continue;
                    entry.getDataEntityState().setDirty((ISimpleProperty)pro, false);
                }
            }
        }
    }

    public static List<String> getEntryEntityFieldKeys() {
        LinkedList<String> entryEntityFieldKeys = new LinkedList<String>();
        entryEntityFieldKeys.add("entryentity.material");
        entryEntityFieldKeys.add("entryentity.baseunit");
        entryEntityFieldKeys.add("entryentity.prodorg");
        entryEntityFieldKeys.add("entryentity.plangp");
        entryEntityFieldKeys.add("entryentity.remark");
        entryEntityFieldKeys.add("entryentity.qty1");
        entryEntityFieldKeys.add("entryentity.qty2");
        entryEntityFieldKeys.add("entryentity.qty3");
        entryEntityFieldKeys.add("entryentity.qty4");
        entryEntityFieldKeys.add("entryentity.qty5");
        entryEntityFieldKeys.add("entryentity.qty6");
        entryEntityFieldKeys.add("entryentity.qty7");
        entryEntityFieldKeys.add("entryentity.qty8");
        entryEntityFieldKeys.add("entryentity.qty9");
        entryEntityFieldKeys.add("entryentity.qty10");
        entryEntityFieldKeys.add("entryentity.qty11");
        entryEntityFieldKeys.add("entryentity.qty12");
        entryEntityFieldKeys.add("entryentity.qty13");
        entryEntityFieldKeys.add("entryentity.qty14");
        entryEntityFieldKeys.add("entryentity.qty15");
        entryEntityFieldKeys.add("entryentity.qty16");
        entryEntityFieldKeys.add("entryentity.qty17");
        entryEntityFieldKeys.add("entryentity.qty18");
        entryEntityFieldKeys.add("entryentity.qty19");
        entryEntityFieldKeys.add("entryentity.qty20");
        entryEntityFieldKeys.add("entryentity.qty21");
        entryEntityFieldKeys.add("entryentity.qty22");
        entryEntityFieldKeys.add("entryentity.qty23");
        entryEntityFieldKeys.add("entryentity.qty24");
        entryEntityFieldKeys.add("entryentity.qty25");
        entryEntityFieldKeys.add("entryentity.qty26");
        entryEntityFieldKeys.add("entryentity.qty27");
        entryEntityFieldKeys.add("entryentity.qty28");
        entryEntityFieldKeys.add("entryentity.qty29");
        entryEntityFieldKeys.add("entryentity.qty30");
        entryEntityFieldKeys.add("entryentity.qty31");
        entryEntityFieldKeys.add("entryentity.qty32");
        entryEntityFieldKeys.add("entryentity.qty33");
        entryEntityFieldKeys.add("entryentity.qty34");
        entryEntityFieldKeys.add("entryentity.qty35");
        entryEntityFieldKeys.add("entryentity.qty36");
        entryEntityFieldKeys.add("entryentity.qty37");
        entryEntityFieldKeys.add("entryentity.qty38");
        entryEntityFieldKeys.add("entryentity.qty39");
        entryEntityFieldKeys.add("entryentity.qty40");
        entryEntityFieldKeys.add("entryentity.qty41");
        entryEntityFieldKeys.add("entryentity.qty42");
        entryEntityFieldKeys.add("entryentity.qty43");
        entryEntityFieldKeys.add("entryentity.qty44");
        entryEntityFieldKeys.add("entryentity.qty45");
        entryEntityFieldKeys.add("entryentity.qty46");
        entryEntityFieldKeys.add("entryentity.qty47");
        entryEntityFieldKeys.add("entryentity.qty48");
        entryEntityFieldKeys.add("entryentity.qty49");
        entryEntityFieldKeys.add("entryentity.qty50");
        entryEntityFieldKeys.add("entryentity.qty51");
        entryEntityFieldKeys.add("entryentity.qty52");
        entryEntityFieldKeys.add("entryentity.qty53");
        entryEntityFieldKeys.add("entryentity.qty54");
        entryEntityFieldKeys.add("entryentity.qty55");
        entryEntityFieldKeys.add("entryentity.qty56");
        entryEntityFieldKeys.add("entryentity.qty57");
        entryEntityFieldKeys.add("entryentity.qty58");
        entryEntityFieldKeys.add("entryentity.qty59");
        entryEntityFieldKeys.add("entryentity.qty60");
        entryEntityFieldKeys.add("entryentity.qty61");
        entryEntityFieldKeys.add("entryentity.qty62");
        entryEntityFieldKeys.add("entryentity.qty63");
        entryEntityFieldKeys.add("entryentity.qty64");
        entryEntityFieldKeys.add("entryentity.qty65");
        entryEntityFieldKeys.add("entryentity.qty66");
        entryEntityFieldKeys.add("entryentity.qty67");
        entryEntityFieldKeys.add("entryentity.qty68");
        entryEntityFieldKeys.add("entryentity.qty69");
        entryEntityFieldKeys.add("entryentity.qty70");
        entryEntityFieldKeys.add("entryentity.qty71");
        entryEntityFieldKeys.add("entryentity.qty72");
        entryEntityFieldKeys.add("entryentity.qty73");
        entryEntityFieldKeys.add("entryentity.qty74");
        entryEntityFieldKeys.add("entryentity.qty75");
        entryEntityFieldKeys.add("entryentity.qty76");
        entryEntityFieldKeys.add("entryentity.qty77");
        entryEntityFieldKeys.add("entryentity.qty78");
        entryEntityFieldKeys.add("entryentity.qty79");
        entryEntityFieldKeys.add("entryentity.qty80");
        entryEntityFieldKeys.add("entryentity.qty81");
        entryEntityFieldKeys.add("entryentity.qty82");
        entryEntityFieldKeys.add("entryentity.qty83");
        entryEntityFieldKeys.add("entryentity.qty84");
        entryEntityFieldKeys.add("entryentity.qty85");
        entryEntityFieldKeys.add("entryentity.qty86");
        entryEntityFieldKeys.add("entryentity.qty87");
        entryEntityFieldKeys.add("entryentity.qty88");
        entryEntityFieldKeys.add("entryentity.qty89");
        entryEntityFieldKeys.add("entryentity.qty90");
        entryEntityFieldKeys.add("entryentity.qty91");
        entryEntityFieldKeys.add("entryentity.qty92");
        entryEntityFieldKeys.add("entryentity.qty93");
        entryEntityFieldKeys.add("entryentity.qty94");
        entryEntityFieldKeys.add("entryentity.qty95");
        entryEntityFieldKeys.add("entryentity.qty96");
        entryEntityFieldKeys.add("entryentity.qty97");
        entryEntityFieldKeys.add("entryentity.qty98");
        entryEntityFieldKeys.add("entryentity.qty99");
        entryEntityFieldKeys.add("entryentity.qty100");
        entryEntityFieldKeys.add("entryentity.qty101");
        entryEntityFieldKeys.add("entryentity.qty102");
        entryEntityFieldKeys.add("entryentity.qty103");
        entryEntityFieldKeys.add("entryentity.qty104");
        entryEntityFieldKeys.add("entryentity.qty105");
        entryEntityFieldKeys.add("entryentity.qty106");
        entryEntityFieldKeys.add("entryentity.qty107");
        entryEntityFieldKeys.add("entryentity.qty108");
        entryEntityFieldKeys.add("entryentity.qty109");
        entryEntityFieldKeys.add("entryentity.qty110");
        entryEntityFieldKeys.add("entryentity.qty111");
        entryEntityFieldKeys.add("entryentity.qty112");
        entryEntityFieldKeys.add("entryentity.qty113");
        entryEntityFieldKeys.add("entryentity.qty114");
        entryEntityFieldKeys.add("entryentity.qty115");
        entryEntityFieldKeys.add("entryentity.qty116");
        entryEntityFieldKeys.add("entryentity.qty117");
        entryEntityFieldKeys.add("entryentity.qty118");
        entryEntityFieldKeys.add("entryentity.qty119");
        entryEntityFieldKeys.add("entryentity.qty120");
        entryEntityFieldKeys.add("entryentity.qty121");
        entryEntityFieldKeys.add("entryentity.qty122");
        entryEntityFieldKeys.add("entryentity.qty123");
        entryEntityFieldKeys.add("entryentity.qty124");
        entryEntityFieldKeys.add("entryentity.qty125");
        entryEntityFieldKeys.add("entryentity.qty126");
        entryEntityFieldKeys.add("entryentity.qty127");
        entryEntityFieldKeys.add("entryentity.qty128");
        entryEntityFieldKeys.add("entryentity.qty129");
        entryEntityFieldKeys.add("entryentity.qty130");
        entryEntityFieldKeys.add("entryentity.qty131");
        entryEntityFieldKeys.add("entryentity.qty132");
        entryEntityFieldKeys.add("entryentity.qty133");
        entryEntityFieldKeys.add("entryentity.qty134");
        entryEntityFieldKeys.add("entryentity.qty135");
        entryEntityFieldKeys.add("entryentity.qty136");
        entryEntityFieldKeys.add("entryentity.qty137");
        entryEntityFieldKeys.add("entryentity.qty138");
        entryEntityFieldKeys.add("entryentity.qty139");
        entryEntityFieldKeys.add("entryentity.qty140");
        entryEntityFieldKeys.add("entryentity.qty141");
        entryEntityFieldKeys.add("entryentity.qty142");
        entryEntityFieldKeys.add("entryentity.qty143");
        entryEntityFieldKeys.add("entryentity.qty144");
        entryEntityFieldKeys.add("entryentity.qty145");
        entryEntityFieldKeys.add("entryentity.qty146");
        entryEntityFieldKeys.add("entryentity.qty147");
        entryEntityFieldKeys.add("entryentity.qty148");
        entryEntityFieldKeys.add("entryentity.qty149");
        entryEntityFieldKeys.add("entryentity.qty150");
        return entryEntityFieldKeys;
    }

    public static List<String> getDateEntityFieldKeys() {
        LinkedList<String> dateEntityFieldKeys = new LinkedList<String>();
        dateEntityFieldKeys.add("dateentity.fieldkey");
        dateEntityFieldKeys.add("dateentity.targetdate");
        dateEntityFieldKeys.add("dateentity.deliverycolumn");
        return dateEntityFieldKeys;
    }

    public static List<Long> getPlanScopeIds(long orgid, long materialid) {
        Long defaultPlanScopeId;
        LinkedList<Long> result = new LinkedList<Long>();
        QFilter filter = new QFilter("material", "=", (Object)materialid);
        filter.and("createorg", "=", (Object)orgid);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        filter.and("entrymatplanscop.start_useing", "=", (Object)"1");
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"FCPlanDataHelper:getPlanScopeIds", (String)"msplan_matplanscop", (String)"entrymatplanscop.planscope", (QFilter[])new QFilter[]{filter}, null);
        if (dataSet != null) {
            for (Row row : dataSet) {
                result.add(row.getLong("entrymatplanscop.planscope"));
            }
        }
        if ((defaultPlanScopeId = FCPlanDataHelper.getDefaultPlanScopeId(orgid)) != null) {
            result.add(defaultPlanScopeId);
        }
        return result;
    }

    public static Long getDefaultPlanScopeId(long orgid) {
        QFilter filter2 = new QFilter("createorg", "=", (Object)orgid);
        filter2.and("enable", "=", (Object)"1");
        filter2.and("status", "=", (Object)"C");
        filter2.and("type", "=", (Object)"A");
        DynamicObject planscope = QueryServiceHelper.queryOne((String)"msplan_planscope", (String)"id", (QFilter[])new QFilter[]{filter2});
        if (planscope != null) {
            return planscope.getLong("id");
        }
        return null;
    }

    public static DynamicObject loadDefaultConfigNo(long materialId) {
        QFilter matFilter = new QFilter("material", "=", (Object)materialId);
        QFilter status = new QFilter("status", "=", (Object)"C");
        QFilter enable = new QFilter("enable", "=", (Object)"1");
        QFilter isDefault = new QFilter("isdefault", "=", (Object)"1");
        DynamicObject config = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_configuredcode", (QFilter[])new QFilter[]{matFilter, status, enable, isDefault});
        return config;
    }

    public static void setMaterialDefaultConfig(IFormView view) {
    }

    public static Object[] getMaterialChangeInfo(Long materialId) {
        Object[] objectArray;
        ArrayList<Long> materialIds = new ArrayList<Long>(16);
        materialIds.add(materialId);
        Object[] values = FCPlanDataHelper.getMaterialChangeInfo(materialIds).get(materialId);
        if (values == null) {
            Object[] objectArray2 = new Object[4];
            objectArray2[0] = null;
            objectArray2[1] = null;
            objectArray2[2] = null;
            objectArray = objectArray2;
            objectArray2[3] = null;
        } else {
            objectArray = values;
        }
        return objectArray;
    }

    public static Map<Long, Object[]> getMaterialChangeInfo(List<Long> materialIds) {
        QFilter isOldQFilter;
        DynamicObject[] newProductColl;
        HashMap<Long, Object[]> result = new HashMap<Long, Object[]>(16);
        QFilter isNewQFilter = new QFilter("newmaterial", "in", materialIds);
        QFilter commonQFilter = new QFilter("enable", "=", (Object)"1");
        commonQFilter.and("status", "=", (Object)"C");
        DynamicObject[] oldProductColl = BusinessDataServiceHelper.load((String)"mds_productchange", (String)"newmaterial,prereleasedate,oldmaterial,predelistdate", (QFilter[])new QFilter[]{isNewQFilter, commonQFilter});
        if (oldProductColl != null) {
            for (DynamicObject oldProduct : oldProductColl) {
                ArrayList<DynamicObject> oldMaterialList;
                Long newmaterial = oldProduct.getLong("newmaterial.id");
                Object[] item = result.computeIfAbsent(newmaterial, k -> new Object[4]);
                DynamicObject oldmaterial = oldProduct.getDynamicObject("oldmaterial");
                Date curprereleasedate = oldProduct.getDate("prereleasedate");
                Date curpredelistdate = oldProduct.getDate("predelistdate");
                Date prereleasedate = (Date)item[0];
                if (prereleasedate == null || prereleasedate.compareTo(curprereleasedate) > 0) {
                    item[0] = curprereleasedate;
                }
                if ((oldMaterialList = (ArrayList<DynamicObject>)item[1]) == null) {
                    item[1] = oldMaterialList = new ArrayList<DynamicObject>();
                }
                oldMaterialList.add(oldmaterial);
                Date predelistdate = (Date)item[2];
                if (predelistdate != null && predelistdate.compareTo(curpredelistdate) <= 0) continue;
                item[2] = curpredelistdate;
            }
        }
        if ((newProductColl = BusinessDataServiceHelper.load((String)"mds_productchange", (String)"newmaterial,oldmaterial", (QFilter[])new QFilter[]{isOldQFilter = new QFilter("oldmaterial", "in", materialIds), commonQFilter})) != null) {
            for (DynamicObject newProduct : newProductColl) {
                Long thismaterial = newProduct.getLong("oldmaterial.id");
                Object[] item = result.computeIfAbsent(thismaterial, k -> new Object[4]);
                DynamicObject newmaterial = newProduct.getDynamicObject("newmaterial");
                ArrayList<DynamicObject> newMaterialList = (ArrayList<DynamicObject>)item[3];
                if (newMaterialList == null) {
                    item[3] = newMaterialList = new ArrayList<DynamicObject>();
                }
                newMaterialList.add(newmaterial);
            }
        }
        return result;
    }
}

