/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plandata;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.plandata.PlanDataFieldsSetter;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.common.util.PlanDataToFcDataTranUtil;

public class MDSHistoryDataHelper {
    private static final Log logger = LogFactory.getLog(MDSHistoryDataHelper.class);

    public static List<Date> getHistoryDateByCytype(String cytype, Date curDate, String dayOfWeek) {
        List<Date> result = MDSHistoryDataHelper.getHistoryDateByCytype(cytype, curDate);
        if ("1".equals(cytype)) {
            result = DateUtil.getMondaysOffset(result, dayOfWeek);
        } else if ("3".equals(cytype)) {
            result = DateUtil.getMonthOffset(result, dayOfWeek);
        }
        return result;
    }

    public static List<Date> getHistoryDateByCytype(String cytype, Date curDate) {
        LinkedList<Date> result = new LinkedList<Date>();
        int type = 5;
        int amount = -1;
        if ("1".equals(cytype)) {
            curDate = DateUtil.getTheWeekStart(curDate, 2);
            amount = -7;
        } else if ("3".equals(cytype)) {
            curDate = DateUtil.findFirstCurrentMonth(curDate);
            type = 2;
            amount = -1;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(curDate);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        for (int i = 0; i < 9; ++i) {
            c.add(type, amount);
            result.add(c.getTime());
        }
        return result;
    }

    public static Map<String, List<BigDecimal>> getHistoryDataByVersionNumber(String vrnNumber, String cytype) {
        QFilter qFilter = new QFilter("number", "=", (Object)vrnNumber);
        DynamicObject vrn = BusinessDataServiceHelper.loadSingleFromCache((String)"mds_vrds", (QFilter[])new QFilter[]{qFilter});
        if (vrn == null) {
            return new HashMap<String, List<BigDecimal>>(16);
        }
        return MDSHistoryDataHelper.getHistoryDataByVersionId(vrn.getPkValue(), cytype);
    }

    public static Object getVersionIdByNumber(String vrnNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)vrnNumber);
        DynamicObject vrn = BusinessDataServiceHelper.loadSingleFromCache((String)"mds_vrds", (QFilter[])new QFilter[]{qFilter});
        if (vrn == null) {
            return null;
        }
        return vrn.getPkValue();
    }

    public static String getVersionTypeByNumber(String vrnNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)vrnNumber);
        DynamicObject vrn = BusinessDataServiceHelper.loadSingleFromCache((String)"mds_vrds", (QFilter[])new QFilter[]{qFilter});
        if (vrn == null) {
            return "0";
        }
        return vrn.getString("vertype");
    }

    public static String getVersionDayOfWeekByNumber(String vrnNumber) {
        QFilter qFilter = new QFilter("number", "=", (Object)vrnNumber);
        DynamicObject vrn = BusinessDataServiceHelper.loadSingleFromCache((String)"mds_vrds", (QFilter[])new QFilter[]{qFilter});
        if (vrn == null) {
            return null;
        }
        return vrn.getString("dayofweek");
    }

    public static Map<String, List<BigDecimal>> getHistoryDataByVersionId(Object vrnPk, String cytype, String dayOfWeek) {
        DynamicObject vrds = BusinessDataServiceHelper.loadSingleFromCache((Object)vrnPk, (String)"mds_vrds");
        ArrayList<String> uniqueKeyList = new ArrayList<String>(16);
        uniqueKeyList.add("fmaterialid");
        if (vrds != null) {
            uniqueKeyList = PlanDataFieldsSetter.getHisDataKeyAlias(vrds.getString("vertype"));
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        List<Date> hisDateList = MDSHistoryDataHelper.getHistoryDateByCytype(cytype, new Date(), dayOfWeek);
        String sqlplan = String.format("select  ffcvrnnum, %s, fqty, ftargetdate,fcreatetime from t_mds_receivedata where ffcvrnnum = ? ", String.join((CharSequence)",", uniqueKeyList));
        DataSet dataSet = DB.queryDataSet((String)"getHistoryDataMDS", (DBRoute)DBRoute.of((String)"scm"), (String)sqlplan, (Object[])new Object[]{vrnPk});
        dataSet = dataSet.orderBy(new String[]{"fcreatetime asc"});
        HashSet<String> materialSet = new HashSet<String>(2048);
        HashMap<String, BigDecimal> valCacheMap = new HashMap<String, BigDecimal>(2048);
        for (Row row : dataSet) {
            StringBuilder keySb = new StringBuilder();
            Date date = row.getDate("ftargetdate");
            BigDecimal fqty = row.getBigDecimal("fqty");
            String dateStr = sdf.format(date);
            String id = MDSHistoryDataHelper.buildHistoryKey(uniqueKeyList, row);
            keySb.append(id);
            keySb.append("#");
            keySb.append(dateStr);
            valCacheMap.put(keySb.toString(), fqty);
            materialSet.add(id);
        }
        dataSet.close();
        return MDSHistoryDataHelper.buildHistoryData(hisDateList, materialSet, valCacheMap);
    }

    public static String buildHistoryKey(List<String> uniqueKeyList, DynamicObject entry) {
        StringBuilder id = new StringBuilder();
        DynamicObjectType dynamicObjectType = entry.getDynamicObjectType();
        for (String uniqueKey : uniqueKeyList) {
            if (id.length() > 0) {
                id.append("#");
            }
            DynamicProperty property = dynamicObjectType.getProperty(uniqueKey);
            String filedVal = entry.getString(uniqueKey);
            if (property instanceof BasedataProp && StringUtils.isEmpty((CharSequence)(filedVal = entry.getString(uniqueKey + ".id")))) {
                filedVal = "0";
            }
            id.append(filedVal);
        }
        return id.toString();
    }

    public static String buildHistoryKey(List<String> uniqueKeyList, Row row) {
        StringBuilder fmaterialid = new StringBuilder();
        for (String uniqueKey : uniqueKeyList) {
            if (fmaterialid.length() > 0) {
                fmaterialid.append("#");
            }
            String uniqueVal = row.getString(uniqueKey);
            fmaterialid.append(uniqueVal);
        }
        return fmaterialid.toString();
    }

    public static Map<String, List<BigDecimal>> getHistoryDataByVersionId(Object vrnPk, String cytype) {
        return MDSHistoryDataHelper.getHistoryDataByVersionId(vrnPk, cytype, "Mon");
    }

    private static Map<String, List<BigDecimal>> buildHistoryData(List<Date> hisDateList, Set<String> materialSet, Map<String, BigDecimal> valCacheMap) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, List<BigDecimal>> result = new HashMap<String, List<BigDecimal>>(2048);
        for (String materialId : materialSet) {
            LinkedList<BigDecimal> valList = new LinkedList<BigDecimal>();
            for (Date date : hisDateList) {
                String dateStr = sdf.format(date);
                StringBuilder keySb = new StringBuilder();
                keySb.append(materialId);
                keySb.append("#");
                keySb.append(dateStr);
                BigDecimal val = valCacheMap.get(keySb.toString());
                if (val == null) {
                    val = BigDecimal.ZERO;
                }
                valList.add(val);
            }
            result.put(materialId, valList);
        }
        return result;
    }

    public static boolean movePlanData2HisData(Object vrnPk, boolean tranFcDataToPlanData) {
        boolean success = true;
        DynamicObject vrn = BusinessDataServiceHelper.loadSingleFromCache((Object)vrnPk, (String)"mds_vrds");
        if (tranFcDataToPlanData) {
            DynamicObject objlog = ORM.create().newDynamicObject("mds_syncplanlog");
            objlog.set("version", (Object)vrn);
            objlog.set("direction", (Object)"B");
            objlog.set("status", (Object)"C");
            objlog.set("enable", (Object)1);
            objlog.set("creator", (Object)RequestContext.get().getCurrUserId());
            objlog.set("createtime", (Object)Calendar.getInstance().getTime());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objlog});
            PlanDataToFcDataTranUtil.tranFcDataToPlanDataByTask(vrn.getString("number"), objlog.getPkValue());
        }
        String cytype = vrn.getString("cytype");
        String dayofweek = vrn.getString("dayofweek");
        Date hisLastDate = MDSHistoryDataHelper.getHisLastDate(cytype);
        Date hisStartDate = MDSHistoryDataHelper.getHisStartDate(cytype);
        if ("1".equals(cytype)) {
            hisLastDate = DateUtil.getMondayOffset(hisLastDate, dayofweek);
            hisStartDate = DateUtil.getMondayOffset(hisStartDate, dayofweek);
        } else if ("3".equals(cytype)) {
            hisLastDate = DateUtil.getMonthOffset(hisLastDate, dayofweek);
            hisStartDate = DateUtil.getMonthOffset(hisStartDate, dayofweek);
        }
        QFilter qFilter = new QFilter("fcvrnnum", "=", vrnPk);
        DynamicObject plandata = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)"id", (QFilter[])new QFilter[]{qFilter});
        if (plandata == null) {
            return false;
        }
        Object plandataPk = plandata.getPkValue();
        DynamicObjectCollection dateentity = (plandata = BusinessDataServiceHelper.loadSingle((Object)plandataPk, (String)"mds_plandata")).getDynamicObjectCollection("dateentity");
        if (dateentity == null || dateentity.isEmpty()) {
            return true;
        }
        List<String> hisFieldkeyList = MDSHistoryDataHelper.getHisFieldKeyList(dateentity, hisLastDate);
        if (hisFieldkeyList.size() <= 0) {
            return true;
        }
        Map<String, DynamicObject> receiveDataMap = MDSHistoryDataHelper.loadReceiveData(plandata);
        MDSHistoryDataHelper.createReceivedata(plandata, hisFieldkeyList, hisStartDate, receiveDataMap);
        return success;
    }

    private static Map<String, DynamicObject> loadReceiveData(DynamicObject plandata) {
        HashMap<String, DynamicObject> receiveDataMap = new HashMap<String, DynamicObject>(2048);
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject fcvrnnum = plandata.getDynamicObject("fcvrnnum");
        QFilter filter = new QFilter("fcvrnnum", "=", fcvrnnum.getPkValue());
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mds_receivedata", (String)"id", (QFilter[])new QFilter[]{filter});
        HashSet<Object> pkSet = new HashSet<Object>(128);
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject receiveData : dynamicObjects) {
                Object id = receiveData.getPkValue();
                pkSet.add(id);
            }
        }
        if ((dynamicObjects = BusinessDataServiceHelper.load((Object[])pkSet.toArray(new Object[0]), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"mds_receivedata"))) != null && dynamicObjects.length > 0) {
            StringBuilder keySb = new StringBuilder();
            String vertype = fcvrnnum.getString("vertype");
            List<String> uniqueKeyList = PlanDataFieldsSetter.getHisDataKey(vertype);
            for (DynamicObject receiveData : dynamicObjects) {
                keySb.setLength(0);
                String fcvrnnumId = receiveData.getString("fcvrnnum.id");
                Date d = receiveData.getDate("targetdate");
                String dateStr = sdf.format(d);
                keySb.append(fcvrnnumId).append("#");
                String id = MDSHistoryDataHelper.buildHistoryKey(uniqueKeyList, receiveData);
                keySb.append(id).append("#");
                keySb.append(dateStr);
                receiveDataMap.put(keySb.toString(), receiveData);
            }
        }
        return receiveDataMap;
    }

    private static void createReceivedata(DynamicObject plandata, List<String> hisFieldkeyList, Date hisStartDate, Map<String, DynamicObject> receiveDataMap) {
        Long userId = RequestContext.get().getCurrUserId();
        LinkedList<DynamicObject> receivedataList = new LinkedList<DynamicObject>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        DynamicObject fcvrnnum = plandata.getDynamicObject("fcvrnnum");
        DynamicObjectCollection entryentity = plandata.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection dateentity = plandata.getDynamicObjectCollection("dateentity");
        String fcvrnnumId = fcvrnnum.getString("id");
        HashMap<String, Date> hisFieldRelDate = new HashMap<String, Date>(16);
        Iterator dateIterator = dateentity.iterator();
        while (dateIterator.hasNext()) {
            DynamicObject dateEntry = (DynamicObject)dateIterator.next();
            String fieldkey = dateEntry.getString("fieldkey");
            Date targetdate = dateEntry.getDate("targetdate");
            if (!hisFieldkeyList.contains(fieldkey)) continue;
            hisFieldRelDate.put(fieldkey, targetdate);
            dateIterator.remove();
        }
        String vertype = fcvrnnum.getString("vertype");
        List<String> uniqueKeyList = PlanDataFieldsSetter.getHisDataKey(vertype);
        StringBuilder keySb = new StringBuilder();
        plandata.set("modifier", (Object)userId);
        plandata.set("modifytime", (Object)new Date());
        for (DynamicObject entry : entryentity) {
            entry.set("entrymodifier", (Object)userId);
            entry.set("editdate", (Object)new Date());
            for (String field : hisFieldkeyList) {
                keySb.setLength(0);
                Date targetdate = (Date)hisFieldRelDate.get(field);
                BigDecimal qty = entry.getBigDecimal(field);
                String dateStr = sdf.format(targetdate);
                keySb.append(fcvrnnumId).append("#");
                String id = MDSHistoryDataHelper.buildHistoryKey(uniqueKeyList, entry);
                keySb.append(id).append("#");
                keySb.append(dateStr);
                String key = keySb.toString();
                DynamicObject item = receiveDataMap.get(key);
                if (item == null) {
                    item = MDSHistoryDataHelper.createReceivedataItem();
                    item.set("createtime", (Object)new Date());
                    item.set("creator", (Object)userId);
                    receiveDataMap.put(key, item);
                }
                item.set("fcvrnnum", (Object)fcvrnnum);
                List<String> uniqueKey = PlanDataFieldsSetter.getHisDataKey(fcvrnnum.getString("vertype"));
                for (String unique : uniqueKey) {
                    item.set(unique, entry.get(unique));
                }
                item.set("qty", (Object)qty);
                item.set("targetdate", (Object)targetdate);
                item.set("modifytime", (Object)new Date());
                item.set("modifier", (Object)userId);
                item.set("status", (Object)"A");
                receivedataList.add(item);
                entry.set(field, (Object)0.0);
            }
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plandata});
        MDSHistoryDataHelper.tranPlanDataToFcData(plandata);
        SaveServiceHelper.save((DynamicObject[])receivedataList.toArray(new DynamicObject[0]));
        QFilter filter = new QFilter("fcvrnnum", "=", fcvrnnum.getPkValue());
        filter.and("targetdate", "<", (Object)hisStartDate);
        DeleteServiceHelper.delete((String)"mds_receivedata", (QFilter[])new QFilter[]{filter});
    }

    private static DynamicObject createReceivedataItem() {
        return ORM.create().newDynamicObject("mds_receivedata");
    }

    private static List<String> getHisFieldKeyList(DynamicObjectCollection dateentity, Date lastDate) {
        LinkedList<String> hisFieldKeyList = new LinkedList<String>();
        for (DynamicObject dateEntry : dateentity) {
            Date targetdate = dateEntry.getDate("targetdate");
            String fieldkey = dateEntry.getString("fieldkey");
            boolean deliverycolumn = dateEntry.getBoolean("deliverycolumn");
            if (deliverycolumn || lastDate.compareTo(targetdate) <= 0) continue;
            hisFieldKeyList.add(fieldkey);
        }
        return hisFieldKeyList;
    }

    private static Date getHisStartDate(String cytype) {
        List<Date> list = MDSHistoryDataHelper.getHistoryDateByCytype(cytype, new Date());
        Date startDate = list.get(8);
        Calendar c = Calendar.getInstance();
        c.setTime(startDate);
        c.add(5, -1);
        return c.getTime();
    }

    private static Date getHisLastDate(String cytype) {
        List<Date> list = MDSHistoryDataHelper.getHistoryDateByCytype(cytype, new Date());
        Date lastDate = list.get(0);
        Calendar c = Calendar.getInstance();
        c.setTime(lastDate);
        c.set(11, 23);
        c.set(12, 59);
        c.set(13, 59);
        return c.getTime();
    }

    public static void tranPlanDataToFcData(DynamicObject obj) {
        DynamicObject version = obj.getDynamicObject("fcvrnnum");
        DynamicObject objlog = MDSHistoryDataHelper.ormCreate("mds_syncplanlog");
        objlog.set("version", (Object)version);
        objlog.set("direction", (Object)"A");
        objlog.set("status", (Object)"C");
        objlog.set("enable", (Object)1);
        objlog.set("syncresult", (Object)"C");
        objlog.set("creator", (Object)RequestContext.get().getUserId());
        objlog.set("createtime", (Object)Calendar.getInstance().getTime());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{objlog});
        PlanDataToFcDataTranUtil.tranPlanDataToFcDataByTask(version.getString("number"), objlog.getPkValue());
    }

    private static DynamicObject ormCreate(String entityName) {
        return ORM.create().newDynamicObject(entityName);
    }
}

