/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plandata;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.FlexEntityType;
import kd.bos.entity.flex.FlexProperty;
import kd.bos.entity.nameversion.NameVersionService;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.TextProp;
import kd.bos.form.operate.webapi.FlexEntityTypeReader;
import kd.bos.form.util.ExportNameVersionHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;

public class PlanDataAuxpropertyHelper {
    private static Log log = LogFactory.getLog(PlanDataAuxpropertyHelper.class);
    private String auxpropertyField;
    private String materialField;
    private String entityId;
    private Map<String, BasedataEntityType> flexRefBDTypes = new HashMap<String, BasedataEntityType>();
    private Map<String, Map<Object, DynamicObject>> flexBasedataObjs = new HashMap<String, Map<Object, DynamicObject>>();
    private Map<String, Boolean> flexBaseDataNameVersionOpenStatus = new HashMap<String, Boolean>(16);
    private static final int FLEX_JSON_OBJ_MAX_SIZE = 1000;
    private Map<Object, JSONObject> flexJsonObjs = new LinkedHashMap<Object, JSONObject>(1000, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Object, JSONObject> pEldest) {
            return this.size() > 1000;
        }
    };
    private FlexEntityTypeReader flexEntityTypeReader;

    public PlanDataAuxpropertyHelper(String auxpropertyField, String materialField, String entityId) {
        this.auxpropertyField = auxpropertyField;
        this.materialField = materialField;
        this.entityId = entityId;
    }

    public JSONObject toJSONObject(DynamicObject activeRow, DynamicObject value) {
        Object pkValue = value.getPkValue();
        boolean enableNameVersionControl = this.isEnableNameVersionControl(value.getDataEntityType().getName());
        JSONObject flexValMap = this.flexJsonObjs.get(pkValue);
        if (flexValMap != null && !enableNameVersionControl) {
            return flexValMap;
        }
        String json = SerializationUtils.toJsonString((Object)value);
        JSONObject flexJsonObj = JSONArray.parseObject((String)json);
        FlexProp flexProp = (FlexProp)activeRow.getDynamicObjectType().getProperty(this.auxpropertyField);
        BasedataProp parentBdProp = (BasedataProp)activeRow.getDynamicObjectType().getProperty(this.materialField);
        DynamicObject parentBdObj = activeRow.getDynamicObject(this.materialField);
        if (parentBdObj == null) {
            return flexJsonObj;
        }
        Map valueMap = (Map)SerializationUtils.fromJsonString((String)flexJsonObj.getString("value"), Map.class);
        if (this.flexEntityTypeReader == null) {
            this.flexEntityTypeReader = new FlexEntityTypeReader(this.entityId);
        }
        FlexEntityType flexEntityType = this.flexEntityTypeReader.read(flexProp, parentBdProp, parentBdObj);
        flexValMap = new JSONObject();
        for (IDataEntityProperty flexObjectProp : flexEntityType.getProperties()) {
            String name = flexObjectProp.getName();
            String[] nameSplit = name.split("__");
            if (nameSplit.length <= 1) continue;
            try {
                Object baseValue = valueMap.get(nameSplit[1]);
                if (baseValue == null) continue;
                if (flexObjectProp instanceof BasedataProp) {
                    String numPropKey;
                    BasedataEntityType flexObjectBaseType;
                    boolean enableNameVersionControl1;
                    if (baseValue instanceof Integer) {
                        baseValue = ((Integer)baseValue).longValue();
                    }
                    if (enableNameVersionControl1 = this.isEnableNameVersionControl((flexObjectBaseType = (BasedataEntityType)((BasedataProp)flexObjectProp).getComplexType()).getName())) {
                        this.flexBaseDataNameVersionOpenStatus.put(value.getDataEntityType().getName(), true);
                    }
                    DynamicObject basedata = this.loadFlexBasedataObj(flexProp, flexObjectBaseType, baseValue, activeRow);
                    String flexValKey = ((BasedataProp)flexObjectProp).getDisplayName().toString();
                    HashMap<String, Object> flexPropValMap = new HashMap<String, Object>();
                    String namePropKeys = flexObjectBaseType.getNameProperty();
                    if (StringUtils.isNotBlank((CharSequence)namePropKeys)) {
                        ArrayList<String> caption = new ArrayList<String>();
                        for (String propKey : namePropKeys.split(",")) {
                            Object propV = basedata.get(propKey);
                            if (!StringUtils.isNotBlank((Object)propV)) continue;
                            caption.add(propV.toString());
                        }
                        flexPropValMap.put("name", String.join((CharSequence)",", caption));
                    }
                    if (StringUtils.isNotBlank((CharSequence)(numPropKey = flexObjectBaseType.getNumberProperty()))) {
                        flexPropValMap.put("number", basedata.get(numPropKey));
                    }
                    flexValMap.put(flexValKey, flexPropValMap);
                    continue;
                }
                if (!(flexObjectProp instanceof TextProp)) continue;
                String flexValKey = ((TextProp)flexObjectProp).getDisplayName().toString();
                flexValMap.put(flexValKey, baseValue);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
        if (SystemParamServiceHelper.isShowStackTrace() && valueMap.size() != flexValMap.size()) {
            StringBuilder sb = new StringBuilder();
            sb.append(ResManager.loadKDString((String)"\u5f55\u5165\u7684\u5f39\u6027\u57df\u6570\u636e\u548c\u7ec4\u88c5\u7684\u5f39\u6027\u57df\u6570\u636e\u4e0d\u4e00\u81f4\uff1avalueMap=", (String)"ExportFlexProp_0", (String)"bos-export", (Object[])new Object[0])).append(valueMap).append(" <> flexValMap=").append(flexValMap);
            log.error(sb.toString());
        }
        flexValMap = this.reSort(flexValMap, flexEntityType.getFlexProperties());
        this.flexJsonObjs.put(pkValue, flexValMap);
        return flexValMap;
    }

    private DynamicObject loadFlexBasedataObj(FlexProp flexProp, BasedataEntityType flexObjectBaseType, Object id, DynamicObject activeRow) {
        String subExtName;
        String typeKey = flexProp.getName() + "_" + flexObjectBaseType.getName();
        BasedataEntityType refBDType = this.flexRefBDTypes.get(typeKey);
        if (refBDType == null) {
            String namePropKeys = flexObjectBaseType.getNameProperty();
            HashSet<String> selectedFields = new HashSet<String>();
            if (StringUtils.isNotBlank((CharSequence)flexObjectBaseType.getNumberProperty())) {
                selectedFields.add(flexObjectBaseType.getNumberProperty());
            }
            if (!StringUtils.isBlank((CharSequence)namePropKeys)) {
                String[] propKeys;
                for (String propKey : propKeys = namePropKeys.split(",")) {
                    if (!StringUtils.isNotBlank((CharSequence)propKey)) continue;
                    selectedFields.add(propKey);
                }
            }
            refBDType = (BasedataEntityType)EntityMetadataCache.getSubDataEntityType((String)flexObjectBaseType.getName(), selectedFields);
            this.flexRefBDTypes.put(typeKey, refBDType);
        }
        String string = subExtName = StringUtils.isBlank((CharSequence)refBDType.getExtendName()) ? refBDType.getName() : refBDType.getExtendName();
        if (!this.flexBasedataObjs.containsKey(subExtName)) {
            this.flexBasedataObjs.put(subExtName, new HashMap());
        }
        String dateStr = "";
        Date versionControlDate = null;
        if (this.isEnableNameVersionControl(refBDType.getName())) {
            versionControlDate = this.getVersionDate(activeRow, refBDType.getName());
            dateStr = dateStr + (versionControlDate == null ? "now" : versionControlDate.toString());
        }
        if (this.flexBasedataObjs.get(subExtName).containsKey(id + dateStr)) {
            return this.flexBasedataObjs.get(subExtName).get(id + dateStr);
        }
        DynamicObject flexBaseData = BusinessDataServiceHelper.loadSingleFromCache((Object)id, (DynamicObjectType)refBDType);
        if (this.isEnableNameVersionControl(refBDType.getName())) {
            flexBaseData = NameVersionService.getInstance().getNameVersionData(flexBaseData, versionControlDate);
        }
        this.flexBasedataObjs.get(subExtName).put(id + dateStr, flexBaseData);
        return flexBaseData;
    }

    private boolean isEnableNameVersionControl(String dataEntityTypename) {
        Boolean isEnableNameVersionCtl = this.flexBaseDataNameVersionOpenStatus.get(dataEntityTypename);
        if (isEnableNameVersionCtl == null) {
            isEnableNameVersionCtl = NameVersionService.getInstance().enableNameVersionControl(dataEntityTypename);
            this.flexBaseDataNameVersionOpenStatus.put(dataEntityTypename, isEnableNameVersionCtl);
        }
        return isEnableNameVersionCtl;
    }

    private Date getVersionDate(DynamicObject activeRow, String dataEntityTypename) {
        boolean enableNameVersionControl = NameVersionService.getInstance().enableNameVersionControl(dataEntityTypename);
        if (enableNameVersionControl) {
            DynamicObject mainData = ExportNameVersionHandler.getMainData((DynamicObject)activeRow);
            Date nameVersionDate = ExportNameVersionHandler.getNameVersionDate((DynamicObject)mainData);
            return nameVersionDate;
        }
        return null;
    }

    private JSONObject reSort(JSONObject flexValMap, List<FlexProperty> flexProperties) {
        JSONObject jsonObject = new JSONObject(true);
        for (FlexProperty flexProperty : flexProperties) {
            String glName = flexProperty.getName().getLocaleValue();
            if (!StringUtils.isNotEmpty((CharSequence)glName) || flexValMap.get((Object)glName) == null) continue;
            jsonObject.put(glName, flexValMap.get((Object)glName));
        }
        return jsonObject.isEmpty() ? flexValMap : jsonObject;
    }

    public List<String[]> getAuxProp(DynamicObject data) {
        JSONObject auxJson;
        ArrayList<String[]> auxProp = new ArrayList<String[]>(16);
        DynamicObject auxproperty = data.getDynamicObject("auxproperty");
        if (auxproperty != null && (auxJson = this.toJSONObject(data, auxproperty)) != null) {
            for (Map.Entry flexItem : auxJson.entrySet()) {
                String[] auxItem = new String[3];
                auxItem[0] = (String)flexItem.getKey();
                Object flexValue = flexItem.getValue();
                if (flexValue instanceof Map) {
                    Map flexMap = (Map)flexValue;
                    auxItem[1] = flexMap.get("number") + "";
                    auxItem[2] = flexMap.get("name") + "";
                } else {
                    auxItem[1] = "";
                    auxItem[2] = flexValue + "";
                }
                auxProp.add(auxItem);
            }
        }
        return auxProp;
    }
}

