/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.plandata;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.util.MDSUtils;

public class PlanDataImportHelper {
    public static void checkImportOverflow(int size, Map<String, String> errMap) {
        int maxSize;
        String maxSizeStr = MDSUtils.getMdsSysConfig("plandataimportmax", "40000");
        try {
            maxSize = Integer.parseInt(maxSizeStr);
        }
        catch (Exception e) {
            maxSize = 40000;
        }
        if (size > maxSize) {
            errMap.put("4", String.format(ResManager.loadKDString((String)"\u5bfc\u5165\u884c\u6570\u8d8a\u9650\uff0c\u6709\u6548\u5bfc\u5165\u884c\u6570\u4e3a'%1$s'\uff0c\u6700\u5927\u884c\u6570\u4e3a'%2$s'\u3002", (String)"PlanDataImportHelper_2", (String)"mmc-mds-common", (Object[])new Object[0]), size, maxSize));
        }
    }

    public static boolean checkImportVrdsContinuity(List<String> sheet, Map<String, String> errMap) {
        HashMap allFcvrnnumKey = new HashMap();
        for (int i = 0; i < sheet.size(); ++i) {
            Set<Integer> rowNumSet;
            String hasVal1 = sheet.get(i);
            if (StringUtils.isEmpty((String)hasVal1)) continue;
            String fcvrnnum = hasVal1;
            if (allFcvrnnumKey.containsKey(fcvrnnum)) {
                rowNumSet = (Set)allFcvrnnumKey.get(fcvrnnum);
                rowNumSet.add(i + 4);
                continue;
            }
            rowNumSet = new TreeSet();
            rowNumSet.add(i + 4);
            allFcvrnnumKey.put(fcvrnnum, rowNumSet);
        }
        Set fcvrnnumEntrySet = allFcvrnnumKey.entrySet();
        HashSet<String> fcvrnnumSkipSet = new HashSet<String>();
        for (Map.Entry entry : fcvrnnumEntrySet) {
            Set indexSet = (Set)entry.getValue();
            String fcvrnnum = (String)entry.getKey();
            int prevIndex = 0;
            for (Integer index : indexSet) {
                if (prevIndex == 0) {
                    prevIndex = index;
                    continue;
                }
                if (index - prevIndex > 1) {
                    fcvrnnumSkipSet.add(fcvrnnum);
                }
                prevIndex = index;
            }
        }
        for (String fcvrnnum : fcvrnnumSkipSet) {
            Set rowNumSet = (Set)allFcvrnnumKey.get(fcvrnnum);
            for (Integer index : rowNumSet) {
                errMap.put(index + "", String.format(ResManager.loadKDString((String)"\u7248\u672c\u7f16\u7801\u201c%s\u201d\u5b58\u5728\u4e0d\u8fde\u7eed\u503c\u3002", (String)"PlanDataImportHelper_1", (String)"mmc-mds-common", (Object[])new Object[0]), fcvrnnum));
            }
        }
        return errMap.isEmpty();
    }
}

