/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.generalbackup.handler;

import java.math.BigDecimal;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.probability.generalbackup.handler.AbstractGeneralBackupCalcHandler;
import kd.mmc.mds.common.probability.model.GeneralBackupContext;
import kd.mmc.mds.common.probability.model.GeneralBackupDef;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import kd.mmc.mds.mservice.algox.ForecastByEqHandlerCoGroupFunction;

public class ForecastByEqHandler
extends AbstractGeneralBackupCalcHandler {
    @Override
    public void handlerRequest(GeneralBackupContext ctx) {
        Date curStartTime = new Date();
        long logId = ctx.getLogId();
        GeneralBackupDef def = ctx.getDef();
        DataSet materialEqDataSet = ctx.getTargetMaterialEqDataSet();
        if (materialEqDataSet == null) {
            return;
        }
        JobSession session = AlgoX.createSession((String)ForecastByEqHandler.class.getName(), (String)(ForecastByEqHandler.class.getName() + "_handlerRequest"));
        DataSetInput dataSetInput = new DataSetInput(materialEqDataSet);
        DataSetX dataSetX = session.fromInput((Input)dataSetInput);
        DynamicObject defaultParams = ProbabilityUtil.loadDefaultMaterialParam("materialgroup,acstockfactor");
        DataSet materialparam = ProbabilityUtil.loadMaterialParam("materialgroup as materialtype,acstockfactor", def.getMaterialGroupIdList());
        DataSetInput paramDataSetInput = new DataSetInput(materialparam);
        DataSetX paramDataSetDataSetX = session.fromInput((Input)paramDataSetInput);
        dataSetX = dataSetX.addFields(new Field[]{new Field("forecastqty", (DataType)DataType.BigDecimalType), new Field("stockfactor", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        dataSetX = dataSetX.coGroup(paramDataSetDataSetX, (CoGroupFunction)new ForecastByEqHandlerCoGroupFunction(dataSetX.getRowMeta(), paramDataSetDataSetX.getRowMeta(), defaultParams)).on("materialtype", "materialtype");
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(2, TimeUnit.HOURS);
        DataSet dataSet = session.readDataSet(outputId);
        if (!MdsAlgoUtils.existField(dataSet.getRowMeta(), "org")) {
            dataSet = dataSet.addField(String.valueOf(ctx.getOrgId()), "org");
        }
        dataSet = ProbabilityDBHelper.addToDBFieldByProbabilityResult(dataSet, logId);
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"mds_forecastbyeq", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)ctx.getLogId())});
                DataSetSaver saver = new DataSetSaver("mds_forecastbyeq");
                saver.init();
                saver.saveByDynamicObject(dataSet);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        DynamicObject generallog = ctx.getGeneralLog();
        Date starttime = generallog.getDate("targetstarttime");
        if (starttime == null) {
            starttime = curStartTime;
            generallog.set("targetstarttime", (Object)starttime);
        }
        Date endDate = new Date();
        BigDecimal seconds = BigDecimal.valueOf(endDate.getTime() - starttime.getTime()).divide(BigDecimal.valueOf(1000L), 2, 4);
        generallog.set("targetendtime", (Object)endDate);
        generallog.set("targetsumtime", (Object)seconds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{generallog});
    }

    @Override
    public String getHandlerName() {
        String handlerName = ResManager.loadKDString((String)"\u57fa\u4e8e\u672a\u6765\u8bbe\u5907\u7684\u9884\u6d4b", (String)"ForecastByEqHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]);
        return handlerName;
    }
}

