/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.generalbackup.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.probability.generalbackup.handler.AbstractGeneralBackupCalcHandler;
import kd.mmc.mds.common.probability.model.GeneralBackupContext;
import kd.mmc.mds.common.probability.model.GeneralBackupDef;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import kd.mmc.mds.mservice.algox.ForecastByTimeHandlerCoGroupFunction;

public class ForecastByTimeHandler
extends AbstractGeneralBackupCalcHandler {
    @Override
    public void handlerRequest(GeneralBackupContext ctx) {
        Date curStartTime = new Date();
        long logId = ctx.getLogId();
        GeneralBackupDef def = ctx.getDef();
        DataSet materialEqDataSet = ctx.getTargetMaterialTimeDataSet();
        if (materialEqDataSet == null) {
            return;
        }
        JobSession session = AlgoX.createSession((String)ForecastByTimeHandler.class.getName(), (String)(ForecastByTimeHandler.class.getName() + "_handlerRequest"));
        DataSetInput dataSetInput = new DataSetInput(materialEqDataSet);
        DataSetX dataSetX = session.fromInput((Input)dataSetInput);
        ArrayList<String> fieldNameList = new ArrayList<String>(16);
        fieldNameList.add("materialtype");
        fieldNameList.add("material");
        fieldNameList.add("unit");
        fieldNameList.add("qty");
        fieldNameList.add("ordercountall");
        fieldNameList.add("usemonthcount");
        fieldNameList.add("averageqty");
        fieldNameList.add("averagedayqty");
        fieldNameList.add("daystandadev");
        fieldNameList.add("shelflife");
        fieldNameList.add("qcode");
        fieldNameList.add("isgeneral");
        fieldNameList.add("islongcyclemater");
        fieldNameList.add("actualintime");
        fieldNameList.add("actualleavetime");
        fieldNameList.add("reqtime");
        fieldNameList.add("atachapterno");
        dataSetX = dataSetX.select(fieldNameList.toArray(new String[0]));
        dataSetX = ProbabilityUtil.transProbabilityRecordMaterialBackup(session, dataSetX);
        Field[] addFields = new Field[]{new Field("safestock", (DataType)DataType.BigDecimalType), new Field("rop", (DataType)DataType.BigDecimalType), new Field("roq", (DataType)DataType.BigDecimalType), new Field("targetstock", (DataType)DataType.BigDecimalType), new Field("quarterfactor", (DataType)DataType.BigDecimalType), new Field("stockfactor", (DataType)DataType.BigDecimalType), new Field("servicefactor", (DataType)DataType.BigDecimalType), new Field("deliveryfactor", (DataType)DataType.BigDecimalType)};
        Object[] addValues = new Object[]{BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO};
        dataSetX = dataSetX.addFields(addFields, addValues);
        DynamicObject defaultParams = ProbabilityUtil.loadDefaultMaterialParam("materialgroup,quarterfactor,stockfactor,servicefactor,deliveryfactor,deliveryfactorno,avgdelivery,delstandadev");
        DataSet materialparam = ProbabilityUtil.loadMaterialParam("materialgroup as materialtype,quarterfactor,stockfactor,servicefactor,deliveryfactor,deliveryfactorno,avgdelivery,delstandadev", def.getMaterialGroupIdList());
        DataSetInput paramDataSetInput = new DataSetInput(materialparam);
        DataSetX paramDataSetDataSetX = session.fromInput((Input)paramDataSetInput);
        dataSetX = dataSetX.coGroup(paramDataSetDataSetX, (CoGroupFunction)new ForecastByTimeHandlerCoGroupFunction(dataSetX.getRowMeta(), paramDataSetDataSetX.getRowMeta(), defaultParams)).on("materialtype", "materialtype");
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(2, TimeUnit.HOURS);
        DataSet dataSet = session.readDataSet(outputId);
        if (!MdsAlgoUtils.existField(dataSet.getRowMeta(), "org")) {
            dataSet = dataSet.addField(String.valueOf(ctx.getOrgId()), "org");
        }
        dataSet = ProbabilityDBHelper.addToDBFieldByProbabilityResult(dataSet, logId);
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"mds_forecastbytime", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)ctx.getLogId())});
                DataSetSaver saver = new DataSetSaver("mds_forecastbytime");
                saver.init();
                saver.saveByDynamicObject(dataSet);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        DynamicObject generallog = ctx.getGeneralLog();
        Date starttime = generallog.getDate("targetstarttime");
        if (starttime == null) {
            starttime = curStartTime;
            generallog.set("targetstarttime", (Object)starttime);
        }
        Date endDate = new Date();
        BigDecimal seconds = BigDecimal.valueOf(endDate.getTime() - starttime.getTime()).divide(BigDecimal.valueOf(1000L), 2, 4);
        generallog.set("targetendtime", (Object)endDate);
        generallog.set("targetsumtime", (Object)seconds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{generallog});
    }

    @Override
    public String getHandlerName() {
        String handlerName = ResManager.loadKDString((String)"\u751f\u6210\u57fa\u4e8e\u65f6\u95f4\u7684\u9884\u6d4b\u3002", (String)"ForecastByTimeHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]);
        return handlerName;
    }
}

