/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.generalbackup.handler;

import java.math.BigDecimal;
import java.util.Date;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.datafetch.DataFetchUtil;
import kd.mmc.mds.common.probability.generalbackup.handler.AbstractGeneralBackupCalcHandler;
import kd.mmc.mds.common.probability.model.GeneralBackupContext;
import kd.mmc.mds.common.probability.model.GeneralBackupDef;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;

public class GeneralPlanHandler
extends AbstractGeneralBackupCalcHandler {
    @Override
    public void handlerRequest(GeneralBackupContext ctx) {
        Date starttime = new Date();
        GeneralBackupDef def = ctx.getDef();
        Long datafetchsetId = def.getGeneralplanId();
        if (datafetchsetId != null && datafetchsetId > 0L) {
            String targetEntityName = DataFetchUtil.getTargetEntityName(datafetchsetId);
            if (!this.supportEntity(targetEntityName)) {
                ctx.setErrMsg(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u7684\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u3002", (String)"GeneralPlanHandler_1", (String)"mmc-mds-common", (Object[])new Object[0]));
                return;
            }
            DataSet dataSet = DataFetchUtil.fetchDataBySetId(datafetchsetId);
            Field orgField = (dataSet = ProbabilityDBHelper.addToDBFieldBySample(dataSet, ctx.getLogId())).getRowMeta().getField("org", false);
            if (orgField == null) {
                dataSet = dataSet.addField(String.valueOf(ctx.getOrgId()), "org");
            }
            int plancount = 0;
            int actypecount = 0;
            int customercount = 0;
            int checktypecount = 0;
            if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "billno")) {
                plancount = dataSet.copy().count("billno", true);
            }
            if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "actype")) {
                actypecount = dataSet.copy().filter("actype > 0").count("actype", true);
            }
            if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "customer")) {
                customercount = dataSet.copy().filter("customer > 0").count("customer", true);
            }
            if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "checktype")) {
                checktypecount = dataSet.copy().filter("checktype > 0").count("checktype", true);
            }
            try (TXHandle h = TX.required();){
                try {
                    DeleteServiceHelper.delete((String)"mds_generalplan", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)ctx.getLogId())});
                    DataSetSaver saver = new DataSetSaver("mds_generalplan");
                    saver.init();
                    saver.saveByDynamicObject(dataSet);
                }
                catch (Throwable e) {
                    h.markRollback();
                    throw e;
                }
            }
            Date endDate = new Date();
            BigDecimal seconds = BigDecimal.valueOf(endDate.getTime() - starttime.getTime()).divide(BigDecimal.valueOf(1000L), 2, 4);
            DynamicObject generallog = ctx.getGeneralLog();
            generallog.set("planstarttime", (Object)starttime);
            generallog.set("planendtime", (Object)endDate);
            generallog.set("plansumtime", (Object)seconds);
            generallog.set("plancount", (Object)plancount);
            generallog.set("actypecount", (Object)actypecount);
            generallog.set("customercount", (Object)customercount);
            generallog.set("checktypecount", (Object)checktypecount);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{generallog});
        }
    }

    @Override
    public String getHandlerName() {
        String handlerName = ResManager.loadKDString((String)"\u751f\u6210\u901a\u7528\u5907\u8d27\u8ba1\u5212\u6e05\u5355", (String)"GeneralPlanHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]);
        return handlerName;
    }

    private boolean supportEntity(String targetEntityName) {
        return "mds_sample".equals(targetEntityName) || "mds_mroplan".equals(targetEntityName) || "mds_generalplan".equals(targetEntityName);
    }
}

