/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.generalbackup.handler;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.probability.generalbackup.handler.AbstractGeneralBackupCalcHandler;
import kd.mmc.mds.common.probability.generalbackup.handler.TargetMaterialDetailHandler;
import kd.mmc.mds.common.probability.model.GeneralBackupContext;
import kd.mmc.mds.common.probability.model.GeneralBackupDef;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import kd.mmc.mds.mservice.algox.GeneralSuggestHandlerCoGroupFunction;
import kd.mmc.mds.mservice.algox.GeneralSuggestLastAdjreasonCoGroupFunction;

public class GeneralSuggestHandler
extends AbstractGeneralBackupCalcHandler {
    GeneralBackupDef def;
    private static final Log logger = LogFactory.getLog(GeneralSuggestHandler.class);
    private static String[] loadTarget4EqFieldArr = new String[]{"materialtype", "material", "unit", "forecastqty"};

    @Override
    public void handlerRequest(GeneralBackupContext ctx) {
        Date starttime = new Date();
        DynamicObject generalLog = ctx.getGeneralLog();
        this.def = ctx.getDef();
        long logId = ctx.getLogId();
        DataSet target4TimeDataSet = this.loadTarget4Time(logId);
        if (target4TimeDataSet == null) {
            return;
        }
        JobSession session = AlgoX.createSession((String)GeneralSuggestHandler.class.getName(), (String)(TargetMaterialDetailHandler.class.getName() + "_handlerRequest"));
        DataSetInput dataSetInput = new DataSetInput(target4TimeDataSet);
        DataSetX dataSetX = session.fromInput((Input)dataSetInput);
        dataSetX = dataSetX.addFields(new Field[]{new Field("stockupmode", (DataType)DataType.StringType)}, new Object[]{"G"});
        dataSetX = dataSetX.addFields(new Field[]{new Field("specialreq", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        dataSetX = dataSetX.addFields(new Field[]{new Field("calmethod", (DataType)DataType.StringType)}, new Object[]{"5"});
        dataSetX = dataSetX.addFields(new Field[]{new Field("calstocklevel", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        dataSetX = dataSetX.addFields(new Field[]{new Field("suggestqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        if (!this.def.isSpecial()) {
            DataSet target4EqDataSet = this.loadTarget4Eq(logId);
            if (target4EqDataSet == null) {
                return;
            }
            DataSetInput target4EqDataSetInput = new DataSetInput(target4EqDataSet);
            DataSetX target4EqDataSetX = session.fromInput((Input)target4EqDataSetInput);
            dataSetX = dataSetX.leftJoin(target4EqDataSetX).on("materialtype", "materialtype").on("material", "material").on("unit", "unit").select(MdsAlgoUtils.getAllField(dataSetX.getRowMeta()), new String[]{"forecastqty"});
        } else {
            dataSetX = dataSetX.addFields(new Field[]{new Field("forecastqty", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        }
        DynamicObject defaultParams = ProbabilityUtil.loadDefaultMaterialParam("materialgroup,inventorylevelhigh,inventorylevellow");
        DataSet materialparam = ProbabilityUtil.loadMaterialParam("materialgroup as materialtype,inventorylevelhigh,inventorylevellow", this.def.getMaterialGroupIdList());
        DataSetInput paramDataSetInput = new DataSetInput(materialparam);
        DataSetX paramDataSetDataSetX = session.fromInput((Input)paramDataSetInput);
        dataSetX = dataSetX.coGroup(paramDataSetDataSetX, (CoGroupFunction)new GeneralSuggestHandlerCoGroupFunction(dataSetX.getRowMeta(), paramDataSetDataSetX.getRowMeta(), defaultParams, this.def.isSpecial())).on("materialtype", "materialtype");
        QFilter filter3 = new QFilter("entryentity.adjreasonflag", "=", (Object)true);
        DataSet generalSuggest = QueryServiceHelper.queryDataSet((String)"ProbabilityUtil", (String)"mds_generalsuggest", (String)"entryentity.material as  material,entryentity.adjreason as adjreason,entryentity.adjreasonflag as adjreasonflag", (QFilter[])new QFilter[]{filter3}, (String)"createtime desc");
        DataSetInput generalSuggestDataSetInput = new DataSetInput(generalSuggest);
        DataSetX generalSuggestDataX = session.fromInput((Input)generalSuggestDataSetInput);
        dataSetX = dataSetX.addFields(new Field[]{new Field("lastadjreason", (DataType)DataType.StringType)}, new Object[]{""});
        dataSetX = dataSetX.coGroup(generalSuggestDataX, (CoGroupFunction)new GeneralSuggestLastAdjreasonCoGroupFunction(dataSetX.getRowMeta(), generalSuggestDataX.getRowMeta())).on("material", "material");
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(2, TimeUnit.HOURS);
        DataSet dataSet = session.readDataSet(outputId);
        int materialCount = dataSet.copy().count("material", true);
        if (!MdsAlgoUtils.existField(dataSet.getRowMeta(), "org")) {
            dataSet = dataSet.addField(String.valueOf(ctx.getOrgId()), "org");
        }
        dataSet = ProbabilityDBHelper.addToDBFieldByProbabilityResult(dataSet, logId);
        try (TXHandle h = TX.required();){
            try {
                Date curTime = new Date();
                DeleteServiceHelper.delete((String)"mds_generalsuggest", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)ctx.getLogId())});
                DynamicObject generalsuggest = BusinessDataServiceHelper.newDynamicObject((String)"mds_generalsuggest");
                generalsuggest.set("logid", (Object)ctx.getLogId());
                generalsuggest.set("billstatus", (Object)"A");
                if (generalLog != null) {
                    generalsuggest.set("billno", generalLog.get("number"));
                } else {
                    generalsuggest.set("billno", (Object)ctx.getLogId());
                }
                generalsuggest.set("creator", (Object)RequestContext.get().getCurrUserId());
                generalsuggest.set("createtime", (Object)curTime);
                generalsuggest.set("modifier", (Object)RequestContext.get().getCurrUserId());
                generalsuggest.set("modifytime", (Object)curTime);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{generalsuggest});
                String sql = "insert into t_mds_generalsug_entry (FSeq,FEntryID,fmaterialtype,fmaterial,funit,ftargetstock,fforecastqty,fcalstocklevel,fspecialreq,fcalmethod,fsuggestqty,flastadjreason,fislongcyclemater,factualintime,factualleavetime,freqtime,fstockupmode,fid) values(?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
                String atachapternoSql = "insert into t_mds_generalsuggest_ata (fpkid,fentryid,fbasedataid) values(?,?,?)";
                LinkedList<Object[]> sqlParams = new LinkedList<Object[]>();
                LinkedList<Object[]> atachapternoParams = new LinkedList<Object[]>();
                int size = 0;
                int seq = 0;
                for (Row row : dataSet) {
                    ++size;
                    Object[] val = this.getValArr(row, ++seq, generalsuggest.getPkValue());
                    sqlParams.add(val);
                    String atachapternoStr = row.getString("atachapterno");
                    if (StringUtils.isNotEmpty((CharSequence)atachapternoStr)) {
                        HashSet<String> atachapternoIds = new HashSet<String>(Arrays.asList(atachapternoStr.split(",")));
                        atachapternoIds.remove("");
                        for (String id : atachapternoIds) {
                            long atachapternoId = 0L;
                            try {
                                atachapternoId = Long.parseLong(id);
                            }
                            catch (Exception e) {
                                logger.error((Throwable)e);
                            }
                            Object[] atachapternoVal = new Object[]{ID.genLongId(), row.get("id"), atachapternoId};
                            atachapternoParams.add(atachapternoVal);
                        }
                    }
                    if (size < 100000) continue;
                    this.dbExecuteBatch(sql, sqlParams);
                    sqlParams.clear();
                    this.dbExecuteBatch(atachapternoSql, atachapternoParams);
                    atachapternoParams.clear();
                    size = 0;
                }
                if (sqlParams.size() > 0) {
                    this.dbExecuteBatch(sql, sqlParams);
                    this.dbExecuteBatch(atachapternoSql, atachapternoParams);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        Date endDate = new Date();
        BigDecimal seconds = BigDecimal.valueOf(endDate.getTime() - starttime.getTime()).divide(BigDecimal.valueOf(1000L), 2, 4);
        DynamicObject generallog = ctx.getGeneralLog();
        generallog.set("stocknocount", (Object)materialCount);
        generallog.set("sugstarttime", (Object)starttime);
        generallog.set("sugendtime", (Object)endDate);
        generallog.set("sugsumtime", (Object)seconds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{generallog});
    }

    private Object[] getValArr(Row row, int seq, Object id) {
        ArrayList<Object> valList = new ArrayList<Object>(16);
        valList.add(seq);
        valList.add(row.get("id") == null ? Long.valueOf(0L) : row.get("id"));
        valList.add(row.get("materialtype") == null ? Long.valueOf(0L) : row.get("materialtype"));
        valList.add(row.get("material") == null ? Long.valueOf(0L) : row.get("material"));
        valList.add(row.get("unit") == null ? Long.valueOf(0L) : row.get("unit"));
        valList.add(row.get("targetstock") == null ? Double.valueOf(0.0) : row.get("targetstock"));
        valList.add(row.get("forecastqty") == null ? Double.valueOf(0.0) : row.get("forecastqty"));
        valList.add(row.get("calstocklevel") == null ? Double.valueOf(0.0) : row.get("calstocklevel"));
        valList.add(row.get("specialreq") == null ? Double.valueOf(0.0) : row.get("specialreq"));
        valList.add(row.get("calmethod") == null ? "5" : row.get("calmethod"));
        valList.add(row.get("suggestqty") == null ? Double.valueOf(0.0) : row.get("suggestqty"));
        valList.add(row.get("lastadjreason") == null ? " " : row.get("lastadjreason"));
        valList.add(row.get("islongcyclemater") == null ? "0" : row.get("islongcyclemater"));
        valList.add(row.get("actualintime"));
        valList.add(row.get("actualleavetime"));
        valList.add(row.get("reqtime"));
        valList.add(row.get("stockupmode") == null ? "G" : row.get("stockupmode"));
        valList.add(id);
        return valList.toArray(new Object[0]);
    }

    @Override
    public String getHandlerName() {
        String handlerName = ResManager.loadKDString((String)"\u751f\u6210\u901a\u7528\u5907\u8d27\u5efa\u8bae", (String)"GeneralSuggestHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]);
        return handlerName;
    }

    private DataSet loadTarget4Eq(long logId) {
        DataSet dataSet = null;
        if (logId > 0L) {
            QFilter qFilter = new QFilter("logid.id", "=", (Object)logId);
            DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)"GeneralSuggestHandler", (String)"mds_forecastbyeq", (String)String.join((CharSequence)",", loadTarget4EqFieldArr), (QFilter[])new QFilter[]{qFilter}, null);
            dataSet = mainDataSet.groupBy(new String[]{"materialtype", "material", "unit"}).sum("forecastqty").finish();
        }
        return dataSet;
    }

    private DataSet loadTarget4Time(long logId) {
        DataSet dataSet = null;
        if (logId > 0L) {
            List<String> fields = this.getTarget4TimeSelectFields();
            String[] fieldArr = fields.toArray(new String[0]);
            fields.add("id");
            QFilter qFilter = new QFilter("logid.id", "=", (Object)logId);
            DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)"GeneralSuggestHandler", (String)"mds_forecastbytime", (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[]{qFilter}, null);
            DataSet ataDataSet = QueryServiceHelper.queryDataSet((String)"GeneralSuggestHandler", (String)"mds_forecastbytime", (String)"id,atachapterno.fbasedataid as atachapterno", (QFilter[])new QFilter[]{qFilter}, null);
            ataDataSet = ataDataSet.groupBy(new String[]{"id"}).groupConcat("atachapterno", "atachapterno").finish();
            dataSet = mainDataSet.leftJoin(ataDataSet).on("id", "id").select(fieldArr, new String[]{"atachapterno"}).finish();
        }
        return dataSet;
    }

    private List<String> getTarget4TimeSelectFields() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("materialtype");
        list.add("material");
        list.add("unit");
        list.add("targetstock");
        list.add("islongcyclemater");
        list.add("actualintime");
        list.add("actualleavetime");
        list.add("reqtime");
        return list;
    }

    private void dbExecuteBatch(String updateSeqSql, List<Object[]> updateList) {
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)updateSeqSql, updateList);
    }
}

