/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.generalbackup.handler;

import java.math.BigDecimal;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.probability.generalbackup.handler.AbstractGeneralBackupCalcHandler;
import kd.mmc.mds.common.probability.model.GeneralBackupContext;
import kd.mmc.mds.common.probability.model.GeneralBackupDef;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import kd.mmc.mds.mservice.algox.Target4EqHandlerCoGroupFunction;
import kd.mmc.mds.mservice.algox.Target4EqHandlerReduceGroupFunction;

public class Target4EqHandler
extends AbstractGeneralBackupCalcHandler {
    @Override
    public void handlerRequest(GeneralBackupContext ctx) {
        Date curStartTime = new Date();
        long logId = ctx.getLogId();
        GeneralBackupDef def = ctx.getDef();
        DataSet materialDetailDataSet = ctx.getTargetMaterialDetailDataSet();
        if (materialDetailDataSet == null) {
            return;
        }
        materialDetailDataSet = materialDetailDataSet.copy();
        JobSession session = AlgoX.createSession((String)Target4EqHandler.class.getName(), (String)(Target4EqHandler.class.getName() + "_handlerRequest"));
        DataSetInput dataSetInput = new DataSetInput(materialDetailDataSet);
        DataSetX targetMaterialDetailDataSetX = session.fromInput((Input)dataSetInput);
        Grouper grouper = targetMaterialDetailDataSetX.groupBy(new String[]{"customer", "actype", "checktype", "material", "materialtype", "unit"});
        DataSetX dataSetX = grouper.reduceGroup((GroupReduceFunction)new Target4EqHandlerReduceGroupFunction(targetMaterialDetailDataSetX.getRowMeta(), new Date()));
        dataSetX = dataSetX.select(new String[]{"customer", "actype", "checktype", "material", "materialtype", "unit", "qty", "isgeneral", "islongcyclemater", "materialchange", "shelflife", "actualintime", "reqtime", "actualleavetime", "atachapterno"});
        DataSet generalPlanDataSet = ProbabilityUtil.loadGeneralPlan(logId);
        if (generalPlanDataSet == null) {
            return;
        }
        DataSetInput generalPlanDataSetInput = new DataSetInput(generalPlanDataSet);
        DataSetX generalPlanDataSetX = session.fromInput((Input)generalPlanDataSetInput);
        DynamicObject generallog = ctx.getGeneralLog();
        Long hisUseLogId = generallog.getLong("hisusecalclog");
        QFilter filter = new QFilter("logid", "=", (Object)hisUseLogId);
        String select = ProbabilityUtil.getDetailSelectField();
        DataSet hisusedetailDataSet = QueryServiceHelper.queryDataSet((String)"Target4EqHandler", (String)"mds_hisusedetail", (String)select, (QFilter[])new QFilter[]{filter}, null);
        DataSetInput hisusedetailDataSetInput = new DataSetInput(hisusedetailDataSet);
        DataSetX hisusedetailDataSetX = session.fromInput((Input)hisusedetailDataSetInput);
        DataSetX useaccount = hisusedetailDataSetX.groupBy(new String[]{"customer", "actype", "checktype", "material", "planno"}).count("unit", "count").groupBy(new String[]{"customer", "actype", "checktype", "material"}).count("planno", "useaccount");
        DataSetX account = hisusedetailDataSetX.groupBy(new String[]{"customer", "actype", "checktype", "planno"}).count("unit", "count").groupBy(new String[]{"customer", "actype", "checktype"}).count("planno", "account");
        dataSetX = dataSetX.join(useaccount).on("customer", "customer").on("actype", "actype").on("checktype", "checktype").on("material", "material").select(MdsAlgoUtils.getAllField(dataSetX.getRowMeta()), new String[]{"useaccount"});
        dataSetX = dataSetX.join(account).on("customer", "customer").on("actype", "actype").on("checktype", "checktype").select(MdsAlgoUtils.getAllField(dataSetX.getRowMeta()), new String[]{"account"});
        DataSetX eqcountDataSetX = generalPlanDataSetX.filter(" billno is not null and billno <> ' ' ").groupBy(new String[]{"customer", "actype", "checktype", "billno"}).count("acreg", "count").groupBy(new String[]{"customer", "actype", "checktype"}).count("billno", "eqcount");
        dataSetX = dataSetX.leftJoin(eqcountDataSetX).on("customer", "customer").on("actype", "actype").on("checktype", "checktype").select(MdsAlgoUtils.getAllField(dataSetX.getRowMeta()), new String[]{"eqcount"});
        Map<String, Object> params1 = ProbabilityUtil.getFutureMonth(1);
        DataSetX eqcountm1DataSetX = generalPlanDataSetX.filter(" billno is not null and billno <> ' ' and actualintime >=startDate and actualintime< endDate ", params1).groupBy(new String[]{"customer", "actype", "checktype", "billno"}).count("acreg", "count").groupBy(new String[]{"customer", "actype", "checktype"}).count("billno", "eqcountm1");
        dataSetX = dataSetX.leftJoin(eqcountm1DataSetX).on("customer", "customer").on("actype", "actype").on("checktype", "checktype").select(MdsAlgoUtils.getAllField(dataSetX.getRowMeta()), new String[]{"eqcountm1"});
        Map<String, Object> params2 = ProbabilityUtil.getFutureMonth(2);
        DataSetX eqcountm2DataSetX = generalPlanDataSetX.filter(" billno is not null and billno <> ' ' and actualintime >=startDate and actualintime< endDate ", params2).groupBy(new String[]{"customer", "actype", "checktype", "billno"}).count("acreg", "count").groupBy(new String[]{"customer", "actype", "checktype"}).count("billno", "eqcountm2");
        dataSetX = dataSetX.leftJoin(eqcountm2DataSetX).on("customer", "customer").on("actype", "actype").on("checktype", "checktype").select(MdsAlgoUtils.getAllField(dataSetX.getRowMeta()), new String[]{"eqcountm2"});
        Map<String, Object> params3 = ProbabilityUtil.getFutureMonth(3);
        DataSetX eqcountm3DataSetX = generalPlanDataSetX.filter(" billno is not null and billno <> ' ' and actualintime >=startDate and actualintime< endDate ", params3).groupBy(new String[]{"customer", "actype", "checktype", "billno"}).count("acreg", "count").groupBy(new String[]{"customer", "actype", "checktype"}).count("billno", "eqcountm3");
        dataSetX = dataSetX.leftJoin(eqcountm3DataSetX).on("customer", "customer").on("actype", "actype").on("checktype", "checktype").select(MdsAlgoUtils.getAllField(dataSetX.getRowMeta()), new String[]{"eqcountm3"});
        DynamicObject defaultParams = ProbabilityUtil.loadDefaultMaterialParam("materialgroup,avgqty");
        DataSet materialparam = ProbabilityUtil.loadMaterialParam("materialgroup as materialtype,avgqty as avgqtytype", def.getMaterialGroupIdList());
        DataSetInput paramDataSetInput = new DataSetInput(materialparam);
        DataSetX paramDataSetDataSetX = session.fromInput((Input)paramDataSetInput);
        dataSetX = dataSetX.addFields(new Field[]{new Field("averageqty", (DataType)DataType.BigDecimalType), new Field("useprobability", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO, BigDecimal.ZERO});
        dataSetX = dataSetX.coGroup(paramDataSetDataSetX, (CoGroupFunction)new Target4EqHandlerCoGroupFunction(dataSetX.getRowMeta(), paramDataSetDataSetX.getRowMeta(), defaultParams)).on("materialtype", "materialtype");
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(2, TimeUnit.HOURS);
        DataSet dataSet = session.readDataSet(outputId);
        ctx.setTargetMaterialEqDataSet(dataSet.copy());
        if (!MdsAlgoUtils.existField(dataSet.getRowMeta(), "org")) {
            dataSet = dataSet.addField(String.valueOf(ctx.getOrgId()), "org");
        }
        dataSet = ProbabilityDBHelper.addToDBFieldByProbabilityResult(dataSet, logId);
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"mds_targetmaterial_eq", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)ctx.getLogId())});
                DataSetSaver saver = new DataSetSaver("mds_targetmaterial_eq");
                saver.init();
                saver.saveByDynamicObject(dataSet);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        Date starttime = generallog.getDate("targetstarttime");
        if (starttime == null) {
            starttime = curStartTime;
            generallog.set("targetstarttime", (Object)starttime);
        }
        Date endDate = new Date();
        BigDecimal seconds = BigDecimal.valueOf(endDate.getTime() - starttime.getTime()).divide(BigDecimal.valueOf(1000L), 2, 4);
        generallog.set("targetendtime", (Object)endDate);
        generallog.set("targetsumtime", (Object)seconds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{generallog});
    }

    @Override
    public String getHandlerName() {
        String handlerName = ResManager.loadKDString((String)"\u6309\u8bbe\u5907\u7edf\u8ba1\u76ee\u6807\u4ef6\u6e05\u5355\u660e\u7ec6\u3002", (String)"Target4EqHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]);
        return handlerName;
    }
}

