/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.generalbackup.handler;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.probability.generalbackup.handler.AbstractGeneralBackupCalcHandler;
import kd.mmc.mds.common.probability.model.GeneralBackupContext;
import kd.mmc.mds.common.probability.model.GeneralBackupDef;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.mservice.algox.Target4TimeHandlerReduceGroupFunction;

public class Target4TimeHandler
extends AbstractGeneralBackupCalcHandler {
    GeneralBackupDef def;

    @Override
    public void handlerRequest(GeneralBackupContext ctx) {
        Date curStartTime = new Date();
        this.def = ctx.getDef();
        long logId = ctx.getLogId();
        DataSet materialDetailDataSet = ctx.getTargetMaterialDetailDataSet();
        if (materialDetailDataSet == null) {
            return;
        }
        materialDetailDataSet = materialDetailDataSet.copy();
        JobSession session = AlgoX.createSession((String)Target4TimeHandler.class.getName(), (String)(Target4TimeHandler.class.getName() + "_handlerRequest"));
        DataSetInput dataSetInput = new DataSetInput(materialDetailDataSet);
        DataSetX dataSetX = session.fromInput((Input)dataSetInput);
        Grouper grouper = dataSetX.groupBy(new String[]{"material", "materialtype", "unit"});
        dataSetX = grouper.reduceGroup((GroupReduceFunction)new Target4TimeHandlerReduceGroupFunction(dataSetX.getRowMeta(), new Date()));
        int useCountMin = this.def.getUseCountMin();
        int useCountMax = this.def.getUseCountMax();
        HashMap<String, Integer> params = new HashMap<String, Integer>(16);
        params.put("min", useCountMin);
        params.put("max", useCountMax);
        dataSetX = dataSetX.filter("usemonthcount >= min and usemonthcount <=max", params);
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(2, TimeUnit.HOURS);
        DataSet dataSet = session.readDataSet(outputId);
        ctx.setTargetMaterialTimeDataSet(dataSet.copy());
        if (!MdsAlgoUtils.existField(dataSet.getRowMeta(), "org")) {
            dataSet = dataSet.addField(String.valueOf(ctx.getOrgId()), "org");
        }
        dataSet = ProbabilityDBHelper.addToDBFieldByProbabilityResult(dataSet, logId);
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"mds_targetmaterial_time", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)ctx.getLogId())});
                DataSetSaver saver = new DataSetSaver("mds_targetmaterial_time");
                saver.init();
                saver.saveByDynamicObject(dataSet);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        DynamicObject generallog = ctx.getGeneralLog();
        Date starttime = generallog.getDate("targetstarttime");
        if (starttime == null) {
            starttime = curStartTime;
            generallog.set("targetstarttime", (Object)starttime);
        }
        Date endDate = new Date();
        BigDecimal seconds = BigDecimal.valueOf(endDate.getTime() - starttime.getTime()).divide(BigDecimal.valueOf(1000L), 2, 4);
        generallog.set("targetendtime", (Object)endDate);
        generallog.set("targetsumtime", (Object)seconds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{generallog});
    }

    @Override
    public String getHandlerName() {
        String handlerName = ResManager.loadKDString((String)"\u6309\u65f6\u95f4\u7edf\u8ba1\u76ee\u6807\u4ef6\u6e05\u5355\u660e\u7ec6", (String)"Target4TimeHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]);
        return handlerName;
    }
}

