/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.generalbackup.handler;

import java.math.BigDecimal;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.probability.generalbackup.handler.AbstractGeneralBackupCalcHandler;
import kd.mmc.mds.common.probability.model.GeneralBackupContext;
import kd.mmc.mds.common.probability.model.GeneralBackupDef;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class TargetMaterialDetailHandler
extends AbstractGeneralBackupCalcHandler {
    GeneralBackupDef def;

    @Override
    public void handlerRequest(GeneralBackupContext ctx) {
        Date starttime = new Date();
        this.def = ctx.getDef();
        long logId = ctx.getLogId();
        DataSet useDetail = this.loadHisUseDetail(logId);
        if (useDetail == null) {
            return;
        }
        JobSession session = AlgoX.createSession((String)TargetMaterialDetailHandler.class.getName(), (String)(TargetMaterialDetailHandler.class.getName() + "_handlerRequest"));
        DataSetInput dataSetInput = new DataSetInput(useDetail);
        DataSetX dataSetX = session.fromInput((Input)dataSetInput);
        dataSetX = ProbabilityUtil.transProbabilityRecordMaterialInventoryInfo(session, dataSetX);
        if (!this.def.isSpecial()) {
            DataSet generalPlan = ProbabilityUtil.loadGeneralPlan(logId);
            if (generalPlan == null) {
                return;
            }
            generalPlan = generalPlan.groupBy(new String[]{"customer", "actype", "checktype"}).max("actualleavetime", "actualleavetime").min("actualintime", "actualintime").min("actualintime", "reqtime").finish();
            DataSetInput generalPlanDataSetInput = new DataSetInput(generalPlan);
            DataSetX generalPlanDataSetX = session.fromInput((Input)generalPlanDataSetInput);
            JoinDataSetX joinDataSetX = dataSetX.join(generalPlanDataSetX).on("customer", "customer").on("actype", "actype").on("checktype", "checktype");
            dataSetX = joinDataSetX.select(MdsAlgoUtils.getAllField(dataSetX.getRowMeta()), new String[]{"actualleavetime", "actualintime", "reqtime"});
            dataSetX = dataSetX.addFields(new Field[]{new Field("targetflag", (DataType)DataType.BooleanType)}, new Object[]{true});
        } else {
            dataSetX = dataSetX.addFields(new Field[]{new Field("targetflag", (DataType)DataType.BooleanType), new Field("actualleavetime", (DataType)DataType.DateType), new Field("actualintime", (DataType)DataType.DateType), new Field("reqtime", (DataType)DataType.DateType)}, new Object[]{false, null, null, new Date()});
        }
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(2, TimeUnit.HOURS);
        DataSet dataSet = session.readDataSet(outputId);
        ctx.setTargetMaterialDetailDataSet(dataSet.copy());
        if (!MdsAlgoUtils.existField(dataSet.getRowMeta(), "org")) {
            dataSet = dataSet.addField(String.valueOf(ctx.getOrgId()), "org");
        }
        dataSet = ProbabilityDBHelper.addToDBFieldByProbabilityResult(dataSet, logId);
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"mds_targetmaterial", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)ctx.getLogId())});
                DataSetSaver saver = new DataSetSaver("mds_targetmaterial");
                saver.init();
                saver.saveByDynamicObject(dataSet);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        Date endDate = new Date();
        BigDecimal seconds = BigDecimal.valueOf(endDate.getTime() - starttime.getTime()).divide(BigDecimal.valueOf(1000L), 2, 4);
        DynamicObject generallog = ctx.getGeneralLog();
        generallog.set("targetstarttime", (Object)starttime);
        generallog.set("targetendtime", (Object)endDate);
        generallog.set("targetsumtime", (Object)seconds);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{generallog});
    }

    private DataSet loadHisUseDetail(long logId) {
        DataSet dataSet = null;
        if (logId > 0L) {
            DynamicObject generallog = BusinessDataServiceHelper.loadSingle((Object)logId, (String)"mds_generallog");
            long hisUseCalcLogId = generallog.getLong("hisusecalclog.id");
            List<String> fields = this.getHisUseSelectFields();
            String[] fieldArr = fields.toArray(new String[0]);
            fields.add("id");
            QFilter qFilter = new QFilter("logid.id", "=", (Object)hisUseCalcLogId);
            DataSet mainDataSet = QueryServiceHelper.queryDataSet((String)"TargetMaterialDetailHandler", (String)"mds_hisuseresult", (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[]{qFilter}, null);
            DataSet ataDataSet = QueryServiceHelper.queryDataSet((String)"TargetMaterialDetailHandler", (String)"mds_hisuseresult", (String)"id,atachapterno.fbasedataid as atachapterno", (QFilter[])new QFilter[]{qFilter}, null);
            ataDataSet = ataDataSet.groupBy(new String[]{"id"}).groupConcat("atachapterno", "atachapterno").finish();
            dataSet = mainDataSet.leftJoin(ataDataSet).on("id", "id").select(fieldArr, new String[]{"atachapterno"}).finish();
        }
        return dataSet;
    }

    private List<String> getHisUseSelectFields() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("customer");
        list.add("actype");
        list.add("checktype");
        list.add("material");
        list.add("materialtype");
        list.add("unit");
        list.add("qty");
        list.add("qty12m");
        list.add("insupplyqty");
        list.add("custosupplyqty");
        list.add("usemonthcount");
        list.add("averageqty");
        list.add("averageqty12m");
        list.add("averagedayqty");
        list.add("averageyearqty");
        list.add("monthstandadev");
        list.add("standadev12m");
        list.add("daystandadev");
        list.add("daystandadev12m");
        list.add("ordercountall");
        list.add("ordercount1");
        list.add("ordercount2");
        list.add("ordercount3");
        list.add("ordercount4");
        list.add("ordercount5");
        list.add("ordercount6");
        list.add("ordercount7");
        list.add("ordercount8");
        list.add("ordercount9");
        list.add("ordercount10");
        list.add("ordercount11");
        list.add("ordercount12");
        list.add("qcode");
        list.add("quarter1");
        list.add("quarter2");
        list.add("quarter3");
        list.add("quarter4");
        list.add("mqty1");
        list.add("mqty2 ");
        list.add("mqty3");
        list.add("mqty4");
        list.add("mqty5");
        list.add("mqty6");
        list.add("mqty7");
        list.add("mqty8");
        list.add("mqty9");
        list.add("mqty10");
        list.add("mqty11");
        list.add("mqty12");
        list.add("isgeneral");
        list.add("avgdelivery");
        list.add("longcycle");
        list.add("islongcyclemater");
        list.add("beforematerialnumber");
        list.add("beforematerialname");
        list.add("beforeunitname");
        list.add("supplyresp");
        list.add("materialchange");
        list.add("conmtypename");
        list.add("conmtypenumber");
        list.add("conmtypeid");
        return list;
    }

    @Override
    public String getHandlerName() {
        String handlerName = ResManager.loadKDString((String)"\u751f\u6210\u76ee\u6807\u4ef6\u6e05\u5355\u660e\u7ec6\u3002", (String)"TargetMaterialDetailHandler_0", (String)"mmc-mds-common", (Object[])new Object[0]);
        return handlerName;
    }
}

