/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.task;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.probability.generalbackup.builder.GeneralHandBuilder;
import kd.mmc.mds.common.probability.generalbackup.handler.AbstractGeneralBackupCalcHandler;
import kd.mmc.mds.common.probability.model.GeneralBackupContext;
import kd.mmc.mds.common.probability.model.GeneralBackupDef;
import kd.mmc.mds.common.probability.util.GeneralBackupDefBuilder;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import org.apache.commons.collections4.MapUtils;

public class GeneralBackupTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(GeneralBackupTask.class);
    private Date starttime = new Date();
    private long logId = 0L;
    private long setId = 0L;
    private long orgId = 0L;
    private String logEntityNum = "mds_generallog";
    private GeneralBackupDef schemeDef = null;

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        block19: {
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u65b9\u6848", (String)"ProbabilityFetchRecordTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            try (AlgoContext algoContext = Algo.newContext();){
                this.setId = MapUtils.getLong(params, (Object)"setid", (Long)0L);
                this.orgId = MapUtils.getLong(params, (Object)"curorg.id", (Long)0L);
                GeneralBackupDefBuilder builder = new GeneralBackupDefBuilder();
                builder.setSchemeId(this.setId);
                this.schemeDef = builder.build();
                String logMsg = this.createLog();
                if (StringUtils.isNotEmpty((String)logMsg)) {
                    HashMap<String, String> result = new HashMap<String, String>(16);
                    result.put("busy", logMsg);
                    this.feedbackCustomdata(result);
                    return;
                }
                this.doExecute(context, params);
            }
            catch (Exception e) {
                HashMap<String, String> result = new HashMap<String, String>(16);
                result.put("failed", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ProbabilityTask_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                this.feedbackCustomdata(result);
                String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error(msg);
                String errorinfo = msg;
                if (errorinfo != null && errorinfo.length() >= 2000) {
                    errorinfo = errorinfo.substring(0, 1999);
                }
                if (this.logId == 0L) break block19;
                ProbabilityUtil.updateProbabilityLogCalStatus(this.logId, "E", errorinfo, this.logEntityNum);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createLog() {
        String logMsg = null;
        if (this.schemeDef == null) {
            return ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"HisUseTask_1", (String)"mmc-mds-common", (Object[])new Object[0]);
        }
        DLock lock = DLock.create((String)("HisUseTask_" + this.setId), (String)"HisUseTask");
        lock.lock();
        try {
            DynamicObject generalset;
            DynamicObject generallog = BusinessDataServiceHelper.newDynamicObject((String)this.logEntityNum);
            String newNum = CodeRuleServiceHelper.getNumber((String)this.logEntityNum, (DynamicObject)generallog, (String)String.valueOf(RequestContext.get().getOrgId()));
            generallog.set("number", (Object)newNum);
            generallog.set("creator", (Object)RequestContext.get().getCurrUserId());
            generallog.set("starttime", (Object)this.starttime);
            generallog.set("status", (Object)Character.valueOf('C'));
            generallog.set("enable", (Object)Character.valueOf('1'));
            generallog.set("calstatus", (Object)Character.valueOf('B'));
            generallog.set("specialcond", (Object)this.schemeDef.isSpecial());
            generallog.set("generalset", (Object)this.schemeDef.getId());
            generallog.set("generalplan", (Object)this.schemeDef.getGeneralplanId());
            generallog.set("repeatcal", (Object)this.schemeDef.isRepeat());
            generallog.set("hisuseset", (Object)this.schemeDef.getHisusesetId());
            generallog.set("usecountmin", (Object)this.schemeDef.getUseCountMin());
            generallog.set("usecountmax", (Object)this.schemeDef.getUseCountMax());
            generallog.set("specialreq", (Object)this.schemeDef.isSpecialReq());
            QFilter filter = new QFilter("calstatus", "=", (Object)"B");
            filter.or("calstatus", "=", (Object)"A");
            QFilter filter2 = new QFilter("generalset", "=", (Object)this.setId);
            DynamicObjectCollection logColl = QueryServiceHelper.query((String)this.logEntityNum, (String)"id,calstatus", (QFilter[])new QFilter[]{filter, filter2});
            if (logColl != null && logColl.size() > 0) {
                logMsg = ResManager.loadKDString((String)"\u65b9\u6848\u6b63\u5728\u8fd0\u7b97\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u3002", (String)"HisUseTask_0", (String)"mmc-mds-common", (Object[])new Object[0]);
                generallog.set("endtime", (Object)new Date());
                generallog.set("calstatus", (Object)Character.valueOf('E'));
                generallog.set("errmsg", (Object)ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", (String)"ProbabilityUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                generallog.set("errmsg_tag", (Object)logMsg);
            }
            if ((generalset = BusinessDataServiceHelper.loadSingle((Object)this.setId, (String)"mds_generalset")) != null) {
                String status = generalset.getString("status");
                String enable = generalset.getString("enable");
                if (!"C".equals(status) || !"1".equals(enable)) {
                    logMsg = ResManager.loadKDString((String)"\u65b9\u6848\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002", (String)"HisUseTask_6", (String)"mmc-mds-common", (Object[])new Object[0]);
                    generallog.set("endtime", (Object)new Date());
                    generallog.set("calstatus", (Object)Character.valueOf('E'));
                    generallog.set("errmsg", (Object)ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", (String)"ProbabilityUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                    generallog.set("errmsg_tag", (Object)logMsg);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{generallog});
            this.logId = generallog.getLong("id");
        }
        finally {
            lock.unlock();
        }
        return logMsg;
    }

    private void doExecute(RequestContext context, Map<String, Object> params) throws Exception {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u65b9\u6848", (String)"ProbabilityFetchRecordTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        GeneralHandBuilder builder = new GeneralHandBuilder(this.schemeDef);
        List<AbstractGeneralBackupCalcHandler> handlers = builder.build();
        if (handlers == null) {
            return;
        }
        int size = handlers.size();
        int step = 0;
        String errMsg = null;
        DynamicObject generallog = BusinessDataServiceHelper.loadSingle((Object)this.logId, (String)this.logEntityNum);
        GeneralBackupContext ctx = new GeneralBackupContext();
        ctx.setDef(this.schemeDef);
        ctx.setLogId(this.logId);
        ctx.setOrgId(this.orgId);
        ctx.setGeneralLog(generallog);
        for (AbstractGeneralBackupCalcHandler handler : handlers) {
            ++step;
            if (this.checkStop()) {
                return;
            }
            String stepMsg = this.getStepMsg(step, size, handler.getHandlerName());
            this.feedbackProgress(step * 100 / size, stepMsg, null);
            handler.handlerRequest(ctx);
            errMsg = ctx.getErrMsg();
            if (!StringUtils.isNotEmpty((String)errMsg)) continue;
            break;
        }
        if (StringUtils.isEmpty(errMsg)) {
            this.clearLogLatest(this.setId);
        }
        if ((generallog = ctx.getGeneralLog()) != null) {
            HashMap<String, Object> result;
            Date endDate = new Date();
            generallog.set("endtime", (Object)endDate);
            BigDecimal seconds = BigDecimal.valueOf(endDate.getTime() - this.starttime.getTime()).divide(BigDecimal.valueOf(1000L), 2, 4);
            generallog.set("sumtime", (Object)seconds);
            generallog.set("calstatus", (Object)"C");
            generallog.set("latest", (Object)true);
            if (StringUtils.isNotEmpty((String)errMsg)) {
                generallog.set("endtime", (Object)new Date());
                generallog.set("calstatus", (Object)Character.valueOf('E'));
                generallog.set("errmsg", (Object)ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", (String)"ProbabilityUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                generallog.set("errmsg_tag", (Object)errMsg);
                result = new HashMap(16);
                result.put("failed", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ProbabilityTask_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                this.feedbackCustomdata(result);
            } else {
                result = new HashMap<String, Object>(16);
                result.put("success", true);
                result.put("logId", this.logId);
                this.feedbackCustomdata(result);
                this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210\u3002", (String)"HisUseTask_5", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{generallog});
        }
    }

    private String getStepMsg(int step, int size, String stepName) {
        String stepMsg = ResManager.loadKDString((String)"\u6b63\u5728\u8fdb\u884c\u7b2c %1$d \u6b65\uff0c\u5171 %2$d \u4e2a\u6b65\u9aa4\u3002", (String)"GeneralBackupTask_0", (String)"mmc-mds-common", (Object[])new Object[0]);
        return String.format(stepMsg, step, size) + "\r\n" + stepName;
    }

    private boolean checkStop() {
        String status = ProbabilityUtil.getProbabilityLogCalStatus(this.logId, this.logEntityNum);
        return !"A".equalsIgnoreCase(status) && !"B".equalsIgnoreCase(status);
    }

    private void clearLogLatest(Object generalsetId) {
        DynamicObject[] logArr = BusinessDataServiceHelper.load((String)this.logEntityNum, (String)"id,latest,generalset", (QFilter[])new QFilter[]{new QFilter("generalset.id", "=", generalsetId).and("latest", "=", (Object)true)});
        if (logArr != null && logArr.length > 0) {
            for (DynamicObject log : logArr) {
                log.set("latest", (Object)false);
            }
            SaveServiceHelper.save((DynamicObject[])logArr);
        }
    }
}

