/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.task;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.datafetch.DataFetchUtil;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import org.apache.commons.collections4.MapUtils;

public class HisUseTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(HisUseTask.class);
    private long logId = 0L;
    private Object setId = 0L;
    private long datafetchsetId = 0L;
    private boolean istransform = false;
    private Object orgId = 0L;
    private Date starttime = new Date();
    private int materialCount = 0;
    private boolean isGeneralBackup = false;

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        block22: {
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u65b9\u6848", (String)"ProbabilityFetchRecordTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            try (AlgoContext algoContext = Algo.newContext();){
                this.setId = MapUtils.getLong(params, (Object)"setid", (Long)0L);
                this.orgId = MapUtils.getLong(params, (Object)"curorg.id", (Long)0L);
                this.isGeneralBackup = MapUtils.getBoolean(params, (Object)"generalBackup", (Boolean)false);
                String logMsg = this.createLog();
                if (StringUtils.isNotEmpty((String)logMsg)) {
                    if (this.isGeneralBackup) {
                        params.put("generalBackup_err", logMsg);
                    }
                    HashMap<String, String> result = new HashMap<String, String>(16);
                    result.put("busy", logMsg);
                    this.feedbackCustomdata(result);
                    return;
                }
                this.doExecute(context, params);
                if (this.isGeneralBackup) {
                    params.put("generalBackup_logid", this.logId);
                }
            }
            catch (Exception e) {
                HashMap<String, String> result = new HashMap<String, String>(16);
                result.put("failed", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ProbabilityTask_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                this.feedbackCustomdata(result);
                String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error(msg);
                String errorinfo = msg;
                if (errorinfo != null && errorinfo.length() >= 2000) {
                    errorinfo = errorinfo.substring(0, 1999);
                }
                if (this.logId != 0L) {
                    ProbabilityUtil.updateProbabilityLogCalStatus(this.logId, "E", errorinfo, "mds_hisusecalclog");
                }
                if (!this.isGeneralBackup) break block22;
                params.put("generalBackup_err", errorinfo);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String createLog() {
        DynamicObject hisuseset = BusinessDataServiceHelper.loadSingle((Object)this.setId, (String)"mds_hisuseset");
        String logMsg = null;
        if (hisuseset == null) {
            return ResManager.loadKDString((String)"\u65b9\u6848\u4e0d\u5b58\u5728\u3002", (String)"HisUseTask_1", (String)"mmc-mds-common", (Object[])new Object[0]);
        }
        this.datafetchsetId = hisuseset.getLong("datafetchset.id");
        this.istransform = hisuseset.getBoolean("istransform");
        DLock lock = DLock.create((String)("HisUseTask_" + this.setId), (String)"HisUseTask");
        lock.lock();
        try {
            DynamicObject hisusecalclog = BusinessDataServiceHelper.newDynamicObject((String)"mds_hisusecalclog");
            String entityNum = "mds_hisusecalclog";
            String newNum = CodeRuleServiceHelper.getNumber((String)entityNum, (DynamicObject)hisusecalclog, (String)String.valueOf(RequestContext.get().getOrgId()));
            hisusecalclog.set("number", (Object)newNum);
            hisusecalclog.set("creator", (Object)RequestContext.get().getCurrUserId());
            hisusecalclog.set("starttime", (Object)this.starttime);
            hisusecalclog.set("status", (Object)Character.valueOf('C'));
            hisusecalclog.set("enable", (Object)Character.valueOf('1'));
            hisusecalclog.set("hisuseset", hisuseset.getPkValue());
            hisusecalclog.set("datafetchset", hisuseset.get("datafetchset"));
            hisusecalclog.set("istransform", hisuseset.get("istransform"));
            hisusecalclog.set("calstatus", (Object)Character.valueOf('B'));
            QFilter filter = new QFilter("calstatus", "=", (Object)"B");
            filter.or("calstatus", "=", (Object)"A");
            QFilter filter2 = new QFilter("hisuseset", "=", this.setId);
            DynamicObjectCollection logColl = QueryServiceHelper.query((String)"mds_hisusecalclog", (String)"id,calstatus", (QFilter[])new QFilter[]{filter, filter2});
            if (logColl != null && logColl.size() > 0) {
                logMsg = ResManager.loadKDString((String)"\u65b9\u6848\u6b63\u5728\u8fd0\u7b97\uff0c\u8bf7\u7b49\u5f85\u8fd0\u7b97\u7ed3\u675f\u3002", (String)"HisUseTask_0", (String)"mmc-mds-common", (Object[])new Object[0]);
                hisusecalclog.set("endtime", (Object)new Date());
                hisusecalclog.set("calstatus", (Object)Character.valueOf('E'));
                hisusecalclog.set("errmsg", (Object)ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", (String)"ProbabilityUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                hisusecalclog.set("errmsg_tag", (Object)logMsg);
            }
            String status = hisuseset.getString("status");
            String enable = hisuseset.getString("enable");
            if (!"C".equals(status) || !"1".equals(enable)) {
                logMsg = ResManager.loadKDString((String)"\u65b9\u6848\u975e\u5ba1\u6838\u4e14\u53ef\u7528\u3002", (String)"HisUseTask_6", (String)"mmc-mds-common", (Object[])new Object[0]);
                hisusecalclog.set("endtime", (Object)new Date());
                hisusecalclog.set("calstatus", (Object)Character.valueOf('E'));
                hisusecalclog.set("errmsg", (Object)ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", (String)"ProbabilityUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                hisusecalclog.set("errmsg_tag", (Object)logMsg);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{hisusecalclog});
            this.logId = hisusecalclog.getLong("id");
        }
        finally {
            lock.unlock();
        }
        return logMsg;
    }

    private void doExecute(RequestContext context, Map<String, Object> params) throws Exception {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u65b9\u6848", (String)"ProbabilityFetchRecordTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        String targetEntityName = DataFetchUtil.getTargetEntityName(this.datafetchsetId);
        if (!this.supportEntity(targetEntityName)) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u5386\u53f2\u4f7f\u7528\u6570\u636e\u5b9e\u4f53\u6709\u8bef\u3002", (String)"HisUseTask_2", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        this.feedbackProgress(15, ResManager.loadKDString((String)"\u6839\u636e\u53d6\u6570\u65b9\u6848\u52a0\u8f7d\u6570\u636e", (String)"ProbabilityFetchRecordTask_3", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        this.feedbackProgress(20, ResManager.loadKDString((String)"\u751f\u6210\u660e\u7ec6\u8868\u5df2\u5f00\u59cb\u3002", (String)"HisUseTask_3", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        this.calcHisUseDetail();
        this.feedbackProgress(50, ResManager.loadKDString((String)"\u660e\u7ec6\u8868\u751f\u6210\u5b8c\u6bd5\uff0c\u5f00\u59cb\u751f\u6210\u6c47\u603b\u8868\u3002", (String)"HisUseTask_4", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        this.calcHisUseResult();
        if (this.checkStop()) {
            return;
        }
        this.clearLogLatest(this.setId);
        DynamicObject probabilitylog = BusinessDataServiceHelper.loadSingle((Object)this.logId, (String)"mds_hisusecalclog");
        if (probabilitylog != null) {
            Date endDate = new Date();
            probabilitylog.set("endtime", (Object)endDate);
            BigDecimal seconds = BigDecimal.valueOf(endDate.getTime() - this.starttime.getTime()).divide(BigDecimal.valueOf(1000L), 2, 4);
            probabilitylog.set("sumtime", (Object)seconds);
            probabilitylog.set("count", (Object)this.materialCount);
            probabilitylog.set("calstatus", (Object)"C");
            probabilitylog.set("latest", (Object)true);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{probabilitylog});
        }
        HashMap<String, Comparable<Boolean>> result = new HashMap<String, Comparable<Boolean>>(16);
        result.put("success", Boolean.valueOf(true));
        result.put("logId", Long.valueOf(this.logId));
        this.feedbackCustomdata(result);
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u5b8c\u6210\u3002", (String)"HisUseTask_5", (String)"mmc-mds-common", (Object[])new Object[0]), null);
    }

    private void calcHisUseResult() {
        if (this.logId < 1L) {
            return;
        }
        String select = ProbabilityUtil.getDetailSelectField();
        QFilter filter = new QFilter("logid", "=", (Object)this.logId);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"calcHisUseResult", (String)"mds_hisusedetail", (String)select, (QFilter[])new QFilter[]{filter}, null);
        if (!MdsAlgoUtils.existField((dataSet = ProbabilityUtil.calcRecordResultData(dataSet)).getRowMeta(), "org")) {
            dataSet = dataSet.addField(String.valueOf(this.orgId), "org");
        }
        dataSet = ProbabilityDBHelper.addToDBFieldBySampleRecord(dataSet, this.logId);
        this.materialCount = dataSet.copy().count("material", true);
        if (this.checkStop()) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"mds_hisuseresult", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)this.logId)});
                DataSetSaver saver = new DataSetSaver("mds_hisuseresult");
                saver.init();
                saver.saveByDynamicObject(dataSet);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private void calcHisUseDetail() {
        DataSet dataSet = DataFetchUtil.fetchDataBySetId(this.datafetchsetId);
        dataSet = ProbabilityUtil.calcRecordData(dataSet, this.istransform);
        dataSet = ProbabilityDBHelper.addToDBFieldBySampleRecord(dataSet, this.logId);
        if (!MdsAlgoUtils.existField((dataSet = dataSet.addField(String.valueOf(this.setId), "hisuseset")).getRowMeta(), "org")) {
            dataSet = dataSet.addField(String.valueOf(this.orgId), "org");
        }
        if (this.checkStop()) {
            return;
        }
        try (TXHandle h = TX.required();){
            try {
                DeleteServiceHelper.delete((String)"mds_hisusedetail", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)this.logId)});
                DataSetSaver saver = new DataSetSaver("mds_hisusedetail");
                saver.init();
                saver.save(dataSet);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    private boolean checkStop() {
        String status = ProbabilityUtil.getProbabilityLogCalStatus(this.logId, "mds_hisusecalclog");
        return !"A".equalsIgnoreCase(status) && !"B".equalsIgnoreCase(status);
    }

    private boolean supportEntity(String targetEntityName) {
        return "mds_samplerecord".equals(targetEntityName) || "mds_hisusedetail".equals(targetEntityName);
    }

    private void clearLogLatest(Object hisusesetId) {
        DynamicObject[] probabilitylogArr = BusinessDataServiceHelper.load((String)"mds_hisusecalclog", (String)"id,latest,hisuseset", (QFilter[])new QFilter[]{new QFilter("hisuseset.id", "=", hisusesetId).and("latest", "=", (Object)true)});
        if (probabilitylogArr != null && probabilitylogArr.length > 0) {
            for (DynamicObject probabilitylog : probabilitylogArr) {
                probabilitylog.set("latest", (Object)false);
            }
            SaveServiceHelper.save((DynamicObject[])probabilitylogArr);
        }
    }
}

