/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.task;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mds.common.algorithm.Algorithm;
import kd.mmc.mds.common.probability.model.ProbabilityCalDef;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.common.probability.util.ProbabilityDefBuilder;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class ProbabilityAnalysisTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ProbabilityAnalysisTask.class);
    private ProbabilityCalDef schemeDef;
    private long logId = 0L;
    Object orgId = 0L;
    Object clear = 0L;

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        block15: {
            try (AlgoContext algoContext = Algo.newContext();){
                this.doExecute(context, params);
            }
            catch (Exception e) {
                HashMap<String, String> result = new HashMap<String, String>(16);
                result.put("failed", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ProbabilityTask_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                this.feedbackCustomdata(result);
                String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error(msg);
                String errorinfo = msg;
                if (errorinfo != null && errorinfo.length() >= 2000) {
                    errorinfo = errorinfo.substring(0, 1999);
                }
                if (this.logId == 0L) break block15;
                ProbabilityUtil.updateProbabilityLogCalStatus(this.logId, null, errorinfo);
            }
        }
    }

    private void doExecute(RequestContext context, Map<String, Object> params) throws Exception {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u65b9\u6848", (String)"ProbabilityFetchRecordTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        Object idObj = params.get("probabilitylog.id");
        this.orgId = params.get("curorg.id");
        this.clear = params.get("clearProbability");
        Object schemeDefObj = params.get("ProbabilityCalDef");
        DynamicObject log = ProbabilityUtil.ProbabilityLog(idObj);
        if (schemeDefObj instanceof ProbabilityCalDef) {
            this.schemeDef = (ProbabilityCalDef)schemeDefObj;
        } else {
            if (log == null) {
                this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5\u5fd7\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchRecordTask_7", (String)"mmc-mds-common", (Object[])new Object[0]), null);
                return;
            }
            this.logId = log.getLong("id");
            if (this.logId == 0L) {
                this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5\u5fd7\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchRecordTask_7", (String)"mmc-mds-common", (Object[])new Object[0]), null);
                return;
            }
            ProbabilityDefBuilder builder = new ProbabilityDefBuilder();
            builder.setSchemeId(this.logId);
            this.schemeDef = builder.build();
        }
        if (this.schemeDef == null) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u7528\u91cf\u6982\u7387\u8ba1\u7b97\u65b9\u6848\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchRecordTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        this.logId = this.schemeDef.getId();
        this.feedbackProgress(10, ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u6848\u5b9a\u4e49\u52a0\u8f7d\u5b8c\u6bd5\u3002", (String)"ProbabilityFetchRecordTask_2", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        List<String> countDim = this.schemeDef.getCountDim();
        List<String> analysisDim = this.schemeDef.getAnalysisDim();
        try (TXHandle h = TX.required();){
            try {
                for (String analysisDimType : analysisDim) {
                    for (String countDimType : countDim) {
                        this.calcDimType(analysisDimType, countDimType);
                    }
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u6837\u672c\u5386\u53f2\u4f7f\u7528\u6570\u636e\u751f\u6210\u6210\u529f\u3002", (String)"ProbabilityFetchRecordTask_5", (String)"mmc-mds-common", (Object[])new Object[0]), null);
    }

    private void calcDimType(String analysisDimType, String countDimType) {
        String[] group = new String[]{"backupproject"};
        if ("2".equals(countDimType)) {
            group = new String[]{"backupproject", "card"};
        }
        long algorithmDefId = this.schemeDef.getAlgorithmDefId();
        Algorithm algorithm = new Algorithm(algorithmDefId, group);
        DataSet dataSet = null;
        try {
            QFilter qFilter = new QFilter("logid", "=", (Object)this.logId);
            qFilter.and("use", "=", (Object)"1");
            qFilter.and("analysisdim", "=", (Object)analysisDimType);
            dataSet = algorithm.process(new QFilter[]{qFilter}, null, -1);
        }
        catch (Exception ex) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ProbabilityAnalysisTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            logger.error(ex.getMessage());
            return;
        }
        this.feedbackProgress(50, ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5b8c\u6210\uff0c\u5f00\u59cb\u751f\u6210\u6570\u636e\u3002", (String)"ProbabilityFetchRecordTask_4", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        dataSet = ProbabilityDBHelper.addToDBFieldByProbabilityResult(dataSet, this.logId);
        Field orgField = dataSet.getRowMeta().getField("org", false);
        if (orgField == null) {
            dataSet = dataSet.addField(String.valueOf(this.orgId), "org");
        }
        dataSet = dataSet.addField("'" + countDimType + "'", "countdim");
        dataSet = dataSet.addField("'" + analysisDimType + "'", "analysisdim");
        dataSet = dataSet.addField(String.valueOf(this.schemeDef.getBackupProjectId()), "backupproject");
        if (this.clear instanceof Boolean && ((Boolean)this.clear).booleanValue()) {
            this.clear = false;
            DeleteServiceHelper.delete((String)algorithm.getDestBillNumber(), (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)this.logId)});
        }
        algorithm.toDB(dataSet);
    }
}

