/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.form.control.UrlUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.export.ExportHelper;
import kd.mmc.mds.common.export.model.ExportField;
import kd.mmc.mds.common.probability.constant.ProbabilityConst;
import kd.mmc.mds.common.probability.model.ProbabilityCalDef;
import kd.mmc.mds.common.probability.util.ProbabilityDefBuilder;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ProbabilityExportTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ProbabilityExportTask.class);
    private ProbabilityCalDef schemeDef;
    private static String sampleFields = ProbabilityConst.sampleFields;
    private static String recordFields = ProbabilityConst.recordFields;
    private static String resultFields = ProbabilityConst.resultFields;
    private static String sampleOrder = ProbabilityConst.sampleOrder;
    private static String recordOrder = ProbabilityConst.recordOrder;
    private static String resultOrder = ProbabilityConst.resultOrder;

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (AlgoContext algoContext = Algo.newContext();){
            this.doExecute(requestContext, map);
        }
        catch (Exception e) {
            HashMap<String, String> result = new HashMap<String, String>(16);
            result.put("failed", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ProbabilityTask_0", (String)"mmc-mds-common", (Object[])new Object[0]));
            this.feedbackCustomdata(result);
            String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error(msg);
        }
    }

    private void doExecute(RequestContext context, Map<String, Object> params) throws Exception {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u65b9\u6848", (String)"ProbabilityFetchRecordTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        Object idObj = params.get("probabilitylog.id");
        Object schemeDefObj = params.get("ProbabilityCalDef");
        DynamicObject log = ProbabilityUtil.ProbabilityLog(idObj);
        long logId = 0L;
        if (schemeDefObj instanceof ProbabilityCalDef) {
            this.schemeDef = (ProbabilityCalDef)schemeDefObj;
        } else {
            if (log == null) {
                this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5\u5fd7\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchRecordTask_7", (String)"mmc-mds-common", (Object[])new Object[0]), null);
                return;
            }
            logId = log.getLong("id");
            if (logId == 0L) {
                this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5\u5fd7\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchRecordTask_7", (String)"mmc-mds-common", (Object[])new Object[0]), null);
                return;
            }
            ProbabilityDefBuilder builder = new ProbabilityDefBuilder();
            builder.setSchemeId(logId);
            this.schemeDef = builder.build();
        }
        if (this.schemeDef == null) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u7528\u91cf\u6982\u7387\u8ba1\u7b97\u65b9\u6848\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchRecordTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        logId = this.schemeDef.getId();
        this.feedbackProgress(10, ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u6848\u5b9a\u4e49\u52a0\u8f7d\u5b8c\u6bd5\u3002", (String)"ProbabilityFetchRecordTask_2", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        SXSSFWorkbook wb = new SXSSFWorkbook();
        QFilter qFilter = new QFilter("logid", "=", (Object)logId);
        DataSet sampleDataSet = QueryServiceHelper.queryDataSet((String)ProbabilityExportTask.class.getName(), (String)"mds_sample", (String)sampleFields, (QFilter[])new QFilter[]{qFilter}, (String)sampleOrder);
        Sheet sheet = wb.createSheet(ResManager.loadKDString((String)"\u6837\u672c\u6570\u636e", (String)"ProbabilityExportTask_4", (String)"mmc-mds-common", (Object[])new Object[0]));
        List<ExportField> sampleExportFields = ProbabilityConst.getSampleExportFields();
        sampleDataSet = this.transformEnum(sampleDataSet);
        ExportHelper.writerSheet((Workbook)wb, sheet, sampleDataSet, sampleExportFields);
        sampleDataSet.close();
        this.feedbackProgress(50, ResManager.loadKDString((String)"\u6837\u672c\u6570\u636e\u5bfc\u51fa\u5b8c\u6210\u3002", (String)"ProbabilityExportTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        DataSet recordDataSet = QueryServiceHelper.queryDataSet((String)ProbabilityExportTask.class.getName(), (String)"mds_samplerecord", (String)recordFields, (QFilter[])new QFilter[]{qFilter}, (String)recordOrder);
        Sheet sheet2 = wb.createSheet(ResManager.loadKDString((String)"\u6837\u672c\u5386\u53f2\u4f7f\u7528\u6570\u636e\u3002 ", (String)"ProbabilityExportTask_5", (String)"mmc-mds-common", (Object[])new Object[0]));
        List<ExportField> recordExportFields = ProbabilityConst.getRecordExportFields();
        recordDataSet = this.transformEnum(recordDataSet);
        ExportHelper.writerSheet((Workbook)wb, sheet2, recordDataSet, recordExportFields);
        recordDataSet.close();
        this.feedbackProgress(75, ResManager.loadKDString((String)"\u6837\u672c\u5386\u53f2\u4f7f\u7528\u6570\u636e\u5df2\u5b8c\u6210\u5bfc\u51fa\u3002", (String)"ProbabilityExportTask_2", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        DataSet resultDataSet = QueryServiceHelper.queryDataSet((String)ProbabilityExportTask.class.getName(), (String)"mds_probabilityresult", (String)resultFields, (QFilter[])new QFilter[]{qFilter}, (String)resultOrder);
        DataSet ataDataSet = QueryServiceHelper.queryDataSet((String)"ProbabilityExportTask", (String)"mds_probabilityresult", (String)"id,atachapterno.fbasedataid,atachapterno.fbasedataid.number as atachapterno", (QFilter[])new QFilter[]{qFilter}, null);
        ataDataSet = ataDataSet.filter("atachapterno.fbasedataid > 0");
        ataDataSet = ataDataSet.groupBy(new String[]{"id"}).groupConcat("atachapterno", "atanumber").finish();
        resultDataSet = resultDataSet.leftJoin(ataDataSet).on("id", "id").select(MdsAlgoUtils.getAllField(resultDataSet.getRowMeta()), new String[]{"atanumber"}).finish();
        Sheet sheet3 = wb.createSheet(ResManager.loadKDString((String)"\u7528\u91cf\u6982\u7387\u5206\u6790\u7ed3\u679c", (String)"ProbabilityExportTask_6", (String)"mmc-mds-common", (Object[])new Object[0]));
        List<ExportField> resultExportFields = ProbabilityConst.getResultExportFields();
        resultDataSet = this.transformEnum(resultDataSet);
        ExportHelper.writerSheet((Workbook)wb, sheet3, resultDataSet, resultExportFields);
        resultDataSet.close();
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        String tempUrl = "";
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            TempFileCache cache = CacheFactory.getCommonCacheFactory().getTempFileCache();
            int timeout = 7200;
            SimpleDateFormat sdf = new SimpleDateFormat("MMddHHmmss");
            StringBuilder fileName = new StringBuilder();
            fileName.append(ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_\u7528\u91cf\u6982\u7387\u8ba1\u7b97_", (String)"ProbabilityExportTask_7", (String)"mmc-mds-common", (Object[])new Object[0]));
            fileName.append(sdf.format(new Date()));
            fileName.append(".xlsx");
            DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
            tempUrl = cache.saveAsUrl(fileName.toString(), (InputStream)inStream, timeout);
            String tempFileId = UrlUtil.getParam((String)tempUrl, (String)"id");
            HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
            refEntitiyMap.put("entityNum", "mds_probabilitycalc");
            refEntitiyMap.put("appId", "mds");
            refEntitiyMap.put("permissionItemId", "4730fc9f000004ae");
            redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
        }
        catch (IOException e) {
            throw new KDBizException(e.getMessage());
        }
        finally {
            if (outStream != null) {
                try {
                    outStream.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            if (inStream != null) {
                try {
                    inStream.close();
                }
                catch (IOException e) {
                    logger.error((Throwable)e);
                }
            }
            try {
                wb.close();
            }
            catch (IOException e) {
                logger.error((Throwable)e);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>(16);
        result.put("exportUrl", tempUrl);
        this.feedbackCustomdata(result);
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u5bfc\u51fa\u5b8c\u6210\u3002", (String)"ProbabilityExportTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
    }

    private DataSet transformEnum(DataSet dataSet) {
        String[] fieldNames = dataSet.getRowMeta().getFieldNames();
        for (int i = 0; i < fieldNames.length; ++i) {
            String str2;
            String str1;
            String fieldName = fieldNames[i];
            if ("analysisdim".equals(fieldName)) {
                str1 = ResManager.loadKDString((String)"\u5ba2\u6237+\u68c0\u4fee\u8bbe\u5907\u7c7b\u578b+\u68c0\u4fee\u7ea7\u522b", (String)"ProbabilityExportTask_8", (String)"mmc-mds-common", (Object[])new Object[0]);
                str2 = ResManager.loadKDString((String)"\u5ba2\u6237+\u68c0\u4fee\u8bbe\u5907\u7c7b\u578b", (String)"ProbabilityExportTask_9", (String)"mmc-mds-common", (Object[])new Object[0]);
                String str3 = ResManager.loadKDString((String)"\u68c0\u4fee\u8bbe\u5907\u7c7b\u578b", (String)"ProbabilityExportTask_10", (String)"mmc-mds-common", (Object[])new Object[0]);
                fieldNames[i] = String.format("case when analysisdim='A' then '%1$s' when analysisdim='B' then '%2$s' else '%3$s' end as analysisdim", str1, str2, str3);
                continue;
            }
            if (!"countdim".equals(fieldName)) continue;
            str1 = ResManager.loadKDString((String)"\u9879\u76ee", (String)"ProbabilityExportTask_11", (String)"mmc-mds-common", (Object[])new Object[0]);
            str2 = ResManager.loadKDString((String)"\u5de5\u5361", (String)"ProbabilityExportTask_12", (String)"mmc-mds-common", (Object[])new Object[0]);
            fieldNames[i] = String.format("case when countdim='1' then '%1$s' else '%2$s' end as countdim", str1, str2);
        }
        return dataSet.select(fieldNames);
    }
}

