/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.task;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.datafetch.DataFetchUtil;
import kd.mmc.mds.common.probability.model.ProbabilityCalDef;
import kd.mmc.mds.common.probability.model.SelectDataConfig;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.common.probability.util.ProbabilityDefBuilder;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class ProbabilityFetchRecordTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ProbabilityFetchRecordTask.class);
    private ProbabilityCalDef schemeDef;
    private long logId = 0L;
    private Object orgId;
    private Object clear;
    private String targetEntityName;

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        block15: {
            try (AlgoContext algoContext = Algo.newContext();){
                this.doExecute(context, params);
            }
            catch (Exception e) {
                HashMap<String, String> result = new HashMap<String, String>(16);
                result.put("failed", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ProbabilityTask_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                this.feedbackCustomdata(result);
                String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error(msg);
                String errorinfo = msg;
                if (errorinfo != null && errorinfo.length() >= 2000) {
                    errorinfo = errorinfo.substring(0, 1999);
                }
                if (this.logId == 0L) break block15;
                ProbabilityUtil.updateProbabilityLogCalStatus(this.logId, "F", errorinfo);
            }
        }
    }

    private void doExecute(RequestContext context, Map<String, Object> params) throws Exception {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u65b9\u6848", (String)"ProbabilityFetchRecordTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        Object idObj = params.get("probabilitylog.id");
        this.orgId = params.get("curorg.id");
        this.clear = params.get("clearProbability");
        DynamicObject log = ProbabilityUtil.ProbabilityLog(idObj);
        if (log == null) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5\u5fd7\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchRecordTask_7", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        this.logId = log.getLong("id");
        if (this.logId == 0L) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5\u5fd7\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchRecordTask_7", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        ProbabilityUtil.updateProbabilityLogCalStatus(this.logId, "C");
        ProbabilityDefBuilder builder = new ProbabilityDefBuilder();
        builder.setSchemeId(this.logId);
        this.schemeDef = builder.build();
        if (this.schemeDef == null) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u7528\u91cf\u6982\u7387\u8ba1\u7b97\u65b9\u6848\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchRecordTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        this.feedbackProgress(10, ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u6848\u5b9a\u4e49\u52a0\u8f7d\u5b8c\u6bd5\u3002", (String)"ProbabilityFetchRecordTask_2", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        long datafetchsetId = this.schemeDef.getRecordFetchId();
        this.targetEntityName = DataFetchUtil.getTargetEntityName(datafetchsetId);
        if (!this.supportEntity(this.targetEntityName)) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u6837\u672c\u5386\u53f2\u4f7f\u7528\u6570\u636e\u5b9e\u4f53\u6709\u8bef\u3002", (String)"ProbabilityFetchRecordTask_6", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        this.feedbackProgress(15, ResManager.loadKDString((String)"\u6839\u636e\u53d6\u6570\u65b9\u6848\u52a0\u8f7d\u6570\u636e", (String)"ProbabilityFetchRecordTask_3", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        DataSet dataSet = DataFetchUtil.fetchDataBySetId(datafetchsetId);
        this.feedbackProgress(50, ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5b8c\u6210\uff0c\u5f00\u59cb\u751f\u6210\u6570\u636e\u3002", (String)"ProbabilityFetchRecordTask_4", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        try (TXHandle h = TX.required();){
            try {
                if (this.clear instanceof Boolean && ((Boolean)this.clear).booleanValue()) {
                    DeleteServiceHelper.delete((String)"mds_samplerecord", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)this.logId)});
                }
                List<String> analysisDim = this.schemeDef.getAnalysisDim();
                Iterator<String> iterator = analysisDim.iterator();
                while (iterator.hasNext()) {
                    String analysisDimType = iterator.next();
                    if (iterator.hasNext()) {
                        this.calcAnalysisDimType(analysisDimType, dataSet.copy());
                        continue;
                    }
                    this.calcAnalysisDimType(analysisDimType, dataSet);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u6837\u672c\u5386\u53f2\u4f7f\u7528\u6570\u636e\u751f\u6210\u6210\u529f\u3002", (String)"ProbabilityFetchRecordTask_5", (String)"mmc-mds-common", (Object[])new Object[0]), null);
    }

    private void calcAnalysisDimType(String analysisDimType, DataSet dataSet) {
        List<SelectDataConfig> recordSelect;
        dataSet = this.filterData(dataSet, analysisDimType);
        dataSet = ProbabilityUtil.doFilterData(dataSet, "cardtype", this.schemeDef.getBiztypeIds());
        Field orgField = (dataSet = ProbabilityDBHelper.addToDBFieldBySampleRecord(dataSet, this.logId)).getRowMeta().getField("org", false);
        if (orgField == null) {
            dataSet = dataSet.addField(String.valueOf(this.orgId), "org");
        }
        if ((recordSelect = this.schemeDef.getRecordSelect()) == null || recordSelect.size() == 0) {
            dataSet = dataSet.addField("1", "sysuse");
            dataSet = dataSet.addField("1", "use");
        }
        dataSet = dataSet.addField("'" + analysisDimType + "'", "analysisdim");
        dataSet = dataSet.addField(String.valueOf(this.schemeDef.getBackupProjectId()), "backupproject");
        DataSetSaver saver = new DataSetSaver("mds_samplerecord");
        saver.init();
        saver.save(dataSet);
        if (recordSelect != null && recordSelect.size() > 0) {
            Set<Long> selectIds = ProbabilityDBHelper.getSelectDataId(this.logId, "mds_samplerecord", recordSelect, analysisDimType);
            ProbabilityDBHelper.updateSelectField(selectIds, "t_mds_samplehisrecord");
        }
        ProbabilityUtil.updateProbabilityLogCalStatus(this.logId, "D");
    }

    private DataSet filterData(DataSet dataSet, String analysisDimType) {
        Set<Long> projectIds = this.getProjectIds(analysisDimType);
        if (projectIds.size() == 0) {
            return dataSet.filter("1=2");
        }
        return ProbabilityUtil.calcRecordData(dataSet, this.schemeDef.isMaterialChange(), projectIds);
    }

    private Set<Long> getProjectIds(String analysisDimType) {
        QFilter qFilter = new QFilter("logid", "=", (Object)this.schemeDef.getId());
        qFilter.and("use", "=", (Object)"1");
        qFilter.and("analysisdim", "=", (Object)analysisDimType);
        DataSet sampleDataSet = QueryServiceHelper.queryDataSet((String)ProbabilityFetchRecordTask.class.getName(), (String)"mds_sample", (String)"project,use,logid", (QFilter[])new QFilter[]{qFilter}, null);
        HashSet<Long> projectIds = new HashSet<Long>(16);
        for (Row row : sampleDataSet) {
            Long projectId = row.getLong("project");
            if (projectId == null || projectId <= 0L) continue;
            projectIds.add(projectId);
        }
        return projectIds;
    }

    private boolean supportEntity(String targetEntityName) {
        return "mds_samplerecord".equals(targetEntityName) || "mds_hisusedetail".equals(targetEntityName);
    }
}

