/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.task;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.AlgoContext;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.datafetch.DataFetchUtil;
import kd.mmc.mds.common.probability.model.ProbabilityCalDef;
import kd.mmc.mds.common.probability.model.SelectDataConfig;
import kd.mmc.mds.common.probability.util.ProbabilityDBHelper;
import kd.mmc.mds.common.probability.util.ProbabilityDefBuilder;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import kd.mmc.mds.common.stockup.util.StockUpStatusHelper;

public class ProbabilityFetchSampleTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(ProbabilityFetchSampleTask.class);
    private ProbabilityCalDef schemeDef;
    private long logId = 0L;
    private Object orgId;
    private Object clear;
    private String targetEntityName;

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        block15: {
            try (AlgoContext algoContext = Algo.newContext();){
                this.doExecute(context, params);
            }
            catch (Exception e) {
                HashMap<String, String> result = new HashMap<String, String>(16);
                result.put("failed", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ProbabilityTask_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                this.feedbackCustomdata(result);
                String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
                logger.error(msg);
                String errorinfo = msg;
                if (errorinfo != null && errorinfo.length() >= 2000) {
                    errorinfo = errorinfo.substring(0, 1999);
                }
                if (this.logId == 0L) break block15;
                ProbabilityUtil.updateProbabilityLogCalStatus(this.logId, "E", errorinfo);
            }
        }
    }

    private void doExecute(RequestContext context, Map<String, Object> params) throws Exception {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u83b7\u53d6\u8ba1\u7b97\u65b9\u6848", (String)"ProbabilityFetchSampleTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        Object idObj = params.get("probabilitylog.id");
        this.orgId = params.get("curorg.id");
        this.clear = params.get("clearProbability");
        DynamicObject log = ProbabilityUtil.ProbabilityLog(idObj);
        if (log == null) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5\u5fd7\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchSampleTask_7", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        this.logId = log.getLong("id");
        if (this.logId == 0L) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u8ba1\u7b97\u65e5\u5fd7\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchSampleTask_7", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        ProbabilityUtil.updateProbabilityLogCalStatus(this.logId, "A");
        ProbabilityDefBuilder builder = new ProbabilityDefBuilder();
        builder.setSchemeId(this.logId);
        this.schemeDef = builder.build();
        if (this.schemeDef == null) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u7528\u91cf\u6982\u7387\u8ba1\u7b97\u65b9\u6848\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"ProbabilityFetchSampleTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        this.feedbackProgress(10, ResManager.loadKDString((String)"\u8ba1\u7b97\u65b9\u6848\u5b9a\u4e49\u52a0\u8f7d\u5b8c\u6bd5\u3002", (String)"ProbabilityFetchSampleTask_2", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        long datafetchsetId = this.schemeDef.getSampleFetchId();
        this.targetEntityName = DataFetchUtil.getTargetEntityName(datafetchsetId);
        if (!this.supportEntity(this.targetEntityName)) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u6837\u672c\u6570\u636e\u5b9e\u4f53\u6709\u8bef\u3002", (String)"ProbabilityFetchSampleTask_6", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        this.feedbackProgress(15, ResManager.loadKDString((String)"\u6839\u636e\u53d6\u6570\u65b9\u6848\u52a0\u8f7d\u6570\u636e", (String)"ProbabilityFetchSampleTask_3", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        DataSet dataSet = DataFetchUtil.fetchDataBySetId(datafetchsetId);
        this.feedbackProgress(50, ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5b8c\u6210\uff0c\u5f00\u59cb\u751f\u6210\u6570\u636e\u3002", (String)"ProbabilityFetchSampleTask_4", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        DataSet stockupRecord = QueryServiceHelper.queryDataSet((String)StockUpStatusHelper.class.getName(), (String)"mds_stockuprecord", (String)"projectid,cabinconfig,polarisstatus", (QFilter[])new QFilter[]{new QFilter("projectid", ">", (Object)0L)}, null);
        stockupRecord = stockupRecord.groupBy(new String[]{"projectid"}).max("cabinconfig").max("polarisstatus").finish();
        dataSet = dataSet.leftJoin(stockupRecord).on("project", "projectid").select(MdsAlgoUtils.getAllField(dataSet.getRowMeta()), new String[]{"cabinconfig", "polarisstatus"}).finish();
        try (TXHandle h = TX.required();){
            try {
                if (this.clear instanceof Boolean && ((Boolean)this.clear).booleanValue()) {
                    DeleteServiceHelper.delete((String)"mds_sample", (QFilter[])new QFilter[]{new QFilter("logid", "=", (Object)this.logId)});
                }
                List<String> analysisDim = this.schemeDef.getAnalysisDim();
                Iterator<String> iterator = analysisDim.iterator();
                while (iterator.hasNext()) {
                    String analysisDimType = iterator.next();
                    if (iterator.hasNext()) {
                        this.calcAnalysisDimType(analysisDimType, dataSet.copy());
                        continue;
                    }
                    this.calcAnalysisDimType(analysisDimType, dataSet);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u6837\u672c\u6570\u636e\u5df2\u6210\u529f\u751f\u6210\u3002", (String)"ProbabilityFetchSampleTask_5", (String)"mmc-mds-common", (Object[])new Object[0]), null);
    }

    private void calcAnalysisDimType(String analysisDimType, DataSet dataSet) {
        List<SelectDataConfig> sampleSelect;
        dataSet = this.filterData(dataSet, analysisDimType);
        Field orgField = (dataSet = ProbabilityDBHelper.addToDBFieldBySample(dataSet, this.logId)).getRowMeta().getField("org", false);
        if (orgField == null) {
            dataSet = dataSet.addField(String.valueOf(this.orgId), "org");
        }
        if ((sampleSelect = this.schemeDef.getSampleSelect()) == null || sampleSelect.size() == 0) {
            dataSet = dataSet.addField("1", "sysuse");
            dataSet = dataSet.addField("1", "use");
        }
        dataSet = dataSet.addField("'" + analysisDimType + "'", "analysisdim");
        dataSet = dataSet.addField(String.valueOf(this.schemeDef.getBackupProjectId()), "backupproject");
        DataSetSaver saver = new DataSetSaver("mds_sample");
        saver.init();
        saver.save(dataSet);
        if (sampleSelect != null && sampleSelect.size() > 0) {
            Set<Long> selectIds = ProbabilityDBHelper.getSelectDataId(this.logId, "mds_sample", sampleSelect, analysisDimType);
            ProbabilityDBHelper.updateSelectField(selectIds, "t_mds_sample");
        }
        ProbabilityUtil.updateProbabilityLogCalStatus(this.logId, "B");
    }

    private DataSet filterData(DataSet dataSet, String analysisDimType) {
        List<Long> actypeIds;
        List<Long> customerIds;
        if ("A".equals(analysisDimType)) {
            customerIds = this.schemeDef.getCustomerIds();
            dataSet = ProbabilityUtil.doFilterData(dataSet, "customer", customerIds);
            actypeIds = this.schemeDef.getActypeIds();
            dataSet = ProbabilityUtil.doFilterData(dataSet, "actype", actypeIds);
            List<Long> checktypeIds = this.schemeDef.getChecktypeIds();
            dataSet = ProbabilityUtil.doFilterData(dataSet, "checktype", checktypeIds);
        } else if ("B".equals(analysisDimType)) {
            customerIds = this.schemeDef.getCustomerIds();
            dataSet = ProbabilityUtil.doFilterData(dataSet, "customer", customerIds);
            actypeIds = this.schemeDef.getActypeIds();
            dataSet = ProbabilityUtil.doFilterData(dataSet, "actype", actypeIds);
        } else if ("C".equals(analysisDimType)) {
            List<Long> actypeIds2 = this.schemeDef.getActypeIds();
            dataSet = ProbabilityUtil.doFilterData(dataSet, "actype", actypeIds2);
        }
        List<Long> projectstateIds = this.schemeDef.getProjectstateIds();
        dataSet = ProbabilityUtil.doFilterData(dataSet, "projectstate", projectstateIds);
        List<Long> cardtypeIds = this.schemeDef.getCardtypeIds();
        dataSet = ProbabilityUtil.doFilterData(dataSet, "cardtype", cardtypeIds);
        List<Long> cabinconfigIds = this.schemeDef.getCabinconfigIds();
        dataSet = ProbabilityUtil.doFilterData(dataSet, "cabinconfig", cabinconfigIds);
        List<Long> polarisstatusIds = this.schemeDef.getPolarisstatusIds();
        dataSet = ProbabilityUtil.doFilterData(dataSet, "polarisstatus", polarisstatusIds);
        List<Long> cardIds = this.schemeDef.getCardIds();
        if (cardIds == null || cardIds.size() > 0) {
            // empty if block
        }
        return dataSet;
    }

    private boolean supportEntity(String targetEntityName) {
        return "mds_sample".equals(targetEntityName) || "mds_mroplan".equals(targetEntityName) || "mds_generalplan".equals(targetEntityName);
    }
}

