/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.util;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.probability.model.GeneralBackupDef;

public class GeneralBackupDefBuilder {
    private Long schemeId;
    private DynamicObject scheme;

    public GeneralBackupDef build() {
        if (this.scheme == null) {
            this.scheme = this.loadScheme(this.schemeId);
        }
        if (this.scheme == null) {
            return null;
        }
        GeneralBackupDef def = new GeneralBackupDef();
        def.setId(this.schemeId);
        def.setSpecial(this.scheme.getBoolean("specialcond"));
        def.setGeneralplanId(this.scheme.getLong("generalplan.id"));
        def.setRepeat(this.scheme.getBoolean("repeatcal"));
        def.setHisusesetId(this.scheme.getLong("hisuseset.id"));
        def.setUseCountMin(this.scheme.getInt("usecountmin"));
        def.setUseCountMax(this.scheme.getInt("usecountmax"));
        def.setSpecialReq(this.scheme.getBoolean("specialreq"));
        if (this.scheme.getBoolean("cusandactype")) {
            def.setCheckTypeCount(this.scheme.getInt("checktypecount"));
        } else {
            def.setCheckTypeCount(null);
        }
        if (this.scheme.getBoolean("actype")) {
            def.setCustomerCount(this.scheme.getInt("customercount"));
        } else {
            def.setCustomerCount(null);
        }
        if (this.scheme.getBoolean("customer")) {
            def.setAcTypeCount(this.scheme.getInt("actypecount"));
        } else {
            def.setAcTypeCount(null);
        }
        boolean isMaterialGroupAll = this.scheme.getBoolean("isall");
        def.setMaterialGroupAll(isMaterialGroupAll);
        if (!isMaterialGroupAll) {
            DynamicObjectCollection materialGroup = this.scheme.getDynamicObjectCollection("materialgroup");
            List<Long> materialGroupIdList = materialGroup.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList());
            def.setMaterialGroupIdList(materialGroupIdList);
        }
        return def;
    }

    private DynamicObject loadScheme(Long schemeId) {
        if (schemeId == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"mds_generalset");
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public DynamicObject getScheme() {
        return this.scheme;
    }

    public void setScheme(DynamicObject scheme) {
        this.scheme = scheme;
    }
}

