/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.id.ID;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.deliveryquery.algo.AddIdMapFunctionByAlgo;
import kd.mmc.mds.common.probability.model.SelectDataConfig;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import kd.mmc.mds.common.util.SliceUtil;

public class ProbabilityDBHelper {
    public static DataSet addToDBFieldBySample(DataSet dataSet, Object logId) {
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "creator")) {
            dataSet = dataSet.removeFields(new String[]{"creator"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "modifier")) {
            dataSet = dataSet.removeFields(new String[]{"modifier"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "createtime")) {
            dataSet = dataSet.removeFields(new String[]{"createtime"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "modifytime")) {
            dataSet = dataSet.removeFields(new String[]{"modifytime"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "logid")) {
            dataSet = dataSet.removeFields(new String[]{"logid"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "status")) {
            dataSet = dataSet.removeFields(new String[]{"status"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "billstatus")) {
            dataSet = dataSet.removeFields(new String[]{"billstatus"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "id")) {
            dataSet = dataSet.removeFields(new String[]{"id"});
        }
        Long userId = RequestContext.get().getCurrUserId();
        dataSet = dataSet.addField(String.valueOf(userId), "creator");
        dataSet = dataSet.addField(String.valueOf(userId), "modifier");
        dataSet = dataSet.addField("now()", "createtime");
        dataSet = dataSet.addField("now()", "modifytime");
        dataSet = dataSet.addField(String.valueOf(logId), "logid");
        dataSet = dataSet.addField("'A'", "status");
        dataSet = dataSet.addField("'A'", "billstatus");
        dataSet = dataSet.addNullField("id");
        return dataSet.map((MapFunction)new AddIdMapFunctionByAlgo(dataSet.getRowMeta(), "id"));
    }

    public static DataSet addToDBFieldBySampleRecord(DataSet dataSet, Object logId) {
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "creator")) {
            dataSet = dataSet.removeFields(new String[]{"creator"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "modifier")) {
            dataSet = dataSet.removeFields(new String[]{"modifier"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "createtime")) {
            dataSet = dataSet.removeFields(new String[]{"createtime"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "modifytime")) {
            dataSet = dataSet.removeFields(new String[]{"modifytime"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "logid")) {
            dataSet = dataSet.removeFields(new String[]{"logid"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "status")) {
            dataSet = dataSet.removeFields(new String[]{"status"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "billstatus")) {
            dataSet = dataSet.removeFields(new String[]{"billstatus"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "id")) {
            dataSet = dataSet.removeFields(new String[]{"id"});
        }
        Long userId = RequestContext.get().getCurrUserId();
        dataSet = dataSet.addField(String.valueOf(userId), "creator");
        dataSet = dataSet.addField(String.valueOf(userId), "modifier");
        dataSet = dataSet.addField("now()", "createtime");
        dataSet = dataSet.addField("now()", "modifytime");
        dataSet = dataSet.addField(String.valueOf(logId), "logid");
        dataSet = dataSet.addField("'A'", "status");
        dataSet = dataSet.addField("'A'", "billstatus");
        dataSet = dataSet.addNullField("id");
        return dataSet.map((MapFunction)new AddIdMapFunctionByAlgo(dataSet.getRowMeta(), "id"));
    }

    public static DataSet addToDBFieldByProbabilityResult(DataSet dataSet, Object logId) {
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "creator")) {
            dataSet = dataSet.removeFields(new String[]{"creator"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "modifier")) {
            dataSet = dataSet.removeFields(new String[]{"modifier"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "createtime")) {
            dataSet = dataSet.removeFields(new String[]{"createtime"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "modifytime")) {
            dataSet = dataSet.removeFields(new String[]{"modifytime"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "logid")) {
            dataSet = dataSet.removeFields(new String[]{"logid"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "status")) {
            dataSet = dataSet.removeFields(new String[]{"status"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "billstatus")) {
            dataSet = dataSet.removeFields(new String[]{"billstatus"});
        }
        if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "id")) {
            dataSet = dataSet.removeFields(new String[]{"id"});
        }
        Long userId = RequestContext.get().getCurrUserId();
        dataSet = dataSet.addField(String.valueOf(userId), "creator");
        dataSet = dataSet.addField(String.valueOf(userId), "modifier");
        dataSet = dataSet.addField("now()", "createtime");
        dataSet = dataSet.addField("now()", "modifytime");
        dataSet = dataSet.addField(String.valueOf(logId), "logid");
        dataSet = dataSet.addField("'A'", "status");
        dataSet = dataSet.addField("'A'", "billstatus");
        dataSet = dataSet.addNullField("id");
        return dataSet.map((MapFunction)new AddIdMapFunctionByAlgo(dataSet.getRowMeta(), "id"));
    }

    public static void updateSelectField(Set<Long> ids, String tableName) {
        String sql = " update %s set fsysuse=1,fuse=1 where fid in (%s)";
        List<ArrayList<Long>> slices = SliceUtil.slice(new ArrayList<Long>(ids), 1000);
        try (TXHandle h = TX.required();){
            try {
                for (List list : slices) {
                    String idStr = list.stream().map(String::valueOf).collect(Collectors.joining(","));
                    if (!StringUtils.isNotEmpty((String)idStr)) continue;
                    String updataSql = String.format(sql, tableName, idStr);
                    ProbabilityDBHelper.dbExecute(updataSql);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void clearUserSelectField(long logid, String tableName) {
        String sql = " update %s set fuse=0 where flogid = %s";
        String updataSql = String.format(sql, tableName, logid);
        ProbabilityDBHelper.dbExecute(updataSql);
    }

    public static void updateUserSelectField(Set<Long> ids, String tableName) {
        String sql = " update %s set fuse=1 where fid in (%s)";
        List<ArrayList<Long>> slices = SliceUtil.slice(new ArrayList<Long>(ids), 1000);
        try (TXHandle h = TX.required();){
            try {
                for (List list : slices) {
                    String idStr = list.stream().map(String::valueOf).collect(Collectors.joining(","));
                    if (!StringUtils.isNotEmpty((String)idStr)) continue;
                    String updataSql = String.format(sql, tableName, idStr);
                    ProbabilityDBHelper.dbExecute(updataSql);
                }
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static void deleteByLogId2(Object idObj, String tableName) {
        String deleteSql = "delete from %s where flogid=%s";
        deleteSql = String.format(deleteSql, tableName, String.valueOf(idObj));
        try (TXHandle h = TX.required();){
            try {
                ProbabilityDBHelper.dbExecute(deleteSql);
            }
            catch (Throwable e) {
                h.markRollback();
                throw e;
            }
        }
    }

    public static Set<Long> getSelectDataId(Object logId, String entityName, List<SelectDataConfig> sampleSelect) {
        return ProbabilityDBHelper.getSelectDataId(logId, entityName, sampleSelect, "");
    }

    public static Set<Long> getSelectDataId(Object logId, String entityName, List<SelectDataConfig> sampleSelect, String analysisDimType) {
        HashSet<Long> ids = new HashSet<Long>(4096);
        for (SelectDataConfig cof : sampleSelect) {
            String filterContent = cof.getFilterContent();
            QFilter logfilter = new QFilter("logid", "=", logId);
            QFilter analysisDimTypeFilter = new QFilter("analysisdim", "=", (Object)analysisDimType);
            QFilter filter = null;
            if (StringUtils.isNotEmpty((String)filterContent)) {
                filter = ProbabilityUtil.getQFilter(filterContent, entityName);
            }
            if (cof.isSelectAll()) {
                DataSet select = ProbabilityDBHelper.queryDataSet(entityName, new QFilter[]{filter, logfilter, analysisDimTypeFilter}, "id", "id desc");
                for (Row row : select) {
                    ids.add(row.getLong("id"));
                }
                continue;
            }
            int count = cof.getSelectCount();
            if (count == 0) continue;
            List<String[]> order = cof.getOrder();
            String orderStr = order.stream().map(m -> String.join((CharSequence)" ", m[0], m[1])).collect(Collectors.joining(","));
            CharSequence[] groupArr = cof.getGroup();
            String group = String.join((CharSequence)",", groupArr);
            StringBuilder selectSb = new StringBuilder("id");
            if (StringUtils.isNotEmpty((String)group)) {
                selectSb.append(",").append(group);
            }
            DataSet select = ProbabilityDBHelper.queryDataSet(entityName, new QFilter[]{filter, logfilter, analysisDimTypeFilter}, selectSb.toString(), orderStr);
            HashSet<Integer> selectSet = new HashSet<Integer>();
            for (Row row : select) {
                StringBuilder sb = new StringBuilder();
                for (CharSequence field : groupArr) {
                    sb.append(row.get((String)field)).append("#");
                }
                int code = sb.toString().hashCode();
                if (selectSet.contains(code)) {
                    ids.add(row.getLong("id"));
                    continue;
                }
                if (selectSet.size() >= count) continue;
                ids.add(row.getLong("id"));
                selectSet.add(code);
            }
        }
        return ids;
    }

    private static DataSet queryDataSet(String entityName, QFilter[] qFilters, String selectFields, String orderBys) {
        return QueryServiceHelper.queryDataSet((String)ProbabilityDBHelper.class.getName(), (String)entityName, (String)selectFields, (QFilter[])qFilters, (String)orderBys);
    }

    public static String genStringId() {
        return ID.genStringId();
    }

    private static void dbExecute(String updateSeqSql) {
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)updateSeqSql);
    }
}

