/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.util;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.mmc.mds.common.probability.model.ProbabilityCalDef;
import kd.mmc.mds.common.probability.model.SelectDataConfig;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;

public class ProbabilityDefBuilder {
    private Long schemeId;
    private DynamicObject scheme;

    public ProbabilityCalDef build() {
        if (this.scheme == null) {
            this.scheme = ProbabilityUtil.ProbabilityLog(this.schemeId);
        }
        if (this.scheme == null) {
            return null;
        }
        ProbabilityCalDef def = new ProbabilityCalDef();
        def.setId(this.schemeId);
        def.setBackupProjectId(this.scheme.getLong("backupproject.id"));
        def.setSampleFetchId(this.scheme.getLong("sampledata.id"));
        def.setRecordFetchId(this.scheme.getLong("historydata.id"));
        def.setSampleRelRecord(this.scheme.getString("samplehistoryfilterval"));
        def.setAlgorithmDefId(this.scheme.getLong("algorithmdef.id"));
        def.setMaterialChange(this.scheme.getBoolean("materialchange"));
        String analysisdimStr = this.scheme.getString("analysisdim");
        String countdimStr = this.scheme.getString("countdim");
        ArrayList<String> analysisDim = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)analysisdimStr)) {
            analysisDim.addAll(Arrays.asList(analysisdimStr.split(",")));
            analysisDim.remove("");
        }
        def.setAnalysisDim(analysisDim);
        ArrayList<String> countDim = new ArrayList<String>(16);
        if (StringUtils.isNotEmpty((CharSequence)countdimStr)) {
            countDim.addAll(Arrays.asList(countdimStr.split(",")));
            countDim.remove("");
        }
        def.setCountDim(countDim);
        List<SelectDataConfig> sampleSelect = this.buildSampleSelect();
        List<SelectDataConfig> recordSelect = this.buildRecordSelect();
        List<SelectDataConfig> resultFilter = this.buildResultFilter();
        def.setSampleSelect(sampleSelect);
        def.setRecordSelect(recordSelect);
        def.setResultSelect(resultFilter);
        DynamicObjectCollection customerColl = this.scheme.getDynamicObjectCollection("customer");
        DynamicObjectCollection actypeColl = this.scheme.getDynamicObjectCollection("actype");
        DynamicObjectCollection checktypeColl = this.scheme.getDynamicObjectCollection("checktype");
        DynamicObjectCollection projectstateColl = this.scheme.getDynamicObjectCollection("projectstate");
        DynamicObjectCollection cardtypeColl = this.scheme.getDynamicObjectCollection("cardtype");
        DynamicObjectCollection cardColl = this.scheme.getDynamicObjectCollection("card");
        DynamicObjectCollection biztypeColl = this.scheme.getDynamicObjectCollection("biztype");
        DynamicObjectCollection polarisstatusColl = this.scheme.getDynamicObjectCollection("polarisstatus");
        DynamicObjectCollection cabinconfigColl = this.scheme.getDynamicObjectCollection("cabinconfig");
        def.setCustomerIds(customerColl.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
        def.setActypeIds(actypeColl.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
        def.setChecktypeIds(checktypeColl.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
        def.setProjectstateIds(projectstateColl.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
        def.setCardtypeIds(cardtypeColl.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
        def.setCardIds(cardColl.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
        def.setBiztypeIds(biztypeColl.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
        def.setPolarisstatusIds(polarisstatusColl.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
        def.setCabinconfigIds(cabinconfigColl.stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
        String commongroup = this.scheme.getString("commongroup");
        List<String> commongroupList = new LinkedList<String>();
        if (StringUtils.isNotEmpty((CharSequence)commongroup)) {
            String[] split = commongroup.split(",");
            commongroupList = Arrays.stream(split).filter(StringUtils::isNotEmpty).collect(Collectors.toList());
        }
        def.setCommongroupIds(commongroupList);
        return def;
    }

    private List<SelectDataConfig> buildSampleSelect() {
        LinkedList<SelectDataConfig> list = new LinkedList<SelectDataConfig>();
        DynamicObjectCollection coll = this.scheme.getDynamicObjectCollection("sampleentryentity");
        for (DynamicObject row : coll) {
            SelectDataConfig cof = new SelectDataConfig();
            cof.setFilterContent(row.getString("spselectfilterval"));
            boolean selectAll = row.getBoolean("spselectall");
            cof.setSelectAll(selectAll);
            int num = row.getInt("spdataselectnum");
            if (num > 0) {
                cof.setSelectCount(num);
                String groupStr = row.getString("spselectdimensionval");
                if (StringUtils.isNotEmpty((CharSequence)groupStr)) {
                    cof.setGroup(groupStr.split(","));
                } else {
                    cof.setGroup(new String[0]);
                }
                List values = JSON.parseArray((String)row.getString("spsortval"), String[].class);
                cof.setOrder(values);
            }
            list.add(cof);
        }
        return list;
    }

    private List<SelectDataConfig> buildRecordSelect() {
        LinkedList<SelectDataConfig> list = new LinkedList<SelectDataConfig>();
        DynamicObjectCollection coll = this.scheme.getDynamicObjectCollection("historyentryentity");
        for (DynamicObject row : coll) {
            SelectDataConfig cof = new SelectDataConfig();
            cof.setFilterContent(row.getString("hpselectfilterval"));
            int num = row.getInt("hpdataselectnum");
            boolean selectAll = row.getBoolean("hpselectall");
            cof.setSelectAll(selectAll);
            if (num > 0) {
                cof.setSelectCount(num);
                String groupStr = row.getString("hpselectdimensionval");
                if (StringUtils.isNotEmpty((CharSequence)groupStr)) {
                    cof.setGroup(groupStr.split(","));
                } else {
                    cof.setGroup(new String[0]);
                }
                List values = JSON.parseArray((String)row.getString("hpsortval"), String[].class);
                cof.setOrder(values);
            }
            list.add(cof);
        }
        return list;
    }

    private List<SelectDataConfig> buildResultFilter() {
        LinkedList<SelectDataConfig> list = new LinkedList<SelectDataConfig>();
        DynamicObjectCollection coll = this.scheme.getDynamicObjectCollection("resultentryentity");
        for (DynamicObject row : coll) {
            SelectDataConfig cof = new SelectDataConfig();
            cof.setFilterContent(row.getString("rpselectfilterval"));
            list.add(cof);
        }
        return list;
    }

    public Long getSchemeId() {
        return this.schemeId;
    }

    public void setSchemeId(Long schemeId) {
        this.schemeId = schemeId;
    }

    public DynamicObject getScheme() {
        return this.scheme;
    }

    public void setScheme(DynamicObject scheme) {
        this.scheme = scheme;
    }
}

