/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.probability.util;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.CoGroupFunction;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.JobSession;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.MapFunction;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.ComboItem;
import kd.bos.orm.query.QFilter;
import kd.bos.service.IUserService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.probability.task.ProbabilityFetchRecordTask;
import kd.mmc.mds.common.util.MDSTransformUtil;
import kd.mmc.mds.mservice.algox.HisUseResultLate12MonthReduceGroupFunction;
import kd.mmc.mds.mservice.algox.HisUseResultLongCycleCoGroupFunction;
import kd.mmc.mds.mservice.algox.HisUseResultMaterialGeneralCoGroupFunction;
import kd.mmc.mds.mservice.algox.HisUseResultReduceGroupFunction;
import kd.mmc.mds.mservice.algox.MroOrderTransMapFunction;
import kd.mpscmm.msplan.mrp.business.helper.MrpEntityTypeUtil;

public class ProbabilityUtil {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("probabilitynumber");
    private static final String MDS_PROBABILITYLOG = "mds_probabilitylog";
    private static final String MDS_PROBABILITYCALDEF = "mds_probabilitycaldef";

    public static DynamicObject ProbabilityScheme(Object idObj) {
        if (idObj == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)idObj, (String)MDS_PROBABILITYCALDEF);
    }

    public static DynamicObject ProbabilityLog(Object idObj) {
        if (idObj == null) {
            return null;
        }
        return BusinessDataServiceHelper.loadSingle((Object)idObj, (String)MDS_PROBABILITYLOG);
    }

    public static Long CreateProbabilityLog(Object schemeId, Map<String, Object> params) {
        if (schemeId == null) {
            return null;
        }
        DynamicObject def = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)MDS_PROBABILITYCALDEF);
        if (def == null) {
            return null;
        }
        DynamicObject probabilitylog = BusinessDataServiceHelper.newDynamicObject((String)MDS_PROBABILITYLOG);
        String number = ProbabilityUtil.getUnRepeatNumber(probabilitylog);
        probabilitylog.set("number", (Object)number);
        probabilitylog.set("name", (Object)number);
        probabilitylog.set("creator", (Object)RequestContext.get().getCurrUserId());
        probabilitylog.set("createtime", (Object)new Date());
        ProbabilityUtil.setProbabilityLog(def, params, probabilitylog);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{probabilitylog});
        return probabilitylog.getLong("id");
    }

    public static Long updateProbabilityLog(Object schemeId, Object probabilityLogId, Map<String, Object> params) {
        if (schemeId == null || probabilityLogId == null) {
            return null;
        }
        DynamicObject def = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)MDS_PROBABILITYCALDEF);
        if (def == null) {
            return null;
        }
        DynamicObject probabilitylog = BusinessDataServiceHelper.loadSingle((Object)probabilityLogId, (String)MDS_PROBABILITYLOG);
        if (probabilitylog == null) {
            return null;
        }
        ProbabilityUtil.setProbabilityLog(def, params, probabilitylog);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{probabilitylog});
        return probabilitylog.getLong("id");
    }

    public static DataSetX transProbabilityRecordOrderId(JobSession session, DataSetX calcDataSetX, Set<Long> projectIds) {
        DataSetX dataSetX = calcDataSetX;
        dataSetX = ProbabilityUtil.addMissField(dataSetX);
        RowMeta meta = dataSetX.getRowMeta();
        if (projectIds != null) {
            if (projectIds.size() == 0) {
                dataSetX = dataSetX.filter("project=-1");
            } else {
                String idsStr = projectIds.stream().map(String::valueOf).collect(Collectors.joining(","));
                dataSetX = dataSetX.filter(String.format("project in (%s)", idsStr));
            }
        }
        if (MdsAlgoUtils.existField(meta, "orderid")) {
            DataSet mroorderDataSet = ProbabilityUtil.getMroOrder(projectIds);
            DataSetInput mroorderDataSetInput = new DataSetInput(mroorderDataSet);
            DataSetX mroorderDataSetX = session.fromInput((Input)mroorderDataSetInput);
            JoinDataSetX mrojoin = dataSetX.leftJoin(mroorderDataSetX);
            mrojoin = mrojoin.on("orderid", "id");
            dataSetX = mrojoin.select(MdsAlgoUtils.getAllField(meta), new String[]{"transactiontype.transactiontype", "treeentryentity.workcard.baseata", "treeentryentity.workcard"});
            HashMap<String, String> transFieldMap = new HashMap<String, String>(16);
            transFieldMap.put("biztype", "transactiontype.transactiontype");
            transFieldMap.put("atachapterno", "treeentryentity.workcard.baseata");
            transFieldMap.put("card", "treeentryentity.workcard");
            return dataSetX.map((MapFunction)new MroOrderTransMapFunction(dataSetX.getRowMeta(), transFieldMap));
        }
        return dataSetX;
    }

    private static DataSetX addMissField(DataSetX dataSetX) {
        Field field;
        RowMeta meta = dataSetX.getRowMeta();
        LinkedList<Field> addFields = new LinkedList<Field>();
        LinkedList<Long> addValues = new LinkedList<Long>();
        if (!MdsAlgoUtils.existField(meta, "project")) {
            field = new Field("project", (DataType)DataType.LongType);
            addFields.add(field);
            addValues.add(0L);
        }
        if (!MdsAlgoUtils.existField(meta, "checktype")) {
            field = new Field("checktype", (DataType)DataType.LongType);
            addFields.add(field);
            addValues.add(0L);
        }
        if (!MdsAlgoUtils.existField(meta, "biztype")) {
            field = new Field("biztype", (DataType)DataType.LongType);
            addFields.add(field);
            addValues.add(0L);
        }
        if (!MdsAlgoUtils.existField(meta, "atachapterno")) {
            field = new Field("atachapterno", (DataType)DataType.LongType);
            addFields.add(field);
            addValues.add(0L);
        }
        if (!MdsAlgoUtils.existField(meta, "card")) {
            field = new Field("card", (DataType)DataType.LongType);
            addFields.add(field);
            addValues.add(0L);
        }
        if (!MdsAlgoUtils.existField(meta, "customer")) {
            field = new Field("customer", (DataType)DataType.LongType);
            addFields.add(field);
            addValues.add(0L);
        }
        if (!MdsAlgoUtils.existField(meta, "actype")) {
            field = new Field("actype", (DataType)DataType.LongType);
            addFields.add(field);
            addValues.add(0L);
        }
        return dataSetX.addFields(addFields.toArray(new Field[0]), addValues.toArray(new Object[0]));
    }

    private static DataSet getMroOrder(Set<Long> projectIds) {
        LinkedList<String> mroorderField = new LinkedList<String>();
        mroorderField.add("id");
        mroorderField.add("transactiontype.transactiontype");
        mroorderField.add("treeentryentity.workcard");
        mroorderField.add("treeentryentity.workcard.baseata");
        QFilter filter = new QFilter("id", ">", (Object)0L);
        if (projectIds != null && projectIds.size() > 0) {
            filter.and("treeentryentity.project", "in", projectIds);
        }
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)ProbabilityFetchRecordTask.class.getName(), (String)"pom_mroorder", (String)String.join((CharSequence)",", mroorderField), (QFilter[])new QFilter[]{filter}, null);
        dataSet = dataSet.groupBy(new String[]{"id"}).max("transactiontype.transactiontype").max("treeentryentity.workcard").max("treeentryentity.workcard.baseata").finish();
        return dataSet;
    }

    private static void setProbabilityLog(DynamicObject def, Map<String, Object> params, DynamicObject probabilitylog) {
        FilterBuilder filterBuilder;
        probabilitylog.set("createorg", params.get("curorg"));
        probabilitylog.set("probabilitycaldef", (Object)def);
        probabilitylog.set("materialchange", (Object)def.getBoolean("materialchange"));
        ProbabilityUtil.setMulBaseDataValue(params, "customer_filter", probabilitylog, "customer");
        ProbabilityUtil.setMulBaseDataValue(params, "actype_filter", probabilitylog, "actype");
        ProbabilityUtil.setMulBaseDataValue(params, "checktype_filter", probabilitylog, "checktype");
        ProbabilityUtil.setMulBaseDataValue(params, "projectstate_filter", probabilitylog, "projectstate");
        ProbabilityUtil.setMulBaseDataValue(params, "cardtype_filter", probabilitylog, "cardtype");
        ProbabilityUtil.setMulBaseDataValue(params, "card_filter", probabilitylog, "card");
        probabilitylog.set("backupproject", params.get("backupproject_filter"));
        ProbabilityUtil.setMulBaseDataValue(params, "biztype_filter", probabilitylog, "biztype");
        ProbabilityUtil.setMulBaseDataValue(params, "cabinconfig_filter", probabilitylog, "cabinconfig");
        ProbabilityUtil.setMulBaseDataValue(params, "polarisstatus_filter", probabilitylog, "polarisstatus");
        probabilitylog.set("countdim", params.get("countdim_filter"));
        probabilitylog.set("analysisdim", params.get("analysisdim_filter"));
        probabilitylog.set("commongroup", params.get("commongroup"));
        probabilitylog.set("sampledata", def.get("sampledata"));
        List<String> sampleFields = Arrays.asList("spselectfilter", "spselectfilterval", "spselectall", "spdataselectnum", "spselectdimension", "spselectdimensionval", "spsort", "spsortval");
        ProbabilityUtil.setEntryValue(def, probabilitylog, "sampleentryentity", sampleFields);
        probabilitylog.set("historydata", def.get("historydata"));
        probabilitylog.set("samplehistoryfilter", (Object)def.getString("samplehistoryfilter"));
        probabilitylog.set("samplehistoryfilterval", (Object)def.getString("samplehistoryfilterval"));
        List<String> historyFields = Arrays.asList("hpselectfilter", "hpselectfilterval", "hpselectall", "hpdataselectnum", "hpselectdimension", "hpselectdimensionval", "hpsort", "hpsortval");
        ProbabilityUtil.setEntryValue(def, probabilitylog, "historyentryentity", historyFields);
        probabilitylog.set("algorithmdef", def.get("algorithmdef"));
        DynamicObjectCollection resultEntry = probabilitylog.getDynamicObjectCollection("resultentryentity");
        resultEntry.clear();
        Object filterStr = params.get("filterStr");
        Object filterEntityNumber = params.get("filterEntityNumber");
        if (StringUtils.isNotBlank((Object)filterStr) && StringUtils.isNotBlank((Object)filterEntityNumber) && (filterBuilder = ProbabilityUtil.getFilterBuilder(String.valueOf(filterStr), String.valueOf(filterEntityNumber))).getQFilter() != null) {
            DynamicObject dynamic = resultEntry.addNew();
            dynamic.set("rpselectfilterval", filterStr);
            dynamic.set("rpselectfilter", (Object)filterBuilder.getFilterString());
        }
        probabilitylog.set("modifier", (Object)RequestContext.get().getCurrUserId());
        probabilitylog.set("modifytime", (Object)new Date());
        probabilitylog.set("status", (Object)"C");
        probabilitylog.set("enable", (Object)"1");
    }

    private static void setEntryValue(DynamicObject sourceDynamicObject, DynamicObject targetDynamicObject, String entryentity, List<String> fields) {
        DynamicObjectCollection dynamicObjectCollection = sourceDynamicObject.getDynamicObjectCollection(entryentity);
        DynamicObjectCollection targetCollection = targetDynamicObject.getDynamicObjectCollection(entryentity);
        targetCollection.clear();
        if (dynamicObjectCollection != null && !dynamicObjectCollection.isEmpty()) {
            for (DynamicObject entry : dynamicObjectCollection) {
                DynamicObject dynamic = targetCollection.addNew();
                for (String field : fields) {
                    Object fieldValue = entry.get(field);
                    dynamic.set(field, fieldValue);
                }
            }
        }
    }

    private static void setMulBaseDataValue(Map<String, Object> params, String key, DynamicObject dynamicObject, String field) {
        if (params == null || StringUtils.isEmpty((CharSequence)key) || dynamicObject == null || StringUtils.isEmpty((CharSequence)field)) {
            return;
        }
        DynamicObjectCollection values = (DynamicObjectCollection)params.get(key);
        DynamicObjectCollection collection = dynamicObject.getDynamicObjectCollection(field);
        collection.clear();
        if (values != null) {
            for (DynamicObject value : values) {
                DynamicObject dynamic = collection.addNew();
                dynamic.set("fbasedataid", value.get("fbasedataid"));
            }
        }
    }

    public static void updateProbabilityLogCalStatus(Long probabilityLogId, String calstatus) {
        ProbabilityUtil.updateProbabilityLogCalStatus(probabilityLogId, calstatus, null);
    }

    public static void updateProbabilityLogCalStatus(Long probabilityLogId, String calstatus, String errmsg, String logEntityName) {
        DynamicObject probabilitylog = BusinessDataServiceHelper.loadSingle((Object)probabilityLogId, (String)logEntityName);
        if (probabilitylog != null) {
            if (StringUtils.isNotEmpty((CharSequence)calstatus)) {
                probabilitylog.set("calstatus", (Object)calstatus);
            }
            if (StringUtils.isNotEmpty((CharSequence)errmsg)) {
                probabilitylog.set("errmsg", (Object)ResManager.loadKDString((String)"\u70b9\u51fb\u67e5\u770b\u8be6\u60c5", (String)"ProbabilityUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                probabilitylog.set("errmsg_tag", (Object)errmsg);
            }
            probabilitylog.set("modifytime", (Object)new Date());
            probabilitylog.set("modifier", (Object)RequestContext.get().getCurrUserId());
            SaveServiceHelper.update((DynamicObject)probabilitylog);
        }
    }

    public static void updateProbabilityLogCalStatus(Long probabilityLogId, String calstatus, String errmsg) {
        ProbabilityUtil.updateProbabilityLogCalStatus(probabilityLogId, calstatus, errmsg, MDS_PROBABILITYLOG);
    }

    private static synchronized String getUnRepeatNumber(DynamicObject targetobj) {
        String entityNum = MDS_PROBABILITYLOG;
        DynamicObject dataInfo = targetobj;
        Long orgId = RequestContext.get().getOrgId();
        String newNum = CodeRuleServiceHelper.getNumber((String)entityNum, (DynamicObject)dataInfo, (String)String.valueOf(orgId));
        while (ProbabilityUtil.getCache(newNum) != null) {
            newNum = CodeRuleServiceHelper.getNumber((String)entityNum, (DynamicObject)dataInfo, (String)String.valueOf(orgId));
        }
        cache.put(newNum, (Object)newNum);
        return newNum;
    }

    private static Object getCache(String newNum) {
        return cache.get(newNum);
    }

    public static QFilter getQFilter(String filterContent, String entityName) {
        FilterBuilder fb = ProbabilityUtil.getFilterBuilder(filterContent, entityName);
        return fb.getQFilter();
    }

    public static FilterBuilder getFilterBuilder(String filterContent, String entityName) {
        MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)entityName);
        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterContent, FilterCondition.class);
        FilterBuilder fb = new FilterBuilder(entityType, filterCondition);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        return fb;
    }

    public static List<Map<String, Object>> getFilterColumns(IDataEntityType dataEntityType) {
        MrpEntityTypeUtil helper = new MrpEntityTypeUtil();
        return helper.getFilterColumns(dataEntityType);
    }

    public static List<ComboItem> getComboItemList(String itemStr) {
        if (StringUtils.isNotEmpty((CharSequence)itemStr)) {
            return JSON.parseArray((String)itemStr, ComboItem.class);
        }
        return null;
    }

    public static void initFilterGridByNumber(String number, FilterGrid filterGrid) {
        if (number != null && filterGrid != null) {
            MainEntityType mainEntityType = MetadataServiceHelper.getDataEntityType((String)number);
            List<Map<String, Object>> cols = ProbabilityUtil.getFilterColumns((IDataEntityType)mainEntityType);
            filterGrid.setEntityNumber(mainEntityType.getName());
            filterGrid.setFilterColumns(cols);
            filterGrid.SetValue(new FilterCondition());
        }
    }

    public static String getComboItemName(List<ComboItem> comboItemList, String field) {
        Optional<ComboItem> optional = comboItemList.stream().filter(f -> StringUtils.equals((CharSequence)field, (CharSequence)f.getValue())).findFirst();
        if (optional.isPresent()) {
            return optional.get().getCaption().getLocaleValue();
        }
        return "";
    }

    public static List<String> getRepeatField(DynamicObjectCollection entryentity, String items, String field) {
        if (entryentity.isEmpty() || StringUtils.isEmpty((CharSequence)field)) {
            return null;
        }
        List<ComboItem> itemList = ProbabilityUtil.getComboItemList(items);
        if (itemList == null || itemList.isEmpty()) {
            return null;
        }
        Map<String, Long> map = entryentity.stream().filter(f -> StringUtils.isNotEmpty((CharSequence)f.getString(field))).map(m -> m.getString(field)).collect(Collectors.groupingBy(m -> m, Collectors.counting()));
        List fieldList = map.entrySet().stream().filter(entry -> (Long)entry.getValue() > 1L).map(Map.Entry::getKey).collect(Collectors.toList());
        return itemList.stream().filter(f -> fieldList.contains(f.getValue())).map(m -> String.valueOf(m.getCaption())).collect(Collectors.toList());
    }

    public static void setBizChanged(DynamicObject dataEntity, String propertyName, List<String> propertiesName) {
        if (dataEntity == null || StringUtils.isEmpty((CharSequence)propertyName) || propertiesName == null) {
            return;
        }
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection(propertyName);
        if (entryEntity != null && !entryEntity.isEmpty()) {
            for (DynamicObject dy : entryEntity) {
                IDataEntityType dt = dy.getDataEntityType();
                DataEntityPropertyCollection properties = dt.getProperties();
                for (String name : propertiesName) {
                    int ordinal = ((IDataEntityProperty)properties.get((Object)name)).getOrdinal();
                    dy.getDataEntityState().setBizChanged(ordinal, false);
                }
            }
        }
    }

    public static DataSetX transProbabilityRecordMaterialInventoryInfo(JobSession session, DataSetX calcDataSetX) {
        DataSetX dataSetX = calcDataSetX;
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("enableshelflifemgr", "=", (Object)true);
        DataSet inventoryInfoDataSet = QueryServiceHelper.queryDataSet((String)"ProbabilityUtil", (String)"bd_materialinventoryinfo", (String)"masterid as material,enableshelflifemgr as shelflife", (QFilter[])new QFilter[]{filter}, null);
        DataSetInput inventoryInfoDataSetInput = new DataSetInput(inventoryInfoDataSet);
        DataSetX inventoryInfoDataSetX = session.fromInput((Input)inventoryInfoDataSetInput);
        String[] left = MdsAlgoUtils.getAllField(dataSetX.getRowMeta());
        ArrayList<String> leftList = new ArrayList<String>(Arrays.asList(left));
        leftList.remove("shelflife");
        String[] right = new String[]{"shelflife"};
        dataSetX = dataSetX.leftJoin(inventoryInfoDataSetX).on("material", "material").select(leftList.toArray(new String[0]), right);
        return dataSetX;
    }

    public static DataSetX transProbabilityRecordMaterialBackup(JobSession session, DataSetX calcDataSetX) {
        DataSetX dataSetX = calcDataSetX;
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DataSet backupDataSet = QueryServiceHelper.queryDataSet((String)"ProbabilityUtil", (String)"mds_materialbackup", (String)"material,avgdelivery,lastdelivery,newestprice,averagetime,avgplandelivery,avgactdelivery,delstandadev,minstandqty,standqty,supplyresp,conmtypename,conmtypenumber,conmtypeid", (QFilter[])new QFilter[]{filter}, null);
        DataSetInput backupDataSetInput = new DataSetInput(backupDataSet);
        DataSetX backupDataSetX = session.fromInput((Input)backupDataSetInput);
        ArrayList<String> fieldList = new ArrayList<String>(16);
        fieldList.add("avgdelivery");
        fieldList.add("lastdelivery");
        fieldList.add("newestprice");
        fieldList.add("averagetime");
        fieldList.add("avgplandelivery");
        fieldList.add("avgactdelivery");
        fieldList.add("delstandadev");
        fieldList.add("minstandqty");
        fieldList.add("standqty");
        fieldList.add("supplyresp");
        fieldList.add("conmtypename");
        fieldList.add("conmtypenumber");
        fieldList.add("conmtypeid");
        String[] left = MdsAlgoUtils.getAllField(dataSetX.getRowMeta());
        ArrayList<String> leftList = new ArrayList<String>(Arrays.asList(left));
        String[] right = fieldList.stream().filter(o -> !leftList.contains(o)).collect(Collectors.toList()).toArray(new String[0]);
        dataSetX = dataSetX.leftJoin(backupDataSetX).on("material", "material").select(left, right);
        return dataSetX;
    }

    public static DataSet calcRecordData(DataSet calcDataSet, boolean transForm) {
        return ProbabilityUtil.calcRecordData(calcDataSet, transForm, null);
    }

    public static DataSet calcRecordData(DataSet calcDataSet, boolean transForm, Set<Long> projectIds) {
        DataSet dataSet = calcDataSet;
        if (!transForm && MdsAlgoUtils.existField(dataSet.getRowMeta(), "billqty")) {
            if (MdsAlgoUtils.existField(dataSet.getRowMeta(), "qty")) {
                dataSet = dataSet.removeFields(new String[]{"qty"});
            }
            dataSet = dataSet.addField("billqty", "qty");
        }
        JobSession session = AlgoX.createSession((String)ProbabilityFetchRecordTask.class.getName(), (String)(ProbabilityFetchRecordTask.class.getName() + "_calcRecordData"));
        DataSetInput dataSetInput = new DataSetInput(dataSet);
        DataSetX dataSetX = session.fromInput((Input)dataSetInput);
        if (transForm) {
            dataSetX = MDSTransformUtil.transProbabilityRecordTransform(session, dataSetX);
        }
        dataSetX = ProbabilityUtil.transProbabilityRecordOrderId(session, dataSetX, projectIds);
        dataSetX = ProbabilityUtil.transProbabilityRecordPmpdResourceplan(session, dataSetX);
        dataSetX = ProbabilityUtil.transProbabilityRecordMaterialBackup(session, dataSetX);
        dataSetX = ProbabilityUtil.transProbabilityRecordMaterialGroup(session, dataSetX);
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(2, TimeUnit.HOURS);
        dataSet = session.readDataSet(outputId);
        return dataSet;
    }

    private static DataSetX transProbabilityRecordPmpdResourceplan(JobSession session, DataSetX calcDataSetX) {
        DataSetX dataSetX = calcDataSetX;
        if (MdsAlgoUtils.existField(dataSetX.getRowMeta(), "project") && !MdsAlgoUtils.existField(dataSetX.getRowMeta(), "planno")) {
            QFilter filter = new QFilter("entry_project.projcet.id", ">", (Object)0L);
            filter.and("version", "=", (Object)0L);
            DataSet backupDataSet = QueryServiceHelper.queryDataSet((String)"ProbabilityUtil", (String)"pmpd_resourceplan", (String)"billno as planno,entry_project.projcet as project", (QFilter[])new QFilter[]{filter}, null);
            DataSetInput backupDataSetInput = new DataSetInput(backupDataSet);
            DataSetX backupDataSetX = session.fromInput((Input)backupDataSetInput);
            String[] left = MdsAlgoUtils.getAllField(dataSetX.getRowMeta());
            dataSetX = dataSetX.leftJoin(backupDataSetX).on("project", "project").select(left, new String[]{"planno"});
        }
        return dataSetX;
    }

    public static DataSet calcRecordResultData(DataSet calcDataSet) {
        DataSet dataSet = calcDataSet;
        JobSession session = AlgoX.createSession((String)ProbabilityFetchRecordTask.class.getName(), (String)(ProbabilityFetchRecordTask.class.getName() + "_calcRecordResultData"));
        DataSetInput dataSetInput = new DataSetInput(dataSet);
        DataSetX dataSetX = session.fromInput((Input)dataSetInput);
        LinkedList<String> headFields = new LinkedList<String>();
        headFields.add("customer");
        headFields.add("actype");
        headFields.add("checktype");
        headFields.add("materialtype");
        headFields.add("material");
        headFields.add("unit");
        String[] headFieldsArr = headFields.toArray(new String[0]);
        Grouper headGrouper = dataSetX.groupBy(headFieldsArr);
        DataSetX headDataSetX = headGrouper.reduceGroup((GroupReduceFunction)new HisUseResultReduceGroupFunction(dataSetX.getRowMeta()));
        Grouper lateGrouper = dataSetX.groupBy(headFieldsArr);
        DataSetX lateDataSetX = lateGrouper.reduceGroup((GroupReduceFunction)new HisUseResultLate12MonthReduceGroupFunction(dataSetX.getRowMeta()));
        JoinDataSetX join = headDataSetX.leftJoin(lateDataSetX);
        for (String field : headFieldsArr) {
            join = join.on(field, field);
        }
        String[] headField = MdsAlgoUtils.getAllField(headDataSetX.getRowMeta());
        String[] lateField = MdsAlgoUtils.getAllField(lateDataSetX.getRowMeta());
        LinkedList<String> headFieldList = new LinkedList<String>(Arrays.asList(headField));
        List<String> lateFieldList = new LinkedList<String>(Arrays.asList(lateField));
        lateFieldList = lateFieldList.stream().filter(o -> !headFieldList.contains(o)).collect(Collectors.toList());
        dataSetX = join.select(headField, lateFieldList.toArray(new String[0]));
        dataSetX = ProbabilityUtil.transProbabilityRecordMaterialBackup(session, dataSetX);
        if (!MdsAlgoUtils.existField((dataSetX = ProbabilityUtil.transProbabilityRecordMaterialGeneral(session, dataSetX)).getRowMeta(), "longcycle")) {
            dataSetX = dataSetX.addFields(new Field[]{new Field("longcycle", (DataType)DataType.BigDecimalType)}, new Object[]{BigDecimal.ZERO});
        }
        if (!MdsAlgoUtils.existField(dataSetX.getRowMeta(), "islongcyclemater")) {
            dataSetX = dataSetX.addFields(new Field[]{new Field("islongcyclemater", (DataType)DataType.BooleanType)}, new Object[]{false});
        }
        DynamicObject defaultParams = ProbabilityUtil.loadDefaultMaterialParam("materialgroup,longcycle");
        DataSet materialparam = ProbabilityUtil.loadMaterialParam("materialgroup as materialtype,longcycle", null);
        DataSetInput paramDataSetInput = new DataSetInput(materialparam);
        DataSetX paramDataSetDataSetX = session.fromInput((Input)paramDataSetInput);
        dataSetX = dataSetX.coGroup(paramDataSetDataSetX, (CoGroupFunction)new HisUseResultLongCycleCoGroupFunction(dataSetX.getRowMeta(), paramDataSetDataSetX.getRowMeta(), defaultParams)).on("materialtype", "materialtype");
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(2, TimeUnit.HOURS);
        dataSet = session.readDataSet(outputId);
        return dataSet;
    }

    private static DataSetX transProbabilityRecordMaterialGeneral(JobSession session, DataSetX calcDataSetX) {
        DataSetX dataSetX = calcDataSetX;
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("entryentity.effectdate", "<=", (Object)new Date());
        filter.and("entryentity.losedate", ">=", (Object)new Date());
        DataSet generalDataSet = QueryServiceHelper.queryDataSet((String)"ProbabilityUtil", (String)"mds_general", (String)"entryentity.customer as customer,entryentity.actype as actype,entryentity.material as material", (QFilter[])new QFilter[]{filter}, null);
        DataSetInput generalDataSetInput = new DataSetInput(generalDataSet);
        DataSetX generalDataSetX = session.fromInput((Input)generalDataSetInput);
        if (!MdsAlgoUtils.existField(dataSetX.getRowMeta(), "isgeneral")) {
            dataSetX = dataSetX.addFields(new Field[]{new Field("isgeneral", (DataType)DataType.BooleanType)}, new Object[]{false});
        }
        dataSetX = dataSetX.coGroup(generalDataSetX, (CoGroupFunction)new HisUseResultMaterialGeneralCoGroupFunction(dataSetX.getRowMeta(), generalDataSetX.getRowMeta())).on("material", "material");
        return dataSetX;
    }

    private static DataSetX transProbabilityRecordMaterialGroup(JobSession session, DataSetX calcDataSetX) {
        if (MdsAlgoUtils.existField(calcDataSetX.getRowMeta(), "materialtype")) {
            return calcDataSetX;
        }
        DataSetX dataSetX = calcDataSetX;
        QFilter filter = new QFilter("standard.number", "=", (Object)"JBFLBZ");
        DataSet backupDataSet = QueryServiceHelper.queryDataSet((String)"ProbabilityUtil", (String)"bd_materialgroupdetail", (String)"material,group as materialtype,standard", (QFilter[])new QFilter[]{filter}, null);
        DataSetInput backupDataSetInput = new DataSetInput(backupDataSet);
        DataSetX backupDataSetX = session.fromInput((Input)backupDataSetInput);
        dataSetX = dataSetX.leftJoin(backupDataSetX).on("material", "material").select(MdsAlgoUtils.getAllField(dataSetX.getRowMeta()), new String[]{"materialtype"});
        return dataSetX;
    }

    public static String getDetailSelectField() {
        LinkedList<String> selectFields = new LinkedList<String>();
        selectFields.add("customer");
        selectFields.add("actype");
        selectFields.add("checktype");
        selectFields.add("planno");
        selectFields.add("materialtype");
        selectFields.add("material");
        selectFields.add("unit");
        selectFields.add("qty");
        selectFields.add("usedate");
        selectFields.add("beforematerial.number");
        selectFields.add("beforematerial.name");
        selectFields.add("beforeunit.name");
        selectFields.add("materialchange");
        selectFields.add("atachapterno");
        selectFields.add("conmtypename");
        selectFields.add("conmtypenumber");
        selectFields.add("conmtypeid");
        selectFields.add("supplyresp");
        return String.join((CharSequence)",", selectFields);
    }

    public static Map<String, Object> getLate12Month() {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        Date endDate = c.getTime();
        c.add(2, -12);
        Date startDate = c.getTime();
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        return params;
    }

    public static Map<String, Object> getFutureMonth(int monthOffset) {
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        Calendar c = Calendar.getInstance();
        c.set(5, 1);
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        c.add(2, monthOffset);
        Date startDate = c.getTime();
        c.add(2, 1);
        Date endDate = c.getTime();
        params.put("startDate", startDate);
        params.put("endDate", endDate);
        return params;
    }

    public static void updateHisUseCalcLogCalStatus(List<Object> ids, String calStatus) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mds_hisusecalclog", (String)"id,calstatus,modifier,modifytime", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("calstatus", (Object)calStatus);
                dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("modifytime", (Object)new Date());
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public static void updateGeneralLogCalStatus(List<Object> ids, String calStatus) {
        QFilter qFilter = new QFilter("id", "in", ids);
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mds_generallog", (String)"id,calstatus,modifier,modifytime", (QFilter[])new QFilter[]{qFilter});
        if (dynamicObjects != null && dynamicObjects.length > 0) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                dynamicObject.set("calstatus", (Object)calStatus);
                dynamicObject.set("modifier", (Object)RequestContext.get().getCurrUserId());
                dynamicObject.set("modifytime", (Object)new Date());
            }
            SaveServiceHelper.update((DynamicObject[])dynamicObjects);
        }
    }

    public static String getProbabilityLogCalStatus(long logId, String logEntityName) {
        DynamicObject probabilitylog = BusinessDataServiceHelper.loadSingle((Object)logId, (String)logEntityName);
        if (probabilitylog != null) {
            return probabilitylog.getString("calstatus");
        }
        return "";
    }

    public static DataSet loadGeneralPlan(long logId) {
        DataSet dataSet = null;
        if (logId > 0L) {
            QFilter qFilter = new QFilter("logid.id", "=", (Object)logId);
            List<String> fields = ProbabilityUtil.getGeneralPlanSelectFields();
            dataSet = QueryServiceHelper.queryDataSet((String)"TargetMaterialDetailHandler", (String)"mds_generalplan", (String)String.join((CharSequence)",", fields), (QFilter[])new QFilter[]{qFilter}, null);
        }
        return dataSet;
    }

    public static List<String> getGeneralPlanSelectFields() {
        LinkedList<String> list = new LinkedList<String>();
        list.add("billno");
        list.add("customer");
        list.add("actype");
        list.add("checktype");
        list.add("acreg");
        list.add("project");
        list.add("projectcreatetime");
        list.add("actualintime");
        list.add("actualleavetime");
        list.add("repaircycle");
        return list;
    }

    public static DynamicObject loadDefaultMaterialParam(String selectFields) {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("materialgroup", "=", (Object)0);
        return QueryServiceHelper.queryOne((String)"mds_materialparam", (String)selectFields, (QFilter[])new QFilter[]{filter});
    }

    public static DataSet loadMaterialParam(String selectFields, List<Long> paramIds) {
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("materialgroup", ">", (Object)0);
        if (paramIds != null) {
            filter.and("materialgroup", "in", paramIds);
        }
        return QueryServiceHelper.queryDataSet((String)"ProbabilityUtil", (String)"mds_materialparam", (String)selectFields, (QFilter[])new QFilter[]{filter}, null);
    }

    public static DataSet doFilterData(DataSet dataSet, String field, List<Long> ids) {
        RowMeta meta = dataSet.getRowMeta();
        String filterFormat = " %s in (%s) ";
        if (ids != null && ids.size() > 0) {
            if (MdsAlgoUtils.existField(meta, field)) {
                String idStr = ids.stream().map(String::valueOf).collect(Collectors.joining(","));
                String filter = String.format(filterFormat, field, idStr);
                dataSet = dataSet.filter(filter);
            } else {
                dataSet = dataSet.filter(" 1 = 2 ");
            }
        }
        return dataSet;
    }
}

