/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.productfamily;

import java.util.HashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.util.MdsLoadOfferingUtil;

public class ProductFamilyCommons {
    public static final String TBL_NEW = "tblnew";
    public static final String TBL_MODIFY = "tblmodify";
    public static final String MDS_PRODUCTFAMILY = "mds_productfamily";
    public static final String MDS_PRODUCTFAMILY_EDIT = "mds_productfamily_edit";
    public static final String FIELD_MATERIELITEM = "materielitem";
    public static final String FIELD_MATERIELPBOM = "materielpbom";
    public static final String FIELD_BOMTYPE = "bomtype";
    public static final String FIELD_GENERALTAG = "generaltag";
    public static final String FIELD_REMARK = "remark";
    public static final String FIELD_MATERIALPLAN = "materialplan";
    public static final String FIELD_PRODUCTFAMILY = "productfamily";
    public static final String FIELD_PLANUSER = "planuser";
    public static final String FIELD_SUPMODEL = "supmodel";
    public static final String FIELD_PLANUSERCODE = "planusercode";
    public static final String FIELD_PBOMNAMEEDIT = "pbomnameedit";
    public static final String SHOW_OFFERING = "offeringshow";
    public static final String SHOW_PBOMNAME = "pbomnameshow";
    public static final String SHOW_ITEMNAME = "itemnameshow";
    public static final String SHOW_APPROVEDATE = "approvedateshow";
    public static final String SYS_CREATOR = "creator";
    public static final String SYS_CREATETIME = "createtime";
    public static final String SYS_MODIFIER = "modifier";
    public static final String SYS_MODIFYTIME = "modifytime";
    public static final String SYS_MASTERID = "masterid";
    public static final String SYS_STATUS = "status";
    public static final String SYS_ENABLE = "enable";
    public static final String LOCK_PREFIX = "mds_productfamily-";
    public static final String LOCK_GLOBAL = "mds_productfamily-global";
    private static boolean isExt = false;

    public static String getOffering(Object materielitem) {
        String result = "";
        if (materielitem instanceof DynamicObject) {
            result = ((DynamicObject)materielitem).getString("offeringcode.name");
        }
        return result;
    }

    public static String getPbomname(Object materielpbom) {
        String result = "";
        if (materielpbom instanceof DynamicObject) {
            result = ((DynamicObject)materielpbom).getString("name");
        }
        return result;
    }

    public static String getItemname(Object materielitem) {
        String result = "";
        if (materielitem instanceof DynamicObject) {
            result = ((DynamicObject)materielitem).getString("name");
        }
        return result;
    }

    public static DynamicObject getPlanUser(Object materielitem) {
        DynamicObject result = null;
        if (materielitem instanceof DynamicObject) {
            Object pkValue = ((DynamicObject)materielitem).getPkValue();
            QFilter filter = new QFilter(SYS_MASTERID, "=", pkValue);
            DynamicObject materialplan = BusinessDataServiceHelper.loadSingle((String)"mpdm_materialplan", (String)"operator", (QFilter[])new QFilter[]{filter});
            if (materialplan != null) {
                DynamicObject operatorNumber;
                result = operatorNumber = materialplan.getDynamicObject("operator");
            }
        }
        return result;
    }

    public static DynamicObject getMaterialPlan(Object materielitem) {
        DynamicObject result = null;
        if (materielitem instanceof DynamicObject) {
            DynamicObject materialplan;
            Object pkValue = ((DynamicObject)materielitem).getPkValue();
            if (pkValue == null) {
                pkValue = ((DynamicObject)materielitem).getLong("id");
            }
            QFilter filter = new QFilter(SYS_MASTERID, "=", pkValue);
            result = materialplan = BusinessDataServiceHelper.loadSingleFromCache((String)"mpdm_materialplan", (QFilter[])new QFilter[]{filter});
        }
        return result;
    }

    public static String getProductfamily(Object materielitem) {
        String result = "";
        if (materielitem instanceof DynamicObject) {
            QFilter filter;
            DynamicObject productgroup;
            String number = ((DynamicObject)materielitem).getString("number");
            HashSet<String> set = new HashSet<String>();
            set.add(number);
            Map<String, DynamicObject> materialMap = MdsLoadOfferingUtil.loadMaterial(set);
            DynamicObject dynamicObject = materialMap.get(number);
            String groupId = dynamicObject.getString("offeringcode.group");
            if (StringUtils.isNotEmpty((String)groupId) && !"0".equals(groupId) && (productgroup = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_productgroup", (QFilter[])new QFilter[]{filter = new QFilter("id", "=", (Object)Long.valueOf(groupId))})) != null) {
                String category = productgroup.getString("category");
                if ("Product Family".equals(category)) {
                    return productgroup.getString("name");
                }
                if ("Product Series".equals(category)) {
                    return productgroup.getString("parent.name");
                }
            }
        }
        return result;
    }

    public static String getSupmodel(Object materielitem) {
        String result = "";
        if (materielitem instanceof DynamicObject) {
            Object pkValue = ((DynamicObject)materielitem).getPkValue();
            if (pkValue == null) {
                pkValue = ((DynamicObject)materielitem).getLong("id");
            }
            QFilter filter = new QFilter(SYS_MASTERID, "=", pkValue);
            DynamicObject materialplan = QueryServiceHelper.queryOne((String)"bd_materialinventoryinfo", (String)"id,manustrategy.demandmodel", (QFilter[])new QFilter[]{filter});
            if (materialplan != null) {
                result = materialplan.getString("manustrategy.demandmodel");
            }
        }
        return result;
    }

    public static String getPlanUserCode(Object materielitem) {
        if (!isExt) {
            return "";
        }
        String result = "";
        if (materielitem instanceof DynamicObject) {
            Object pkValue = ((DynamicObject)materielitem).getPkValue();
            if (pkValue == null) {
                pkValue = ((DynamicObject)materielitem).getLong("id");
            }
            QFilter filter = new QFilter(SYS_MASTERID, "=", pkValue);
            DynamicObject materialplan = QueryServiceHelper.queryOne((String)"mpdm_materialplan", (String)"id,hihn_planpersonsrc", (QFilter[])new QFilter[]{filter});
            if (materialplan != null) {
                result = materialplan.getString("hihn_planpersonsrc");
            }
        }
        return result;
    }

    public static void reloadProductfamily() {
        DynamicObject[] productfamilys = BusinessDataServiceHelper.load((String)MDS_PRODUCTFAMILY, (String)"materielitem.number,productfamily", (QFilter[])new QFilter[0]);
        HashSet<String> set = new HashSet<String>();
        if (productfamilys != null) {
            for (DynamicObject productfamily : productfamilys) {
                String number = productfamily.getString("materielitem.number");
                set.add(number);
            }
        }
        Map<String, DynamicObject> materialMap = MdsLoadOfferingUtil.loadMaterial(set);
        if (productfamilys != null) {
            for (DynamicObject productfamily : productfamilys) {
                QFilter filter;
                DynamicObject productgroup;
                String groupId;
                String result = "";
                String number = productfamily.getString("materielitem.number");
                DynamicObject dynamicObject = materialMap.get(number);
                if (dynamicObject != null && StringUtils.isNotEmpty((String)(groupId = dynamicObject.getString("offeringcode.group"))) && !"0".equals(groupId) && (productgroup = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_productgroup", (QFilter[])new QFilter[]{filter = new QFilter("id", "=", (Object)Long.valueOf(groupId))})) != null) {
                    String category = productgroup.getString("category");
                    if ("Product Family".equals(category)) {
                        result = productgroup.getString("name");
                    } else if ("Product Series".equals(category)) {
                        result = productgroup.getString("parent.name");
                    }
                }
                productfamily.set(FIELD_PRODUCTFAMILY, (Object)result);
            }
        }
        SaveServiceHelper.save((DynamicObject[])productfamilys);
    }

    public static void updatePBOMname(DynamicObject data, String bomtype, DynamicObject materielpbom) {
        if (materielpbom != null) {
            Object materielId = materielpbom.getPkValue();
            if ("MBOM".equals(bomtype)) {
                String pbomnameedit = ProductFamilyCommons.getPBOMNameEdit(materielId);
                data.set(FIELD_PBOMNAMEEDIT, (Object)pbomnameedit);
            } else if ("PBOM".equals(bomtype)) {
                String pbomnameedit = data.getString(FIELD_PBOMNAMEEDIT);
                String sql = "update t_mds_productfamily set fpbomnameedit=? where fmaterielpbom=? and fmaterielitem <> ?";
                Object[] params = new Object[]{pbomnameedit, materielId, materielId};
                DB.execute((DBRoute)new DBRoute("scm"), (String)sql, (Object[])params);
            }
        }
    }

    public static String getPBOMNameEdit(Object materielId) {
        QFilter qFilter = new QFilter(FIELD_MATERIELITEM, "=", materielId);
        DynamicObject productfamilys = QueryServiceHelper.queryOne((String)MDS_PRODUCTFAMILY, (String)FIELD_PBOMNAMEEDIT, (QFilter[])new QFilter[]{qFilter});
        if (productfamilys != null) {
            return productfamilys.getString(FIELD_PBOMNAMEEDIT);
        }
        return "";
    }

    public static boolean checkPbomnameEditOnly(DynamicObject data, String pbomnameedit) {
        if (StringUtils.isEmpty((String)pbomnameedit)) {
            return true;
        }
        String bomtype = data.getString(FIELD_BOMTYPE);
        if ("PBOM".equals(bomtype)) {
            Object id = data.getPkValue();
            QFilter[] qFilters = null;
            qFilters = id != null ? new QFilter[]{new QFilter("id", "!=", id), new QFilter(FIELD_PBOMNAMEEDIT, "=", (Object)pbomnameedit), new QFilter(FIELD_BOMTYPE, "=", (Object)"PBOM")} : new QFilter[]{new QFilter(FIELD_PBOMNAMEEDIT, "=", (Object)pbomnameedit), new QFilter(FIELD_BOMTYPE, "=", (Object)"PBOM")};
            DynamicObjectCollection materialplan = QueryServiceHelper.query((String)MDS_PRODUCTFAMILY, (String)FIELD_MATERIELITEM, (QFilter[])qFilters);
            if (materialplan != null && materialplan.size() > 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean checkContainsPbom(Object id) {
        QFilter filter = new QFilter(FIELD_MATERIELITEM, "=", (Object)Long.valueOf(id + "")).and(FIELD_BOMTYPE, "=", (Object)"PBOM");
        DynamicObjectCollection materialplan = QueryServiceHelper.query((String)MDS_PRODUCTFAMILY, (String)"id", (QFilter[])new QFilter[]{filter});
        return materialplan != null && !materialplan.isEmpty();
    }

    static {
        DynamicObject bd_material = ORM.create().newDynamicObject("mpdm_materialplan");
        DataEntityPropertyCollection properties = bd_material.getDataEntityType().getProperties();
        for (IDataEntityProperty pro : properties) {
            if (!"hihn_planpersonsrc".equals(pro.getName())) continue;
            isExt = true;
        }
    }
}

