/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.schedule;

import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.id.ID;
import kd.bos.lang.Lang;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.mmc.mds.common.schedule.StandardTaskClick;

public class TaskTrigger {
    private Class<? extends AbstractTask> task;
    private String click = StandardTaskClick.class.getName();
    private String appId = "mds";
    private boolean setCanStop = false;
    private IFormView view;
    private String jobName;
    private String jobCaption;
    private CloseCallBack closeCallBack;

    public void run(Map<String, Object> params) {
        JobInfo job = new JobInfo();
        job.setAppId(this.appId);
        job.setJobType(JobType.REALTIME);
        job.setName(this.jobName);
        job.setRunByUserId(RequestContext.get().getCurrUserId());
        job.setRunByLang(Lang.get());
        job.setTaskClassname(this.task.getName());
        job.setParams(params);
        JobFormInfo jobFormInfo = new JobFormInfo(job);
        jobFormInfo.setCaption(this.jobCaption);
        if (this.closeCallBack != null) {
            jobFormInfo.setCloseCallBack(this.closeCallBack);
        }
        jobFormInfo.setCanBackground(true);
        jobFormInfo.setCanStop(this.setCanStop);
        jobFormInfo.setClickClassName(this.click);
        JobForm.dispatch((JobFormInfo)jobFormInfo, (IFormView)this.view);
    }

    public TaskTrigger(Class<? extends AbstractTask> task, IFormView view, String jobName) {
        this.task = task;
        this.view = view;
        if (StringUtils.isEmpty((CharSequence)jobName)) {
            jobName = ID.genStringId();
        }
        this.jobName = jobName;
    }

    public Class<? extends AbstractTask> getTask() {
        return this.task;
    }

    public void setTask(Class<? extends AbstractTask> task) {
        this.task = task;
    }

    public String getClick() {
        return this.click;
    }

    public void setClick(String click) {
        this.click = click;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public boolean isSetCanStop() {
        return this.setCanStop;
    }

    public void setSetCanStop(boolean setCanStop) {
        this.setCanStop = setCanStop;
    }

    public IFormView getView() {
        return this.view;
    }

    public void setView(IFormView view) {
        this.view = view;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobCaption() {
        return this.jobCaption;
    }

    public void setJobCaption(String jobCaption) {
        this.jobCaption = jobCaption;
    }

    public CloseCallBack getCloseCallBack() {
        return this.closeCallBack;
    }

    public void setCloseCallBack(CloseCallBack closeCallBack) {
        this.closeCallBack = closeCallBack;
    }
}

