/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.setoff;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ITimeService;
import kd.bos.service.IUserService;
import kd.bos.service.TimeService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserService;
import kd.mmc.mds.common.setoff.FormulaExec;
import kd.mmc.mds.common.setoff.SetOffCommonUtil;
import kd.mmc.mds.common.setoff.infoclass.MatinvInfo;

public class BillFieldChange {
    private static final String MDS_DATA = "mds_data";
    private static final String SM_SALORDER = "sm_salorder";
    private static final Log logger = LogFactory.getLog(BillFieldChange.class);

    private BillFieldChange() {
    }

    public static void genSetoffSourceRecords(Long billFieldId, Long toolid, Long setid, Long MrpDateid, Integer sxh, List<Long> matidlst, Set<Long> orderidlst, Set<Long> mdsidlist) {
        BillFieldChange.genSetoffSourceRecords(billFieldId, toolid, setid, MrpDateid, sxh, matidlst, orderidlst, mdsidlist, null);
    }

    public static void genSetoffSourceRecords(Long billFieldId, Long toolid, Long setid, Long MrpDateid, Integer sxh, List<Long> matidlst, Set<Long> orderidlst, Set<Long> mdsidlist, Map<String, QFilter> materialQFilter) {
        DynamicObject sourfield = BusinessDataServiceHelper.loadSingleFromCache((Object)billFieldId, (String)"mrp_resource_dataconf_rgt", (String)BillFieldChange.getDataSourceSelectors());
        if (sourfield == null) {
            return;
        }
        long billFieldTransferId = sourfield.getLong("billfieldtransfer_id");
        DynamicObject billFieldTrans = BusinessDataServiceHelper.loadSingleFromCache((Object)billFieldTransferId, (String)"mrp_billfieldtransfer", (String)BillFieldChange.getTransferSelectors());
        if (billFieldTrans == null) {
            return;
        }
        String filter = sourfield.getString("filter_tag");
        String srcbill = billFieldTrans.getString("srcbill_id");
        String destbill = billFieldTrans.getString("destbill_id");
        ArrayList<QFilter> lQFilters = new ArrayList<QFilter>();
        if (SM_SALORDER.equals(srcbill)) {
            QFilter qFilter1 = new QFilter("1", "=", (Object)1);
            if (materialQFilter != null) {
                QFilter qFilter2 = materialQFilter.get(srcbill);
                if (qFilter2 == null) {
                    return;
                }
                qFilter1.and(qFilter2);
            } else {
                qFilter1.and(BillFieldChange.getMaterialFilter(billFieldTransferId, matidlst));
            }
            lQFilters.add(qFilter1);
            logger.info("\u672c\u6b21\u51b2\u9500\u65f6\u4ece\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u4e2d\u83b7\u53d6\u7684\u8fc7\u6ee4\u6761\u4ef6\u5b57\u7b26\u4e32:" + filter);
            BillFieldChange.genSaleOrderRecords(billFieldTrans, MrpDateid, toolid, setid, sxh, destbill, filter, lQFilters);
        } else {
            QFilter qFilter1 = new QFilter("1", "=", (Object)1);
            if (MDS_DATA.equals(srcbill)) {
                qFilter1.and(new QFilter("enablestatus", "=", (Object)"A"));
            }
            if (materialQFilter != null) {
                QFilter qFilter2 = materialQFilter.get(srcbill);
                if (qFilter2 == null) {
                    return;
                }
                qFilter1.and(qFilter2);
            } else {
                qFilter1.and(BillFieldChange.getMaterialFilter(billFieldTransferId, matidlst));
            }
            lQFilters.add(qFilter1);
            BillFieldChange.genCommonRecords(billFieldTrans, MrpDateid, toolid, setid, sxh, filter, lQFilters);
        }
    }

    private static DataSet getDataByFilter(DynamicObjectCollection billfield, String entityNumber, Long Mrpdateid, String filter, List<QFilter> addqfs) {
        FilterCondition filterCondition = new FilterCondition();
        if (!StringUtils.isBlank((CharSequence)filter)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        }
        filterCondition.setFilter(filter);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
        TimeService timeService = new TimeService();
        fb.setTimeService((ITimeService)timeService);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        QFilter filters = fb.getQFilter();
        String selfield = MDS_DATA.equals(entityNumber) ? BillFieldChange.getMdsDataSelectors(billfield, mainType) : BillFieldChange.getOtherBillSearchField(billfield, mainType);
        DataSet coll = null;
        if (addqfs == null) {
            if (Mrpdateid > 0L) {
                coll = SetOffCommonUtil.loadCacheDatas(Mrpdateid, entityNumber, selfield, new QFilter[]{filters});
            }
            if (coll == null) {
                coll = QueryServiceHelper.queryDataSet((String)"getDataByFilterMDS", (String)entityNumber, (String)selfield, (QFilter[])new QFilter[]{filters}, null);
            }
        } else {
            addqfs.add(filters);
            QFilter[] qfs = new QFilter[addqfs.size()];
            addqfs.toArray(qfs);
            if (Mrpdateid.compareTo(0L) > 0) {
                coll = SetOffCommonUtil.loadCacheDatas(Mrpdateid, entityNumber, selfield, qfs);
            }
            if (coll == null) {
                coll = QueryServiceHelper.queryDataSet((String)"getDataByFilterMDS", (String)entityNumber, (String)selfield, (QFilter[])qfs, null);
            }
        }
        return coll;
    }

    private static DataSet getDataByFilterSalorder(DynamicObjectCollection billfieldentry, Long Mrpdateid, String filter, List<QFilter> addqfs) {
        String entityNumber = SM_SALORDER;
        FilterCondition filterCondition = new FilterCondition();
        if (!StringUtils.isBlank((CharSequence)filter)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filter, FilterCondition.class);
        }
        filterCondition.setFilter(filter);
        MainEntityType mainType = MetadataServiceHelper.getDataEntityType((String)entityNumber);
        FilterBuilder fb = new FilterBuilder(mainType, filterCondition);
        TimeService timeService = new TimeService();
        fb.setTimeService((ITimeService)timeService);
        UserService userService = new UserService();
        fb.setUserService((IUserService)userService);
        fb.buildFilter(false);
        QFilter filters = fb.getQFilter();
        addqfs.add(filters);
        QFilter[] qfs = new QFilter[addqfs.size()];
        addqfs.toArray(qfs);
        logger.info("\u672c\u6b21\u51b2\u9500\u4ea7\u751f\u7684\u6700\u7ec8\u8fc7\u6ee4\u6761\u4ef6\u7684FILTER:" + filters);
        String selfield = BillFieldChange.getSearchField(billfieldentry, mainType);
        DataSet coll = null;
        if (Mrpdateid.compareTo(0L) > 0) {
            coll = SetOffCommonUtil.loadCacheDatas(Mrpdateid, entityNumber, selfield, qfs);
        }
        if (coll == null) {
            coll = QueryServiceHelper.queryDataSet((String)"getDataByFilterSalorder", (String)entityNumber, (String)selfield, (QFilter[])qfs, null);
        }
        return coll;
    }

    private static QFilter getMaterialFilter(Long billFieldId, List<Long> matidlst) {
        QFilter res = null;
        QFilter billfieldFilter = new QFilter("id", "=", (Object)billFieldId);
        DynamicObjectCollection billfieldentry = QueryServiceHelper.query((String)"mrp_billfieldtransfer", (String)BillFieldChange.getTransferSelectors(), (QFilter[])new QFilter[]{billfieldFilter});
        boolean hasmatkey = false;
        for (DynamicObject fieldEntry : billfieldentry) {
            String contype = fieldEntry.getString("entryentity.converttype");
            if (!"materiel".equals(fieldEntry.getString("entryentity.destfieldflag"))) continue;
            hasmatkey = true;
            if ("0".equals(contype)) {
                res = new QFilter(fieldEntry.getString("entryentity.sourcefieldflag"), "in", matidlst);
                continue;
            }
            res = new QFilter(fieldEntry.getString("entryentity.calculateexc"), "in", matidlst);
        }
        if (!hasmatkey) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u9700\u8981\u914d\u7f6e\u7269\u6599\u5b57\u6bb5\u7684\u6620\u5c04\u4fe1\u606f\u3002", (String)"BillFieldChange_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        return res;
    }

    private static void genCommonRecords(DynamicObject billFieldTrans, Long MrpDateid, Long toolid, Long setid, Integer sxh, String filter, List<QFilter> qfs) {
        String sourcebill = billFieldTrans.getString("srcbill_id");
        String destbill = billFieldTrans.getString("destbill_id");
        boolean flag = false;
        String materialField = null;
        DynamicObjectCollection billfieldentry = billFieldTrans.getDynamicObjectCollection("entryentity");
        for (DynamicObject item : billfieldentry) {
            if ("recorddate".equals(item.getString("destfieldflag"))) {
                flag = true;
            }
            if (!"materiel".equals(item.getString("destfieldflag"))) continue;
            String contype = item.getString("converttype");
            if ("0".equals(contype)) {
                materialField = item.getString("sourcefieldflag");
                continue;
            }
            materialField = item.getString("calculateexc");
        }
        if (!flag) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u9700\u8981\u914d\u7f6e\u76ee\u6807\u5b9e\u4f53\u4e3a\u4f9b\u65b9\u8bb0\u5f55\u8868\u548c\u9700\u65b9\u8bb0\u5f55\u8868\u7684\u8bb0\u5f55\u65e5\u671f\u5b57\u6bb5\u7684\u6620\u5c04\u4fe1\u606f\u3002", (String)"BillFieldChange_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        ArrayList<Object> dynSet = new ArrayList<DynamicObject>();
        boolean degbugerr = true;
        try (DataSet ds = BillFieldChange.getDataByFilter(billfieldentry, sourcebill, MrpDateid, filter, qfs);){
            HashSet<Long> mathaszero = new HashSet<Long>(10005);
            while (ds.hasNext()) {
                DynamicObject recordData;
                block44: {
                    Row srcData;
                    block43: {
                        srcData = ds.next();
                        recordData = BillFieldChange.getNewDynamicObject(destbill);
                        recordData.set("id", (Object)BillFieldChange.genLongId(destbill));
                        if (MDS_DATA.equals(sourcebill) && "mds_providerrecord".equals(destbill)) {
                            BillFieldChange.addMdsDataDefValue(recordData, srcData);
                        }
                        for (DynamicObject item : billfieldentry) {
                            String contype = item.getString("converttype");
                            try {
                                if ("0".equals(contype)) {
                                    recordData.set(item.getString("destfieldflag"), srcData.get(item.getString("sourcefieldflag")));
                                    continue;
                                }
                                if ("4".equals(contype)) {
                                    recordData.set(item.getString("destfieldflag"), srcData.get(item.getString("calculateexc")));
                                    continue;
                                }
                                if ("3".equals(contype)) {
                                    recordData.set(item.getString("destfieldflag"), item.get("calculateexc"));
                                    continue;
                                }
                                String exestr = item.getString("calculateexc");
                                if (FormulaExec.IsexecMode(exestr)) {
                                    Object execval = FormulaExec.exec(exestr, srcData);
                                    if (execval == null) continue;
                                    recordData.set(item.getString("destfieldflag"), execval);
                                    continue;
                                }
                                String dstag = item.getString("destfieldflag");
                                String execfiledName = SetOffCommonUtil.getExecfiledName(exestr, dstag);
                                recordData.set(dstag, srcData.get(execfiledName));
                            }
                            catch (Exception e) {
                                if (!degbugerr) continue;
                                logger.error("genCommonRecords() catch\u5f02\u5e381", (Throwable)e);
                                degbugerr = false;
                            }
                        }
                        String configtype = recordData.getString("defineconfig");
                        if ("1".equals(configtype)) {
                            recordData.set("recorddate", (Object)SetOffCommonUtil.getConfigDate(recordData.getDate("recorddate")));
                        }
                        if (recordData.getDate("recorddate") == null) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8bf7\u7ed9\u5bf9\u5e94\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u4fe1\u606f\u4e2d\u7684\u8bb0\u5f55\u65e5\u671f\u5b57\u6bb5\u8bbe\u7f6e\u6b63\u786e\u7684\u65e5\u671f\u5b57\u6bb5\u7684\u6620\u5c04\u503c", (String)"BillFieldChange_2", (String)"mmc-mds-common", (Object[])new Object[0]));
                        }
                        try {
                            if ("mds_requestrecord".equals(destbill)) {
                                recordData.set("sxh", (Object)sxh);
                                recordData.set("setoffqty", (Object)recordData.getBigDecimal("qty"));
                            }
                        }
                        catch (Exception e) {
                            if (!degbugerr) break block43;
                            logger.error("genCommonRecords() catch\u5f02\u5e382", (Throwable)e);
                            degbugerr = false;
                        }
                    }
                    recordData.set("toolid", (Object)toolid);
                    recordData.set("setid", (Object)setid);
                    recordData.set("transferid", (Object)billFieldTrans.getLong("id"));
                    recordData.set("creator", (Object)Long.valueOf(RequestContext.get().getUserId()));
                    recordData.set("createtime", (Object)new Date());
                    recordData.set("billstatus", (Object)Character.valueOf('A'));
                    recordData.set("billtag", (Object)sourcebill);
                    recordData.set("billid", (Object)srcData.getLong("id"));
                    if (recordData.getLong("org") <= 0L) {
                        recordData.set("org", (Object)RequestContext.get().getOrgId());
                    }
                    if ("im_saloutbill".equals(sourcebill)) {
                        recordData.set("materiel", (Object)srcData.getLong("billentry.material.masterid"));
                        recordData.set("billentryid", srcData.get("billentry.id"));
                    } else if ("sm_delivernotice".equals(sourcebill)) {
                        recordData.set("materiel", (Object)srcData.getLong("billentry.materialmasterid"));
                        recordData.set("billentryid", srcData.get("billentry.id"));
                    } else if ("mds_fnreport".equals(sourcebill)) {
                        recordData.set("billentryid", srcData.get("id"));
                    } else {
                        try {
                            if (materialField != null) {
                                recordData.set("materiel", (Object)srcData.getLong(materialField));
                            }
                        }
                        catch (Exception e) {
                            if (!degbugerr) break block44;
                            logger.error("genCommonRecords() catch\u5f02\u5e383", (Throwable)e);
                            degbugerr = false;
                        }
                    }
                }
                if (recordData.getLong("materiel") <= 0L || recordData.getBigDecimal("qty").compareTo(new BigDecimal(0)) < 0) continue;
                if (recordData.getBigDecimal("qty").compareTo(new BigDecimal(0)) == 0) {
                    if (!"mds_providerrecord".equals(destbill) || mathaszero.contains(recordData.getLong("materiel"))) continue;
                    mathaszero.add(recordData.getLong("materiel"));
                }
                dynSet.add(recordData);
                if (dynSet.size() <= 10000) continue;
                DynamicObject[] dynObj = dynSet.toArray(new DynamicObject[dynSet.size()]);
                BillFieldChange.insertData(dynObj);
                dynSet = new ArrayList(10005);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        BillFieldChange.SetOtherProp(dynSet);
        DynamicObject[] dynObj = dynSet.toArray(new DynamicObject[dynSet.size()]);
        BillFieldChange.insertData(dynObj);
    }

    private static void SetOtherProp(List<DynamicObject> dynSet) {
        String billname;
        HashSet<Long> trackids = new HashSet<Long>();
        for (DynamicObject item : dynSet) {
            Long trackid;
            String billname2 = item.getDynamicObjectType().getName();
            if (!"mds_requestrecord".equalsIgnoreCase(billname2) || (trackid = Long.valueOf(item.getLong("trackid"))) == null || trackid <= 0L) continue;
            trackids.add(trackid);
        }
        Map<Long, MatinvInfo> trackidAndManu = SetOffCommonUtil.getManustrategybyTrackid(trackids);
        HashSet<Long> matidlst = new HashSet<Long>(100);
        List<MatinvInfo> invs = new ArrayList<MatinvInfo>(100);
        for (DynamicObject item : dynSet) {
            billname = item.getDynamicObjectType().getName();
            if (!"mds_requestrecord".equalsIgnoreCase(billname)) continue;
            Long trackid = item.getLong("trackid");
            MatinvInfo matinvInfo = trackidAndManu.get(trackid);
            if (matinvInfo != null) {
                item.set("manustrategy", (Object)matinvInfo.getManustrategyid());
                item.set("demandoffset", (Object)matinvInfo.getDemandoffset());
                continue;
            }
            Long matid = item.getLong("materiel");
            Long stockorgid = item.getLong("stockorg");
            if (matid <= 0L || stockorgid <= 0L) continue;
            MatinvInfo invitem = new MatinvInfo();
            invitem.setMatid(matid);
            invitem.setStockorgid(stockorgid);
            invs.add(invitem);
            matidlst.add(matid);
        }
        invs = SetOffCommonUtil.getPolicyAndMatidLst(matidlst, invs);
        for (DynamicObject item : dynSet) {
            billname = item.getDynamicObjectType().getName();
            if (!"mds_requestrecord".equalsIgnoreCase(billname)) continue;
            Long matid = item.getLong("materiel");
            Long stockorgid = item.getLong("stockorg");
            for (MatinvInfo invitem : invs) {
                if (!invitem.getMatid().equals(matid) || !invitem.getStockorgid().equals(stockorgid)) continue;
                item.set("manustrategy", (Object)invitem.getManustrategyid());
                item.set("demandoffset", (Object)invitem.getDemandoffset());
            }
        }
    }

    private static void addMdsDataDefValue(DynamicObject recordData, Row srcData) {
        recordData.set("qty", srcData.get("detailentity.fcqty"));
        recordData.set("bno", (Object)srcData.getString("billno"));
        recordData.set("billid", (Object)srcData.getLong("id"));
        recordData.set("billentryid", (Object)srcData.getLong("detailentity.id"));
        recordData.set("materiel", (Object)srcData.getLong("detailentity.materialid"));
        recordData.set("billno", (Object)srcData.getString("billno"));
        recordData.set("org", (Object)srcData.getLong("org"));
        recordData.set("bstatus", (Object)"A");
        recordData.set("billunit", (Object)srcData.getLong("detailentity.baseunit"));
        recordData.set("billtag", (Object)MDS_DATA);
        recordData.set("fcvrnnum", (Object)srcData.getLong("fcvrnnum"));
        recordData.set("billrowno", (Object)srcData.getLong("detailentity.seq"));
        recordData.set("setoffqty", srcData.get("detailentity.writeoffnum"));
        recordData.set("billtypename", (Object)ResManager.loadKDString((String)"\u9884\u6d4b\u3001\u9700\u6c42\u8ba1\u5212\u5904\u7406", (String)"BillFieldChange_3", (String)"mmc-mds-common", (Object[])new Object[0]));
    }

    private static void genSaleOrderRecords(DynamicObject billFieldTrans, Long MrpDateid, Long toolid, Long setid, Integer sxh, String destbill, String filter, List<QFilter> qfsadd) {
        DynamicObjectCollection billfieldentry = billFieldTrans.getDynamicObjectCollection("entryentity");
        boolean flag = false;
        for (DynamicObject fieldEntry : billfieldentry) {
            if (!"recorddate".equals(fieldEntry.getString("destfieldflag"))) continue;
            flag = true;
            break;
        }
        if (!flag) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u9700\u8981\u914d\u7f6e\u76ee\u6807\u5b9e\u4f53\u4e3a\u4f9b\u65b9\u8bb0\u5f55\u8868\u548c\u9700\u65b9\u8bb0\u5f55\u8868\u7684\u8bb0\u5f55\u65e5\u671f\u5b57\u6bb5\u7684\u6620\u5c04\u4fe1\u606f\u3002", (String)"BillFieldChange_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        QFilter qFilter1 = new QFilter("billentry.materialmasterid", ">", (Object)0);
        qFilter1.and(new QFilter("billentry.qty", ">", (Object)0));
        ArrayList<QFilter> lQFilters = new ArrayList<QFilter>();
        lQFilters.add(qFilter1);
        if (qfsadd != null) {
            for (QFilter qitem : qfsadd) {
                lQFilters.add(qitem);
            }
        }
        ArrayList<Object> dynSet = new ArrayList<DynamicObject>(1000);
        boolean degbugerr = true;
        try (DataSet ds = BillFieldChange.getDataByFilterSalorder(billfieldentry, MrpDateid, filter, lQFilters);){
            while (ds.hasNext()) {
                String billno;
                DynamicObject recordData;
                DynamicObject saleout;
                Row saleorder;
                block33: {
                    saleorder = ds.next();
                    RequestContext request = RequestContext.get();
                    saleout = null;
                    BigDecimal xinvqty = saleorder.getBigDecimal("billentry.invqty");
                    if (xinvqty == null) {
                        xinvqty = BigDecimal.ZERO;
                    }
                    if (xinvqty.compareTo(new BigDecimal(0)) > 0) {
                        saleout = SetOffCommonUtil.getSaleOutobject(saleorder.getLong("id"));
                    }
                    recordData = BillFieldChange.getNewDynamicObject(destbill);
                    billno = saleorder.getString("billno");
                    recordData.set("id", (Object)BillFieldChange.genLongId(destbill));
                    recordData.set("billno", (Object)billno);
                    recordData.set("bno", (Object)billno);
                    recordData.set("toolid", (Object)toolid);
                    recordData.set("setid", (Object)setid);
                    recordData.set("billid", (Object)saleorder.getLong("id"));
                    recordData.set("billstatus", (Object)Character.valueOf('A'));
                    recordData.set("billrowno", saleorder.get("billentry.seq"));
                    recordData.set("billentryid", saleorder.get("billentry.id"));
                    recordData.set("sxh", (Object)sxh);
                    recordData.set("billtype", (Object)saleorder.getLong("billtype"));
                    recordData.set("org", (Object)RequestContext.get().getOrgId());
                    recordData.set("bstatus", saleorder.get("closestatus"));
                    recordData.set("transferid", (Object)billFieldTrans.getLong("id"));
                    recordData.set("creator", (Object)Long.valueOf(request.getUserId()));
                    recordData.set("createtime", (Object)new Date());
                    recordData.set("qty", (Object)saleorder.getBigDecimal("billentry.qty").subtract(xinvqty));
                    recordData.set("materiel", (Object)saleorder.getLong("billentry.materialmasterid"));
                    recordData.set("billunit", (Object)saleorder.getLong("billentry.unit"));
                    recordData.set("accoutqty", saleorder.get("billentry.invqty"));
                    recordData.set("setoffqty", (Object)saleorder.getBigDecimal("billentry.qty"));
                    recordData.set("billtag", (Object)SM_SALORDER);
                    try {
                        recordData.set("epd", saleorder.get("billentry.hihn_hihn_epd"));
                        recordData.set("rpd", saleorder.get("billentry.hihn_rpd"));
                    }
                    catch (Exception e) {
                        if (!degbugerr) break block33;
                        logger.error("genSaleOrderRecords() catch\u5f02\u5e381", (Throwable)e);
                        degbugerr = false;
                    }
                }
                if (saleout != null) {
                    recordData.set("saleorderoutid", (Object)saleout.getLong("id"));
                    recordData.set("deleverydate", (Object)saleout.getDate("biztime"));
                }
                for (DynamicObject item : billfieldentry) {
                    String contype = item.getString("converttype");
                    try {
                        if ("0".equals(contype)) {
                            recordData.set(item.getString("destfieldflag"), saleorder.get(item.getString("sourcefieldflag")));
                            continue;
                        }
                        if ("4".equals(contype)) {
                            recordData.set(item.getString("destfieldflag"), saleorder.get(item.getString("calculateexc")));
                            continue;
                        }
                        if ("3".equals(contype)) {
                            recordData.set(item.getString("destfieldflag"), item.get("calculateexc"));
                            continue;
                        }
                        String exestr = item.getString("calculateexc");
                        if (FormulaExec.IsexecMode(exestr)) {
                            Object execval = FormulaExec.exec(exestr, saleorder);
                            if (execval == null) continue;
                            recordData.set(item.getString("destfieldflag"), execval);
                            continue;
                        }
                        String dstag = item.getString("destfieldflag");
                        String execfiledName = SetOffCommonUtil.getExecfiledName(exestr, dstag);
                        recordData.set(dstag, saleorder.get(execfiledName));
                    }
                    catch (Exception e) {
                        if (!degbugerr) continue;
                        logger.error("genSaleOrderRecords() catch\u5f02\u5e382", (Throwable)e);
                        degbugerr = false;
                    }
                }
                String configtype = recordData.getString("defineconfig");
                if ("1".equals(configtype)) {
                    recordData.set("recorddate", (Object)SetOffCommonUtil.getConfigDate(recordData.getDate("recorddate")));
                }
                if (recordData.getDate("recorddate") == null) {
                    throw new KDBizException(String.format(ResManager.loadKDString((String)"'%s':\u8bf7\u7ed9\u5bf9\u5e94\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u4fe1\u606f\u4e2d\u7684\u8bb0\u5f55\u65e5\u671f\u5b57\u6bb5\u8bbe\u7f6e\u6b63\u786e\u7684\u65e5\u671f\u5b57\u6bb5\u7684\u6620\u5c04\u503c\u3002", (String)"BillFieldChange_5", (String)"mmc-mds-common", (Object[])new Object[0]), billno));
                }
                dynSet.add(recordData);
                if (dynSet.size() <= 10000) continue;
                DynamicObject[] dynObj = dynSet.toArray(new DynamicObject[dynSet.size()]);
                BillFieldChange.insertData(dynObj);
                dynSet = new ArrayList(10005);
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
        BillFieldChange.SetOtherProp(dynSet);
        DynamicObject[] dynObj = dynSet.toArray(new DynamicObject[dynSet.size()]);
        BillFieldChange.insertData(dynObj);
    }

    private static String getSearchField(DynamicObjectCollection billfieldentry, MainEntityType mainType) {
        HashSet<String> reSet = new HashSet<String>(30);
        reSet.add("id");
        reSet.add("closestatus");
        reSet.add("org");
        reSet.add("billno");
        reSet.add("biztime");
        reSet.add("billtype");
        reSet.add("billentry.qty");
        reSet.add("billentry.id");
        reSet.add("billentry.unit");
        reSet.add("billentry.materialmasterid");
        reSet.add("billentry.seq");
        reSet.add("billentry.deliverydate");
        reSet.add("billentry.invqty");
        reSet.add("billentry.invbaseqty");
        for (DynamicObject item : billfieldentry) {
            String skey;
            String contype = item.getString("converttype");
            if ("0".equals(contype)) {
                skey = item.getString("sourcefieldflag");
                reSet.add(skey);
                continue;
            }
            if ("4".equals(contype)) {
                skey = item.getString("calculateexc");
                reSet.add(skey);
                continue;
            }
            Set<String> allfiled = BillFieldChange.getBillAllField(mainType);
            String exestr = item.getString("calculateexc");
            if (exestr.indexOf(43) >= 0 || exestr.indexOf(45) >= 0 || exestr.indexOf(42) >= 0 || exestr.indexOf(47) >= 0) {
                reSet.add(BillFieldChange.getDestFlagString(exestr, item.getString("destfieldflag")));
                continue;
            }
            if (exestr.length() > 20) {
                for (String itemfield : allfiled) {
                    if (exestr.indexOf(itemfield) < 0) continue;
                    reSet.add(itemfield);
                }
                continue;
            }
            if (!allfiled.contains(exestr)) continue;
            reSet.add(exestr);
        }
        return String.join((CharSequence)",", reSet);
    }

    private static String getDestFlagString(String exestr, String deststr) {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(exestr);
        sBuilder.append(" as tmpexe");
        sBuilder.append(deststr);
        return sBuilder.toString();
    }

    private static String getOtherBillSearchField(DynamicObjectCollection billfieldentry, MainEntityType mainType) {
        HashSet<String> reSet = new HashSet<String>();
        String srcbill = mainType.getName();
        reSet.add("id");
        if ("im_saloutbill".equals(srcbill)) {
            reSet.add("billentry.material.masterid");
            reSet.add("billentry.id");
        } else if ("sm_delivernotice".equals(srcbill)) {
            reSet.add("billentry.materialmasterid");
            reSet.add("billentry.id");
        } else if ("mds_fnreport".equals(srcbill)) {
            reSet.add("materialid");
        }
        for (DynamicObject item : billfieldentry) {
            String contype = item.getString("converttype");
            if ("0".equals(contype)) {
                reSet.add(item.getString("sourcefieldflag"));
                continue;
            }
            if ("4".equals(contype)) {
                reSet.add(item.getString("calculateexc"));
                continue;
            }
            Set<String> allfiled = BillFieldChange.getBillAllField(mainType);
            String exestr = item.getString("calculateexc");
            if (exestr.indexOf(43) >= 0 || exestr.indexOf(45) >= 0 || exestr.indexOf(42) >= 0 || exestr.indexOf(47) >= 0) {
                reSet.add(BillFieldChange.getDestFlagString(exestr, item.getString("destfieldflag")));
                continue;
            }
            if (exestr.length() > 20) {
                for (String itemfield : allfiled) {
                    if (exestr.indexOf(itemfield) < 0) continue;
                    reSet.add(itemfield);
                }
                continue;
            }
            if (!allfiled.contains(exestr)) continue;
            reSet.add(exestr);
        }
        return String.join((CharSequence)",", reSet);
    }

    private static Set<String> getBillAllField(MainEntityType mainType) {
        HashSet<String> reSet = new HashSet<String>();
        Map fields = mainType.getAllFields();
        Iterator fits = fields.entrySet().iterator();
        int i = 0;
        while (fits.hasNext()) {
            String pname;
            Map.Entry entry = fits.next();
            IDataEntityProperty entity = (IDataEntityProperty)entry.getValue();
            String key = (String)entry.getKey();
            String alias = entity.getAlias();
            if (++i > 500) break;
            if (alias == null || "".equals(alias)) continue;
            if (!(entity.getParent() instanceof EntryType)) {
                reSet.add(key);
                continue;
            }
            if (!(entity.getParent() instanceof EntryType) || "".equals(pname = entity.getParent().getName())) continue;
            String idkey = pname + ".id";
            reSet.add(idkey);
            String seqkey = pname + ".seq";
            reSet.add(seqkey);
            String skey = pname + "." + key;
            reSet.add(skey);
        }
        return reSet;
    }

    private static String getMdsDataSelectors(DynamicObjectCollection billfieldentry, MainEntityType mainType) {
        HashSet<String> selectors = new HashSet<String>();
        selectors.add("id");
        selectors.add("billno");
        selectors.add("detailentity.fcqty");
        selectors.add("detailentity.id");
        selectors.add("detailentity.materialid");
        selectors.add("org");
        selectors.add("detailentity.baseunit");
        selectors.add("fcvrnnum");
        selectors.add("detailentity.seq");
        selectors.add("detailentity.writeoffnum");
        selectors.add("detailentity.datenode");
        for (DynamicObject item : billfieldentry) {
            String skey;
            String contype = item.getString("converttype");
            if ("0".equals(contype)) {
                skey = item.getString("sourcefieldflag");
                selectors.add(skey);
                continue;
            }
            if ("4".equals(contype)) {
                skey = item.getString("calculateexc");
                selectors.add(skey);
                continue;
            }
            Set<String> allfiled = BillFieldChange.getBillAllField(mainType);
            String exestr = item.getString("calculateexc");
            if (exestr.indexOf(43) >= 0 || exestr.indexOf(45) >= 0 || exestr.indexOf(42) >= 0 || exestr.indexOf(47) >= 0) {
                selectors.add(BillFieldChange.getDestFlagString(exestr, item.getString("destfieldflag")));
                continue;
            }
            if (exestr.length() > 20) {
                for (String itemfield : allfiled) {
                    if (exestr.indexOf(itemfield) < 0) continue;
                    selectors.add(itemfield);
                }
                continue;
            }
            if (!allfiled.contains(exestr)) continue;
            selectors.add(exestr);
        }
        return String.join((CharSequence)",", selectors);
    }

    private static String getTransferSelectors() {
        HashSet<String> selectors = new HashSet<String>();
        selectors.add("id");
        selectors.add("filter_tag");
        selectors.add("destbill.id");
        selectors.add("srcbill.id");
        selectors.add("entryentity.destfieldflag");
        selectors.add("entryentity.sourcefieldflag");
        selectors.add("entryentity.converttype");
        selectors.add("entryentity.calculateexc");
        selectors.add("entryentity.calculatetext");
        return String.join((CharSequence)",", selectors);
    }

    private static String getDataSourceSelectors() {
        HashSet<String> selectors = new HashSet<String>();
        selectors.add("id");
        selectors.add("billfieldtransfer");
        selectors.add("filter_tag");
        return String.join((CharSequence)",", selectors);
    }

    private static DynamicObject getNewDynamicObject(String entityNumber) {
        return ORM.create().newDynamicObject(entityNumber);
    }

    private static Long genLongId(String entityNumber) {
        return ORM.create().genLongId(entityNumber);
    }

    private static void insertData(DynamicObject[] recordData) {
        ORM.create().insert(recordData);
    }
}

