/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.setoff;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import kd.bos.algo.Row;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class FormulaExec {
    private static final String CNOW = "now()";
    private static final Log logger = LogFactory.getLog(FormulaExec.class);

    public static Object exec(String mualstr, Row obj) {
        Object realfalseval;
        Object realtrueval;
        Object res = null;
        String execString = mualstr.replaceAll(" ", "").toLowerCase();
        if (execString.length() <= 10) {
            return res;
        }
        String ifString = execString.substring(0, 3);
        String endstring = execString.substring(execString.length() - 1, execString.length());
        if (!"if(".equals(ifString) || !")".equals(endstring)) {
            return res;
        }
        String[] split2 = (execString = execString.substring(3, execString.length() - 1)).split(",");
        if (split2.length != 3) {
            return res;
        }
        String trueval = split2[1];
        String falseval = split2[2];
        Date curdate = FormulaExec.getCurDate();
        if (CNOW.equals(trueval)) {
            realtrueval = curdate;
        } else if ("''".equals(trueval)) {
            realtrueval = "";
        } else {
            realtrueval = obj.get(trueval);
            if (realtrueval == null) {
                realtrueval = "";
            }
        }
        if (CNOW.equals(falseval)) {
            realfalseval = curdate;
        } else if ("''".equals(falseval)) {
            realfalseval = "";
        } else {
            realfalseval = obj.get(falseval);
            if (realfalseval == null) {
                realfalseval = "";
            }
        }
        String cfdstr = split2[0];
        if (FormulaExec.execVal(cfdstr, obj)) {
            return realtrueval;
        }
        return realfalseval;
    }

    private static boolean execVal(String cfdstr, Row obj) {
        boolean res = false;
        String[] split2 = new String[]{};
        ExecOperator op = ExecOperator.LARGE_THEN;
        if (cfdstr.indexOf("&&") >= 0) {
            split2 = cfdstr.split("&&");
            op = ExecOperator.AND_THEN;
        } else if (cfdstr.indexOf("||") >= 0) {
            split2 = cfdstr.split("||");
            op = ExecOperator.OR_THEN;
        } else if (cfdstr.indexOf("!=") >= 0) {
            split2 = cfdstr.split("!=");
            op = ExecOperator.NOT_EQUALS;
        } else if (cfdstr.indexOf(">=") >= 0) {
            split2 = cfdstr.split(">=");
            op = ExecOperator.LARGE_EQUALS;
        } else if (cfdstr.indexOf("<=") >= 0) {
            split2 = cfdstr.split("<=");
            op = ExecOperator.LESS_EQUALS;
        } else if (cfdstr.indexOf(62) >= 0) {
            split2 = cfdstr.split(">");
            op = ExecOperator.LARGE_THEN;
        } else if (cfdstr.indexOf(60) >= 0) {
            split2 = cfdstr.split("<");
            op = ExecOperator.LESS_THEN;
        } else if (cfdstr.indexOf(61) >= 0) {
            split2 = cfdstr.split("=");
            op = ExecOperator.EQUALS_THEN;
        }
        if (split2.length == 2) {
            Object realbval;
            Object realaval;
            String aval = "";
            String bval = "";
            for (int i = 0; i < split2.length; ++i) {
                if (i == 0) {
                    aval = split2[i];
                }
                if (i != 1) continue;
                bval = split2[i];
            }
            Date curdate = FormulaExec.getCurDate();
            if (CNOW.equals(aval)) {
                realaval = curdate;
            } else if ("''".equals(aval)) {
                realaval = "";
            } else {
                realaval = obj.get(aval);
                if (realaval == null) {
                    realaval = "";
                }
            }
            if (CNOW.equals(bval)) {
                realbval = curdate;
            } else if ("''".equals(bval)) {
                realbval = "";
            } else {
                realbval = obj.get(bval);
                if (realbval == null) {
                    realbval = "";
                }
            }
            switch (op) {
                case NOT_EQUALS: {
                    int x = FormulaExec.compare(realaval, realbval);
                    if (x == 0) {
                        res = false;
                        break;
                    }
                    res = true;
                    break;
                }
                case LARGE_EQUALS: {
                    int x = FormulaExec.compare(realaval, realbval);
                    if (x >= 0) {
                        res = true;
                        break;
                    }
                    res = false;
                    break;
                }
                case LESS_EQUALS: {
                    int x = FormulaExec.compare(realaval, realbval);
                    if (x <= 0) {
                        res = true;
                        break;
                    }
                    res = false;
                    break;
                }
                case LARGE_THEN: {
                    int x = FormulaExec.compare(realaval, realbval);
                    if (x > 0) {
                        res = true;
                        break;
                    }
                    res = false;
                    break;
                }
                case LESS_THEN: {
                    int x = FormulaExec.compare(realaval, realbval);
                    if (x < 0) {
                        res = true;
                        break;
                    }
                    res = false;
                    break;
                }
                case EQUALS_THEN: {
                    int x = FormulaExec.compare(realaval, realbval);
                    if (x == 0) {
                        res = true;
                        break;
                    }
                    res = false;
                    break;
                }
            }
        }
        return res;
    }

    private static int compare(Object o1, Object o2) {
        if (o1 instanceof Boolean && o2 instanceof Boolean) {
            Boolean g1 = (Boolean)o1;
            Boolean g2 = (Boolean)o2;
            return g1.compareTo(g2);
        }
        if (o1 instanceof String && o2 instanceof String) {
            String g1 = (String)o1;
            String g2 = (String)o2;
            return g1.compareTo(g2);
        }
        if (o1 instanceof Integer && o2 instanceof Integer) {
            Integer g1 = (Integer)o1;
            Integer g2 = (Integer)o2;
            return g1.compareTo(g2);
        }
        if (o1 instanceof Long && o2 instanceof Long) {
            Long g1 = (Long)o1;
            Long g2 = (Long)o2;
            return g1.compareTo(g2);
        }
        if (o1 instanceof Date && o2 instanceof Date) {
            Date g1 = (Date)o1;
            Date g2 = (Date)o2;
            return g1.compareTo(g2);
        }
        if (o1 instanceof LocalDateTime && o2 instanceof LocalDateTime) {
            LocalDateTime g1 = (LocalDateTime)o1;
            LocalDateTime g2 = (LocalDateTime)o2;
            return g1.compareTo(g2);
        }
        if (o1 instanceof BigDecimal && o2 instanceof BigDecimal) {
            BigDecimal g1 = (BigDecimal)o1;
            BigDecimal g2 = (BigDecimal)o2;
            return g1.compareTo(g2);
        }
        return -1;
    }

    private static Date getCurDate() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String s = sdf.format(new Date());
        Date res = new Date();
        try {
            res = sdf.parse(s);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            return new Date();
        }
        return res;
    }

    public static boolean IsexecMode(String mualstr) {
        String execString = mualstr.replaceAll(" ", "").toLowerCase();
        if (execString.length() <= 10) {
            return false;
        }
        String ifString = execString.substring(0, 3);
        String endstring = execString.substring(execString.length() - 1, execString.length());
        return "if(".equals(ifString) && ")".equals(endstring);
    }

    private static enum ExecOperator {
        AND_THEN("&&"),
        OR_THEN("||"),
        NOT_EQUALS("!="),
        LARGE_EQUALS(">="),
        LESS_EQUALS("<="),
        LARGE_THEN(">"),
        LESS_THEN("<"),
        EQUALS_THEN("=");

        private String code;

        private ExecOperator(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

