/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.setoff;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.CachedDataSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.Row;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.botp.BusinessFlowDataService;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.dlock.DLock;
import kd.bos.dlock.DLockInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.exception.KDBizException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mutex.impl.MutexLockInfo;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.TaskInfo;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.mmc.mds.common.setoff.FNSetOffList;
import kd.mmc.mds.common.setoff.infoclass.MatinvInfo;
import kd.mmc.mds.common.setoff.infoclass.SetoffFieldSet;
import kd.mpscmm.msplan.mservice.service.datasync.MMCSnapDataVisitor;

public class SetOffCommonUtil {
    public static final String MDS_SETOFFLOG = "mds_setofflog";
    public static final int WeekFirst = 2;
    public static final int MonthFirst = 5;
    private static final Log logger = LogFactory.getLog(SetOffCommonUtil.class);

    public static DynamicObject CreateSetoffLog(List<Long> settoolid) {
        DynamicObject bill = BusinessDataServiceHelper.newDynamicObject((String)MDS_SETOFFLOG);
        String unRepeatNumber = SetOffCommonUtil.getUnRepeatNumber(bill, MDS_SETOFFLOG);
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("setofftoolentry");
        DynamicObjectType sType = entrys.getDynamicObjectType();
        bill.set("number", (Object)unRepeatNumber);
        bill.set("name", (Object)unRepeatNumber);
        bill.set("createorg", (Object)RequestContext.get().getOrgId());
        bill.set("org", (Object)RequestContext.get().getOrgId());
        bill.set("ctrlstrategy", (Object)"5");
        bill.set("execstat", (Object)"B");
        bill.set("creator", (Object)UserServiceHelper.getCurrentUserId());
        bill.set("createtime", (Object)new Date());
        bill.set("modifier", (Object)UserServiceHelper.getCurrentUserId());
        bill.set("modifytime", (Object)new Date());
        bill.set("status", (Object)"C");
        bill.set("enable", (Object)"1");
        int i = 0;
        for (Long toolid : settoolid) {
            DynamicObject entry = new DynamicObject(sType);
            entry.set("setoffid", (Object)toolid);
            entry.set("seq", (Object)(++i));
            entrys.add((Object)entry);
        }
        Object[] res = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        BaseDataServiceHelper.clearCache((DynamicObject)bill);
        if (res.length > 0) {
            return (DynamicObject)res[0];
        }
        return null;
    }

    public static DynamicObject CreateSetoffLogAddShow(IFormView view, List<Long> settoolid) {
        DynamicObject obj = SetOffCommonUtil.CreateSetoffLog(settoolid);
        if (obj != null && view != null) {
            BillShowParameter showParameter = new BillShowParameter();
            showParameter.setFormId(MDS_SETOFFLOG);
            showParameter.setPkId(obj.getPkValue());
            showParameter.setCustomParam("isexec", (Object)"true");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setStatus(OperationStatus.VIEW);
            view.showForm((FormShowParameter)showParameter);
        }
        return obj;
    }

    public static synchronized String getUnRepeatNumber(DynamicObject obj, String objtag) {
        String snumber = CodeRuleServiceHelper.getNumber((String)objtag, (DynamicObject)obj, (String)String.valueOf(RequestContext.get().getOrgId()));
        QFilter qsfilter = new QFilter("number", "=", (Object)snumber);
        DynamicObjectCollection qobj = QueryServiceHelper.query((String)objtag, (String)"id", (QFilter[])new QFilter[]{qsfilter});
        if (!qobj.isEmpty()) {
            try {
                snumber = SetOffCommonUtil.getNewNumber(snumber);
            }
            catch (Exception e) {
                logger.info(e.getMessage());
            }
        }
        return snumber;
    }

    public static String getNewNumber(String snumber) {
        String last = snumber.substring(snumber.length() - 3, snumber.length());
        String first = snumber.substring(0, snumber.length() - 3);
        int i = Integer.parseInt(last) + 1;
        last = StringUtils.leftPad((String)String.valueOf(i), (int)3, (String)"0");
        return first + last;
    }

    public static String getDateString() {
        Date date = new Date(System.currentTimeMillis());
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        return simpleDateFormat.format(date);
    }

    public static TaskInfo getTaskStat(String taskid) {
        return JobClient.queryTask((String)taskid);
    }

    public static void stoptask(Long setoffLogid) {
        try {
            DynamicObject setofflog = BusinessDataServiceHelper.loadSingle((Object)setoffLogid, (String)MDS_SETOFFLOG);
            setofflog.set("execstat", (Object)"C");
            SaveServiceHelper.update((DynamicObject)setofflog);
            SetOffCommonUtil.UpdateSetJobAndPlan(setofflog);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    public static void UpdateSetJobAndPlanById(Long setoffLogid) {
        try {
            DynamicObject setoffLog = BusinessDataServiceHelper.loadSingle((Object)setoffLogid, (String)MDS_SETOFFLOG);
            SetOffCommonUtil.UpdateSetJobAndPlan(setoffLog);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    public static void UpdateSetJobAndPlan(DynamicObject setoffLog) {
        DynamicObjectCollection logentrys = setoffLog.getDynamicObjectCollection("setofftoolentry");
        if (logentrys == null) {
            return;
        }
        try {
            for (DynamicObject item : logentrys) {
                DynamicObject dobj = item.getDynamicObject("setoffid");
                if (dobj == null) continue;
                DynamicObject setofftool = BusinessDataServiceHelper.loadSingle((Object)dobj.getLong("id"), (String)"mds_setofftool");
                DynamicObjectCollection setoffset = setofftool.getDynamicObjectCollection("entryentity");
                for (DynamicObject dynamicObject : setoffset) {
                    DynamicObject setItem = BusinessDataServiceHelper.loadSingle((Object)dynamicObject.getDynamicObject("setid").getPkValue(), (String)"mds_setoffsetting");
                    setItem.set("jobid", (Object)"");
                    setItem.set("planid", (Object)"");
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{setItem});
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
    }

    public static String getExecStat(Long setoffLogId) {
        return (String)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"select fexecstat from t_mds_setofflog where fid=?", (Object[])new Object[]{setoffLogId}, rs -> {
            if (rs.next()) {
                return rs.getString(1);
            }
            return "";
        });
    }

    public static Date formatDate(Date curdate) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(curdate);
        instance.set(11, 0);
        instance.set(12, 0);
        instance.set(13, 0);
        instance.set(14, 0);
        return instance.getTime();
    }

    public static Date stringToDate(String firstDay) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Date date = null;
        try {
            date = sdf.parse(firstDay);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return date;
    }

    public static Date getThisWeekXday(boolean addone, int x) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        day = day < x ? x - day - 7 : x - day;
        if (addone) {
            cal.add(5, day - 1);
        } else {
            cal.add(5, day);
        }
        return cal.getTime();
    }

    public static Date cutDate(Date cdate, int x) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(cdate);
        cal.add(5, x);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getNextWeekXday(Date mondaydate, Integer muit) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(mondaydate);
        if (muit > 1) {
            Integer pMuit = muit - 1;
            cal.add(5, 7 * pMuit);
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getDateWeekMonday(Date fdate, int x) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(fdate);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        day = day < x ? x - day - 7 : x - day;
        cal.add(5, day);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date getMonthFirstXday(Date gdate, boolean cutone, int calenderdayemu) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(gdate);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        cal.set(1, year);
        cal.set(2, month - 1);
        int day = 1;
        cal.set(5, day);
        while (cal.get(7) != calenderdayemu) {
            cal.set(5, ++day);
        }
        if (cutone) {
            cal.add(5, -1);
        }
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static boolean isSameDate(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        boolean isSameYear = cal1.get(1) == cal2.get(1);
        boolean isSameMonth = isSameYear && cal1.get(2) == cal2.get(2);
        boolean isSameDate = isSameMonth && cal1.get(5) == cal2.get(5);
        return isSameDate;
    }

    public static boolean isInAreaDate(Date sdate, Date edate, Date curdate) {
        return sdate.getTime() <= curdate.getTime() && edate.getTime() >= curdate.getTime();
    }

    public static BigDecimal calLastedTime(Date startDate, Date enddate) {
        double a = enddate.getTime();
        double b = startDate.getTime();
        double e = 1000.0;
        BigDecimal c = BigDecimal.valueOf((a - b) / e);
        return c;
    }

    public static void BatchInsertTable(String tablename, List<String> fieldList, List<Object[]> paramsList, String routeNo) {
        StringBuilder sb = new StringBuilder();
        if (fieldList.isEmpty() || paramsList.isEmpty() || "".equals(tablename)) {
            return;
        }
        if (tablename.toLowerCase().indexOf("t_") < 0) {
            return;
        }
        if ("".equals(routeNo)) {
            routeNo = "scm";
        }
        ArrayList<String> lstW = new ArrayList<String>(41);
        for (int i = 0; i < fieldList.size(); ++i) {
            lstW.add("?");
        }
        sb.append("insert into ");
        sb.append(tablename);
        sb.append(" (");
        sb.append(String.join((CharSequence)",", fieldList));
        sb.append(") values(");
        sb.append(String.join((CharSequence)",", lstW));
        sb.append(") ");
        DB.executeBatch((DBRoute)DBRoute.of((String)routeNo), (String)sb.toString(), paramsList);
    }

    public static List<SetoffFieldSet> buildSetoffFieldSet() {
        ArrayList<SetoffFieldSet> fieldSetList = new ArrayList<SetoffFieldSet>();
        QFilter[] filters = new QFilter[]{new QFilter("effect", "=", (Object)true)};
        DynamicObject setoffFieldSet = BusinessDataServiceHelper.loadSingleFromCache((String)"mds_setofffieldset", (QFilter[])filters);
        if (setoffFieldSet == null) {
            return fieldSetList;
        }
        DynamicObjectCollection entryEntity = setoffFieldSet.getDynamicObjectCollection("entryentity");
        MainEntityType fnReportType = EntityMetadataCache.getDataEntityType((String)"mds_fnreport");
        for (DynamicObject row : entryEntity) {
            String targetFieldKey = row.getString("targetfieldkey");
            DynamicObject sourceType = row.getDynamicObject("sourcetype");
            String srcFieldKey = row.getString("srcfieldkey");
            if (StringUtils.isBlank((CharSequence)targetFieldKey) || sourceType == null || StringUtils.isBlank((CharSequence)srcFieldKey)) continue;
            IDataEntityProperty targetProp = fnReportType.findProperty(targetFieldKey);
            if (targetProp == null) {
                logger.info("\u6784\u9020\u51b2\u51cf\u5b57\u6bb5\u8bbe\u7f6e\uff1a\u76ee\u6807\u5b57\u6bb5\u3010{}\u3011\u5728\u9884\u6d4b\u51b2\u51cf\u8bb0\u5f55\u4e2d\u4e0d\u5b58\u5728", (Object)targetFieldKey);
                continue;
            }
            String targetDbKey = targetProp.getAlias();
            if (StringUtils.isBlank((CharSequence)targetDbKey)) {
                logger.info("\u6784\u9020\u51b2\u51cf\u5b57\u6bb5\u8bbe\u7f6e\uff1a\u76ee\u6807\u5b57\u6bb5\u3010{}\u3011\u4e0d\u5b58\u5728\u6570\u636e\u5e93\u5b57\u6bb5", (Object)targetFieldKey);
                continue;
            }
            String sourceTypeId = (String)sourceType.getPkValue();
            if (StringUtils.isBlank((CharSequence)sourceTypeId)) {
                logger.info("\u6784\u9020\u51b2\u51cf\u5b57\u6bb5\u8bbe\u7f6e\uff1a\u6765\u6e90\u7c7b\u578b\u4e3b\u952e\u4e3a\u7a7a");
                continue;
            }
            SetoffFieldSet fieldSet = new SetoffFieldSet(targetDbKey, sourceTypeId, srcFieldKey);
            fieldSetList.add(fieldSet);
        }
        return fieldSetList;
    }

    public static Long backupSetoffData(Long setoffsetid, Long logid) {
        Long res = (Long)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"select count(*) from t_mds_fnreport where fsetid=?", (Object[])new Object[]{setoffsetid}, rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
        List<SetoffFieldSet> fieldSetList = SetOffCommonUtil.buildSetoffFieldSet();
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("Insert into  t_mds_fnreportbk(");
        sBuilder.append("fid");
        sBuilder.append(",fbillno");
        sBuilder.append(",fbillstatus");
        sBuilder.append(",fcreatorid");
        sBuilder.append(",fcreatetime");
        sBuilder.append(",forgid");
        sBuilder.append(",fsno");
        sBuilder.append(",fbillid");
        sBuilder.append(",fbillentryid");
        sBuilder.append(",fmaterialid");
        sBuilder.append(",fokdate");
        sBuilder.append(",ffinishdate");
        sBuilder.append(",ffordate");
        sBuilder.append(",fsetoffdate");
        sBuilder.append(",fqty");
        sBuilder.append(",fsetoffqty");
        sBuilder.append(",fsetoffverid");
        sBuilder.append(",funitid");
        sBuilder.append(",frowno");
        sBuilder.append(",fforecastqty");
        sBuilder.append(",fremainqty");
        sBuilder.append(",fepddate");
        sBuilder.append(",fsaleorg");
        sBuilder.append(",frpddate");
        sBuilder.append(",foutstockqty");
        sBuilder.append(",forderremainqty");
        sBuilder.append(",fbilltype");
        sBuilder.append(",fsendgoodsdate");
        sBuilder.append(",ftoolid");
        sBuilder.append(",fsetid");
        sBuilder.append(",forderstatus");
        sBuilder.append(",fplanid");
        sBuilder.append(",fplanentryid");
        sBuilder.append(",fkqdate");
        sBuilder.append(",fexecqty");
        sBuilder.append(",fmanufactureid");
        sBuilder.append(",fsrcmaterialid");
        sBuilder.append(",fhwremainqty");
        sBuilder.append(",fsalremainqty");
        sBuilder.append(",fisqtysetoff");
        sBuilder.append(",fmodifytime");
        sBuilder.append(",ftrackid");
        sBuilder.append(",fconfigid");
        sBuilder.append(",fprojectid");
        sBuilder.append(",fplanscopeid");
        sBuilder.append(",fauxpropertyid");
        sBuilder.append(",fproconfigid");
        sBuilder.append(",fproprojectid");
        sBuilder.append(",fproplanscopeid");
        sBuilder.append(",fproauxpropertyid");
        sBuilder.append(",fdemandoffset");
        sBuilder.append(",freqmanufactureid");
        sBuilder.append(",fsetofflogid");
        for (SetoffFieldSet fieldSet : fieldSetList) {
            sBuilder.append(String.format(",%s", fieldSet.getTargetDbKey()));
        }
        sBuilder.append(")");
        sBuilder.append("select ");
        sBuilder.append("fid");
        sBuilder.append(",fbillno");
        sBuilder.append(",fbillstatus");
        sBuilder.append(",fcreatorid");
        sBuilder.append(",fcreatetime");
        sBuilder.append(",forgid");
        sBuilder.append(",fsno");
        sBuilder.append(",fbillid");
        sBuilder.append(",fbillentryid");
        sBuilder.append(",fmaterialid");
        sBuilder.append(",fokdate");
        sBuilder.append(",ffinishdate");
        sBuilder.append(",ffordate");
        sBuilder.append(",fsetoffdate");
        sBuilder.append(",fqty");
        sBuilder.append(",fsetoffqty");
        sBuilder.append(",fsetoffverid");
        sBuilder.append(",funitid");
        sBuilder.append(",frowno");
        sBuilder.append(",fforecastqty");
        sBuilder.append(",fremainqty");
        sBuilder.append(",fepddate");
        sBuilder.append(",fsaleorg");
        sBuilder.append(",frpddate");
        sBuilder.append(",foutstockqty");
        sBuilder.append(",forderremainqty");
        sBuilder.append(",fbilltype");
        sBuilder.append(",fsendgoodsdate");
        sBuilder.append(",ftoolid");
        sBuilder.append(",fsetid");
        sBuilder.append(",forderstatus");
        sBuilder.append(",fplanid");
        sBuilder.append(",fplanentryid");
        sBuilder.append(",fkqdate");
        sBuilder.append(",fexecqty");
        sBuilder.append(",fmanufactureid");
        sBuilder.append(",fsrcmaterialid");
        sBuilder.append(",fhwremainqty");
        sBuilder.append(",fsalremainqty");
        sBuilder.append(",fisqtysetoff");
        sBuilder.append(",fcreatetime");
        sBuilder.append(",ftrackid");
        sBuilder.append(",fconfigid");
        sBuilder.append(",fprojectid");
        sBuilder.append(",fplanscopeid");
        sBuilder.append(",fauxpropertyid");
        sBuilder.append(",fproconfigid");
        sBuilder.append(",fproprojectid");
        sBuilder.append(",fproplanscopeid");
        sBuilder.append(",fproauxpropertyid");
        sBuilder.append(",fdemandoffset");
        sBuilder.append(",freqmanufactureid");
        sBuilder.append(",?");
        for (SetoffFieldSet fieldSet : fieldSetList) {
            sBuilder.append(String.format(",%s", fieldSet.getTargetDbKey()));
        }
        sBuilder.append(" from t_mds_fnreport where fsetid=?;");
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)sBuilder.toString(), (Object[])new Object[]{logid, setoffsetid});
        return res;
    }

    public static void SaveFNREPORT(List<FNSetOffList> lstitem) {
        Long uid = Long.valueOf(RequestContext.get().getUserId());
        Long oid = RequestContext.get().getOrgId();
        ArrayList<String> fieldlst = new ArrayList<String>(51);
        fieldlst.add("fid");
        fieldlst.add("fbillno");
        fieldlst.add("fbillstatus");
        fieldlst.add("fcreatorid");
        fieldlst.add("fcreatetime");
        fieldlst.add("forgid");
        fieldlst.add("fsno");
        fieldlst.add("fbillid");
        fieldlst.add("fbillentryid");
        fieldlst.add("fmaterialid");
        fieldlst.add("fokdate");
        fieldlst.add("ffinishdate");
        fieldlst.add("ffordate");
        fieldlst.add("fsetoffdate");
        fieldlst.add("fqty");
        fieldlst.add("fsetoffqty");
        fieldlst.add("fsetoffverid");
        fieldlst.add("funitid");
        fieldlst.add("frowno");
        fieldlst.add("fforecastqty");
        fieldlst.add("fremainqty");
        fieldlst.add("fepddate");
        fieldlst.add("fsaleorg");
        fieldlst.add("frpddate");
        fieldlst.add("foutstockqty");
        fieldlst.add("forderremainqty");
        fieldlst.add("fbilltype");
        fieldlst.add("fsendgoodsdate");
        fieldlst.add("ftoolid");
        fieldlst.add("fsetid");
        fieldlst.add("forderstatus");
        fieldlst.add("fplanid");
        fieldlst.add("fplanentryid");
        fieldlst.add("fkqdate");
        fieldlst.add("fexecqty");
        fieldlst.add("fmanufactureid");
        fieldlst.add("fsrcmaterialid");
        fieldlst.add("fhwremainqty");
        fieldlst.add("fsalremainqty");
        fieldlst.add("fisqtysetoff");
        fieldlst.add("ftrackid");
        fieldlst.add("fconfigid");
        fieldlst.add("fprojectid");
        fieldlst.add("fplanscopeid");
        fieldlst.add("fauxpropertyid");
        fieldlst.add("fproconfigid");
        fieldlst.add("fproprojectid");
        fieldlst.add("fproplanscopeid");
        fieldlst.add("fproauxpropertyid");
        fieldlst.add("fdemandoffset");
        fieldlst.add("freqmanufactureid");
        if (!lstitem.isEmpty()) {
            FNSetOffList item = lstitem.get(0);
            List<Tuple<String, Object>> fieldSetValueList = item.getFieldSetValueList();
            for (Tuple<String, Object> tuple : fieldSetValueList) {
                fieldlst.add((String)tuple.item1);
            }
        }
        ORM orm = ORM.create();
        ArrayList<Object[]> addParamsList = new ArrayList<Object[]>(10001);
        long[] genLongIds = orm.genLongIds("mds_fnreport", lstitem.size());
        int idIndex = 0;
        for (FNSetOffList soff : lstitem) {
            int paramIndex = 0;
            Object[] param = new Object[fieldlst.size()];
            param[paramIndex++] = genLongIds[idIndex];
            ++idIndex;
            param[paramIndex++] = soff.getForderno();
            param[paramIndex++] = "C";
            param[paramIndex++] = uid;
            param[paramIndex++] = soff.getFcreatetime();
            param[paramIndex++] = oid;
            param[paramIndex++] = soff.getForderno();
            param[paramIndex++] = soff.getForderid();
            param[paramIndex++] = soff.getForderentryid();
            param[paramIndex++] = soff.getFmaterialid();
            param[paramIndex++] = soff.getFokdate();
            param[paramIndex++] = soff.getFfinishdate();
            param[paramIndex++] = soff.getFfordate();
            param[paramIndex++] = soff.getFsetoffdate();
            param[paramIndex++] = soff.getFqty();
            param[paramIndex++] = soff.getFsetoffqty();
            param[paramIndex++] = soff.getFsetoffverid();
            param[paramIndex++] = soff.getFunitid();
            param[paramIndex++] = soff.getFrowno();
            param[paramIndex++] = soff.getFforecastqty();
            param[paramIndex++] = soff.getFremainqty();
            param[paramIndex++] = soff.getFepddate();
            param[paramIndex++] = soff.getFsaleorg();
            param[paramIndex++] = soff.getFrpddate();
            param[paramIndex++] = soff.getFoutstockqty();
            param[paramIndex++] = soff.getFqty().subtract(soff.getFoutstockqty());
            param[paramIndex++] = soff.getFbilltype();
            param[paramIndex++] = soff.getFsendgoodsdate();
            param[paramIndex++] = soff.getFtoolid();
            param[paramIndex++] = soff.getFsetid();
            param[paramIndex++] = soff.getForderstatus();
            param[paramIndex++] = soff.getFplanid();
            param[paramIndex++] = soff.getFplanentryid();
            param[paramIndex++] = soff.getFkqdate();
            param[paramIndex++] = soff.getFexecqty();
            param[paramIndex++] = soff.getFmanufactureid();
            param[paramIndex++] = soff.getFsrcmaterialid();
            param[paramIndex++] = soff.getFhwremainqty();
            param[paramIndex++] = soff.getFsalremainqty();
            param[paramIndex++] = soff.getFisqtysetoff();
            param[paramIndex++] = soff.getFtrackid();
            param[paramIndex++] = soff.getFconfigid();
            param[paramIndex++] = soff.getFprojectid();
            param[paramIndex++] = soff.getFplanscopeid();
            param[paramIndex++] = soff.getFauxpropertyid();
            param[paramIndex++] = soff.getFproconfigid();
            param[paramIndex++] = soff.getFproprojectid();
            param[paramIndex++] = soff.getFproplanscopeid();
            param[paramIndex++] = soff.getFproauxpropertyid();
            param[paramIndex++] = soff.getFdemandoffset();
            param[paramIndex++] = soff.getFreqmanufactureid();
            List<Tuple<String, Object>> fieldSetValueList = soff.getFieldSetValueList();
            for (Tuple<String, Object> tuple : fieldSetValueList) {
                param[paramIndex++] = tuple.item2;
            }
            addParamsList.add(param);
            if (addParamsList.size() <= 10000) continue;
            SetOffCommonUtil.BatchInsertTable("t_mds_fnreport", fieldlst, addParamsList, "SCM");
            addParamsList.clear();
        }
        if (!addParamsList.isEmpty()) {
            SetOffCommonUtil.BatchInsertTable("t_mds_fnreport", fieldlst, addParamsList, "SCM");
        }
    }

    public static Map<Long, Set<Long>> getPolicymatidlst(DynamicObject setoffset, Long erpDateid) {
        DynamicObjectCollection hasmatlst;
        Row srcData2;
        Object object;
        DataSet coll;
        Object qfilter;
        DynamicObjectCollection zzobjs;
        HashSet<Long> idSet;
        HashMap<Long, Set<Long>> res = new HashMap<Long, Set<Long>>();
        ArrayList<Long> polids = new ArrayList<Long>();
        try {
            DynamicObjectCollection sentrys = setoffset.getDynamicObjectCollection("entryentitys");
            for (DynamicObject sitem : sentrys) {
                idSet = new HashSet<Long>();
                zzobjs = sitem.getDynamicObjectCollection("manustrategy");
                if (zzobjs.isEmpty()) continue;
                for (DynamicObject item : zzobjs) {
                    polids.add((Long)item.get("fbasedataid_id"));
                }
                if (polids.isEmpty()) continue;
                qfilter = new QFilter("manustrategy", "in", polids);
                qfilter.and(new QFilter("status", "=", (Object)"C"));
                qfilter.and(new QFilter("enable", "=", (Object)"1"));
                if (erpDateid > 0L) {
                    try {
                        coll = SetOffCommonUtil.loadCacheDatas(erpDateid, "bd_materialinventoryinfo", "masterid", new QFilter[]{qfilter});
                        object = null;
                        try {
                            if (coll != null) {
                                while (coll.hasNext()) {
                                    srcData2 = coll.next();
                                    idSet.add(srcData2.getLong("masterid"));
                                }
                                res.put(sitem.getLong("id"), idSet);
                                continue;
                            }
                        }
                        catch (Throwable srcData2) {
                            object = srcData2;
                            throw srcData2;
                        }
                        finally {
                            if (coll == null) continue;
                            if (object != null) {
                                try {
                                    coll.close();
                                }
                                catch (Throwable srcData2) {
                                    ((Throwable)object).addSuppressed(srcData2);
                                }
                                continue;
                            }
                            coll.close();
                            continue;
                        }
                    }
                    catch (Exception e) {
                        throw new KDBizException(e.getMessage());
                    }
                }
                hasmatlst = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"masterid", (QFilter[])new QFilter[]{qfilter});
                for (DynamicObject obj : hasmatlst) {
                    idSet.add(obj.getLong("masterid"));
                }
                res.put(sitem.getLong("id"), idSet);
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u9700\u65b9\u5236\u9020\u7b56\u7565\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"SetOffCommonUtil_8", (String)"mmc-mds-common", (Object[])new Object[0]), e.getMessage()));
        }
        polids = new ArrayList();
        try {
            DynamicObjectCollection gentrys = setoffset.getDynamicObjectCollection("entryentityg");
            for (DynamicObject sitem : gentrys) {
                idSet = new HashSet();
                zzobjs = sitem.getDynamicObjectCollection("manustrategysup");
                if (zzobjs.isEmpty()) continue;
                for (DynamicObject item : zzobjs) {
                    polids.add((Long)item.get("fbasedataid_id"));
                }
                if (polids.isEmpty()) continue;
                qfilter = new QFilter("manustrategy", "in", polids);
                qfilter.and(new QFilter("status", "=", (Object)"C"));
                qfilter.and(new QFilter("enable", "=", (Object)"1"));
                if (erpDateid > 0L) {
                    try {
                        coll = SetOffCommonUtil.loadCacheDatas(erpDateid, "bd_materialinventoryinfo", "masterid", new QFilter[]{qfilter});
                        object = null;
                        try {
                            if (coll != null) {
                                while (coll.hasNext()) {
                                    srcData2 = coll.next();
                                    idSet.add(srcData2.getLong("masterid"));
                                }
                                res.put(sitem.getLong("id"), idSet);
                                continue;
                            }
                        }
                        catch (Throwable srcData3) {
                            object = srcData3;
                            throw srcData3;
                        }
                        finally {
                            if (coll == null) continue;
                            if (object != null) {
                                try {
                                    coll.close();
                                }
                                catch (Throwable srcData3) {
                                    ((Throwable)object).addSuppressed(srcData3);
                                }
                                continue;
                            }
                            coll.close();
                            continue;
                        }
                    }
                    catch (Exception e) {
                        throw new KDBizException(e.getMessage());
                    }
                }
                hasmatlst = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"masterid", (QFilter[])new QFilter[]{qfilter});
                for (DynamicObject obj : hasmatlst) {
                    idSet.add(obj.getLong("masterid"));
                }
                res.put(sitem.getLong("id"), idSet);
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u4f9b\u65b9\u5236\u9020\u7b56\u7565\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"SetOffCommonUtil_9", (String)"mmc-mds-common", (Object[])new Object[0]), e.getMessage()));
        }
        return res;
    }

    public static DataSet wrap(CachedDataSet cds) {
        if (cds == null) {
            return null;
        }
        DataSetBuilder builder = Algo.create((String)SetOffCommonUtil.class.getName()).createDataSetBuilder(cds.getRowMeta());
        Iterator rowIter = cds.iterator(0, cds.getRowCount());
        while (rowIter.hasNext()) {
            builder.append((Row)rowIter.next());
        }
        return builder.build();
    }

    public static DataSet loadCacheDatas(Long snapshotschemeid, String etStr, String selectFields, QFilter[] filters) {
        if (snapshotschemeid.compareTo(999L) == 0) {
            return null;
        }
        if (snapshotschemeid.compareTo(888L) == 0) {
            return QueryServiceHelper.queryDataSet((String)"", (String)etStr, (String)selectFields, (QFilter[])filters, null);
        }
        if (snapshotschemeid != null && snapshotschemeid != 0L) {
            MMCSnapDataVisitor mspvisitor = new MMCSnapDataVisitor();
            return mspvisitor.localFastDataVisit(snapshotschemeid, Long.valueOf(0L), etStr, selectFields, filters, "");
        }
        return null;
    }

    public static Date getConfigDate(Date rDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String s = sdf.format(new Date());
        Date res = null;
        try {
            res = sdf.parse(s);
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        if (res == null) {
            res = new Date();
        }
        if (rDate == null) {
            return res;
        }
        if (rDate.compareTo(res) > 0) {
            res = rDate;
        }
        return res;
    }

    public static DynamicObject getSaleOutobject(Long saleorderid, String billentity, String selfield, String datekey) {
        DynamicObject saleout = null;
        try {
            Map<String, HashSet<Long>> map = SetOffCommonUtil.getTargetBillsByObj("sm_salorder", saleorderid);
            for (Map.Entry<String, HashSet<Long>> entry : map.entrySet()) {
                String key = entry.getKey();
                if (!billentity.equals(key)) continue;
                HashSet<Long> idSet = entry.getValue();
                QFilter qsfilter = new QFilter("id", "in", idSet);
                DynamicObjectCollection saleOutColl = QueryServiceHelper.query((String)billentity, (String)selfield, (QFilter[])new QFilter[]{qsfilter});
                if (saleOutColl.isEmpty()) continue;
                saleout = (DynamicObject)saleOutColl.get(0);
                for (DynamicObject sales : saleOutColl) {
                    if (sales.getDate(datekey).compareTo(saleout.getDate(datekey)) <= 0) continue;
                    saleout = sales;
                }
            }
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        return saleout;
    }

    public static DynamicObject getSaleOutobject(Long saleorderid) {
        return SetOffCommonUtil.getSaleOutobject(saleorderid, "im_saloutbill", "id,biztime", "biztime");
    }

    public static Map<String, HashSet<Long>> getTargetBillsByObj(String entityNumber, Long objid) {
        BusinessFlowDataService service = new BusinessFlowDataService();
        Long[] ids = new Long[]{objid};
        Map map = service.findTargetBills(entityNumber, ids);
        return map;
    }

    public static List<Long> getTableMatidlst(String tablename, String fieldname, String dbroute) {
        StringBuilder sqlsb = new StringBuilder();
        sqlsb.append("select distinct ");
        sqlsb.append(fieldname);
        sqlsb.append(" from ");
        sqlsb.append(tablename);
        sqlsb.append(';');
        ArrayList<Long> idList = new ArrayList(10000);
        try {
            idList = (List)DB.query((DBRoute)DBRoute.of((String)dbroute), (String)sqlsb.toString(), rs -> {
                LinkedList<Long> ret = new LinkedList<Long>();
                while (rs.next()) {
                    ret.add(rs.getLong(1));
                }
                return ret;
            });
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u5355\u636e\u7269\u6599\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a%s\u3002", (String)"SetOffCommonUtil_10", (String)"mmc-mds-common", (Object[])new Object[0]), e.getMessage()));
        }
        return idList;
    }

    public static void updateTaskid(Long billid, String taskid) {
        DB.update((DBRoute)DBRoute.of((String)"scm"), (String)"update t_mds_setofflog set FJOBID=? where fid=?", (Object[])new Object[]{taskid, billid});
    }

    public static boolean getTaskIsWork(Long setoffLogId) {
        DLockInfo lockInfo = DLock.getLockInfo((String)"");
        return (Boolean)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"select FEXECSTAT from t_mds_setofflog where fid=?", (Object[])new Object[]{setoffLogId}, rs -> {
            if (rs.next() && "B".equals(rs.getString(1))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        });
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<Long, List<Long>> getProductSub(Long mrpid) {
        Object object;
        Row proMap;
        QFilter[] qfs;
        String selstring;
        block23: {
            selstring = "materielitem,materielpbom";
            QFilter qFilter1 = new QFilter("bomtype", "=", (Object)"MBOM");
            qfs = new QFilter[]{qFilter1};
            proMap = new HashMap();
            if (mrpid > 0L) {
                DataSet coll;
                block22: {
                    try {
                        coll = SetOffCommonUtil.loadCacheDatas(mrpid, "mds_productfamily", selstring, qfs);
                        object = null;
                        try {
                            if (coll != null) break block22;
                            break block23;
                        }
                        catch (Throwable srcData) {
                            object = srcData;
                            throw srcData;
                        }
                        finally {
                            if (coll != null) {
                                if (object != null) {
                                    try {
                                        coll.close();
                                    }
                                    catch (Throwable cid) {
                                        ((Throwable)object).addSuppressed(cid);
                                    }
                                } else {
                                    coll.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new KDBizException(e.getMessage());
                    }
                }
                while (true) {
                    if (!coll.hasNext()) {
                        return proMap;
                    }
                    Row srcData = coll.next();
                    Long cid = srcData.getLong("materielitem");
                    Long pid = srcData.getLong("materielpbom");
                    if (proMap.containsKey(cid)) {
                        List list = (List)proMap.get(cid);
                        if (list.contains(pid)) continue;
                        list.add(pid);
                        continue;
                    }
                    ArrayList<Long> list2 = new ArrayList<Long>();
                    list2.add(pid);
                    proMap.put(cid, list2);
                }
            }
        }
        DynamicObjectCollection proItem = QueryServiceHelper.query((String)"mds_productfamily", (String)selstring, (QFilter[])qfs);
        object = proItem.iterator();
        while (object.hasNext()) {
            DynamicObject item = (DynamicObject)object.next();
            Long cid = item.getLong("materielitem");
            Long pid = item.getLong("materielpbom");
            if (proMap.containsKey(cid)) {
                List list = (List)proMap.get(cid);
                if (list.contains(pid)) continue;
                list.add(pid);
                continue;
            }
            ArrayList<Long> list2 = new ArrayList<Long>();
            list2.add(pid);
            proMap.put(cid, list2);
        }
        return proMap;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<Long, List<Long>> getProductSub2(Long mrpid) {
        Object object;
        Row proMap;
        QFilter[] qfs;
        String selstring;
        block23: {
            selstring = "materielitem,materielpbom";
            QFilter qFilter1 = new QFilter("bomtype", "=", (Object)"MBOM");
            qfs = new QFilter[]{qFilter1};
            proMap = new HashMap();
            if (mrpid > 0L) {
                DataSet coll;
                block22: {
                    try {
                        coll = SetOffCommonUtil.loadCacheDatas(mrpid, "mds_productfamily", selstring, qfs);
                        object = null;
                        try {
                            if (coll != null) break block22;
                            break block23;
                        }
                        catch (Throwable srcData) {
                            object = srcData;
                            throw srcData;
                        }
                        finally {
                            if (coll != null) {
                                if (object != null) {
                                    try {
                                        coll.close();
                                    }
                                    catch (Throwable pid) {
                                        ((Throwable)object).addSuppressed(pid);
                                    }
                                } else {
                                    coll.close();
                                }
                            }
                        }
                    }
                    catch (Exception e) {
                        throw new KDBizException(e.getMessage());
                    }
                }
                while (true) {
                    if (!coll.hasNext()) {
                        return proMap;
                    }
                    Row srcData = coll.next();
                    Long pid = srcData.getLong("materielitem");
                    Long cid = srcData.getLong("materielpbom");
                    if (proMap.containsKey(cid)) {
                        List list = (List)proMap.get(cid);
                        if (list.contains(pid)) continue;
                        list.add(pid);
                        continue;
                    }
                    ArrayList<Long> list2 = new ArrayList<Long>();
                    list2.add(pid);
                    proMap.put(cid, list2);
                }
            }
        }
        DynamicObjectCollection proItem = QueryServiceHelper.query((String)"mds_productfamily", (String)selstring, (QFilter[])qfs);
        object = proItem.iterator();
        while (object.hasNext()) {
            DynamicObject item = (DynamicObject)object.next();
            Long pid = item.getLong("materielitem");
            Long cid = item.getLong("materielpbom");
            if (proMap.containsKey(cid)) {
                List list = (List)proMap.get(cid);
                if (list.contains(pid)) continue;
                list.add(pid);
                continue;
            }
            ArrayList<Long> list2 = new ArrayList<Long>();
            list2.add(pid);
            proMap.put(cid, list2);
        }
        return proMap;
    }

    public static String getExecfiledName(String exestr, String dfield) {
        if (exestr.indexOf(43) >= 0 || exestr.indexOf(45) >= 0 || exestr.indexOf(42) >= 0 || exestr.indexOf(47) >= 0) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("tmpexe");
            sBuilder.append(dfield);
            return sBuilder.toString();
        }
        return exestr;
    }

    public static Map<String, Set<Long>> getsetAllMatid(DynamicObject setoffset, Map<Long, Set<Long>> manumasterids) {
        HashMap<String, Set<Long>> maplst = new HashMap<String, Set<Long>>(20);
        try {
            DynamicObjectCollection sentrys = setoffset.getDynamicObjectCollection("entryentitys");
            for (DynamicObject sitem : sentrys) {
                if (sitem.getDynamicObject("salesetid") == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u9884\u6d4b\u51b2\u51cf\u5b9a\u4e49\u201d\u4e2d\u201c\u9700\u65b9\u53d6\u6570\u201d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u51b2\u51cf\u5b9a\u4e49", (String)"SetOffCommonUtil_3", (String)"mmc-mds-common", (Object[])new Object[0]));
                }
                Long billFieldId = sitem.getDynamicObject("salesetid").getLong("id");
                Set<Long> resset = new HashSet<Long>(10000);
                if (manumasterids != null) {
                    resset = manumasterids.get(sitem.getLong("id"));
                }
                maplst.putAll(SetOffCommonUtil.getTransferMatItem(billFieldId, resset));
            }
            DynamicObjectCollection sentryg = setoffset.getDynamicObjectCollection("entryentityg");
            for (DynamicObject gitem : sentryg) {
                if (gitem.getDynamicObject("providersetid") == null) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u201c\u9884\u6d4b\u51b2\u51cf\u5b9a\u4e49\u201d\u4e2d\u201c\u4f9b\u65b9\u53d6\u6570\u201d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u51b2\u51cf\u5b9a\u4e49", (String)"SetOffCommonUtil_12", (String)"mmc-mds-common", (Object[])new Object[0]));
                }
                Long billFieldId = gitem.getDynamicObject("providersetid").getLong("id");
                Set<Long> resgset = new HashSet<Long>(10000);
                if (manumasterids != null) {
                    resgset = manumasterids.get(gitem.getLong("id"));
                }
                maplst.putAll(SetOffCommonUtil.getTransferMatItem(billFieldId, resgset));
            }
        }
        catch (Exception e) {
            logger.warn(e.getMessage());
            throw new KDBizException(e.getMessage());
        }
        return maplst;
    }

    public static Map<String, Set<Long>> getTransferMatItem(Long billFieldId, Set<Long> manumasterids) {
        HashMap<String, Set<Long>> maplst = new HashMap<String, Set<Long>>(20);
        QFilter qfiltersor = new QFilter("id", "=", (Object)billFieldId);
        DynamicObject sourfield = QueryServiceHelper.queryOne((String)"mrp_resource_dataconf_rgt", (String)"id,billfieldtransfer", (QFilter[])new QFilter[]{qfiltersor});
        if (sourfield == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6570\u636e\u6e90\u914d\u7f6e\u53d6\u6570\u5931\u8d25\u3002", (String)"SetOffCommonUtil_4", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        QFilter qfilter = new QFilter("id", "=", (Object)sourfield.getLong("billfieldtransfer"));
        DynamicObjectCollection billfieldentry = QueryServiceHelper.query((String)"mrp_billfieldtransfer", (String)String.join((CharSequence)",", SetOffCommonUtil.getTransferSelectors()), (QFilter[])new QFilter[]{qfilter});
        if (billfieldentry.isEmpty()) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u53d6\u6570\u5931\u8d25\u3002", (String)"SetOffCommonUtil_5", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        boolean hasmat = false;
        for (DynamicObject fieldEntry : billfieldentry) {
            String contype = fieldEntry.getString("entryentity.converttype");
            if (!"materiel".equals(fieldEntry.getString("entryentity.destfieldflag"))) continue;
            hasmat = true;
            String matfield = "";
            String Entitykey = fieldEntry.getString("srcbill.id");
            matfield = "0".equals(contype) ? fieldEntry.getString("entryentity.sourcefieldflag") : fieldEntry.getString("entryentity.calculateexc");
            StringBuilder skey = new StringBuilder();
            skey.append(Entitykey);
            skey.append("@@@");
            skey.append(matfield);
            HashSet<Long> entityMatidlst = new HashSet<Long>();
            Set<Long> res = SetOffCommonUtil.getEntityMatidlst(Entitykey, matfield);
            if (manumasterids != null) {
                for (Long matid : manumasterids) {
                    if (!res.contains(matid)) continue;
                    entityMatidlst.add(matid);
                }
                maplst.put(skey.toString(), entityMatidlst);
                break;
            }
            maplst.put(skey.toString(), res);
            break;
        }
        if (!hasmat) {
            throw new KDBizException(ResManager.loadKDString((String)"\u5b9e\u4f53\u5b57\u6bb5\u6620\u5c04\u9700\u8981\u914d\u7f6e\u7269\u6599\u5b57\u6bb5\u7684\u6620\u5c04\u4fe1\u606f\u3002", (String)"SetOffCommonUtil_6", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
        return maplst;
    }

    private static String getTransferSelectors() {
        HashSet<String> selectors = new HashSet<String>();
        selectors.add("id");
        selectors.add("filter_tag");
        selectors.add("destbill.id");
        selectors.add("srcbill.id");
        selectors.add("entryentity.destfieldflag");
        selectors.add("entryentity.sourcefieldflag");
        selectors.add("entryentity.converttype");
        selectors.add("entryentity.calculateexc");
        selectors.add("entryentity.calculatetext");
        return String.join((CharSequence)",", selectors);
    }

    public static Set<Long> getEntityMatidlst(String Entitykey, String Matfield) {
        HashSet<Long> matidlst = new HashSet<Long>(10000);
        try (DataSet dSet = QueryServiceHelper.queryDataSet((String)"getEntityMatid", (String)Entitykey, (String)Matfield, null, null);){
            while (dSet.hasNext()) {
                Row row = dSet.next();
                matidlst.add(row.getLong(Matfield));
            }
        }
        catch (Exception e) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u67e5\u8be2\u7269\u6599\u5931\u8d25%s", (String)"SetOffCommonUtil_11", (String)"mmc-mds-common", (Object[])new Object[0]), e.getMessage()));
        }
        return matidlst;
    }

    public static void closelock(Long objid, String entityname) {
        MutexHelper.release((String)entityname, (String)"modify", (String)String.valueOf(objid));
    }

    public static boolean getlock(Long objid, String entityname) {
        MutexLockInfo info = new MutexLockInfo();
        info.setOperationKey("modify");
        info.setEntityNumber(entityname);
        info.setDataObjId(String.valueOf(objid));
        info.setStrict(true);
        StringBuilder msg = new StringBuilder();
        return MutexHelper.require((MutexLockInfo)info, (StringBuilder)msg);
    }

    public static Map<Long, MatinvInfo> getManustrategybyTrackid(Set<Long> trackids) {
        HashMap<Long, MatinvInfo> res = new HashMap<Long, MatinvInfo>(100);
        QFilter qFilter = new QFilter("id", "in", trackids);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"bd_tracknumber", (String)"id,manustrategy", (QFilter[])qFilter.toArray());
        HashSet<Long> manustr = new HashSet<Long>();
        for (DynamicObject item : query) {
            Long manuid = item.getLong("manustrategy");
            if (manuid == null || manuid <= 0L) continue;
            MatinvInfo clsmatinv = new MatinvInfo();
            clsmatinv.setManustrategyid(manuid);
            manustr.add(manuid);
            res.put(item.getLong("id"), clsmatinv);
        }
        QFilter qfilter2 = new QFilter("id", "in", manustr);
        DynamicObjectCollection manustrinfo = QueryServiceHelper.query((String)"bd_manustrategy", (String)"id,demandoffset", (QFilter[])qfilter2.toArray());
        for (DynamicObject obj : manustrinfo) {
            Long manuid = obj.getLong("id");
            String settypes = obj.getString("demandoffset");
            for (MatinvInfo item : res.values()) {
                if (item == null || !item.getManustrategyid().equals(manuid)) continue;
                item.setDemandoffset(settypes);
            }
        }
        return res;
    }

    public static List<MatinvInfo> getPolicyAndMatidLst(Set<Long> matidlst, List<MatinvInfo> invs) {
        QFilter qfilter = new QFilter("masterid", "in", matidlst);
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        qfilter.and(new QFilter("manustrategy", ">", (Object)0));
        DynamicObjectCollection hasmatlst = QueryServiceHelper.query((String)"bd_materialinventoryinfo", (String)"id,createorg,masterid,manustrategy", (QFilter[])new QFilter[]{qfilter});
        HashSet<Long> manustr = new HashSet<Long>();
        for (DynamicObject obj : hasmatlst) {
            Long matid = obj.getLong("masterid");
            Long Stockorg = obj.getLong("createorg");
            Long polid = obj.getLong("manustrategy");
            for (MatinvInfo invitem : invs) {
                if (!invitem.getMatid().equals(matid) || !invitem.getStockorgid().equals(Stockorg)) continue;
                invitem.setManustrategyid(polid);
                manustr.add(polid);
            }
        }
        QFilter qfilter2 = new QFilter("id", "in", manustr);
        DynamicObjectCollection manustrinfo = QueryServiceHelper.query((String)"bd_manustrategy", (String)"id,demandoffset", (QFilter[])qfilter2.toArray());
        for (DynamicObject obj : manustrinfo) {
            Long manuid = obj.getLong("id");
            String settypes = obj.getString("demandoffset");
            for (MatinvInfo item : invs) {
                if (!item.getManustrategyid().equals(manuid)) continue;
                item.setDemandoffset(settypes);
            }
        }
        return invs;
    }

    public static Map<Long, Long> getPlanMat(List<Long> allmats) {
        HashMap<Long, Long> res = new HashMap<Long, Long>();
        QFilter qfilter = new QFilter("masterid", "in", allmats);
        qfilter.and(new QFilter("status", "=", (Object)"C"));
        qfilter.and(new QFilter("enable", "=", (Object)"1"));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mpdm_materialplan", (String)"masterid,materialplan", (QFilter[])qfilter.toArray());
        for (DynamicObject item : query) {
            Long matid = item.getLong("masterid");
            Long planmatid = item.getLong("materialplan");
            if (planmatid == null || planmatid <= 0L) continue;
            res.put(matid, planmatid);
        }
        return res;
    }

    public static boolean getMatHasManustrategy(Long setid) {
        boolean res = true;
        QFilter qfilter = new QFilter("setid", "=", (Object)setid);
        qfilter.and(new QFilter("manustrategy", "=", (Object)0L));
        DynamicObjectCollection query = QueryServiceHelper.query((String)"mds_requestrecord", (String)"id", (QFilter[])qfilter.toArray());
        if (query != null && !query.isEmpty()) {
            res = false;
        }
        return res;
    }
}

