/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.setoff.fntask;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.ThreadLocals;
import kd.mmc.mds.common.setoff.FNSetoffExecUtil;
import kd.mmc.mds.common.setoff.SetOffCommonUtil;
import kd.mmc.mds.common.setoff.fntask.FNSetOffEvent;
import kd.mmc.mds.common.util.MDSJobCache;
import kd.mmc.mds.common.util.MDSUtils;
import kd.mpscmm.msplan.mservice.service.batchtask.BatchTask;

public class FNTask {
    private int totalL;
    private int baseperL;
    private int finishL;
    private int perL;
    private BatchTask task;
    private MDSJobCache cache;
    private DynamicObject setoffsetL;
    private DynamicObject setseqL;
    private Long setoffLogIdL;
    private Long toolIdL;
    private Long dataveridL;
    private int runcount;
    private Map<Long, Set<Long>> manumasteridsL;
    private boolean localmodel = true;
    private static final Log logger = LogFactory.getLog(FNTask.class);

    public int getRuncount() {
        return this.runcount;
    }

    final void setRuncount(int runcount) {
        this.runcount = runcount;
    }

    public boolean isLocalmodel() {
        return this.localmodel;
    }

    public FNTask(int per, int total, Long dataverid, DynamicObject setoffset, DynamicObject setseq, Long setoffLogId, Long toolId, Set<Long> orderidlst, Set<Long> mdsidlist, Map<Long, Set<Long>> manumasterids) {
        this.manumasteridsL = manumasterids;
        this.setoffLogIdL = setoffLogId;
        this.toolIdL = toolId;
        this.setoffsetL = setoffset;
        this.setseqL = setseq;
        this.perL = per;
        this.baseperL = FNTask.getBasePercent(setoffLogId);
        this.localmodel = "true".equals(MDSUtils.getMdsSysConfig("setofflocalmodel", "true"));
        try {
            int setcount = Integer.parseInt(MDSUtils.getMdsSysConfig("setoffsize", "500"));
            this.setRuncount(setcount);
        }
        catch (Exception e) {
            this.setRuncount(500);
        }
        this.totalL = total;
        this.finishL = 0;
        this.dataveridL = dataverid;
        this.task = BatchTask.create((String)"SetOffRun");
        this.task.setQueueName("kd.mmc.mds.framework.safestock.mds_queue");
        this.task.registBizClass(FNSetOffEvent.class);
        this.cache = new MDSJobCache("setoff" + setoffLogId);
        this.cache.put("perL", String.valueOf(this.perL));
        this.cache.put("totalL", String.valueOf(this.totalL));
        this.cache.put("finishL", "0");
        this.cache.put("baseperL", String.valueOf(this.baseperL));
    }

    public void FNTaskx(int per, int total, DynamicObject setoffset, DynamicObject setseq, Long setoffLogId, Long toolId, Set<Long> orderidlst, Set<Long> mdsidlist, Map<Long, Set<Long>> manumasterids) {
    }

    public String taskid() {
        return SetOffCommonUtil.getDateString();
    }

    public void setoff(List<Long> materialIds, Map<String, QFilter> matQFilter) {
        block8: {
            String execstat = SetOffCommonUtil.getExecStat(this.setoffLogIdL);
            if ("C".equals(execstat)) {
                return;
            }
            try {
                if (this.localmodel) {
                    FNSetoffExecUtil.setOffTask(this.setoffsetL, this.setseqL, this.dataveridL, this.toolIdL, materialIds, null, null, this.manumasteridsL, matQFilter);
                    break block8;
                }
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("setoffsetL", this.setoffsetL);
                params.put("setseqL", this.setseqL);
                params.put("setoffLogIdL", this.setoffLogIdL);
                params.put("dataveridL", this.dataveridL);
                params.put("toolIdL", this.toolIdL);
                params.put("manumasteridsL", this.manumasteridsL);
                params.put("materialIds", materialIds);
                params.put("matQFilter", matQFilter);
                this.task.addEvent(params);
                return;
            }
            catch (Exception e) {
                logger.info(e.getMessage());
                throw new KDBizException(e.getMessage());
            }
            finally {
                ThreadLocals.release();
            }
        }
        this.finishL += materialIds.size();
        Double per = this.perL;
        Double basePer = this.baseperL;
        Double finished = this.finishL;
        Double total = this.totalL;
        double tmpcount2 = finished / total;
        double tmpcount = basePer + per * tmpcount2;
        BigDecimal doublePre = BigDecimal.valueOf(tmpcount);
        int curPer = doublePre.setScale(0, 1).intValue();
        if (curPer > 100) {
            curPer = 100;
        }
        FNTask.updateSpeed(this.setoffLogIdL, curPer);
    }

    public void setoff(List<Long> materialIds) {
        this.setoff(materialIds, null);
    }

    public void waitForDone() {
        if (!this.localmodel && this.task != null) {
            try {
                logger.info("\u51b2\u51cfBatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u5f00\u59cb...");
                this.task.startTask();
                logger.info("\u51b2\u51cfBatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u8c03\u5ea6\u7ed3\u675f...");
            }
            catch (Exception e) {
                logger.error("\u51b2\u51cfBatchTask\u5206\u5e03\u5f0f\u8ba1\u7b97\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            finally {
                this.task.terminate();
            }
            try {
                if (this.cache != null) {
                    this.cache.remove("setoff" + this.setoffLogIdL);
                }
            }
            catch (Exception e) {
                logger.info("setoffcache\u91ca\u653e\u5931\u8d25\uff1a" + e.getMessage());
            }
        }
    }

    private static int getBasePercent(Long setoffLogId) {
        return (Integer)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"select fcalculatepro from t_mds_setofflog where fid=?", (Object[])new Object[]{setoffLogId}, rs -> {
            if (rs.next()) {
                return rs.getInt(1);
            }
            return 0;
        });
    }

    public static void updateSpeed(Long setoffLogId, int curPer) {
        DB.update((DBRoute)DBRoute.of((String)"scm"), (String)"update t_mds_setofflog set fcalculatepro=? where fid=?", (Object[])new Object[]{curPer, setoffLogId});
    }
}

