/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.stockup.task;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeCacheHAPolicy;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.cache.TempFileCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.control.UrlUtil;
import kd.bos.impt.ExcelReader;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.ExceptionUtils;
import kd.bos.util.StringUtils;
import kd.mmc.mds.common.export.ExportHelper;
import kd.mmc.mds.common.stockup.util.StockUpRecorder;
import org.apache.commons.collections4.MapUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class StockUpStatusImportTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(StockUpStatusImportTask.class);
    private static final DistributeSessionlessCache redisCache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("", new DistributeCacheHAPolicy(true, true));
    private static final List<String> ID_FIELDS = new ArrayList<String>(16);
    private static final List<String> EDIT_FIELDS = new ArrayList<String>(16);
    private Map<String, Integer> keyRelIndex = new HashMap<String, Integer>(16);
    private Map<String, Object> result = new HashMap<String, Object>(16);
    private int total = 0;
    private int successSize = 0;

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        try {
            this.doExecute(context, params);
        }
        catch (Exception e) {
            this.result.put("failed", ResManager.loadKDString((String)"\u64cd\u4f5c\u5931\u8d25\uff0c\u8be6\u60c5\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u67e5\u770b\u65e5\u5fd7\u3002", (String)"ProbabilityTask_0", (String)"mmc-mds-common", (Object[])new Object[0]));
            this.feedbackCustomdata(this.result);
            String msg = ExceptionUtils.getExceptionStackTraceMessage((Exception)e);
            logger.error(msg);
        }
    }

    private void doExecute(RequestContext context, Map<String, Object> params) throws Exception {
        block19: {
            this.feedbackProgress(0, ResManager.loadKDString((String)"\u89e3\u6790\u5b8c\u6210\uff0c\u8bf7\u7a0d\u5019\u3002", (String)"StockUpStatusImportTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            String url = String.valueOf(params.get("import_url"));
            FileService service = FileServiceFactory.getAttachmentFileService();
            try (InputStream in = service.getInputStream(url);){
                final LinkedList<Map<Integer, String>> sheet = new LinkedList<Map<Integer, String>>();
                final HashMap<Integer, String> keyRow = new HashMap<Integer, String>(16);
                new ExcelReader().read(in, new SheetHandler(){

                    public void handleRow(SheetHandler.ParsedRow row) {
                        if (row.getData().values().stream().anyMatch(StringUtils::isNotEmpty)) {
                            sheet.add(row.getData());
                            if (row.getRowNum() == 1) {
                                keyRow.putAll(row.getData());
                            }
                        }
                    }
                });
                this.keyRelIndex = this.getKeyRelIndex(keyRow);
                StringBuilder msg = new StringBuilder();
                if (this.validation(sheet, msg)) {
                    List<Map<Integer, String>> err = this.doImport(sheet);
                    if (err.size() > 0) {
                        String tempUrl = this.buildErrExcel(err, sheet);
                        this.result.put("success", false);
                        this.result.put("failed_url", tempUrl);
                        String showMsg = ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f%1$d\u884c\uff0c\u5931\u8d25%2$d\u884c\uff0c\u70b9\u51fb\u786e\u8ba4\u5bfc\u51faExcel\u9519\u8bef\u6570\u636e\u3002", (String)"StockUpStatusImportTask_11", (String)"mmc-mds-common", (Object[])new Object[0]);
                        this.result.put("import_msg", String.format(showMsg, this.successSize, this.total - this.successSize));
                        this.feedbackCustomdata(this.result);
                        return;
                    }
                    break block19;
                }
                this.result.put("success", false);
                this.result.put("import_msg", msg.toString());
                this.feedbackCustomdata(this.result);
                return;
            }
        }
        this.result.put("success", true);
        this.result.put("import_msg", ResManager.loadKDString((String)"\u5bfc\u5165\u6210\u529f\u3002", (String)"StockUpStatusImportTask_8", (String)"mmc-mds-common", (Object[])new Object[0]));
        this.feedbackCustomdata(this.result);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String buildErrExcel(List<Map<Integer, String>> err, List<Map<Integer, String>> data) {
        String string;
        ByteArrayInputStream inStream;
        SXSSFWorkbook wb;
        block26: {
            ByteArrayOutputStream byteArrayOutputStream2;
            int i;
            int[] widthArr = new int[data.get(1).size() + 1];
            wb = new SXSSFWorkbook();
            DataFormat dataFormat = wb.createDataFormat();
            CellStyle textStyle = wb.createCellStyle();
            textStyle.setDataFormat(dataFormat.getFormat("@"));
            CellStyle style4Title = wb.createCellStyle();
            style4Title.setDataFormat(dataFormat.getFormat("@"));
            style4Title.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
            style4Title.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            CellStyle style4Err = wb.createCellStyle();
            style4Err.setDataFormat(dataFormat.getFormat("@"));
            Font font = wb.createFont();
            font.setColor((short)10);
            style4Err.setFont(font);
            Sheet sheet = wb.createSheet();
            for (i = 0; i < 3; ++i) {
                Row row = sheet.createRow(i);
                Map<Integer, String> map = data.get(i);
                for (Map.Entry<Integer, String> entry : map.entrySet()) {
                    int n = entry.getKey() + 1;
                    String v = entry.getValue();
                    Cell cell = row.createCell(n);
                    if (i > 0) {
                        cell.setCellStyle(style4Title);
                    }
                    cell.setCellValue(entry.getValue());
                    int defColWidth = widthArr[n];
                    widthArr[n] = ExportHelper.calcColumnWidth(v, defColWidth);
                }
            }
            for (Map map : err) {
                Row row = sheet.createRow(i);
                for (Map.Entry entry : map.entrySet()) {
                    int index = (Integer)entry.getKey() + 1;
                    String v = (String)entry.getValue();
                    Cell cell = row.createCell(index);
                    cell.setCellValue((String)entry.getValue());
                    int defColWidth = widthArr[index];
                    widthArr[index] = ExportHelper.calcColumnWidth(v, defColWidth);
                    if (index == 0) {
                        cell.setCellStyle(style4Err);
                        continue;
                    }
                    cell.setCellStyle(textStyle);
                }
                ++i;
            }
            for (int j = 0; j < widthArr.length; ++j) {
                sheet.setColumnWidth(j, widthArr[j]);
            }
            CellRangeAddress cellRangeAddress = new CellRangeAddress(0, 0, 1, data.get(0).size());
            sheet.addMergedRegion(cellRangeAddress);
            ByteArrayOutputStream byteArrayOutputStream = null;
            inStream = null;
            String string2 = "";
            try {
                byteArrayOutputStream2 = new ByteArrayOutputStream();
                wb.write((OutputStream)byteArrayOutputStream2);
                inStream = new ByteArrayInputStream(byteArrayOutputStream2.toByteArray());
                TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
                int timeout = 7200;
                SimpleDateFormat sdf = new SimpleDateFormat("MMddHHmmss");
                StringBuilder fileName = new StringBuilder();
                fileName.append(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25_\u5907\u8d27\u72b6\u6001\u786e\u8ba4_", (String)"StockUpStatusImportTask_9", (String)"mmc-mds-common", (Object[])new Object[0]));
                fileName.append(sdf.format(new Date()));
                fileName.append(".xlsx");
                string = tempFileCache.saveAsUrl(fileName.toString(), (InputStream)inStream, timeout);
                String tempFileId = UrlUtil.getParam((String)string, (String)"id");
                HashMap<String, String> refEntitiyMap = new HashMap<String, String>(2);
                refEntitiyMap.put("entityNum", "mds_stockupstatus_rpt");
                refEntitiyMap.put("appId", "mds");
                refEntitiyMap.put("permissionItemId", "4730fc9f000003ae");
                redisCache.put("TempFileCheckId:" + tempFileId, (Object)SerializationUtils.toJsonString(refEntitiyMap), 7200);
                if (byteArrayOutputStream2 == null) break block26;
            }
            catch (IOException iOException) {
                try {
                    throw new KDBizException(iOException.getMessage());
                }
                catch (Throwable throwable) {
                    if (byteArrayOutputStream != null) {
                        try {
                            byteArrayOutputStream.close();
                        }
                        catch (IOException e) {
                            logger.error((Throwable)e);
                        }
                    }
                    if (inStream != null) {
                        try {
                            inStream.close();
                        }
                        catch (IOException e) {
                            logger.error((Throwable)e);
                        }
                    }
                    try {
                        wb.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        logger.error((Throwable)e);
                    }
                    throw throwable;
                }
            }
            try {
                byteArrayOutputStream2.close();
            }
            catch (IOException iOException) {
                logger.error((Throwable)iOException);
            }
        }
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException iOException) {
                logger.error((Throwable)iOException);
            }
        }
        try {
            wb.close();
            return string;
        }
        catch (IOException iOException) {
            logger.error((Throwable)iOException);
            return string;
        }
    }

    private boolean validation(List<Map<Integer, String>> sheet, StringBuilder msg) {
        String errMsg = null;
        if (sheet.size() <= 3) {
            errMsg = ResManager.loadKDString((String)"\u672a\u8bc6\u522b\u5230\u5185\u5bb9\uff0c\u8bf7\u4f7f\u7528\u5bfc\u51fa\u6587\u4ef6\u7528\u4e8e\u5bfc\u5165\u3002", (String)"StockUpStatusImportTask_1", (String)"mmc-mds-common", (Object[])new Object[0]);
            msg.append(errMsg);
            return false;
        }
        for (String idField : ID_FIELDS) {
            if (this.keyRelIndex.containsKey(idField)) continue;
            errMsg = ResManager.loadKDString((String)"\u6807\u8bc6\u5b57\u6bb5\u7f3a\u5931\uff0c\u8bf7\u4f7f\u7528\u5bfc\u51fa\u6587\u4ef6\u7528\u4e8e\u5bfc\u5165\u3002", (String)"StockUpStatusImportTask_2", (String)"mmc-mds-common", (Object[])new Object[0]);
            msg.append(errMsg);
            return false;
        }
        for (String editField : EDIT_FIELDS) {
            int i = 0;
            if (this.keyRelIndex.containsKey(editField)) {
                ++i;
            }
            if (i != 0) continue;
            errMsg = ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u9700\u8981\u4fee\u6539\u7684\u5b57\u6bb5\u3002", (String)"StockUpStatusImportTask_3", (String)"mmc-mds-common", (Object[])new Object[0]);
            msg.append(errMsg);
            return false;
        }
        return true;
    }

    private List<Map<Integer, String>> doImport(List<Map<Integer, String>> sheet) {
        LinkedList<Map<Integer, String>> errSheet = new LinkedList<Map<Integer, String>>();
        this.total = sheet.size() > 3 ? sheet.size() - 3 : 1;
        int curIndex = 0;
        this.successSize = 0;
        for (int i = 3; i < sheet.size(); ++i) {
            String showMsg = ResManager.loadKDString((String)"\u6b63\u5728\u5bfc\u5165\u7b2c%1$d\u884c\uff0c\u603b\u5171%2$d\u884c...", (String)"StockUpStatusImportTask_10", (String)"mmc-mds-common", (Object[])new Object[0]);
            this.feedbackProgress(curIndex * 100 / this.total, String.format(showMsg, ++curIndex, this.total), null);
            LinkedList<String> errMsg = new LinkedList<String>();
            Map<Integer, String> row = sheet.get(i);
            String planidStr = MapUtils.getString(row, (Object)this.keyRelIndex.get("planid"), (String)"0");
            String projectidStr = MapUtils.getString(row, (Object)this.keyRelIndex.get("projectid"), (String)"0");
            long planid = 0L;
            long projectid = 0L;
            try {
                planid = Long.parseLong(planidStr);
                projectid = Long.parseLong(projectidStr);
            }
            catch (NumberFormatException e) {
                String msg = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636eID'%1$s',\u9879\u76eeID'%2$s'\u4e0d\u5b58\u5728\uff0c\u8bf7\u4f7f\u7528\u5bfc\u51fa\u6587\u4ef6\u7528\u4e8e\u5bfc\u5165\u3002", (String)"StockUpStatusImportTask_13", (String)"mmc-mds-common", (Object[])new Object[0]);
                errMsg.add(String.format(msg, planidStr, projectidStr));
            }
            if (errMsg.size() == 0) {
                for (String editField : EDIT_FIELDS) {
                    String v = row.get(this.keyRelIndex.get(editField));
                    if (StringUtils.isEmpty((String)v)) continue;
                    long id = this.getBasedataId(editField, v);
                    if (id == 0L) {
                        String fieldName = this.getFieldName(editField);
                        String msg = ResManager.loadKDString((String)"'%1$s'\u7f16\u7801'%2$s'\u5bfc\u5165\u4e0d\u6210\u529f\u3002\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1a1\u3001\u7f16\u7801\u4e0d\u6b63\u786e\uff1b2\u3001\u4e0d\u7b26\u5408\u57fa\u7840\u8d44\u6599\u5b57\u6bb5\u67e5\u8be2\u6761\u4ef6\uff1b", (String)"StockUpStatusImportTask_7", (String)"mmc-mds-common", (Object[])new Object[0]);
                        errMsg.add(String.format(msg, fieldName, v));
                        continue;
                    }
                    if (StockUpRecorder.updateRecord(planid, projectid, this.getRecordName(editField), id)) continue;
                    String msg = ResManager.loadKDString((String)"\u6765\u6e90\u5355\u636eID'%1$d',\u9879\u76eeID'%2$d'\u4e0d\u5b58\u5728\uff0c\u8bf7\u4f7f\u7528\u5bfc\u51fa\u6587\u4ef6\u7528\u4e8e\u5bfc\u5165\u3002", (String)"StockUpStatusImportTask_12", (String)"mmc-mds-common", (Object[])new Object[0]);
                    errMsg.add(String.format(msg, planid, projectid));
                }
            }
            if (errMsg.size() > 0) {
                row.put(-1, String.join((CharSequence)",", errMsg));
                errSheet.add(row);
                continue;
            }
            ++this.successSize;
        }
        return errSheet;
    }

    private String getRecordName(String editField) {
        String fieldName = "cabinconfig";
        if ("cabinconfignumber".equalsIgnoreCase(editField)) {
            fieldName = "cabinconfig";
        } else if ("polarisstatusnumber".equalsIgnoreCase(editField)) {
            fieldName = "polarisstatus";
        }
        return fieldName;
    }

    private String getFieldName(String editField) {
        String fieldName = ResManager.loadKDString((String)"\u7269\u6599\u7f16\u7801", (String)"StockUpStatusImportTask_4", (String)"mmc-mds-common", (Object[])new Object[0]);
        if ("cabinconfignumber".equalsIgnoreCase(editField)) {
            fieldName = ResManager.loadKDString((String)"\u5ba2\u8231\u6539\u88c5\u72b6\u6001\u7f16\u7801", (String)"StockUpStatusImportTask_5", (String)"mmc-mds-common", (Object[])new Object[0]);
        } else if ("polarisstatusnumber".equalsIgnoreCase(editField)) {
            fieldName = ResManager.loadKDString((String)"\u5ba2\u8231\u6784\u578b\u7f16\u7801", (String)"StockUpStatusImportTask_6", (String)"mmc-mds-common", (Object[])new Object[0]);
        }
        return fieldName;
    }

    private long getBasedataId(String editField, String v) {
        long id = 0L;
        String entityName = "bd_material";
        if ("cabinconfignumber".equalsIgnoreCase(editField)) {
            entityName = "mpdm_cabinconfig";
        } else if ("polarisstatusnumber".equalsIgnoreCase(editField)) {
            entityName = "mds_polarisstatus";
        }
        QFilter filter = new QFilter("number", "=", (Object)v);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        DynamicObject basedata = BusinessDataServiceHelper.loadSingleFromCache((String)entityName, (String)"id", (QFilter[])new QFilter[]{filter});
        if (basedata != null) {
            id = basedata.getLong("id");
        }
        return id;
    }

    private Map<String, Integer> getKeyRelIndex(Map<Integer, String> keyRow) {
        HashMap<String, Integer> keyRelIndex = new HashMap<String, Integer>(16);
        for (Map.Entry<Integer, String> entry : keyRow.entrySet()) {
            if (ID_FIELDS.contains(entry.getValue())) {
                keyRelIndex.put(entry.getValue(), entry.getKey());
                continue;
            }
            if (!EDIT_FIELDS.contains(entry.getValue())) continue;
            keyRelIndex.put(entry.getValue(), entry.getKey());
        }
        return keyRelIndex;
    }

    static {
        ID_FIELDS.add("planid");
        ID_FIELDS.add("projectid");
        EDIT_FIELDS.add("cabinconfignumber");
        EDIT_FIELDS.add("polarisstatusnumber");
    }
}

