/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.stockup.task;

import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.mmc.mds.common.algorithm.db.DataSetSaver;
import kd.mmc.mds.common.datafetch.DataFetchUtil;
import kd.mmc.mds.common.stockup.util.StockUpStatusHelper;
import kd.mmc.mds.common.stockup.util.StockUpUtil;

public class StockUpStatusTask
extends AbstractTask {
    private static final Log logger = LogFactory.getLog(StockUpStatusTask.class);

    public void execute(RequestContext context, Map<String, Object> params) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u83b7\u53d6\u5907\u8d27\u65b9\u6848", (String)"StockUpStatusTask_1", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        Object idObj = params.get("stockupscheme.id");
        long schemeId = this.getSchemeId(idObj);
        DynamicObject scheme = StockUpUtil.getStockUpScheme(schemeId);
        if (scheme == null) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u5907\u8d27\u65b9\u6848\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"StockUpStatusTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        this.feedbackProgress(10, ResManager.loadKDString((String)"\u5907\u8d27\u65b9\u6848\u5b9a\u4e49\u52a0\u8f7d\u5b8c\u6bd5\u3002", (String)"StockUpStatusTask_2", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        long datafetchsetId = scheme.getLong("datafetchset.id");
        String targetEntityName = DataFetchUtil.getTargetEntityName(datafetchsetId);
        if (!this.supportEntity(targetEntityName)) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u5907\u8d27\u65b9\u6848\u5b9a\u4e49\u76ee\u6807\u5b9e\u4f53\u6709\u8bef\u3002", (String)"StockUpStatusTask_6", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            return;
        }
        this.feedbackProgress(15, ResManager.loadKDString((String)"\u6839\u636e\u53d6\u6570\u65b9\u6848\u52a0\u8f7d\u6570\u636e", (String)"StockUpStatusTask_3", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        DataSet dataSet = DataFetchUtil.fetchDataBySetId(datafetchsetId);
        this.feedbackProgress(50, ResManager.loadKDString((String)"\u6570\u636e\u52a0\u8f7d\u5b8c\u6210\uff0c\u5f00\u59cb\u751f\u6210\u5907\u8d27\u6e05\u5355\u3002", (String)"StockUpStatusTask_4", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        dataSet = StockUpStatusHelper.addToDBField(dataSet, schemeId);
        DataSetSaver saver = new DataSetSaver("mds_stockupstatus");
        saver.init();
        saver.save(dataSet);
        this.feedbackProgress(100, ResManager.loadKDString((String)"\u5907\u8d27\u6e05\u5355\u751f\u6210\u6210\u529f\u3002", (String)"StockUpStatusTask_5", (String)"mmc-mds-common", (Object[])new Object[0]), null);
    }

    private boolean supportEntity(String targetEntityName) {
        return "mds_stockupstatus".equals(targetEntityName);
    }

    private long getSchemeId(Object idObj) {
        long schemeId = 0L;
        if (idObj == null) {
            this.feedbackProgress(100, ResManager.loadKDString((String)"\u5907\u8d27\u65b9\u6848\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"StockUpStatusTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
        } else if (idObj instanceof String) {
            try {
                schemeId = Long.parseLong((String)idObj);
            }
            catch (Exception e) {
                String msg = e.getMessage();
                logger.error(msg);
                this.feedbackProgress(100, ResManager.loadKDString((String)"\u5907\u8d27\u65b9\u6848\u5b9a\u4e49\u4e0d\u5b58\u5728\u3002", (String)"StockUpStatusTask_0", (String)"mmc-mds-common", (Object[])new Object[0]), null);
            }
        } else if (idObj instanceof Long) {
            schemeId = (Long)idObj;
        }
        return schemeId;
    }
}

