/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.stockup.util;

import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.stockup.model.StockUpRangeEntry;

public class StockUpRangeHelper {
    public static List<StockUpRangeEntry> getRangeData(String rangeType) {
        List<Object> entries = null;
        QFilter commonFilter = new QFilter("status", "=", (Object)"C");
        commonFilter.and("enable", "=", (Object)"1");
        if ("backupbom".equalsIgnoreCase(rangeType)) {
            QFilter typeQFilter = new QFilter("provisionmode", "in", (Object)new String[]{"0", "3"});
            DynamicObject[] range = BusinessDataServiceHelper.load((String)"mds_stockrangedef", (String)"entryentity.isuse,entryentity.customer,entryentity.mrtype,entryentity.checktype,entryentity.cabinconfig,entryentity.schdstatus", (QFilter[])new QFilter[]{commonFilter, typeQFilter}, (String)"");
            entries = StockUpRangeHelper.buildStockUpRangeEntry(range);
        } else if ("backuphis".equalsIgnoreCase(rangeType)) {
            QFilter typeQFilter = new QFilter("provisionmode", "in", (Object)new String[]{"1", "3"});
            DynamicObject[] range = BusinessDataServiceHelper.load((String)"mds_stockrangedef", (String)"entryentity.isuse,entryentity.customer,entryentity.mrtype,entryentity.checktype,entryentity.cabinconfig,entryentity.schdstatus", (QFilter[])new QFilter[]{commonFilter, typeQFilter}, (String)"");
            entries = StockUpRangeHelper.buildStockUpRangeEntry(range);
        } else if ("backupcustmor".equalsIgnoreCase(rangeType)) {
            QFilter typeQFilter = new QFilter("provisionmode", "in", (Object)new String[]{"2", "3"});
            DynamicObject[] range = BusinessDataServiceHelper.load((String)"mds_stockrangedef", (String)"entryentity.isuse,entryentity.customer,entryentity.mrtype,entryentity.checktype,entryentity.cabinconfig,entryentity.schdstatus", (QFilter[])new QFilter[]{commonFilter, typeQFilter}, (String)"");
            entries = StockUpRangeHelper.buildStockUpRangeEntry(range);
        }
        if (entries == null) {
            entries = new LinkedList();
        }
        return entries;
    }

    private static List<StockUpRangeEntry> buildStockUpRangeEntry(DynamicObject[] range) {
        LinkedList<StockUpRangeEntry> list = new LinkedList<StockUpRangeEntry>();
        if (range != null && range.length > 0) {
            for (DynamicObject item : range) {
                DynamicObjectCollection entryentity = item.getDynamicObjectCollection("entryentity");
                if (entryentity == null || entryentity.size() <= 0) continue;
                for (DynamicObject dynamicObject : entryentity) {
                    if (!dynamicObject.getBoolean("isuse")) continue;
                    StockUpRangeEntry entry = new StockUpRangeEntry();
                    entry.setCustomIds(dynamicObject.getDynamicObjectCollection("customer").stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
                    LinkedList<Long> mrtypeIds = new LinkedList<Long>();
                    long mrtype = dynamicObject.getLong("mrtype.id");
                    if (mrtype != 0L) {
                        mrtypeIds.add(mrtype);
                    }
                    entry.setMrTypeIds(mrtypeIds);
                    entry.setCheckTypeIds(dynamicObject.getDynamicObjectCollection("checktype").stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
                    entry.setCabinConfigIds(dynamicObject.getDynamicObjectCollection("cabinconfig").stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
                    entry.setSchdStatusIds(dynamicObject.getDynamicObjectCollection("schdstatus").stream().map(o -> o.getLong("fbasedataid.id")).collect(Collectors.toList()));
                    list.add(entry);
                }
            }
        }
        return list;
    }

    public static String buildRangeWhereExpr(StockUpRangeEntry stockUpRangeEntry, List<String[]> matchList) {
        LinkedList<String> exprList = new LinkedList<String>();
        for (String[] match : matchList) {
            String expr = StockUpRangeHelper.buildExpr(match, stockUpRangeEntry);
            if (!StringUtils.isNotEmpty((CharSequence)expr)) continue;
            exprList.add(expr);
        }
        return String.join((CharSequence)" and ", exprList);
    }

    private static String buildExpr(String[] match, StockUpRangeEntry stockUpRangeEntry) {
        String field = match[0];
        String rangField = match[1];
        List<Long> ids = null;
        if ("customer".equalsIgnoreCase(rangField)) {
            ids = stockUpRangeEntry.getCustomIds();
        }
        if ("mrtype".equalsIgnoreCase(rangField)) {
            ids = stockUpRangeEntry.getMrTypeIds();
        }
        if ("checktype".equalsIgnoreCase(rangField)) {
            ids = stockUpRangeEntry.getCheckTypeIds();
        }
        if ("cabinconfig".equalsIgnoreCase(rangField)) {
            ids = stockUpRangeEntry.getCabinConfigIds();
        }
        if ("schdstatus".equalsIgnoreCase(rangField)) {
            ids = stockUpRangeEntry.getSchdStatusIds();
        }
        if (ids != null && ids.size() > 0) {
            return String.format(" %s in (%s) ", field, ids.stream().map(String::valueOf).collect(Collectors.joining(",")));
        }
        return null;
    }
}

