/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.stockup.util;

import java.util.Date;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.util.StringUtils;

public class StockUpRecorder {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean updateRecord(long planId, long projectId, String field, Object value) {
        String selectField = "%s,modifier,modifytime";
        String key = String.join((CharSequence)"#", String.valueOf(planId), String.valueOf(projectId));
        DLock lock = DLock.create((String)key, (String)"StockUpRecorder_update");
        lock.lock();
        try {
            QFilter filter = new QFilter("planid", "=", (Object)planId);
            filter.and("projectid", "=", (Object)projectId);
            DynamicObject stockuprecord = BusinessDataServiceHelper.loadSingle((String)"mds_stockuprecord", (String)String.format(selectField, field), (QFilter[])new QFilter[]{filter});
            if (stockuprecord == null) {
                boolean bl = false;
                return bl;
            }
            Object old = stockuprecord.get(field);
            if (old != null && old.equals(value)) {
                boolean bl = true;
                return bl;
            }
            stockuprecord.set(field, value);
            stockuprecord.set("modifier", (Object)RequestContext.get().getCurrUserId());
            stockuprecord.set("modifytime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stockuprecord});
        }
        finally {
            lock.unlock();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void initUpdateRecord(DataSet dataSet) {
        DLock lock = DLock.create((String)"mds_StockUpStatus_initUpdateRecord", (String)"StockUpRecorder_initupdate");
        lock.lock();
        try {
            RowMeta rowMeta = dataSet.getRowMeta();
            for (Row row : dataSet) {
                long planId = 0L;
                long projectId = 0L;
                Object srcbill = null;
                Object plancode = null;
                if (rowMeta.getField("planid", false) == null) continue;
                planId = row.getLong("planid");
                if (rowMeta.getField("projectid", false) == null) continue;
                projectId = row.getLong("projectid");
                if (rowMeta.getField("sourcebilltype", false) != null) {
                    srcbill = row.get("sourcebilltype");
                }
                if (rowMeta.getField("plancode", false) != null) {
                    plancode = row.get("plancode");
                }
                String selectField = "id,modifier,modifytime,%s,%s";
                String key = String.join((CharSequence)"#", String.valueOf(planId), String.valueOf(projectId));
                QFilter filter = new QFilter("planid", "=", (Object)planId);
                filter.and("projectid", "=", (Object)projectId);
                DynamicObject stockuprecord = StockUpRecorder.getRecord("mds_stockuprecord", String.format(selectField, "sourcebilltype", "plancode"), filter);
                if (stockuprecord != null) continue;
                stockuprecord = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"mds_stockuprecord"));
                stockuprecord.set("planid", (Object)planId);
                stockuprecord.set("projectid", (Object)projectId);
                stockuprecord.set("creator", (Object)RequestContext.get().getCurrUserId());
                stockuprecord.set("createtime", (Object)new Date());
                stockuprecord.set("queryindex", (Object)key);
                stockuprecord.set("billstatus", (Object)"A");
                if (srcbill != null) {
                    stockuprecord.set("sourcebilltype", srcbill);
                }
                if (plancode != null) {
                    stockuprecord.set("plancode", plancode);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{stockuprecord});
            }
        }
        finally {
            lock.unlock();
        }
    }

    public static void addAdjustRecord(String field, DynamicObject beforeAdjstus, DynamicObject afterAdjstus, String adjustReason, long planId, long projectId) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"mds_adjustrecord");
        obj.set("field", (Object)field);
        obj.set("beforeadjstus", (Object)beforeAdjstus);
        obj.set("afteradjstus", (Object)afterAdjstus);
        obj.set("adjustreason", (Object)adjustReason);
        obj.set("planid", (Object)planId);
        obj.set("projectid", (Object)projectId);
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        obj.set("createtime", (Object)new Date());
        obj.set("billstatus", (Object)"A");
        obj.set("issystem", (Object)false);
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateAdjustRecord(String field, Map<String, Long> updateMap) {
        DLock lock = DLock.create((String)"AdjustRecord_update", (String)"AdjustRecord_update");
        lock.lock();
        try {
            for (Map.Entry<String, Long> entry : updateMap.entrySet()) {
                String key = entry.getKey();
                if (StringUtils.isEmpty((String)key)) continue;
                String[] idArr = key.split("#");
                Long planId = Long.parseLong(idArr[0]);
                Long projectId = Long.parseLong(idArr[1]);
                QFilter filter = new QFilter("planid", "=", (Object)planId);
                filter.and("projectid", "=", (Object)projectId);
                filter.and("field", "=", (Object)field);
                filter.and("issystem", "=", (Object)true);
                DynamicObject adjustRecord = StockUpRecorder.getRecord("mds_adjustrecord", "id,afteradjstus,createtime", filter);
                if (adjustRecord == null) {
                    adjustRecord = new DynamicObject((DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"mds_adjustrecord"));
                    adjustRecord.set("field", (Object)field);
                    adjustRecord.set("beforeadjstus", null);
                    adjustRecord.set("adjustreason", (Object)ResManager.loadKDString((String)"\u7cfb\u7edf\u8ba1\u7b97\u751f\u6210", (String)"StockUpRecorder_0", (String)"mmc-mds-common", (Object[])new Object[0]));
                    adjustRecord.set("planid", (Object)planId);
                    adjustRecord.set("projectid", (Object)projectId);
                    adjustRecord.set("creator", (Object)1L);
                    adjustRecord.set("billstatus", (Object)"A");
                    adjustRecord.set("issystem", (Object)true);
                }
                adjustRecord.set("afteradjstus", (Object)entry.getValue());
                adjustRecord.set("createtime", (Object)new Date());
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{adjustRecord});
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static DynamicObject getRecord(String entityName, String select, QFilter filter) {
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)select, (QFilter[])new QFilter[]{filter});
    }
}

