/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.stockup.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.probability.util.ProbabilityUtil;
import kd.mmc.mds.common.stockup.model.StockUpRuleEntry;

public class StockUpRuleHelper {
    private static final String MDS_STOCKSTATUSRULE = "mds_stockstatusrule";
    private static final String MDS_STOCKUPSTATUS = "mds_stockupstatus";

    public static List<StockUpRuleEntry> getRuleData(String ruleType) {
        List<Object> entries = null;
        QFilter commonFilter = new QFilter("status", "=", (Object)"C");
        commonFilter.and("enable", "=", (Object)"1");
        if ("backupbom".equalsIgnoreCase(ruleType)) {
            QFilter targetStatusQFilter = new QFilter("targetstatus", "=", (Object)"0");
            DynamicObject[] rule = BusinessDataServiceHelper.load((String)MDS_STOCKSTATUSRULE, (String)"targetstatus,entryentity.seq,entryentity.stockstatus,entryentity.matchelement,entryentity.filterconditionval,entryentity.allowadjust,entryentity.adjustrange", (QFilter[])new QFilter[]{commonFilter, targetStatusQFilter}, (String)"");
            entries = StockUpRuleHelper.buildStockUpRuleEntry(rule);
        } else if ("backuphis".equalsIgnoreCase(ruleType)) {
            QFilter targetStatusQFilter = new QFilter("targetstatus", "=", (Object)"1");
            DynamicObject[] rule = BusinessDataServiceHelper.load((String)MDS_STOCKSTATUSRULE, (String)"targetstatus,entryentity.seq,entryentity.stockstatus,entryentity.matchelement,entryentity.filterconditionval,entryentity.allowadjust,entryentity.adjustrange", (QFilter[])new QFilter[]{commonFilter, targetStatusQFilter}, (String)"");
            entries = StockUpRuleHelper.buildStockUpRuleEntry(rule);
        } else if ("backupcustmor".equalsIgnoreCase(ruleType)) {
            QFilter targetStatusQFilter = new QFilter("targetstatus", "=", (Object)"2");
            DynamicObject[] rule = BusinessDataServiceHelper.load((String)MDS_STOCKSTATUSRULE, (String)"targetstatus,entryentity.seq,entryentity.stockstatus,entryentity.matchelement,entryentity.filterconditionval,entryentity.allowadjust,entryentity.adjustrange", (QFilter[])new QFilter[]{commonFilter, targetStatusQFilter}, (String)"");
            entries = StockUpRuleHelper.buildStockUpRuleEntry(rule);
        }
        if (entries == null) {
            entries = new LinkedList();
        }
        return entries;
    }

    private static List<StockUpRuleEntry> buildStockUpRuleEntry(DynamicObject[] range) {
        ArrayList<StockUpRuleEntry> list = new ArrayList<StockUpRuleEntry>(16);
        if (range != null && range.length > 0) {
            for (DynamicObject item : range) {
                DynamicObjectCollection entryentity = item.getDynamicObjectCollection("entryentity");
                if (entryentity == null || entryentity.size() <= 0) continue;
                for (DynamicObject dynamicObject : entryentity) {
                    StockUpRuleEntry entry = new StockUpRuleEntry();
                    Integer seq = dynamicObject.getInt("seq");
                    entry.setLevel(seq);
                    entry.setStockStatus(dynamicObject.getLong("stockstatus.id"));
                    String matchElementVal = dynamicObject.getString("matchelement");
                    entry.setMatch(StockUpRuleHelper.getMatchData(matchElementVal));
                    String filterConditionVal = dynamicObject.getString("filterconditionval");
                    if (StringUtils.isNotEmpty((CharSequence)filterConditionVal)) {
                        FilterBuilder filterBuilder = ProbabilityUtil.getFilterBuilder(filterConditionVal, MDS_STOCKUPSTATUS);
                        entry.setFilterCondition(filterBuilder.getQFilter());
                    }
                    Boolean allowAdjust = dynamicObject.getBoolean("allowadjust");
                    entry.setAllowAdjust(allowAdjust);
                    DynamicObjectCollection adjustRange = dynamicObject.getDynamicObjectCollection("adjustrange");
                    if (adjustRange != null && !adjustRange.isEmpty()) {
                        entry.setAdjustRange(adjustRange.stream().map(m -> m.getLong("fbasedataid.id")).collect(Collectors.toList()));
                    }
                    list.add(entry);
                }
            }
        }
        return list;
    }

    private static List<String[]> getMatchData(String matchElementVal) {
        String[] values;
        if (StringUtils.isEmpty((CharSequence)matchElementVal)) {
            return null;
        }
        ArrayList<String[]> data = new ArrayList<String[]>(16);
        for (String val : values = matchElementVal.split(",")) {
            if ("0".equals(val)) {
                data.add(new String[]{"customer", "customer"});
                continue;
            }
            if ("1".equals(val)) {
                data.add(new String[]{"mrtype", "mrtype"});
                continue;
            }
            if ("2".equals(val)) {
                data.add(new String[]{"checktype", "checktype"});
                continue;
            }
            if ("3".equals(val)) {
                data.add(new String[]{"cabinconfig", "cabinconfig"});
                continue;
            }
            if (!"4".equals(val)) continue;
            data.add(new String[]{"schdstatus", "schdstatus"});
        }
        return data;
    }
}

