/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.stockup.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.MapFunction;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.mmc.mds.common.algorithm.util.MdsAlgoUtils;
import kd.mmc.mds.common.deliveryquery.algo.AddIdMapFunctionByAlgo;
import kd.mmc.mds.common.stockup.algo.UpdateMapFunctionByAlgo;
import kd.mmc.mds.common.stockup.model.StockUpRangeEntry;
import kd.mmc.mds.common.stockup.model.StockUpRuleEntry;
import kd.mmc.mds.common.stockup.util.StockUpRangeHelper;
import kd.mmc.mds.common.stockup.util.StockUpRecorder;
import kd.mmc.mds.common.stockup.util.StockUpRuleHelper;

public class StockUpStatusHelper {
    private static final Log logger = LogFactory.getLog(StockUpStatusHelper.class);
    private static List<String> selectFields = new ArrayList<String>(16);
    private static List<String> backUpFields;
    private static List<String> matchField;
    private static List<String> rightJoinField;

    public static DataSet addToDBField(DataSet dataSet, Long schemeId) {
        Long userId = RequestContext.get().getCurrUserId();
        dataSet = dataSet.addField(String.valueOf(userId), "creator");
        dataSet = dataSet.addField(String.valueOf(userId), "modifier");
        dataSet = dataSet.addField("now()", "createtime");
        dataSet = dataSet.addField("now()", "modifytime");
        dataSet = dataSet.addField(String.valueOf(schemeId), "stockupscheme");
        dataSet = dataSet.addField("'A'", "status");
        dataSet = dataSet.addNullField("id");
        return dataSet.map((MapFunction)new AddIdMapFunctionByAlgo(dataSet.getRowMeta(), "id"));
    }

    public static DataSet joinRecord(DataSet dataSet) {
        RowMeta meta = dataSet.getRowMeta();
        Field cabinconfig = meta.getField("cabinconfig", false);
        if (cabinconfig == null) {
            dataSet = dataSet.addNullField("cabinconfig_a");
        } else {
            dataSet = dataSet.addField("cabinconfig", "cabinconfig_a");
            dataSet = dataSet.removeFields(new String[]{"cabinconfig"});
        }
        Field cabinconfigname = meta.getField("cabinconfig.name", false);
        if (cabinconfigname == null) {
            dataSet = dataSet.addNullField("cabinconfig.name_a");
        } else {
            dataSet = dataSet.addField("cabinconfig.name", "cabinconfig.name_a");
            dataSet = dataSet.removeFields(new String[]{"cabinconfig.name"});
        }
        Field cabinconfignnumber = meta.getField("cabinconfig.number", false);
        if (cabinconfignnumber == null) {
            dataSet = dataSet.addNullField("cabinconfig.number_a");
        } else {
            dataSet = dataSet.addField("cabinconfig.number", "cabinconfig.number_a");
            dataSet = dataSet.removeFields(new String[]{"cabinconfig.number"});
        }
        meta = dataSet.getRowMeta();
        Field[] fields = meta.getFields();
        HashSet<String> r = new HashSet<String>(rightJoinField);
        Set<String> l = new ArrayList<Field>(Arrays.asList(fields)).stream().map(Field::getName).filter(o -> !r.contains(o)).collect(Collectors.toSet());
        DataSet record = QueryServiceHelper.queryDataSet((String)StockUpStatusHelper.class.getName(), (String)"mds_stockuprecord", (String)String.join((CharSequence)",", selectFields), (QFilter[])new QFilter[]{new QFilter("1", "=", (Object)1)}, null);
        record = record.groupBy(selectFields.toArray(new String[0])).finish();
        DataSet joinDataSet = dataSet.leftJoin(record).on("planid", "planid").on("projectid", "projectid").select(l.toArray(new String[0]), r.toArray(new String[0])).finish();
        joinDataSet = joinDataSet.addField("case when cabinconfig_c is null or  cabinconfig_c = 0  then cabinconfig_a else cabinconfig_c end as cabinconfig", "cabinconfig");
        joinDataSet = joinDataSet.addField("case when cabinconfig.name_c is null then cabinconfig.name_a else cabinconfig.name_c end as cabinconfig.name", "cabinconfig.name");
        joinDataSet = joinDataSet.addField("case when cabinconfig.number_c is null then cabinconfig.number_a else cabinconfig.number_c end as cabinconfig.number", "cabinconfig.number");
        return joinDataSet;
    }

    public static DataSet calcStockUpStatus(DataSet dataSet) {
        DataSet resultDataSet = dataSet.addNullField("id");
        resultDataSet = resultDataSet.addField("concat(planid,'#',projectid)", "id");
        resultDataSet = StockUpStatusHelper.joinRecord(resultDataSet);
        RowMeta meta = resultDataSet.getRowMeta();
        for (String field : matchField) {
            if (MdsAlgoUtils.existField(meta, field)) continue;
            resultDataSet = resultDataSet.addNullField(field);
            meta = resultDataSet.getRowMeta();
        }
        for (String backUpField : backUpFields) {
            HashMap<String, Long> updateMap = new HashMap<String, Long>();
            DataSet calcDataSet = resultDataSet.copy().filter(String.format("%s = 0 or %s is null", backUpField, backUpField));
            List<StockUpRuleEntry> ruleEntries = StockUpRuleHelper.getRuleData(backUpField);
            List<StockUpRangeEntry> rangeEntries = StockUpRangeHelper.getRangeData(backUpField);
            ruleEntries.sort((o1, o2) -> o2.getLevel() - o1.getLevel());
            for (StockUpRuleEntry ruleEntry : ruleEntries) {
                Long stockStatus = ruleEntry.getStockStatus();
                List<String[]> matchList = ruleEntry.getMatch();
                if (matchList != null) {
                    for (StockUpRangeEntry rangeEntry : rangeEntries) {
                        String whereExpr = StockUpStatusHelper.buildWhereExpr(rangeEntry, ruleEntry);
                        DataSet whereDataSet = calcDataSet.copy();
                        if (StringUtils.isNotEmpty((CharSequence)whereExpr)) {
                            whereDataSet = whereDataSet.where(whereExpr);
                        }
                        for (Row row : whereDataSet) {
                            updateMap.put(row.getString("id"), stockStatus);
                        }
                    }
                    continue;
                }
                String whereExpr = StockUpStatusHelper.buildWhereExpr(null, ruleEntry);
                DataSet whereDataSet = calcDataSet.copy();
                if (StringUtils.isNotEmpty((CharSequence)whereExpr)) {
                    whereDataSet = whereDataSet.where(whereExpr);
                }
                for (Row row : whereDataSet) {
                    updateMap.put(row.getString("id"), stockStatus);
                }
            }
            resultDataSet = resultDataSet.map((MapFunction)new UpdateMapFunctionByAlgo(resultDataSet.getRowMeta(), "id", backUpField, updateMap));
            StockUpRecorder.updateAdjustRecord(backUpField, updateMap);
        }
        resultDataSet = resultDataSet.addField("projectid", "project");
        return resultDataSet;
    }

    private static String buildWhereExpr(StockUpRangeEntry rangeEntry, StockUpRuleEntry ruleEntry) {
        String rangeExpr;
        LinkedList<String> whereExprList = new LinkedList<String>();
        List<String[]> matchList = ruleEntry.getMatch();
        if (matchList != null && StringUtils.isNotBlank((CharSequence)(rangeExpr = StockUpRangeHelper.buildRangeWhereExpr(rangeEntry, matchList)))) {
            whereExprList.add(rangeExpr);
        }
        return String.join((CharSequence)" and ", whereExprList);
    }

    static {
        selectFields.add("backupbom");
        selectFields.add("backuphis");
        selectFields.add("backupcustmor");
        selectFields.add("polarisstatus");
        selectFields.add("polarisstatus.name");
        selectFields.add("polarisstatus.number");
        selectFields.add("stockupmode");
        selectFields.add("cabinconfig");
        selectFields.add("cabinconfig.name");
        selectFields.add("cabinconfig.number");
        selectFields.add("queryindex");
        selectFields.add("planid");
        selectFields.add("projectid");
        selectFields.add("creator");
        selectFields.add("modifier");
        selectFields.add("createtime");
        selectFields.add("modifytime");
        rightJoinField = new ArrayList<String>(16);
        rightJoinField.add("backupbom");
        rightJoinField.add("backuphis");
        rightJoinField.add("backupcustmor");
        rightJoinField.add("polarisstatus");
        rightJoinField.add("stockupmode");
        rightJoinField.add("polarisstatus.name");
        rightJoinField.add("polarisstatus.number");
        rightJoinField.add("cabinconfig as cabinconfig_c");
        rightJoinField.add("cabinconfig.name as cabinconfig.name_c");
        rightJoinField.add("cabinconfig.number as cabinconfig.number_c");
        rightJoinField.add("creator as creatorlist");
        rightJoinField.add("modifier as modifierlist");
        rightJoinField.add("createtime as createtimelist");
        rightJoinField.add("modifytime as modifytimelist");
        backUpFields = new ArrayList<String>(16);
        backUpFields.add("backupbom");
        backUpFields.add("backuphis");
        backUpFields.add("backupcustmor");
        matchField = new ArrayList<String>(16);
        matchField.add("cabinconfig");
        matchField.add("schdstatus");
        matchField.add("customer");
        matchField.add("checktype");
        matchField.add("mrtype");
    }
}

