/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class CalcCalendarUtil {
    private static final String KEY_CALENDAR = "mpdm_calendar";
    private static final String KEY_CREATEORG = "createorg";
    private static final String KEY_DATEENTRY_WORKDATE = "dateentry.workdate";
    private static final String KEY_DATEENTRY_DATETYPE = "dateentry.datetype";
    private static final String KEY_ISFAULT = "isfault";
    private static final String KEY_ENABLE = "enable";
    private static final String KEY_STATUS = "status";
    private static final String KEY_ISDEFAULT = "isfault";
    private static final String KEY_WORKDATES = "workDates";
    private static final String KEY_MANUAL = "manual";
    public static final String KEY_MFTDEFAULT = "fmm_defaultorg";
    private static final String KEY_CALENDARID = "calendar";
    public static final String KEY_DEFAULTORG = "fmm_defaultorg";

    public static boolean isExistsCalendar(DynamicObject dept) {
        if (dept == null) {
            return false;
        }
        QFilter[] qfilters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", dept.getPkValue()), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")};
        DynamicObjectCollection colByOrg = QueryServiceHelper.query((String)"fmm_defaultorg", (String)KEY_CALENDARID, (QFilter[])qfilters);
        return !colByOrg.isEmpty();
    }

    public static String getCalendarId(Object orgId) {
        if (orgId == null) {
            return "";
        }
        QFilter[] qfilters = new QFilter[4];
        qfilters[0] = new QFilter(KEY_CREATEORG, "=", orgId);
        qfilters[1] = new QFilter(KEY_ENABLE, "=", (Object)"1");
        qfilters[2] = new QFilter(KEY_STATUS, "=", (Object)"C");
        DynamicObjectCollection colByOrg = QueryServiceHelper.query((String)"fmm_defaultorg", (String)KEY_CALENDARID, (QFilter[])qfilters);
        if (!colByOrg.isEmpty()) {
            return ((DynamicObject)colByOrg.get(0)).getString(KEY_CALENDARID);
        }
        return "";
    }

    public static List<Date> loadWorkDates(Object orgPk, IFormView fv) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Date> workDates = new ArrayList<Date>(100);
        QFilter[] qfilters = new QFilter[]{new QFilter(KEY_CREATEORG, "=", orgPk), new QFilter(KEY_ENABLE, "=", (Object)"1"), new QFilter(KEY_STATUS, "=", (Object)"C")};
        DynamicObjectCollection calendarList = QueryServiceHelper.query((String)"mrp_plancalendar", (String)"isfault,id", (QFilter[])qfilters);
        DynamicObject defaultCal = null;
        for (DynamicObject calendar : calendarList) {
            Boolean isfault = calendar.getBoolean("isfault");
            if (!isfault.booleanValue()) continue;
            defaultCal = calendar;
            break;
        }
        if (defaultCal == null && calendarList.size() == 1) {
            defaultCal = (DynamicObject)calendarList.get(0);
        }
        if (defaultCal == null) {
            fv.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u7684\u8ba1\u5212\u65e5\u5386\uff0c\u65e0\u6cd5\u8ba1\u7b97\u660e\u7ec6\u65f6\u95f4\u70b9\u3002", (String)"CalcCalendarUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        } else {
            Object id = defaultCal.get("id");
            qfilters = new QFilter[]{new QFilter("id", "=", id), new QFilter(KEY_DATEENTRY_DATETYPE, "=", (Object)"1")};
            DynamicObjectCollection wkdates = QueryServiceHelper.query((String)"mrp_plancalendar", (String)KEY_DATEENTRY_WORKDATE, (QFilter[])qfilters, (String)"dateentry.seq");
            for (DynamicObject plan : wkdates) {
                try {
                    workDates.add(sdf.parse(plan.getString(0)));
                }
                catch (ParseException e) {
                    throw new KDException((Throwable)e, new ErrorCode("mds", e.getMessage()), new Object[0]);
                }
            }
        }
        return workDates;
    }
}

