/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowType;
import kd.bos.form.control.Toolbar;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.lang.Lang;
import kd.bos.list.BillList;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.api.ScheduleDao;
import kd.bos.schedule.api.ScheduleManager;
import kd.bos.schedule.api.TaskDao;
import kd.bos.schedule.executor.ExecutorService;
import kd.bos.schedule.executor.JobClient;
import kd.bos.schedule.server.JobDispatcherProxy;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.util.CalcCalendarUtil;

public class CalcuColumns {
    public static final String BASE_TASK = "kd.mmc.mds.formplugin.basedata.task.BaseCalcRunningTask";
    public static final String BTNSAVE = "bar_save";
    public static final String C_END = "end";
    public static final String C_START = "start";
    public static final int CANCEL = 2;
    public static final String CLOSEDCALLBACK = "RUNNINGCALLBACK";
    public static final String CO_AMOUNTTYPE = "amounttype";
    public static final String CO_BASENUMBER = "number";
    public static final String CO_BILLSTATUS = "billstatus";
    public static final String CO_BKEDEDUCTS = "bkdeducts";
    public static final String CO_BOMTYPE = "type";
    public static final String CO_CALSTATUS = "calstatus";
    public static final String CO_CHANGEMOD = "mod";
    public static final String CO_CHANGEWAY = "changeway";
    public static final String CO_CREATOR = "creator";
    public static final String CO_CYCLETYPED = "cycletyped";
    public static final String CO_DAYSOFMON = "daysofmon";
    public static final String CO_DAYSOFWEEK = "daysofweek";
    public static final String CO_DESTPREDVER = "predversion";
    public static final String CO_DTYPE = "dtype";
    public static final String CO_ENABLE = "enable";
    public static final String CO_EXE = "tasktype";
    public static final String CO_FCQTY = "fcqty";
    public static final String CO_FCVRNNUM = "fcvrnnum";
    public static final String CO_FCVRNNUM_NUMBER = "fcvrnnum.number";
    public static final String CO_HEAD_REDUCE = "deduct_h";
    public static final String CO_ISWRD = "deduct";
    public static final String CO_JOBID = "jobid";
    public static final String CO_LOSEDATE = "losedate";
    public static final String CO_MATERIAL = "materialid";
    public static final String CO_MODIFIER = "modifier";
    public static final String CO_NOWQTY = "nowqty";
    public static final String CO_NUMBER = "billno";
    public static final String CO_SCHEMEID = "schemeid";
    public static final String CO_OPENLEVEL = "openlv";
    public static final String CO_ORG = "org";
    public static final String CO_PLANEND = "end";
    public static final String CO_PLANGP = "plangp";
    public static final String CO_PLANID = "planid";
    public static final String CO_PLANSTART = "start";
    public static final String CO_PREDEDUCTS = "prededucts";
    public static final String CO_PREDTIME = "predtime";
    public static final String CO_QTYSRC = "qtysrc";
    public static final String CO_REPEAT = "repeat";
    public static final String CO_REPEATTYPE = "repeattype";
    public static final String CO_RUNNINGLOG = "runninglog";
    public static final String CO_RUNNINGLOG_TAG = "runninglog_tag";
    public static final String CO_RUNNINGTYPE = "runningtype";
    public static final String CO_SOURCENAME = "sourcename";
    public static final String CO_SOURCETYPE = "sourcetype";
    public static final String CO_TAIL_REDUCE = "deduct_t";
    public static final String CO_XQJH_STYPE = "stype";
    public static final String DATANODE = "datenode";
    public static final String DETAIL_ENTRY = "detailentity";
    public static final String ENTITY_FCCORL = "mds_corl";
    public static final String ENTITY_VRDS = "mds_vrds";
    public static final String ENTPDCC = "mds_pdcc";
    public static final String ENTXQJH = "mds_rplancal";
    public static final int HMS = 60;
    public static final String INPUT_ENTRY = "inputentry";
    public static final String LOCALIP = "127.0.0.1";
    public static final String MASTERID = "masterid";
    public static final String MDS_DATAIN = "mds_data";
    public static final String OP = "op";
    public static final String OPCALCULATESETTING = "calculatesetting";
    public static final String OPCALCULATING = "calculating";
    public static final String OPTERMINATION = "tblstop";
    public static final String RMONTH = "1";
    public static final String RTDELAY = "1";
    public static final String RTIMD = "0";
    public static final int RUNNING = 1;
    public static final String RWEEK = "0";
    public static final int SAVE = 0;
    public static final String SETTINGPAGE = "mds_ysset";
    public static final String USEORG = "useorg";

    public static boolean beforeNow(int h, int m, int s) {
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(System.currentTimeMillis());
        Calendar pred = Calendar.getInstance();
        pred.set(1, now.get(1));
        pred.set(2, now.get(2));
        pred.set(5, now.get(5));
        pred.set(11, h);
        pred.set(12, m);
        pred.set(13, s);
        return pred.compareTo(now) > 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    private static boolean bigger(Calendar c1, Calendar c2, int c) {
        return c1.get(c) > c2.get(c);
    }

    public static int compare(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        if (CalcuColumns.bigger(c1, c2, 1)) {
            return 1;
        }
        if (CalcuColumns.lower(c1, c2, 1)) {
            return -1;
        }
        if (CalcuColumns.bigger(c1, c2, 2)) {
            return 1;
        }
        if (CalcuColumns.lower(c1, c2, 2)) {
            return -1;
        }
        if (CalcuColumns.bigger(c1, c2, 5)) {
            return 1;
        }
        if (CalcuColumns.lower(c1, c2, 5)) {
            return -1;
        }
        return 0;
    }

    public static String createExp(String key, Map<String, Object> m) {
        List days = (List)m.get(key);
        CharSequence[] array = days.toArray(new String[days.size()]);
        return String.join((CharSequence)",", array);
    }

    public static boolean createLock(String ent, String oprKey, String id) {
        return MutexHelper.require((String)ent, (Object)id, (String)oprKey, (boolean)true, (StringBuilder)new StringBuilder(ResManager.loadKDString((String)"\u6570\u636e\u88ab\u9501\u5b9a\u3002", (String)"CalcuColumns_0", (String)"mmc-mds-common", (Object[])new Object[0])));
    }

    public static void exec(String op, DynamicObject bill, IFormView view, int calctype) {
        if (op != null && !"".equals(op)) {
            switch (op) {
                case "save": {
                    view.close();
                    break;
                }
                case "rn": {
                    CalcuColumns.run(bill, view, calctype);
                    view.close();
                    break;
                }
                case "rn1": {
                    CalcuColumns.runImediatly(bill, view, calctype, null);
                    view.close();
                    break;
                }
            }
        }
    }

    public static Map<String, Object> getSetParams(DynamicObject d, String hd) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hidden", hd);
        params.put("id", d.getPkValue());
        params.put(CO_DAYSOFWEEK, d.get(CO_DAYSOFWEEK));
        params.put(CO_DAYSOFMON, d.get(CO_DAYSOFMON));
        params.put(CO_RUNNINGTYPE, d.get(CO_RUNNINGTYPE));
        params.put(CO_REPEATTYPE, d.get(CO_REPEATTYPE));
        params.put(CO_REPEAT, d.get(CO_REPEAT));
        params.put(CO_PREDTIME, d.get(CO_PREDTIME));
        params.put(CO_LOSEDATE, d.get(CO_LOSEDATE));
        params.put(CO_BILLSTATUS, d.get(CO_BILLSTATUS));
        return params;
    }

    public static Calendar getStarttime(int pred, String rt) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        if (StringUtils.equals((CharSequence)"0", (CharSequence)rt)) {
            c.add(13, 60);
            return c;
        }
        int h = pred / 60 / 60;
        int m = pred / 60 % 60;
        int s = pred % 60;
        if (CalcuColumns.beforeNow(h, m, s)) {
            c.add(5, 1);
            c.set(11, h);
            c.set(12, m);
            c.set(13, s);
            return c;
        }
        c.set(11, h);
        c.set(12, m);
        c.set(13, s);
        return c;
    }

    public static String getTaskId() {
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)CO_BASENUMBER, (QFilter[])new QFilter[]{new QFilter("classname", "=", (Object)BASE_TASK)});
        if (taskname == null) {
            return null;
        }
        return String.valueOf(taskname.getPkValue());
    }

    public static JobInfo initJobInfo(DynamicObject task, int calsType) {
        String reqId = task.getString(CO_NUMBER);
        Boolean repeat = task.getBoolean(CO_REPEAT);
        String jobNum = "JOB-" + reqId;
        JobInfo jobInfo = new JobInfo();
        HashMap<String, Object> params = new HashMap<String, Object>();
        Object pkValue = task.getPkValue();
        params.put(CO_NUMBER, pkValue);
        if (repeat == null || !repeat.booleanValue()) {
            params.put(CO_REPEAT, Boolean.FALSE);
        } else {
            params.put(CO_REPEAT, Boolean.TRUE);
        }
        params.put(CO_EXE, calsType);
        jobInfo.setId(jobNum);
        jobInfo.setNumber(jobNum);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u7b97\u4f5c\u4e1a%s", (String)"CalcuColumns_13", (String)"mmc-mds-common", (Object[])new Object[0]), reqId));
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setRunConcurrently(true);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        String className = CalcuColumns.getTaskId();
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setTaskClassname(BASE_TASK);
        jobInfo.setParams(params);
        jobInfo.setAppId("mds");
        jobInfo.setRunByLang(Lang.get());
        return jobInfo;
    }

    public static PlanInfo initPlanInfo(String jobId, DynamicObject task) {
        PlanInfo planInfo = new PlanInfo();
        String reqId = task.getString(CO_NUMBER);
        String rt = task.getString(CO_RUNNINGTYPE);
        Date losd = task.getDate(CO_LOSEDATE);
        String planNum = "PLAN-" + reqId;
        planInfo.setNumber(planNum);
        planInfo.setJobId(jobId);
        CalcuColumns.setLostdate(planInfo, losd);
        Integer pred = task.getInt(CO_PREDTIME);
        Calendar starttime = CalcuColumns.getStarttime(pred, rt);
        planInfo.setStartTime(starttime);
        planInfo.setName(String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u7b97\u8ba1\u5212%s", (String)"CalcuColumns_2", (String)"mmc-mds-common", (Object[])new Object[0]), reqId));
        task.set(CO_JOBID, (Object)jobId);
        String repeattype = task.getString(CO_REPEATTYPE);
        if (rt.equals("0")) {
            task.set(CO_CALSTATUS, (Object)"B");
        } else {
            task.set(CO_CALSTATUS, (Object)"A");
        }
        task.set(CO_BILLSTATUS, (Object)"B");
        if (!task.getBoolean(CO_REPEAT)) {
            planInfo.setRepeatMode(RepeatModeEnum.NONE);
            return planInfo;
        }
        if (CalcuColumns.isWeek(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
            String daysExp = task.getString(CO_DAYSOFWEEK);
            planInfo.setWeekdaysExp(daysExp);
            planInfo.setPeriod(1);
        } else {
            planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
            String daysExp = task.getString(CO_DAYSOFMON);
            planInfo.setDaysExp(daysExp);
            planInfo.setPeriod(1);
        }
        return planInfo;
    }

    public static void initWorkDates(IDataModel dm, IFormView view) {
        if (dm.getValue(CO_ORG) == null) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u5f53\u524d\u7ec4\u7ec7\u65e0\u53ef\u7528\u7684\u8ba1\u5212\u65e5\u5386\u3002", (String)"CalcuColumns_3", (String)"mmc-mds-common", (Object[])new Object[0]));
        } else {
            CalcCalendarUtil.loadWorkDates(((DynamicObject)dm.getValue(CO_ORG)).getPkValue(), view);
        }
    }

    public static boolean isEmpty(Object[] obj) {
        return obj == null || obj.length < 1;
    }

    public static boolean isSaveStatus(DynamicObject task) {
        return Billstatus.SAVE.getCode().equals(task.getString(CO_BILLSTATUS));
    }

    public static boolean isWeek(Map<String, Object> csetting) {
        String week = (String)csetting.get(CO_REPEATTYPE);
        return StringUtils.equals((CharSequence)"0", (CharSequence)week) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean isWeek(String rweek) {
        return StringUtils.equals((CharSequence)"0", (CharSequence)rweek) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static Object load(IDataModel dm, String key) {
        return dm.getValue(key);
    }

    private static boolean lower(Calendar c1, Calendar c2, int c) {
        return c1.get(c) < c2.get(c);
    }

    public static void refresh(IFormView fv) {
        Toolbar toolbar = (Toolbar)fv.getControl("tbmain");
        toolbar.itemClick("", "refresh");
    }

    public static void releaseLock(String ent, String oprKey, String id) {
        MutexHelper.release((String)ent, (String)oprKey, (String)id);
    }

    public static void run(DynamicObject bill, IFormView view, int calctype) {
        String jobId = bill.getString(CO_JOBID);
        String planId = bill.getString(CO_PLANID);
        String runningtype = bill.getString(CO_RUNNINGTYPE);
        JobDispatcherProxy jdp = new JobDispatcherProxy();
        TaskDao tdao = ExecutorService.getInstance().getObjectFactory().getTaskDao();
        ScheduleDao sdao = ExecutorService.getInstance().getObjectFactory().getScheduleDao();
        ScheduleManager scheduleManager = (ScheduleManager)ServiceFactory.getService(ScheduleManager.class);
        if (planId != null && !planId.isEmpty()) {
            tdao.deleteTaskByScheduleId(planId);
            jdp.deletePlan(planId);
        }
        if (jobId != null && !jobId.isEmpty()) {
            jdp.deleteJob(jobId);
        }
        JobInfo jobInfo = CalcuColumns.initJobInfo(bill, calctype);
        jobId = jdp.createJob(jobInfo);
        scheduleManager.enableJob(jobId);
        PlanInfo planInfo = CalcuColumns.initPlanInfo(jobId, bill);
        planId = jdp.createPlan(planInfo);
        boolean isSuccess = sdao.existed(planId);
        for (int count = 0; !isSuccess && count <= 3; ++count) {
            planId = jdp.createPlan(planInfo);
            isSuccess = sdao.existed(planId);
        }
        if (!isSuccess) {
            view.showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u8c03\u5ea6\u8ba1\u5212\u5931\u8d25\u3002", (String)"CalcuColumns_4", (String)"mmc-mds-common", (Object[])new Object[0]));
            return;
        }
        scheduleManager.enableSchedule(planId);
        bill.set(CO_PLANID, (Object)planId);
        if ("0".equals(runningtype)) {
            bill.set(CO_CALSTATUS, (Object)CalcStatus.RUNNING.getCode());
        } else {
            bill.set(CO_CALSTATUS, (Object)CalcStatus.WAIT.getCode());
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{bill});
        view.setEnable(Boolean.FALSE, new String[]{BTNSAVE});
        view.showMessage(ResManager.loadKDString((String)"\u8ba1\u7b97\u4efb\u52a1\u5df2\u5206\u53d1\u6210\u529f\uff0c\u8bf7\u524d\u5f80\u5217\u8868\u754c\u9762\u67e5\u770b\u3002", (String)"CalcuColumns_5", (String)"mmc-mds-common", (Object[])new Object[0]));
    }

    public static void runImediatlyNoView(DynamicObject bill, int calctype, Object schemeid) {
        CalcuColumns.runImediatly(bill, null, calctype, schemeid);
    }

    public static void runImediatly(DynamicObject bill, IFormView fv, int calctype, Object schemeid) {
        String id = bill.getString(CO_NUMBER);
        HashMap<String, Object> pages = new HashMap<String, Object>();
        pages.put(CO_REPEAT, Boolean.FALSE);
        JobInfo jobInfo = new JobInfo();
        String jobId = id;
        jobInfo.setId(jobId);
        jobInfo.setName(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u7b97\u4efb\u52a1", (String)"CalcuColumns_6", (String)"mmc-mds-common", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        boolean connc = true;
        jobInfo.setRunConcurrently(connc);
        String className = CalcuColumns.getTaskId();
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setTaskClassname(BASE_TASK);
        jobInfo.setAppId("mds");
        if (schemeid != null) {
            DynamicObject schemebill = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)"mds_planexec");
            schemebill.set("status", (Object)Billstatus.PLAN.getCode());
            schemebill.set(CO_ENABLE, (Object)CalcStatus.RUNNING.getCode());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemebill});
        }
        Object pkValue = bill.getPkValue();
        pages.put(CO_NUMBER, pkValue);
        pages.put(CO_EXE, calctype);
        pages.put(CO_SCHEMEID, schemeid);
        jobInfo.setParams(pages);
        JobClient.dispatch((JobInfo)jobInfo);
        if (fv != null) {
            fv.setEnable(Boolean.FALSE, new String[]{BTNSAVE});
            fv.showMessage(ResManager.loadKDString((String)"\u8ba1\u7b97\u4efb\u52a1\u5df2\u5206\u53d1\u6210\u529f\uff0c\u8bf7\u524d\u5f80\u5217\u8868\u754c\u9762\u67e5\u770b\u3002", (String)"CalcuColumns_5", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
    }

    public static void saveBill(IFormView fv) {
        Toolbar tbar = (Toolbar)fv.getControl("tbmain");
        tbar.itemClick(BTNSAVE, "save");
    }

    public static DynamicObject[] selectedData(IFormView view) {
        BillList list = (BillList)view.getControl("billlistap");
        ListSelectedRowCollection rows = list.getSelectedRows();
        String entityName = list.getEntityType().getName();
        if (!rows.isEmpty()) {
            DynamicObject[] cc = new DynamicObject[rows.size()];
            for (int i = 0; i < rows.size(); ++i) {
                Object pk = rows.get(i).getPrimaryKeyValue();
                cc[i] = BusinessDataServiceHelper.loadSingle((Object)pk, (String)entityName);
            }
            return cc;
        }
        return new DynamicObject[0];
    }

    public static void setLostdate(PlanInfo planInfo, Date lostdate) {
        Calendar lc = Calendar.getInstance();
        if (lostdate == null) {
            lc.set(1, 2099);
            lc.set(2, 11);
            lc.set(5, 31);
        } else {
            lc.setTime(lostdate);
            lc.add(5, 1);
        }
        planInfo.setEndTime(lc);
    }

    public static void showCalcErr(IFormView view, Map<String, String> ops, int size) {
        if (size == 1) {
            if (ops.isEmpty()) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u8ba1\u7b97\u4efb\u52a1\u5df2\u5206\u53d1\u6210\u529f\uff0c\u8bf7\u524d\u5f80\u5217\u8868\u754c\u9762\u67e5\u770b\u3002", (String)"CalcuColumns_5", (String)"mmc-mds-common", (Object[])new Object[0]));
            } else {
                for (Map.Entry<String, String> en : ops.entrySet()) {
                    view.showTipNotification(en.getKey() + "\uff1a" + en.getValue());
                }
            }
        } else {
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"CalcuColumns_15", (String)"mmc-mds-common", (Object[])new Object[0]), size, size - ops.size(), ops.size());
            StringBuilder msg = new StringBuilder(500);
            for (Map.Entry<String, String> m : ops.entrySet()) {
                msg.append(m.getKey());
                msg.append('\uff1a');
                msg.append(m.getValue());
                msg.append('\n');
            }
            view.showMessage(title, msg.toString(), MessageTypes.Default);
        }
    }

    public static void showForm(IFormPlugin plugin, IFormView view, Map<String, Object> params) {
        FormShowParameter form = new FormShowParameter();
        form.setFormId(SETTINGPAGE);
        form.getOpenStyle().setShowType(ShowType.Modal);
        form.setCloseCallBack(new CloseCallBack(plugin, CLOSEDCALLBACK));
        form.setCustomParams(params);
        view.showForm(form);
    }

    public static void showStopTip(IFormView view, List<Map<String, String>> ops, DynamicObject[] bill) {
        if (bill.length == 1) {
            if (ops.isEmpty()) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f\u3002", (String)"CalcuColumns_11", (String)"mmc-mds-common", (Object[])new Object[0]));
            } else {
                for (Map.Entry<String, String> en : ops.get(0).entrySet()) {
                    view.showTipNotification(en.getKey() + "\uff1a" + en.getValue());
                }
            }
        } else {
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u7ec8\u6b62%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"CalcuColumns_16", (String)"mmc-mds-common", (Object[])new Object[0]), bill.length, bill.length - ops.size(), ops.size());
            StringBuilder msg = new StringBuilder(500);
            for (Map<String, String> m : ops) {
                for (Map.Entry<String, String> e : m.entrySet()) {
                    msg.append(e.getKey());
                    msg.append('\uff1a');
                    msg.append(e.getValue());
                    msg.append('\n');
                }
            }
            view.showMessage(title, msg.toString(), MessageTypes.Default);
        }
    }

    public static void updateLost(String entity) {
        Calendar c = Calendar.getInstance();
        c.setTime(new Date());
        c.add(5, -1);
        String[] st = new String[]{CalcStatus.ERROR.getCode(), CalcStatus.STOP.getCode()};
        String[] bt = new String[]{Billstatus.SAVE.getCode(), Billstatus.CLOSE.getCode()};
        DynamicObject[] load = BusinessDataServiceHelper.load((String)entity, (String)"number,calstatus,billstatus", (QFilter[])new QFilter[]{new QFilter(CO_LOSEDATE, "<", (Object)c.getTime()), new QFilter(CO_CALSTATUS, "not in", (Object)st), new QFilter(CO_BILLSTATUS, "not in", (Object)bt)});
        if (load != null && load.length > 0) {
            for (DynamicObject d : load) {
                d.set(CO_CALSTATUS, (Object)CalcStatus.FINISH.getCode());
                d.set(CO_BILLSTATUS, (Object)Billstatus.CLOSE.getCode());
                SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{d});
            }
        }
    }

    private CalcuColumns() {
    }

    public static enum Caltype {
        XQJH_CAL,
        YC_CAL;

    }

    public static enum CalCycle {
        CUSTOM("2"),
        DAY("0"),
        MON("3"),
        WEEK("1"),
        YEAR("4");

        private String code;

        private CalCycle(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum CalcStatus {
        ERROR("D"),
        FINISH("C"),
        RUNNING("B"),
        STOP("E"),
        WAIT("A");

        private String code;

        private CalcStatus(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum Billstatus {
        CLOSE("C"),
        PLAN("B"),
        SAVE("A");

        private String code;

        private Billstatus(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

