/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.executor.JobClient;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.util.CalcuColumns;

public class ClearMdsPlanDataUtils {
    public static void runClearImediatly(Map<String, Object> csetting, List<Object> ids, String entityNumber) {
        ArrayList<QFilter> qfFilters = new ArrayList<QFilter>(1);
        qfFilters.add(new QFilter("id", "in", ids));
        Map planDatas = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)"id,fcvrnnum", (QFilter[])qfFilters.toArray(new QFilter[0]));
        if (planDatas == null || planDatas.size() == 0) {
            return;
        }
        ArrayList<Object> fcvrnnumIds = new ArrayList<Object>(planDatas.size());
        StringBuilder nameStr = new StringBuilder();
        for (DynamicObject planData : planDatas.values()) {
            DynamicObject fcvrnnum = planData.getDynamicObject("fcvrnnum");
            fcvrnnumIds.add(fcvrnnum.getPkValue());
            String name = fcvrnnum.getLocaleString("name").getLocaleValue();
            if (!StringUtils.isBlank((CharSequence)nameStr.toString()) && nameStr.toString().split("\\[").length > 3) continue;
            nameStr.append('[').append(name).append(']');
        }
        HashMap<String, Object> params = new HashMap<String, Object>(3);
        params.put("repeat", Boolean.FALSE);
        JobInfo jobInfo = new JobInfo();
        SimpleDateFormat systemDataSdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String now = systemDataSdf.format(new Date());
        Boolean isrept = (Boolean)csetting.get("repeat");
        Integer pred = (Integer)csetting.get("predtime");
        String rt = (String)csetting.get("runningtype");
        Calendar starttime = CalcuColumns.getStarttime(pred, rt);
        jobInfo.setNumber("Clear" + now);
        jobInfo.setId("Clear" + now);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u5904\u7406\u6e05\u7a7a\u8bbe\u7f6e%1$s%2$s\u3002", (String)"ClearMdsPlanDataUtils_2", (String)"mmc-mds-common", (Object[])new Object[0]), now, nameStr.toString()));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        boolean connc = true;
        jobInfo.setRunConcurrently(connc);
        jobInfo.setTaskClassname("kd.mmc.mds.formplugin.basedata.task.ClearMdsPlanDataTask");
        jobInfo.setAppId("mds");
        String className = ClearMdsPlanDataUtils.getTaskId("ClearMdsPlanDataTask");
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        params.put("fcvrnnum", fcvrnnumIds);
        params.put("number", entityNumber);
        params.put("runningtype", rt);
        params.put("repeat", isrept);
        params.put("predtime", starttime);
        jobInfo.setParams(params);
        JobClient.dispatch((JobInfo)jobInfo);
    }

    public static JobInfo createJob(Map<String, Object> csetting, List<Object> ids, String entityNumber) {
        ArrayList<QFilter> qfFilters = new ArrayList<QFilter>(1);
        qfFilters.add(new QFilter("id", "in", ids));
        JobInfo jobInfo = new JobInfo();
        Map planDatas = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (String)"id,fcvrnnum", (QFilter[])qfFilters.toArray(new QFilter[0]));
        if (planDatas == null || planDatas.size() == 0) {
            return jobInfo;
        }
        ArrayList<Object> fcvrnnumIds = new ArrayList<Object>(planDatas.size());
        StringBuilder nameStr = new StringBuilder();
        for (DynamicObject planData : planDatas.values()) {
            DynamicObject fcvrnnum = planData.getDynamicObject("fcvrnnum");
            fcvrnnumIds.add(fcvrnnum.getPkValue());
            String name = fcvrnnum.getLocaleString("name").getLocaleValue();
            if (!StringUtils.isBlank((CharSequence)nameStr.toString()) && nameStr.toString().split("\\[").length > 3) continue;
            nameStr.append('[').append(name).append(']');
        }
        jobInfo.setTaskClassname("kd.mmc.mds.formplugin.basedata.task.ClearMdsPlanDataTask");
        jobInfo.setAppId("mds");
        String className = ClearMdsPlanDataUtils.getTaskId("ClearMdsPlanDataTask");
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setJobType(JobType.BIZ);
        HashMap<String, Object> params = new HashMap<String, Object>(5);
        SimpleDateFormat systemDataSdf = new SimpleDateFormat("yyyyMMddhhmmss");
        String now = systemDataSdf.format(new Date());
        jobInfo.setNumber("Clear" + now);
        jobInfo.setId("Clear" + now);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u9700\u6c42\u8ba1\u5212\u5904\u7406\u6e05\u7a7a\u8bbe\u7f6e%1$s%2$s\u3002", (String)"ClearMdsPlanDataUtils_2", (String)"mmc-mds-common", (Object[])new Object[0]), now, nameStr.toString()));
        Boolean isrept = (Boolean)csetting.get("repeat");
        Integer pred = (Integer)csetting.get("predtime");
        String rt = (String)csetting.get("runningtype");
        params.put("fcvrnnum", fcvrnnumIds);
        params.put("number", entityNumber);
        params.put("runningtype", rt);
        params.put("repeat", isrept);
        params.put("predtime", pred);
        jobInfo.setParams(params);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunConcurrently(true);
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createJob", new Object[]{jobInfo});
        return jobInfo;
    }

    public static String getTaskId(String className) {
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)"number", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)className)});
        if (taskname == null) {
            return null;
        }
        return String.valueOf(taskname.getPkValue());
    }

    public static void setLostdate(PlanInfo planInfo, Date lostdate) {
        Calendar lc = Calendar.getInstance();
        if (lostdate == null) {
            lc.set(1, 2099);
            lc.set(2, 11);
            lc.set(5, 31);
        } else {
            lc.setTime(lostdate);
            lc.add(5, 1);
        }
        planInfo.setEndTime(lc);
    }

    public static String createPlan(Map<String, Object> csetting, JobInfo jobInfo) {
        PlanInfo planInfo = new PlanInfo();
        String rt = (String)csetting.get("runningtype");
        Object losd = csetting.get("losedate");
        planInfo.setJobId(jobInfo.getId());
        ClearMdsPlanDataUtils.setLostdate(planInfo, (Date)losd);
        Integer pred = (Integer)csetting.get("predtime");
        Calendar starttime = CalcuColumns.getStarttime(pred, rt);
        planInfo.setStartTime(starttime);
        planInfo.setNumber("Clear" + jobInfo.getNumber());
        planInfo.setName(jobInfo.getName());
        String repeattype = (String)csetting.get("repeattype");
        Boolean isrept = (Boolean)csetting.get("repeat");
        if (!isrept.booleanValue()) {
            planInfo.setRepeatMode(RepeatModeEnum.NONE);
        } else if (CalcuColumns.isWeek(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
            Object daysExp = csetting.get("daysofweek");
            String join = String.join((CharSequence)",", (List)daysExp);
            planInfo.setWeekdaysExp(join);
            planInfo.setPeriod(1);
        } else {
            planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
            Object monthExp = csetting.get("daysofmon");
            String joinm = String.join((CharSequence)",", (List)monthExp);
            planInfo.setDaysExp(joinm);
            planInfo.setPeriod(1);
        }
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createPlan", new Object[]{planInfo});
        return String.valueOf(obj);
    }
}

