/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;

public class DateUtil {
    private static Log logger = LogFactory.getLog(DateUtil.class);
    private static Date maxDate = null;
    private static final ThreadLocal<SimpleDateFormat> DATETIME = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy/MM/dd HH:mm:ss"));
    private static final ThreadLocal<SimpleDateFormat> DATE = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));

    public static List<Map<String, Object>> getBetweenWeeks(Date start, Date end) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        if (tempStart.get(7) == 1) {
            tempStart.add(5, -6);
        } else {
            tempStart.add(5, 1 - tempStart.get(7));
        }
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd) || tempStart.equals(tempEnd)) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            int we = tempStart.get(7);
            if (we == 2) {
                map.put("start", sdf.format(tempStart.getTime()));
                map.put("startDate", tempStart.getTime());
            }
            if (map.isEmpty()) {
                tempStart.add(6, 1);
                continue;
            }
            tempStart.add(6, 6);
            map.put("end", sdf.format(tempStart.getTime()));
            map.put("endDate", tempStart.getTime());
            result.add(map);
        }
        return result;
    }

    public static List<Map<String, Object>> getBetweenMonths(Date start, Date end) throws ParseException {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(15);
        Calendar dd = Calendar.getInstance();
        dd.setTime(start);
        while (dd.getTime().before(end) || dd.getTime().equals(end)) {
            HashMap<String, Object> m = new HashMap<String, Object>();
            dd.set(5, dd.getActualMaximum(5));
            String str = sdf.format(dd.getTime());
            m.put("end", str);
            m.put("endDate", dd.getTime());
            dd.set(5, 1);
            str = sdf.format(dd.getTime());
            m.put("start", str);
            m.put("startDate", dd.getTime());
            result.add(m);
            dd.add(2, 1);
        }
        return result;
    }

    public static List<Map<String, Object>> getBetweenQuarters(Date start, Date end) throws ParseException {
        HashMap<String, Object> m;
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        Map<String, String> startq = DateUtil.getCurrQuarter(start, DateUtil.getQuarter(start));
        Map<String, String> endq = DateUtil.getCurrQuarter(end, DateUtil.getQuarter(end));
        Date start_s = sdf.parse(startq.get("start"));
        Date start_e = sdf.parse(startq.get("end"));
        Date end_s = sdf.parse(endq.get("start"));
        Date end_e = sdf.parse(endq.get("end"));
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>(15);
        Calendar d1 = Calendar.getInstance();
        d1.setTime(start_s);
        Calendar d2 = Calendar.getInstance();
        d2.setTime(start_e);
        while (d1.getTime().before(end_s)) {
            m = new HashMap<String, Object>();
            String str = sdf.format(d1.getTime());
            m.put("start", str);
            m.put("startDate", d1.getTime());
            str = sdf.format(d2.getTime());
            m.put("end", str);
            m.put("endDate", d2.getTime());
            result.add(m);
            d1.add(2, 3);
            d2.add(2, 3);
        }
        m = new HashMap();
        m.put("start", endq.get("start"));
        m.put("startDate", end_s);
        m.put("end", endq.get("end"));
        m.put("endDate", end_e);
        result.add(m);
        return result;
    }

    public static int getQuarter(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        int month = c.get(2) + 1;
        int quarter = month >= 1 && month <= 3 ? 1 : (month >= 4 && month <= 6 ? 2 : (month >= 7 && month <= 9 ? 3 : 4));
        return quarter;
    }

    public static Map<String, String> getCurrQuarter(Date time, int num) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        HashMap<String, String> m = new HashMap<String, String>(2);
        String str = "";
        Calendar quarterCalendar = Calendar.getInstance();
        quarterCalendar.setTime(time);
        switch (num) {
            case 1: {
                quarterCalendar.set(2, 3);
                quarterCalendar.set(5, 1);
                quarterCalendar.add(5, -1);
                str = sdf.format(quarterCalendar.getTime());
                m.put("start", str.substring(0, str.length() - 5) + "01-01");
                m.put("end", str);
                break;
            }
            case 2: {
                quarterCalendar.set(2, 6);
                quarterCalendar.set(5, 1);
                quarterCalendar.add(5, -1);
                str = sdf.format(quarterCalendar.getTime());
                m.put("start", str.substring(0, str.length() - 5) + "04-01");
                m.put("end", str);
                break;
            }
            case 3: {
                quarterCalendar.set(2, 9);
                quarterCalendar.set(5, 1);
                quarterCalendar.add(5, -1);
                str = sdf.format(quarterCalendar.getTime());
                m.put("start", str.substring(0, str.length() - 5) + "07-01");
                m.put("end", str);
                break;
            }
            case 4: {
                str = sdf.format(quarterCalendar.getTime());
                m.put("start", str.substring(0, str.length() - 5) + "10-01");
                m.put("end", str.substring(0, str.length() - 5) + "12-31");
                break;
            }
        }
        return m;
    }

    public static int compareDates(Date before, Date after) {
        Calendar bc = Calendar.getInstance();
        bc.setTime(before);
        Calendar ba = Calendar.getInstance();
        ba.setTime(after);
        return bc.compareTo(ba);
    }

    public static boolean comp(Date comp, Date now) {
        Calendar nCal = Calendar.getInstance();
        nCal.setTime(now);
        Calendar cCal = Calendar.getInstance();
        cCal.setTime(comp);
        if (cCal.get(1) > nCal.get(1)) {
            return true;
        }
        if (cCal.get(1) < nCal.get(1)) {
            return false;
        }
        if (cCal.get(2) > nCal.get(2)) {
            return true;
        }
        if (cCal.get(2) < nCal.get(2)) {
            return false;
        }
        return cCal.get(5) >= nCal.get(5);
    }

    public static List<Date> findDatesByCycles(Date start, List<Date> workDates, int cycles) {
        ArrayList<Date> results = new ArrayList<Date>();
        results.add(start);
        int i = 1;
        for (Date d : workDates) {
            if (i >= cycles) break;
            if (!d.after(start)) continue;
            results.add(d);
            ++i;
        }
        if (i < cycles) {
            return new ArrayList<Date>();
        }
        return results;
    }

    public static List<Date> findMonday(Date start, List<Date> workDates, int cycles) {
        Date end = DateUtil.weekEndByStartCycles(start, cycles);
        return DateUtil.findMonday(start, end, workDates);
    }

    public static List<Date> findCustomStart(Date start, List<Date> workdates, int period) {
        ArrayList<Date> results = new ArrayList<Date>();
        results.add(start);
        int i = 1;
        for (Date d : workdates) {
            if (i >= period) break;
            if (!d.after(start)) continue;
            results.add(d);
            ++i;
        }
        if (i < period) {
            return new ArrayList<Date>();
        }
        return results;
    }

    public static List<Date> findCustomStart(Date start, Date end, List<Date> workDates, int cycles) {
        ArrayList<Date> results = new ArrayList<Date>(15);
        if (cycles == 0) {
            return results;
        }
        List<Date> dates = DateUtil.findDates(start, end, workDates);
        if (dates.isEmpty()) {
            return results;
        }
        double cy = cycles;
        for (int i = 0; i < cycles; ++i) {
            double index = (double)dates.size() / cy * (double)i;
            results.add(dates.get((int)index));
        }
        return results;
    }

    public static List<Date> findDates(Date dStart, Date dEnd, List<Date> workDates) {
        Calendar cStart = Calendar.getInstance();
        cStart.setTime(dStart);
        cStart.add(5, -1);
        Calendar cEnd = Calendar.getInstance();
        cEnd.setTime(dEnd);
        cEnd.add(5, 1);
        ArrayList<Date> dates = new ArrayList<Date>();
        for (int i = 0; i < workDates.size(); ++i) {
            Date d = workDates.get(i);
            if (!d.after(cStart.getTime()) || !d.before(cEnd.getTime())) continue;
            dates.add(d);
        }
        return dates;
    }

    public static List<Date> findMonday(Date start, Date end, List<Date> workDates) {
        List<Date> dates = DateUtil.findDates(start, end, workDates);
        ArrayList<Date> mondays = new ArrayList<Date>();
        for (int i = 0; i < dates.size(); ++i) {
            if (i == 0) {
                mondays.add(dates.get(i));
                continue;
            }
            if (DateUtil.isSameWeek(dates.get(i - 1), dates.get(i))) continue;
            Date date = dates.get(i);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.add(5, 1);
            mondays.add(cal.getTime());
        }
        return mondays;
    }

    public static Date findTheWeekMonday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (cal.get(7) == 1) {
            cal.add(3, -1);
        }
        cal.set(7, 2);
        return cal.getTime();
    }

    public static Date getZeroTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static Date dateAddDays(Date date, int days) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(5, calendar.get(5) + days);
        return calendar.getTime();
    }

    public static Date findTheWeekMondayNext(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (cal.get(7) == 1) {
            cal.add(5, 1);
        } else {
            cal.set(7, 2);
        }
        return cal.getTime();
    }

    public static Date findTheWeekSunday(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (cal.get(7) != 1) {
            cal.add(5, 7);
        }
        cal.set(7, 1);
        return cal.getTime();
    }

    public static boolean isSameWeek(Date d1, Date d2) {
        Calendar cal1 = Calendar.getInstance();
        Calendar cal2 = Calendar.getInstance();
        cal1.setTime(d1);
        cal2.setTime(d2);
        int subYear = cal1.get(1) - cal2.get(1);
        return cal1.get(3) == cal2.get(3);
    }

    public static boolean isSameWeekAy(Date d2, Date d1, Calendar cal1) {
        int betweenDate = (int)((d2.getTime() - d1.getTime()) / 86400000L);
        if (betweenDate >= 1 && betweenDate <= 6) {
            return DateUtil.dayWeek(cal1, 7 - betweenDate);
        }
        return false;
    }

    public static boolean dayWeek(Calendar cal1, int i) {
        return cal1.get(7) <= i;
    }

    public static Date weekEndByStartCycles(Date start, int cycles) {
        Calendar c = Calendar.getInstance();
        c.setTime(start);
        c.set(7, 1);
        c.add(5, cycles * 7);
        return c.getTime();
    }

    public static Date weekEndByStartCycle(Date start, int cycles) {
        Calendar c = Calendar.getInstance();
        c.setTime(start);
        c.set(7, 2);
        c.add(5, (cycles - 1) * 7);
        return c.getTime();
    }

    public static Date nowZeroTime() {
        Calendar c = Calendar.getInstance();
        c.set(11, 0);
        c.set(12, 0);
        c.set(13, 0);
        c.set(14, 0);
        return c.getTime();
    }

    public static Date nowZeroTime(String cycleType) {
        Date date = DateUtil.nowZeroTime();
        if ("1".equals(cycleType)) {
            return DateUtil.findTheWeekMonday(date);
        }
        return date;
    }

    public static List<Date> getWorkDates(String cycleType, int day) {
        SimpleDateFormat sim = new SimpleDateFormat("yyyy-MM-dd");
        ArrayList<Date> list = new ArrayList<Date>();
        if ("0".equals(cycleType)) {
            try {
                String startForm = sim.format(Calendar.getInstance().getTime());
                Date start = sim.parse(startForm);
                if (!list.contains(start)) {
                    list.add(start);
                }
                Calendar startcal = Calendar.getInstance();
                startcal.setTime(start);
                for (int k = 1; k < day; ++k) {
                    startcal.add(5, 1);
                    Date date = startcal.getTime();
                    if (list.contains(date)) continue;
                    list.add(date);
                }
            }
            catch (ParseException e) {
                logger.warn((Throwable)e);
            }
        } else if ("1".equals(cycleType)) {
            try {
                String startForm = sim.format(Calendar.getInstance().getTime());
                Date start = sim.parse(startForm);
                if (!DateUtil.currentIsMonday(start)) {
                    start = DateUtil.findMondayCurrentWeek(start);
                }
                Calendar startcal = Calendar.getInstance();
                startcal.setTime(start);
                if (!list.contains(start)) {
                    list.add(start);
                }
                for (int k = 1; k <= (day - 1) * 7; ++k) {
                    startcal.add(5, 1);
                    Date date = startcal.getTime();
                    if (list.contains(date)) continue;
                    list.add(date);
                }
            }
            catch (ParseException e) {
                logger.warn((Throwable)e);
            }
        } else if ("3".equals(cycleType)) {
            try {
                String startForm = sim.format(Calendar.getInstance().getTime());
                Date start = sim.parse(startForm);
                start = DateUtil.findFirstCurrentMonth(start);
                Calendar startcal = Calendar.getInstance();
                startcal.setTime(start);
                if (!list.contains(start)) {
                    list.add(start);
                }
                for (int k = 1; k < day; ++k) {
                    startcal.add(2, 1);
                    Date date = startcal.getTime();
                    if (list.contains(date)) continue;
                    list.add(date);
                }
            }
            catch (ParseException e) {
                logger.warn((Throwable)e);
            }
        }
        return list;
    }

    public static Date findMondayCurrentWeek(Date currentDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        while (!DateUtil.currentIsMonday(currentDate)) {
            calendar.add(6, -1);
            currentDate = calendar.getTime();
        }
        return currentDate;
    }

    public static Date findFirstCurrentMonth(Date currentDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        calendar.set(5, 1);
        currentDate = calendar.getTime();
        return currentDate;
    }

    public static boolean currentIsMonthFirst(Date currentDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        if (calendar.get(5) == 1) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static boolean currentIsMonday(Date currentDate) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        if (calendar.get(7) == 2) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static List<Date> getBetweenDates(Date start, Date end) {
        ArrayList<Date> result = new ArrayList<Date>(16);
        if (start == null || end == null) {
            return result;
        }
        Calendar tempStart = Calendar.getInstance();
        tempStart.setTime(start);
        Calendar tempEnd = Calendar.getInstance();
        tempEnd.setTime(end);
        while (tempStart.before(tempEnd) || tempStart.equals(tempEnd)) {
            result.add(tempStart.getTime());
            tempStart.add(6, 1);
        }
        return result;
    }

    public static Date getMonthFirstXday(Date gdate, boolean cutone, int calenderdayemu) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(gdate);
        int month = cal.get(2) + 1;
        int year = cal.get(1);
        cal.set(1, year);
        cal.set(2, month - 1);
        int day = 1;
        cal.set(5, day);
        while (cal.get(7) != calenderdayemu) {
            cal.set(5, ++day);
        }
        if (cutone) {
            cal.add(5, -1);
        }
        return cal.getTime();
    }

    public static Date getDateWeekMonday(Date fdate, int x) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(fdate);
        int dayWeek = cal.get(7);
        if (1 == dayWeek) {
            cal.add(5, -1);
        }
        cal.setFirstDayOfWeek(2);
        int day = cal.get(7);
        day = day < x ? x - day - 7 : x - day;
        cal.add(5, day);
        return cal.getTime();
    }

    public static Date getDateFormat(Date fdate, int type) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        SimpleDateFormat sdfhms = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String fdateStr = sdf.format(fdate);
        Date parse = new Date();
        try {
            if (1 == type) {
                parse = sdfhms.parse(fdateStr + " 23:59:59");
            } else if (2 == type) {
                parse = sdfhms.parse(fdateStr + " 00:00:00");
            }
        }
        catch (ParseException e) {
            logger.warn((Throwable)e);
            return parse;
        }
        return parse;
    }

    public static Date getTheWeekStart(Date baseDate, int firstDay) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(baseDate);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        cal.setFirstDayOfWeek(firstDay);
        cal.set(7, 2);
        return cal.getTime();
    }

    public static boolean checkDateOverflow(Date baseDate) {
        if (maxDate != null && baseDate != null) {
            return maxDate.compareTo(baseDate) < 0;
        }
        return false;
    }

    private static List<Date> getMondaysOffset(List<Date> mondays, long offsetMillis) {
        ArrayList<Date> offsetMondays = new ArrayList<Date>(16);
        if (mondays == null) {
            return new ArrayList<Date>(16);
        }
        for (Date monday : mondays) {
            long time = 0L;
            if (monday != null) {
                time = monday.getTime();
            }
            offsetMondays.add(new Date(time + offsetMillis));
        }
        return offsetMondays;
    }

    public static List<Date> getMondaysOffset(List<Date> mondays, String dayOfWeek) {
        List<Object> result = null;
        result = mondays == null ? new ArrayList(16) : new ArrayList<Date>(mondays);
        result = result.stream().map(o -> DateUtil.getMondayOffset(o, dayOfWeek)).collect(Collectors.toList());
        return result;
    }

    public static Date getMondayOffset(Date monday, String dayOfWeek) {
        Calendar c = Calendar.getInstance();
        c.setTime(monday);
        if ("Mon".equalsIgnoreCase(dayOfWeek)) {
            c.set(7, 2);
        } else if ("Tue".equalsIgnoreCase(dayOfWeek)) {
            c.set(7, 3);
        } else if ("Wed".equalsIgnoreCase(dayOfWeek)) {
            c.set(7, 4);
        } else if ("Thu".equalsIgnoreCase(dayOfWeek)) {
            c.set(7, 5);
        } else if ("Fri".equalsIgnoreCase(dayOfWeek)) {
            c.set(7, 6);
        } else if ("Sat".equalsIgnoreCase(dayOfWeek)) {
            c.set(7, 7);
        } else if ("Sun".equalsIgnoreCase(dayOfWeek)) {
            c.set(7, 1);
        }
        return c.getTime();
    }

    public static Date[] curWeek(Date date) {
        Date[] dates = new Date[2];
        Calendar calendar = Calendar.getInstance();
        calendar.get(2);
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(7, 2);
        Date curWeekStart = calendar.getTime();
        calendar.set(7, 1);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date curWeekEnd = calendar.getTime();
        dates[0] = curWeekStart;
        dates[1] = curWeekEnd;
        return dates;
    }

    public static Date[] curMonth(Date date) {
        Date[] dates = new Date[2];
        Calendar calendar = Calendar.getInstance();
        calendar.get(2);
        calendar.setFirstDayOfWeek(2);
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        calendar.set(8, 1);
        calendar.set(7, 4);
        Date curMonthFirstWed = calendar.getTime();
        calendar.add(5, -2);
        Date curMonthStart = calendar.getTime();
        calendar.setTime(curMonthFirstWed);
        calendar.add(2, 1);
        calendar.set(8, 1);
        calendar.set(7, 4);
        calendar.add(5, -3);
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        Date curMonthEnd = calendar.getTime();
        dates[0] = curMonthStart;
        dates[1] = curMonthEnd;
        return dates;
    }

    public static Date getMonthOffset(Date day, String dayOfWeek) {
        Calendar c = Calendar.getInstance();
        c.setTime(day);
        if ("Mbeg".equalsIgnoreCase(dayOfWeek)) {
            c.set(5, 1);
        } else if ("Mmid".equalsIgnoreCase(dayOfWeek)) {
            c.set(5, 15);
        } else if ("Mend".equalsIgnoreCase(dayOfWeek)) {
            c.set(5, 1);
            c.add(2, 1);
            c.add(5, -1);
        }
        return c.getTime();
    }

    public static List<Date> getMonthOffset(List<Date> days, String dayOfWeek) {
        List<Date> result = new ArrayList<Date>(days);
        result = result.stream().map(o -> DateUtil.getMonthOffset(o, dayOfWeek)).collect(Collectors.toList());
        return result;
    }

    public static int getDayByDate(Date date, Date date2) {
        long time = date.getTime();
        long time2 = date2.getTime();
        long timeLong = time2 - time;
        return (int)(timeLong / 24L / 60L / 60L / 1000L);
    }

    public static String formatDateTime(Date date) {
        return DATETIME.get().format(date);
    }

    public static String formatDate(Date date) {
        return DATE.get().format(date);
    }

    static {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        try {
            maxDate = df.parse("3000-12-30");
        }
        catch (ParseException e) {
            logger.warn((Throwable)e);
        }
    }
}

