/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;

public class FastPhotoCalcTaskUtil {
    private static Log log = LogFactory.getLog(FastPhotoCalcTaskUtil.class);
    private static DBRoute pur = new DBRoute("scm");
    private static DateFormat df = new SimpleDateFormat("yyyyMMdd");
    private static SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
    private static String fcdatatSql = "fid, fbillno, fbillstatus, fcreatorid, fmodifierid, fenablestatus, fcreatetime, fmodifytime, fauditorid, fauditdate, forgid, ffcvrnnum, finvaldate ";
    private static String fcentrydatetSql = "fid,fseq, ffieldkey ,fdeliverycolumn,ftargetdate ";

    public static Set<Long> calcFastPhoto(Map<String, Set<String>> fpMap, String coverflag) {
        HashSet<Long> vidandpid = new HashSet<Long>(1000);
        block10: for (Map.Entry<String, Set<String>> sentry : fpMap.entrySet()) {
            String key;
            switch (key = sentry.getKey()) {
                case "0": {
                    vidandpid.addAll(FastPhotoCalcTaskUtil.queryFastPhoto("mds_forecastplandata", sentry.getValue(), coverflag));
                    continue block10;
                }
                case "1": {
                    vidandpid.addAll(FastPhotoCalcTaskUtil.queryFastPhoto("mds_mdsplandata", sentry.getValue(), coverflag));
                    continue block10;
                }
                case "2": {
                    vidandpid.addAll(FastPhotoCalcTaskUtil.queryFastPhoto("mds_dpsplandata", sentry.getValue(), coverflag));
                    continue block10;
                }
            }
            vidandpid.addAll(FastPhotoCalcTaskUtil.queryFastPhoto("mds_forecastplandata", sentry.getValue(), coverflag));
        }
        return vidandpid;
    }

    public static Boolean exitFastPhotoData(Map<String, Set<String>> fpMap, String type) {
        Map.Entry<String, Set<String>> sentry;
        Boolean flag = Boolean.TRUE;
        Iterator<Map.Entry<String, Set<String>>> iterator = fpMap.entrySet().iterator();
        while (iterator.hasNext() && !(flag = FastPhotoCalcTaskUtil.getFlagFastPhoto((sentry = iterator.next()).getValue())).booleanValue()) {
        }
        return flag;
    }

    public static Boolean getFlagFastPhoto(Set<String> idlist) {
        Boolean flag = Boolean.TRUE;
        try (DataSet queryMainData = DB.queryDataSet((String)"queryExitFCData", (DBRoute)pur, (String)FastPhotoCalcTaskUtil.getfcHeadSql(idlist));){
            if (queryMainData.isEmpty()) {
                flag = Boolean.FALSE;
            }
        }
        return flag;
    }

    public static Set<Long> queryFastPhoto(String entityName, Set<String> fpSet, String coverflag) {
        String fcHeadSql = FastPhotoCalcTaskUtil.getfcHeadSql(fpSet);
        ArrayList<String> fpIdList = new ArrayList<String>();
        int batchSize = 500;
        HashMap<String, List<String>> addHeadMap = new HashMap<String, List<String>>();
        int rr = 0;
        try (DataSet queryMainData = DB.queryDataSet((String)"queryFCData1", (DBRoute)pur, (String)fcHeadSql);){
            for (Row row : queryMainData) {
                if (++rr % batchSize == 0) {
                    addHeadMap.put(rr + "", fpIdList);
                    fpIdList = new ArrayList();
                    fpIdList.add(row.get("fid").toString());
                    continue;
                }
                fpIdList.add(row.get("fid").toString());
                if (rr < 999) continue;
                log.info("sycnFastPhoto---------\u5feb\u7167\u7248\u672c\u6570\u636e\u8d85\u8fc7999\uff0c\u53ea\u8ba1\u7b97\u524d999\u4e2a\u7248\u672c\u6570\u636e\u3002");
                break;
            }
            if (fpIdList.size() > 0) {
                addHeadMap.put(rr + "", fpIdList);
            }
        }
        return FastPhotoCalcTaskUtil.insertFastPhotoInfo(addHeadMap, coverflag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> insertFastPhotoInfo(Map<String, List<String>> addHeadMap, String coverflag) {
        HashSet<Long> vidandpid = new HashSet<Long>(1000);
        if (!addHeadMap.isEmpty()) {
            try (TXHandle h = TX.requiresNew((String)"deleteFastPhotoREF");){
                String deleteRef = "delete from T_MDS_FCDATATSENTRY_KZ_REF where 1=1 ";
                DB.execute((DBRoute)pur, (String)deleteRef);
            }
            DLock lock = DLock.create((String)"mds-fastphoto-global-mutex-lock");
            lock.lock();
            try (TXHandle h = TX.requiresNew((String)"insetFastPhotoInfo");){
                for (Map.Entry<String, List<String>> eMap : addHeadMap.entrySet()) {
                    List<String> idList = eMap.getValue();
                    Long res = FastPhotoCalcTaskUtil.getMaxRuleIndex();
                    if ("1".equals(coverflag) && idList.size() > 0) {
                        FastPhotoCalcTaskUtil.deleteTableInfo(idList);
                    }
                    if (idList.size() <= 0) continue;
                    FastPhotoCalcTaskUtil.insertRefData(idList, "T_MDS_FCDATATSENTRY");
                    FastPhotoCalcTaskUtil.insertRefData(idList, "T_MDS_DATEENTRY");
                    FastPhotoCalcTaskUtil.insertTableInfo(idList);
                    Set<Long> vidpiditem = FastPhotoCalcTaskUtil.updateRuleInfo(idList, res);
                    vidandpid.addAll(vidpiditem);
                }
            }
            finally {
                lock.unlock();
            }
        }
        return vidandpid;
    }

    private static Long getMaxRuleIndex() {
        Long res = (Long)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)"select max(frule) from t_mds_fcdatats_KZ", (Object[])new Object[0], rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
        return res;
    }

    private static void deleteTableInfo(List<String> idList) {
        HashMap<String, String> idMap = new HashMap<String, String>();
        String qursql = "select fid,ffcvrnnum from t_mds_fcdatats_KZ where ffcvrnnum in (select distinct ffcvrnnum  from t_mds_fcdatats where fid in  (" + String.join((CharSequence)",", idList) + ")) ";
        DataSet queryMainData = DB.queryDataSet((String)"queryFCkz", (DBRoute)pur, (String)qursql);
        Object object = null;
        try {
            for (Row row : queryMainData) {
                String fcvrnnum = row.get("ffcvrnnum").toString();
                Long fid = row.getLong("fid");
                if (idMap.containsKey(fcvrnnum)) {
                    String fidnum = (String)idMap.get(fcvrnnum);
                    Long parseLong = Long.valueOf(fidnum);
                    if (fid <= parseLong) continue;
                    idMap.put(fcvrnnum, fid.toString());
                    continue;
                }
                idMap.put(fcvrnnum, fid.toString());
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (queryMainData != null) {
                if (object != null) {
                    try {
                        queryMainData.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    queryMainData.close();
                }
            }
        }
        if (!idMap.isEmpty() && idMap.size() > 0) {
            ArrayList resultList = new ArrayList(idMap.size());
            for (Map.Entry entry : idMap.entrySet()) {
                resultList.add(entry.getValue());
            }
            String deletesql = "delete from T_MDS_FCDATATS_KZ where fid in (" + String.join((CharSequence)",", resultList) + ") ";
            String string = "delete from T_MDS_FCDATATSENTRY_KZ where fid in (" + String.join((CharSequence)",", resultList) + ") ";
            String deletesql3 = "delete from T_MDS_DATEENTRY_KZ where fid in (" + String.join((CharSequence)",", resultList) + ") ";
            DB.execute((DBRoute)pur, (String)deletesql);
            DB.execute((DBRoute)pur, (String)string);
            DB.execute((DBRoute)pur, (String)deletesql3);
        }
    }

    private static void insertTableInfo(List<String> idList) {
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)FastPhotoCalcTaskUtil.getInsertHeadSql(idList), (Object[])new Object[0]);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)FastPhotoCalcTaskUtil.getfcEntrySql(idList), (Object[])new Object[0]);
        DB.execute((DBRoute)DBRoute.of((String)"scm"), (String)FastPhotoCalcTaskUtil.getfcEntryDateSql(idList), (Object[])new Object[0]);
    }

    private static List<String> getinsertRef(List<String> idList, String tableName) {
        ArrayList<String> entryidList = new ArrayList<String>();
        StringBuilder sb = new StringBuilder("select fentryid from ");
        sb.append(tableName);
        sb.append(" where fid in(");
        sb.append(String.join((CharSequence)",", idList));
        sb.append(" )");
        try (DataSet queryMainData = DB.queryDataSet((String)"queryEntry1", (DBRoute)pur, (String)sb.toString());){
            for (Row row : queryMainData) {
                entryidList.add(row.getString("fentryid"));
            }
        }
        return entryidList;
    }

    private static void insertRefData(List<String> idList, String tableName) {
        List<String> fcdataRef = FastPhotoCalcTaskUtil.getinsertRef(idList, tableName);
        StringBuilder sb = new StringBuilder("select count(1) from ");
        sb.append(tableName);
        sb.append(" where fid in (");
        sb.append(String.join((CharSequence)",", idList));
        sb.append(")");
        Long count = (Long)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)sb.toString(), (Object[])new Object[0], rs -> {
            if (rs.next()) {
                return rs.getLong(1);
            }
            return 0L;
        });
        int batchSize = 2000;
        IDService idService = IDService.get();
        long[] genLongIds = idService.genLongIds(batchSize);
        ArrayList<Object> identry = new ArrayList<Object[]>();
        int inbatch = 0;
        int i = 0;
        while ((long)i < count) {
            Object[] pid = new Object[]{genLongIds[i - inbatch * batchSize], Long.valueOf(fcdataRef.get(i))};
            identry.add(pid);
            if ((i + 1) % batchSize == 0) {
                genLongIds = idService.genLongIds(batchSize);
                inbatch = (i + 1) / batchSize;
                FastPhotoCalcTaskUtil.insertRefData(identry);
                identry = new ArrayList();
            }
            ++i;
        }
        if (identry.size() > 0) {
            FastPhotoCalcTaskUtil.insertRefData(identry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Set<Long> updateRuleInfo(List<String> idList, Long res) {
        ArrayList<Long[]> updateRule = new ArrayList<Long[]>(idList.size());
        ArrayList<Long[]> updateId = new ArrayList<Long[]>(idList.size());
        HashSet<Long> vidandpid = new HashSet<Long>(100);
        Calendar cal = Calendar.getInstance();
        String format = "";
        DateFormat dateFormat = df;
        synchronized (dateFormat) {
            format = df.format(cal.getTime());
        }
        DecimalFormat g1 = new DecimalFormat("000");
        int startindex = 0;
        if (res.toString().indexOf(format) >= 0) {
            String ss = res.toString();
            String origindex = ss.substring(8, ss.length());
            startindex = Integer.parseInt(origindex);
        }
        for (int i = 0; i < idList.size(); ++i) {
            int sindex = i + startindex + 1;
            String startZeroStr = format + g1.format(sindex);
            Long startZero = Long.valueOf(startZeroStr);
            Long[] param = new Long[]{startZero, startZero, Long.valueOf(idList.get(i))};
            Long[] paramid = new Long[]{startZero, Long.valueOf(idList.get(i))};
            updateId.add(paramid);
            updateRule.add(param);
            vidandpid.add(startZero);
        }
        if (updateRule.size() > 0) {
            String updatesql = "update t_mds_fcdatats_KZ set frule=?,fid=? where fid = ? and frule=0 ";
            DB.executeBatch((DBRoute)pur, (String)updatesql, updateRule);
        }
        if (updateId.size() > 0) {
            String updateid1 = "update T_MDS_FCDATATSENTRY_KZ set fid=? where fid = ? ";
            DB.executeBatch((DBRoute)pur, (String)updateid1, updateId);
            String updateid2 = "update T_MDS_DATEENTRY_KZ set fid=? where fid = ? ";
            DB.executeBatch((DBRoute)pur, (String)updateid2, updateId);
        }
        return vidandpid;
    }

    private static String getfcHeadSql(Set<String> fpSet) {
        String join = String.join((CharSequence)",", fpSet);
        StringBuilder sb = new StringBuilder("select ");
        sb.append(fcdatatSql);
        sb.append(" from T_MDS_FCDATATS ");
        sb.append(" where ffcvrnnum in (");
        sb.append(join);
        sb.append(")");
        return sb.toString();
    }

    private static String getInsertHeadSql(List<String> fpSet) {
        String join = String.join((CharSequence)",", fpSet);
        StringBuilder sb = new StringBuilder("insert into  T_MDS_FCDATATS_KZ( ");
        sb.append(fcdatatSql);
        sb.append(",frule) select ");
        sb.append(fcdatatSql);
        sb.append(",0  from T_MDS_FCDATATS ");
        sb.append(" where fid in (");
        sb.append(join);
        sb.append(")");
        return sb.toString();
    }

    private static String getfcEntrySql(List<String> fpIdList) {
        String fcentrySql = FastPhotoCalcTaskUtil.buildFcEntrySql();
        String join = String.join((CharSequence)",", fpIdList);
        StringBuilder sb = new StringBuilder("insert into  T_MDS_FCDATATSENTRY_KZ( ");
        sb.append(fcentrySql);
        sb.append(",fentryid)select ");
        sb.append(fcentrySql);
        sb.append(" ,fkzid from T_MDS_FCDATATSENTRY inner join T_MDS_FCDATATSENTRY_KZ_REF on fentryid= forigid ");
        sb.append(" where fid in (");
        sb.append(join);
        sb.append(")");
        return sb.toString();
    }

    private static String buildFcEntrySql() {
        Set<String> fields = new HashSet<String>(256);
        fields.addAll(FastPhotoCalcTaskUtil.loadFieldAlias("mds_forecastplandata"));
        fields.addAll(FastPhotoCalcTaskUtil.loadFieldAlias("mds_mdsplandata"));
        fields.addAll(FastPhotoCalcTaskUtil.loadFieldAlias("mds_dpsplandata"));
        fields.addAll(FastPhotoCalcTaskUtil.loadFieldAlias("mds_mdsplandatamulti"));
        if (fields.size() > 0) {
            fields = fields.stream().filter(o -> !"fentryid".equalsIgnoreCase((String)o)).collect(Collectors.toSet());
            return String.join((CharSequence)",", fields);
        }
        return "fqty1,fqty2,fqty3,fqty4,fqty5,fqty6,fqty7,fqty8,fqty9,fqty10,fqty11,fqty12,fqty13,fqty14,fqty15,fqty16,fqty17,fqty18,fqty19,fqty20,fqty21,fqty22,fqty23,fqty24,fqty25,fqty26,fqty27,fqty28,fqty29,fqty30,fqty31,fqty32,fqty33,fqty34,fqty35,fqty36,fqty37,fqty38,fqty39,fqty40,fqty41,fqty42,fqty43,fqty44,fqty45,fqty46,fqty47,fqty48,fqty49,fqty50,fqty51,fqty52,fqty53,fqty54,fqty55,fqty56,fqty57,fqty58,fqty59,fqty60,fqty61,fqty62,fqty63,fqty64,fqty65,fqty66,fqty67,fqty68,fqty69,fqty70,fqty71,fqty72,fqty73,fqty74,fqty75,fqty76,fqty77,fqty78,fqty79,fqty80,fqty81,fqty82,fqty83,fqty84,fqty85,fqty86,fqty87,fqty88,fqty89,fqty90,fqty91,fqty92,fqty93,fqty94,fqty95,fqty96,fqty97,fqty98,fqty99,fqty100,fqty101,fqty102,fqty103,fqty104,fqty105,fqty106,fqty107,fqty108,fqty109,fqty110,fqty111,fqty112,fqty113,fqty114,fqty115,fqty116,fqty117,fqty118,fqty119,fqty120,fqty121,fqty122,fqty123,fqty124,fqty125,fqty126,fqty127,fqty128,fqty129,fqty130,fqty131,fqty132,fqty133,fqty134,fqty135,fqty136,fqty137,fqty138,fqty139,fqty140,fqty141,fqty142,fqty143,fqty144,fqty145,fqty146,fqty147,fqty148,fqty149,fqty150,fid,fseq,fmaterialid,fbaseunitid,fprodorg,fplangp,fremark,freceive1,freceive2,freceive3,freceive4,freceive5,freceive6,freceive7,freceive8,freceive9,freceive10,fofferingedit,flevel1edit,fmdsuser,feditdate,feditcreatedate,fentrymodifier,fedituser,fspdt";
    }

    private static Set<String> loadFieldAlias(String entityNumber) {
        HashSet<String> fields = new HashSet<String>(256);
        MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        IDataEntityProperty property = mainEntityType.findProperty("entryentity");
        if (property instanceof EntryProp) {
            EntryProp entryProp = (EntryProp)property;
            DataEntityPropertyCollection entryProperties = entryProp._collectionItemPropertyType.getProperties();
            for (IDataEntityProperty pro : entryProperties) {
                String alias;
                if (pro instanceof MulBasedataProp || !StringUtils.isNotEmpty((CharSequence)(alias = pro.getAlias()))) continue;
                fields.add(alias);
            }
        }
        return fields;
    }

    private static void insertRefData(List<Object[]> identry) {
        String insertSeqSql = "insert into T_MDS_FCDATATSENTRY_KZ_REF (fkzid,forigid)values(?,?)";
        DB.executeBatch((DBRoute)DBRoute.of((String)"scm"), (String)insertSeqSql, identry);
    }

    private static String getfcEntryDateSql(List<String> fpIdList) {
        String join = String.join((CharSequence)",", fpIdList);
        StringBuilder sb = new StringBuilder("insert into  T_MDS_DATEENTRY_KZ( ");
        sb.append(fcentrydatetSql);
        sb.append(",fentryid)select ");
        sb.append(fcentrydatetSql);
        sb.append(" ,fkzid from T_MDS_DATEENTRY inner join T_MDS_FCDATATSENTRY_KZ_REF on fentryid= forigid ");
        sb.append(" where fid in (");
        sb.append(join);
        sb.append(")");
        return sb.toString();
    }

    public static Set<String> validVrds(Set<Long> setIds) {
        DynamicObjectCollection dynamicVrds;
        Set emptyDataId;
        QFilter qFilter = new QFilter("fcvrnnum.id", "in", setIds);
        String selectProperties = "id, fcvrnnum.id, fcvrnnum.number, entryentity, dateentity.fieldkey";
        DynamicObject[] dynamicObjects = BusinessDataServiceHelper.load((String)"mds_plandata", (String)selectProperties, (QFilter[])new QFilter[]{qFilter});
        HashSet<Long> fcvrId = new HashSet<Long>(16);
        HashSet<String> vrdNumbers = new HashSet<String>(16);
        if (dynamicObjects != null) {
            for (DynamicObject dynamicObject : dynamicObjects) {
                fcvrId.add(dynamicObject.getLong("fcvrnnum.id"));
                String number = dynamicObject.getString("fcvrnnum.number");
                DynamicObjectCollection entryentity = dynamicObject.getDynamicObjectCollection("entryentity");
                if (entryentity == null || entryentity.isEmpty()) {
                    vrdNumbers.add(number);
                    continue;
                }
                DynamicObjectCollection dateentity = dynamicObject.getDynamicObjectCollection("dateentity");
                if (dateentity == null || dateentity.isEmpty()) {
                    vrdNumbers.add(number);
                    continue;
                }
                boolean fieldkey = dateentity.stream().noneMatch(t -> t.getString("fieldkey").contains("qty"));
                if (!fieldkey) continue;
                vrdNumbers.add(number);
            }
        }
        if ((emptyDataId = setIds.stream().filter(f -> !fcvrId.contains(f)).collect(Collectors.toSet())) != null && !emptyDataId.isEmpty() && (dynamicVrds = QueryServiceHelper.query((String)"mds_vrds", (String)"id, number", (QFilter[])new QFilter[]{new QFilter("id", "in", emptyDataId)})) != null && !dynamicVrds.isEmpty()) {
            Set numbers = dynamicVrds.stream().map(m -> m.getString("number")).collect(Collectors.toSet());
            vrdNumbers.addAll(numbers);
        }
        return vrdNumbers;
    }

    public static DynamicObject createPhotoLogEntry(DynamicObject bill, Set<Long> ids, Set<Long> vidandpid) {
        Map mpids = new HashMap(1000);
        if (!vidandpid.isEmpty()) {
            HashSet<String> arids = new HashSet<String>(1000);
            for (Long itemid : vidandpid) {
                arids.add(String.valueOf(itemid));
            }
            StringBuilder sb = new StringBuilder("select ffcvrnnum,fid  from t_mds_fcdatats_kz ");
            sb.append(" where fid in (");
            sb.append(String.join((CharSequence)",", arids));
            sb.append(")");
            mpids = (Map)DB.query((DBRoute)DBRoute.of((String)"scm"), (String)sb.toString(), (Object[])new Object[0], rs -> {
                HashMap<Long, Long> ret = new HashMap<Long, Long>(10000);
                while (rs.next()) {
                    ret.put(rs.getLong(1), rs.getLong(2));
                }
                return ret;
            });
        }
        DynamicObjectCollection entrys = bill.getDynamicObjectCollection("entryentity");
        DynamicObjectType sType = entrys.getDynamicObjectType();
        for (Long id : ids) {
            DynamicObject entry = new DynamicObject(sType);
            entry.set("seq", (Object)(entrys.size() + 1));
            Long photoid = (Long)mpids.get(id);
            if (photoid != null) {
                entry.set("bkentryid", (Object)photoid);
            }
            entry.set("verid", (Object)id);
            entrys.add((Object)entry);
        }
        return bill;
    }
}

