/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.executor.JobClient;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.mmc.mds.common.util.CalcuColumns;

public class FastPhotoUtils {
    public static final String FASTPHOTOSET_TASK = "kd.mmc.mds.formplugin.basedata.task.FastPhotoSetTask";
    public static final String FASTPHOTO_TASK = "kd.mmc.mds.formplugin.basedata.task.FastPhotoTask";
    public static final String CO_BASENUMBER = "number";
    public static final String CO_JOBID = "jobid";
    public static final String CO_PLANID = "planid";
    public static final String CO_RUNNINGTYPE = "runningtype";
    public static final String CO_FASTPHOTOTYPE = "fastphototype";
    public static final String CO_REQTYPE = "reqtype";
    public static final String CO_REPEAT = "repeat";
    public static final String CO_REPEATTYPE = "repeattype";
    public static final String CO_NUMBER = "billno";
    public static final String CO_LOSEDATE = "losedate";
    public static final String CO_PREDTIME = "predtime";
    public static final String RMONTH = "1";
    public static final String RTDELAY = "1";
    public static final String RTIMD = "0";
    public static final int RUNNING = 1;
    public static final String RWEEK = "0";
    public static final int SAVE = 0;
    public static final String CO_CYCLETYPED = "cycletyped";
    public static final String CO_DAYSOFMON = "daysofmon";
    public static final String CO_DAYSOFWEEK = "daysofweek";

    public static String getTaskId(String className) {
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)CO_BASENUMBER, (QFilter[])new QFilter[]{new QFilter("classname", "=", (Object)className)});
        if (taskname == null) {
            return null;
        }
        return String.valueOf(taskname.getPkValue());
    }

    public static void runImediatly(Set<String> pkValueList) {
        Iterator<String> iterator = pkValueList.iterator();
        HashMap<String, Object> pages = new HashMap<String, Object>();
        pages.put("coverflag", "0");
        pages.put(CO_FASTPHOTOTYPE, "0");
        JobInfo jobInfo = new JobInfo();
        String jobId = iterator.next();
        jobInfo.setId(jobId);
        jobInfo.setName(ResManager.loadKDString((String)"\u5feb\u7167\u4efb\u52a1", (String)"FastPhotoUtils_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        boolean connc = true;
        jobInfo.setRunConcurrently(connc);
        String className = FastPhotoUtils.getTaskId(FASTPHOTO_TASK);
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setTaskClassname(FASTPHOTO_TASK);
        jobInfo.setAppId("mds");
        pages.put(CO_NUMBER, pkValueList);
        jobInfo.setParams(pages);
        JobClient.dispatch((JobInfo)jobInfo);
    }

    public static void runFastPhotoImediatly(Map<String, Object> csetting) {
        Set idList = (Set)csetting.get(CO_REQTYPE);
        HashMap<String, Object> pages = new HashMap<String, Object>();
        pages.put(CO_REPEAT, Boolean.FALSE);
        JobInfo jobInfo = new JobInfo();
        Iterator iterator = idList.iterator();
        String jobId = (String)iterator.next();
        jobInfo.setId(jobId);
        jobInfo.setName(ResManager.loadKDString((String)"\u5feb\u7167\u4efb\u52a1", (String)"FastPhotoUtils_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        boolean connc = true;
        jobInfo.setRunConcurrently(connc);
        jobInfo.setTaskClassname(FASTPHOTOSET_TASK);
        jobInfo.setAppId("mds");
        jobInfo.setRunByLang(Lang.get());
        Object fastphototype = csetting.get(CO_FASTPHOTOTYPE);
        Object coverflag = csetting.get("coverflag");
        pages.put(CO_FASTPHOTOTYPE, fastphototype.toString());
        pages.put(CO_NUMBER, idList);
        pages.put("coverflag", coverflag);
        jobInfo.setParams(pages);
        JobClient.dispatch((JobInfo)jobInfo);
    }

    public static String createJob(Map<String, Object> csetting) {
        JobInfo jobInfo = new JobInfo();
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        jobInfo.setTaskClassname(FASTPHOTOSET_TASK);
        jobInfo.setJobType(JobType.BIZ);
        HashMap<String, Object> scheduleParams = new HashMap<String, Object>();
        Set idList = (Set)csetting.get(CO_REQTYPE);
        Iterator iterator = idList.iterator();
        String reqId = (String)iterator.next();
        String jobNum = "JOB" + reqId;
        Calendar scal = Calendar.getInstance();
        String format = df.format(scal.getTime());
        jobInfo.setName(ResManager.loadKDString((String)"\u5feb\u7167\u4efb\u52a1", (String)"FastPhotoUtils_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        jobInfo.setNumber(jobNum + format);
        Object fastphototype = csetting.get(CO_FASTPHOTOTYPE);
        scheduleParams.put(CO_FASTPHOTOTYPE, fastphototype.toString());
        scheduleParams.put(CO_NUMBER, idList);
        Object coverflag = csetting.get("coverflag");
        scheduleParams.put("coverflag", coverflag);
        jobInfo.setParams(scheduleParams);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunConcurrently(true);
        String className = FastPhotoUtils.getTaskId(FASTPHOTOSET_TASK);
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setAppId("mds");
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createJob", new Object[]{jobInfo});
        return String.valueOf(obj);
    }

    public static String createPlan(String jobId, Map<String, Object> csetting) {
        PlanInfo planInfo = new PlanInfo();
        Set idList = (Set)csetting.get(CO_REQTYPE);
        Iterator iterator = idList.iterator();
        String reqId = (String)iterator.next();
        String fastphototype = (String)csetting.get(CO_FASTPHOTOTYPE);
        String rt = (String)csetting.get(CO_RUNNINGTYPE);
        Object losd = csetting.get(CO_LOSEDATE);
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMddHHmmss");
        Calendar scal = Calendar.getInstance();
        String format = df.format(scal.getTime());
        String planNum = "PLAN-" + fastphototype + reqId + format;
        planInfo.setNumber(planNum);
        planInfo.setJobId(jobId);
        FastPhotoUtils.setLostdate(planInfo, (Date)losd);
        Integer pred = (Integer)csetting.get(CO_PREDTIME);
        Calendar starttime = CalcuColumns.getStarttime(pred, rt);
        planInfo.setStartTime(starttime);
        planInfo.setName(String.format(ResManager.loadKDString((String)"\u5feb\u7167%1$s%2$s%3$s\u3002", (String)"FastPhotoUtils_3", (String)"mmc-mds-common", (Object[])new Object[0]), fastphototype, reqId, format));
        String repeattype = (String)csetting.get(CO_REPEATTYPE);
        Boolean isrept = (Boolean)csetting.get(CO_REPEAT);
        if (!isrept.booleanValue()) {
            planInfo.setRepeatMode(RepeatModeEnum.NONE);
        } else if (CalcuColumns.isWeek(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
            Object daysExp = csetting.get(CO_DAYSOFWEEK);
            String join = String.join((CharSequence)",", (List)daysExp);
            planInfo.setWeekdaysExp(join);
            planInfo.setPeriod(1);
        } else {
            planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
            Object monthExp = csetting.get(CO_DAYSOFMON);
            String joinm = String.join((CharSequence)",", (List)monthExp);
            planInfo.setDaysExp(joinm);
            planInfo.setPeriod(1);
        }
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createPlan", new Object[]{planInfo});
        return String.valueOf(obj);
    }

    public static void setLostdate(PlanInfo planInfo, Date lostdate) {
        Calendar lc = Calendar.getInstance();
        if (lostdate == null) {
            lc.set(1, 2099);
            lc.set(2, 11);
            lc.set(5, 31);
        } else {
            lc.setTime(lostdate);
            lc.add(5, 1);
        }
        planInfo.setEndTime(lc);
    }
}

