/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.MessageTypes;
import kd.bos.form.operate.MutexHelper;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class ForecastCalUtil {
    public static final String CO_BILLNO = "billno";
    public static final String CO_NUMBER = "number";
    public static final String CO_NAME = "name";
    public static final String CO_SCHEMEID = "schemeid";
    public static final String CO_REPEAT = "repeat";
    public static final String SCH_TASKDEFINE = "sch_taskdefine";
    public static final String CO_TASK_DEFINE = "number";
    public static final String BTNSAVE = "bar_save";
    public static final String MDS_FORECASTCAL = "mds_forecastcal";
    public static final String CO_FCALPLAN = "fcalplan";
    public static final String MDS_FORECASTCALPLAN = "mds_forecastcalplan";
    public static final String CO_OUTLOOKPERIOD = "outlookperiod";
    public static final String CO_CHANGEMOD = "mod";
    public static final String CO_CHANGEWAY = "changeway";
    public static final String CO_SOURCETYPE = "sourcetype";
    public static final String CO_CALPLANID = "calplanid";
    public static final String CO_PREDVERSION = "predversion";
    public static final String FORECAST = "forecast";
    public static final String MDS_VRDS = "mds_vrds";
    public static final String MDS_CORL = "mds_corl";
    public static final String CO_LOSEDATE = "losedate";
    public static final String CO_CYTYPE = "cytype";
    public static final String CO_ENABLE = "enable";
    public static final String CO_CALSTATUS = "calstatus";
    public static final String CO_STATUS = "status";
    public static final String MDS_DATA = "mds_data";
    public static final String CO_ENABLESTATUS = "enablestatus";
    public static final String CO_FCVRNNUM = "fcvrnnum";
    public static final String CO_INVALDATE = "invaldate";
    public static final String CO_BILLSTATUS = "billstatus";
    public static final String CO_FCVRNNUM_NUMBER = "fcvrnnum.number";
    public static final String CO_SRCVRNNUM = "srcvrnnum";
    public static final String CO_DAYSOFMON = "daysofmon";
    public static final String CO_DAYSOFWEEK = "daysofweek";
    public static final String CO_REPEATTYPE = "repeattype";
    public static final String CO_RUNNINGTYPE = "runningtype";
    public static final String CO_PREDTIME = "predtime";
    public static final String CO_JOBID = "jobid";
    public static final String CO_PLANID = "planid";
    public static final String CO_EXE = "tasktype";
    public static final String RWEEK = "0";
    public static final int HMS = 60;
    public static final String RTIMD = "0";
    public static final String LOCALIP = "127.0.0.1";
    public static final String TASK_CLASS_NAME = "kd.mmc.mds.formplugin.basedata.task.ForecastCalRunningTask";

    public static boolean createLock(String ent, String oprKey, String id) {
        return MutexHelper.require((String)ent, (Object)id, (String)oprKey, (boolean)true, (StringBuilder)new StringBuilder(ResManager.loadKDString((String)"\u6570\u636e\u88ab\u9501\u5b9a\u3002", (String)"ForecastCalUtil_0", (String)"mmc-mds-common", (Object[])new Object[0])));
    }

    public static void releaseLock(String ent, String oprKey, String id) {
        MutexHelper.release((String)ent, (String)oprKey, (String)id);
    }

    public static boolean isEmpty(Object[] obj) {
        return obj == null || obj.length < 1;
    }

    public static boolean isWeek(Map<String, Object> csetting) {
        String week = (String)csetting.get(CO_REPEATTYPE);
        return StringUtils.equals((CharSequence)"0", (CharSequence)week) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static boolean isWeek(String rweek) {
        return StringUtils.equals((CharSequence)"0", (CharSequence)rweek) ? Boolean.TRUE : Boolean.FALSE;
    }

    public static int compare(Date d1, Date d2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        if (ForecastCalUtil.bigger(c1, c2, 1)) {
            return 1;
        }
        if (ForecastCalUtil.lower(c1, c2, 1)) {
            return -1;
        }
        if (ForecastCalUtil.bigger(c1, c2, 2)) {
            return 1;
        }
        if (ForecastCalUtil.lower(c1, c2, 2)) {
            return -1;
        }
        if (ForecastCalUtil.bigger(c1, c2, 5)) {
            return 1;
        }
        if (ForecastCalUtil.lower(c1, c2, 5)) {
            return -1;
        }
        return 0;
    }

    private static boolean bigger(Calendar c1, Calendar c2, int c) {
        return c1.get(c) > c2.get(c);
    }

    private static boolean lower(Calendar c1, Calendar c2, int c) {
        return c1.get(c) < c2.get(c);
    }

    public static void setLostdate(PlanInfo planInfo, Date lostdate) {
        Calendar lc = Calendar.getInstance();
        if (lostdate == null) {
            lc.set(1, 2099);
            lc.set(2, 11);
            lc.set(5, 31);
        } else {
            lc.setTime(lostdate);
            lc.add(5, 1);
        }
        planInfo.setEndTime(lc);
    }

    public static String createExp(String key, Map<String, Object> m) {
        List days = (List)m.get(key);
        CharSequence[] array = days.toArray(new String[days.size()]);
        return String.join((CharSequence)",", array);
    }

    public static JobInfo initJobInfo(DynamicObject task, int calsType, String uniquekey) {
        String reqId = task.getString(uniquekey);
        Boolean repeat = task.getBoolean(CO_REPEAT);
        String jobNum = "JOB-" + reqId;
        JobInfo jobInfo = new JobInfo();
        HashMap<String, Object> params = new HashMap<String, Object>();
        DynamicObject obj = task.getDynamicObject(CO_FCALPLAN);
        params.put(CO_CALPLANID, obj.getPkValue());
        if (repeat == null || !repeat.booleanValue()) {
            params.put(CO_REPEAT, Boolean.FALSE);
        } else {
            params.put(CO_REPEAT, Boolean.TRUE);
        }
        params.put(CO_EXE, calsType);
        params.put(CO_SCHEMEID, task.getPkValue());
        jobInfo.setId(jobNum);
        jobInfo.setNumber(jobNum);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8fd0\u7b97\u4f5c\u4e1a\uff1a%s", (String)"ForecastCalUtil_1", (String)"mmc-mds-common", (Object[])new Object[0]), reqId));
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setRunConcurrently(true);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        String className = ForecastCalUtil.getTaskId();
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setTaskClassname(TASK_CLASS_NAME);
        jobInfo.setAppId("mds");
        jobInfo.setParams(params);
        return jobInfo;
    }

    public static PlanInfo initPlanInfo(String jobId, DynamicObject task) {
        PlanInfo planInfo = new PlanInfo();
        String reqId = task.getString("number");
        String rt = task.getString(CO_RUNNINGTYPE);
        Date losd = task.getDate(CO_LOSEDATE);
        String planNum = "FORECAST-" + reqId;
        planInfo.setNumber(planNum);
        planInfo.setJobId(jobId);
        ForecastCalUtil.setLostdate(planInfo, losd);
        Integer pred = task.getInt(CO_PREDTIME);
        Calendar starttime = ForecastCalUtil.getStarttime(pred, rt);
        planInfo.setStartTime(starttime);
        planInfo.setName(String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8fd0\u7b97\u8ba1\u5212\uff1a%s", (String)"ForecastCalUtil_2", (String)"mmc-mds-common", (Object[])new Object[0]), reqId));
        task.set(CO_JOBID, (Object)jobId);
        String repeattype = task.getString(CO_REPEATTYPE);
        if (rt.equals("0")) {
            task.set(CO_CALSTATUS, (Object)CalcStatus.RUNNING.getCode());
        } else {
            task.set(CO_CALSTATUS, (Object)CalcStatus.WAIT.getCode());
        }
        task.set(CO_CALSTATUS, (Object)Billstatus.PLAN.getCode());
        if (!task.getBoolean(CO_REPEAT)) {
            planInfo.setRepeatMode(RepeatModeEnum.NONE);
            return planInfo;
        }
        if (ForecastCalUtil.isWeek(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
            String daysExp = task.getString(CO_DAYSOFWEEK);
            planInfo.setWeekdaysExp(daysExp);
            planInfo.setPeriod(1);
        } else {
            planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
            String daysExp = task.getString(CO_DAYSOFMON);
            planInfo.setDaysExp(daysExp);
            planInfo.setPeriod(1);
        }
        return planInfo;
    }

    public static void runImediatly(DynamicObject dynamicObject, IFormView fv, Object schemeid, int calctype) {
        DynamicObject schemebill;
        if (dynamicObject == null) {
            return;
        }
        String billNo = dynamicObject.getString(CO_BILLNO);
        JobInfo jobInfo = new JobInfo();
        jobInfo.setId(billNo);
        jobInfo.setName(ResManager.loadKDString((String)"\u9884\u6d4b\u8fd0\u7b97\u4f5c\u4e1a", (String)"ForecastCalUtil_3", (String)"mmc-mds-common", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunConcurrently(true);
        String className = ForecastCalUtil.getTaskId();
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setTaskClassname(TASK_CLASS_NAME);
        jobInfo.setAppId("mds");
        if (schemeid != null && (schemebill = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)MDS_FORECASTCAL)) != null) {
            schemebill.set(CO_STATUS, (Object)Billstatus.PLAN.getCode());
            schemebill.set(CO_CALSTATUS, (Object)CalcStatus.RUNNING.getCode());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemebill});
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CO_REPEAT, Boolean.FALSE);
        params.put(CO_CALPLANID, dynamicObject.getPkValue());
        params.put(CO_SCHEMEID, schemeid);
        params.put(CO_EXE, calctype);
        jobInfo.setParams(params);
        JobClient.dispatch((JobInfo)jobInfo);
        if (fv != null) {
            fv.setEnable(Boolean.FALSE, new String[]{BTNSAVE});
            fv.showMessage(ResManager.loadKDString((String)"\u8ba1\u7b97\u4efb\u52a1\u5df2\u5206\u53d1\u6210\u529f\uff0c\u8bf7\u524d\u5f80\u5217\u8868\u754c\u9762\u67e5\u770b\u3002", (String)"ForecastCalUtil_4", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
    }

    public static String getTaskId() {
        QFilter filter = new QFilter("classname", "=", (Object)TASK_CLASS_NAME);
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)SCH_TASKDEFINE, (String)"number", (QFilter[])new QFilter[]{filter});
        if (taskname == null) {
            return null;
        }
        return String.valueOf(taskname.getPkValue());
    }

    public static Calendar getStarttime(int pred, String rt) {
        Calendar c = Calendar.getInstance();
        c.setTimeInMillis(System.currentTimeMillis());
        if (StringUtils.equals((CharSequence)"0", (CharSequence)rt)) {
            c.add(13, 60);
            return c;
        }
        int h = pred / 60 / 60;
        int m = pred / 60 % 60;
        int s = pred % 60;
        if (ForecastCalUtil.beforeNow(h, m, s)) {
            c.add(5, 1);
            c.set(11, h);
            c.set(12, m);
            c.set(13, s);
            return c;
        }
        c.set(11, h);
        c.set(12, m);
        c.set(13, s);
        return c;
    }

    public static boolean beforeNow(int h, int m, int s) {
        Calendar now = Calendar.getInstance();
        now.setTimeInMillis(System.currentTimeMillis());
        Calendar pred = Calendar.getInstance();
        pred.set(1, now.get(1));
        pred.set(2, now.get(2));
        pred.set(5, now.get(5));
        pred.set(11, h);
        pred.set(12, m);
        pred.set(13, s);
        return pred.compareTo(now) > 0 ? Boolean.FALSE : Boolean.TRUE;
    }

    public static Map<String, Object> getSetParamsByScheme(DynamicObject scheme, String hidden) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("hidden", hidden);
        params.put("id", scheme.getPkValue());
        params.put(CO_DAYSOFWEEK, scheme.get(CO_DAYSOFWEEK));
        params.put(CO_DAYSOFMON, scheme.get(CO_DAYSOFMON));
        params.put(CO_RUNNINGTYPE, scheme.get(CO_RUNNINGTYPE));
        params.put(CO_REPEATTYPE, scheme.get(CO_REPEATTYPE));
        params.put(CO_REPEAT, scheme.get(CO_REPEAT));
        params.put(CO_PREDTIME, scheme.get(CO_PREDTIME) == null ? Integer.valueOf(-1) : scheme.get(CO_PREDTIME));
        params.put(CO_LOSEDATE, scheme.get(CO_LOSEDATE));
        params.put(CO_STATUS, scheme.get(CO_STATUS));
        return params;
    }

    public static void showStopTip(IFormView view, List<Map<String, String>> ops, DynamicObject[] bill) {
        if (bill.length == 1) {
            if (ops.isEmpty()) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u7ec8\u6b62\u6210\u529f\u3002", (String)"ForecastCalUtil_5", (String)"mmc-mds-common", (Object[])new Object[0]));
            } else {
                StringBuilder title = new StringBuilder();
                for (Map.Entry<String, String> en : ops.get(0).entrySet()) {
                    title.append(en.getKey()).append("\uff1a").append(en.getValue());
                    view.showTipNotification(title.toString());
                }
            }
        } else {
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f\u7ec8\u6b62%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"ForecastCalUtil_12", (String)"mmc-mds-common", (Object[])new Object[0]), bill.length, bill.length - ops.size(), ops.size());
            StringBuilder msg = new StringBuilder(500);
            for (Map<String, String> m : ops) {
                for (Map.Entry<String, String> e : m.entrySet()) {
                    msg.append(e.getKey());
                    msg.append('\uff1a');
                    msg.append(e.getValue());
                    msg.append('\n');
                }
            }
            view.showMessage(title, msg.toString(), MessageTypes.Default);
        }
    }

    public static void showCalcErr(IFormView view, Map<String, String> ops, int size) {
        if (size == 1) {
            if (ops.isEmpty()) {
                view.showSuccessNotification(ResManager.loadKDString((String)"\u8fd0\u7b97\u4efb\u52a1\u5206\u53d1\u6210\u529f\uff0c\u8bf7\u5230\u5217\u8868\u754c\u9762\u67e5\u770b\u3002", (String)"ForecastCalUtil_10", (String)"mmc-mds-common", (Object[])new Object[0]));
            } else {
                for (Map.Entry<String, String> en : ops.entrySet()) {
                    view.showTipNotification(en.getKey() + "\uff1a" + en.getValue() + "\u3002");
                }
            }
        } else {
            String title = String.format(ResManager.loadKDString((String)"\u5171%1$s\u5f20\u5355\u636e\uff0c\u6210\u529f%2$s\u5f20\uff0c\u5931\u8d25%3$s\u5f20\u3002", (String)"ForecastCalUtil_13", (String)"mmc-mds-common", (Object[])new Object[0]), size, size - ops.size(), ops.size());
            StringBuilder msg = new StringBuilder(500);
            for (Map.Entry<String, String> m : ops.entrySet()) {
                msg.append(m.getKey());
                msg.append('\uff1a');
                msg.append(m.getValue());
                msg.append('\n');
            }
            view.showMessage(title, msg.toString(), MessageTypes.Default);
        }
    }

    public static enum CalcStatus {
        ERROR("D"),
        FINISH("C"),
        RUNNING("B"),
        STOP("E"),
        WAIT("A");

        private String code;

        private CalcStatus(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }

    public static enum Billstatus {
        CLOSE("C"),
        PLAN("B"),
        SAVE("A");

        private String code;

        private Billstatus(String code) {
            this.code = code;
        }

        public String getCode() {
            return this.code;
        }
    }
}

