/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.setoff.SetOffCommonUtil;
import kd.mmc.mds.common.util.CalcuColumns;

public class MDSCreatePlanTask {
    private static final Log logger = LogFactory.getLog(MDSCreatePlanTask.class);
    private static final String[] MONTHDAY = new String[]{"m1", "m2", "m3", "m4", "m5", "m6", "m7", "m8", "m9", "m10", "m11", "m12", "m13", "m14", "m15", "m16", "m17", "m18", "m19", "m20", "m21", "m22", "m23", "m24", "m25", "m26", "m27", "m28", "m29", "m30", "m31"};
    private static final String[] WEEKDAY = new String[]{"day7", "day1", "day2", "day3", "day4", "day5", "day6"};
    private String baseclass = "";
    private String jobnum = "";
    private String plannum = "";
    private String jobname = "";
    private String planname = "";
    private String jobid = "";
    private String planid = "";
    private JSONObject SetObject;
    Map<String, Object> scheduleParams = new HashMap<String, Object>(10);

    public String getJobname() {
        return this.jobname;
    }

    public final void setJobname(String jobname) {
        this.jobname = jobname;
    }

    public String getPlanname() {
        return this.planname;
    }

    public final void setPlanname(String planname) {
        this.planname = planname;
    }

    public String getJobid() {
        return this.jobid;
    }

    public void setJobid(String jobid) {
        this.jobid = jobid;
    }

    public String getPlanid() {
        return this.planid;
    }

    public void setPlanid(String planid) {
        this.planid = planid;
    }

    public String getJobnum() {
        return this.jobnum;
    }

    public final void setJobnum(String jobnum) {
        this.jobnum = jobnum;
    }

    public String getPlannum() {
        return this.plannum;
    }

    public final void setPlannum(String plannum) {
        this.plannum = plannum;
    }

    public JSONObject getSetObject() {
        return this.SetObject;
    }

    public final void setSetObject(JSONObject setObject) {
        this.SetObject = setObject;
    }

    public Map<String, Object> getScheduleParams() {
        return this.scheduleParams;
    }

    public final void setScheduleParams(Map<String, Object> scheduleParams) {
        this.scheduleParams = scheduleParams;
    }

    public String getBaseclass() {
        return this.baseclass;
    }

    public final void setBaseclass(String baseclass) {
        this.baseclass = baseclass;
    }

    public MDSCreatePlanTask(String taskbaseclass, String taskjobnum, String taskjobname, String taskplannum, String taskplanname, JSONObject taskSetObject, Map<String, Object> taskParams) {
        this.setBaseclass(taskbaseclass);
        this.setJobnum(taskjobnum);
        this.setJobname(taskjobname);
        this.setPlannum(taskplannum);
        this.setPlanname(taskplanname);
        this.setSetObject(taskSetObject);
        this.setScheduleParams(taskParams);
    }

    public void CreatePlan() {
        String createJobid = this.createJob();
        this.setJobid(createJobid);
        this.setPlanid(this.createPlan(createJobid));
    }

    private String createJob() {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setTaskClassname(this.baseclass);
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setName(this.getJobname());
        jobInfo.setNumber(this.getJobnum());
        jobInfo.setParams(this.scheduleParams);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunConcurrently(true);
        String className = this.getTaskId(this.baseclass);
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setAppId("mds");
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createJob", new Object[]{jobInfo});
        return String.valueOf(obj);
    }

    private Date getLostdate(Date lostdate) {
        Calendar lc = Calendar.getInstance();
        if (lostdate == null) {
            lc.set(1, 2099);
            lc.set(2, 11);
            lc.set(5, 31);
        } else {
            lc.setTime(lostdate);
            lc.add(5, 1);
        }
        return SetOffCommonUtil.formatDate(lc.getTime());
    }

    private String createPlan(String jobId) {
        int i;
        PlanInfo planInfo = new PlanInfo();
        String losds = this.getSetObject().getString("losedate");
        planInfo.setNumber(this.getPlannum());
        planInfo.setName(this.getPlanname());
        planInfo.setJobId(jobId);
        Date lostdate = null;
        if (!"-1".equals(losds)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                lostdate = this.getLostdate(format.parse(this.getSetObject().getString("losedate")));
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
            }
        } else {
            lostdate = this.getLostdate(null);
        }
        Integer pred = this.getSetObject().getInteger("predtime");
        Calendar starttime = CalcuColumns.getStarttime(pred, "1");
        planInfo.setStartTime(starttime);
        Calendar endTime = Calendar.getInstance();
        endTime.set(5, starttime.get(5) + 1);
        planInfo.setEndTime(endTime);
        String repeattype = this.getSetObject().getString("repeattype");
        Boolean isrept = this.getSetObject().getBoolean("repeat");
        if (!isrept.booleanValue()) {
            planInfo.setRepeatMode(RepeatModeEnum.NONE);
        } else if ("0".equals(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
            i = 0;
            HashSet<String> daysExp = new HashSet<String>(10);
            for (String ditem : WEEKDAY) {
                ++i;
                if (!this.getSetObject().getBooleanValue(ditem)) continue;
                daysExp.add(String.valueOf(i));
            }
            String string = String.join((CharSequence)",", daysExp);
            planInfo.setWeekdaysExp(string);
            planInfo.setPeriod(1);
        } else {
            planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
            i = 0;
            HashSet<String> monthExp = new HashSet<String>(32);
            for (String ditem : MONTHDAY) {
                ++i;
                if (!this.getSetObject().getBooleanValue(ditem)) continue;
                monthExp.add(String.valueOf(i));
            }
            String string = String.join((CharSequence)",", monthExp);
            planInfo.setDaysExp(string);
            planInfo.setPeriod(1);
        }
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createPlan", new Object[]{planInfo});
        try {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)obj, (String)"sch_schedule", (String)"endtime");
            dynamicObject.set("endtime", (Object)lostdate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        catch (Exception exception) {
            logger.warn((Throwable)exception);
        }
        return String.valueOf(obj);
    }

    private String getTaskId(String className) {
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)"number,appid", (QFilter[])new QFilter[]{new QFilter("classname", "=", (Object)className)});
        if (taskname == null) {
            return null;
        }
        if (!"mds".equals(taskname.getString("appid"))) {
            taskname.set("appid", (Object)"mds");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{taskname});
        }
        return String.valueOf(taskname.getPkValue());
    }
}

