/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;

public class MDSJobCache {
    private final DistributeSessionlessCache cache;
    private final String jobkey;

    public MDSJobCache(String jobkey) {
        this.jobkey = jobkey;
        this.cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
    }

    private String getParentKey() {
        return "distribute.MDSjobcache." + this.jobkey;
    }

    public void put(String key, String value) {
        this.cache.put(this.getParentKey(), key, value, this.getDefaultTimeOut());
    }

    public String get(String key) {
        return (String)this.cache.get(this.getParentKey(), key);
    }

    public void remove(String key) {
        this.cache.remove(this.getParentKey(), key);
    }

    public void clear() {
        this.cache.removeType(this.getParentKey());
    }

    private int getDefaultTimeOut() {
        return 86400;
    }
}

