/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.algo.DataSet;
import kd.bos.algo.olap.util.ByteArrayInputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityState;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.entity.property.BasedataProp;
import kd.bos.form.FieldTip;
import kd.bos.form.IFormView;
import kd.bos.form.operate.MutexHelper;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.util.StringUtils;
import kd.bos.util.io.ByteArrayOutputStream;
import kd.mpscmm.msplan.mrp.business.helper.BillFieldEntityHelper;
import kd.mpscmm.msplan.mservice.service.datasync.MMCSnapDataVisitor;

public class MDSUtils {
    private static final Log logger = LogFactory.getLog(MDSUtils.class);

    public static void clearHeadOtherData(DynamicObject dynamicObject, Set<String> fieldNameSet) {
        if (dynamicObject != null) {
            DataEntityPropertyCollection properties = dynamicObject.getDynamicObjectType().getProperties();
            LinkedList<IDataEntityProperty> proList = new LinkedList<IDataEntityProperty>();
            for (IDataEntityProperty pro : properties) {
                if (!fieldNameSet.contains(pro.getName())) continue;
                proList.add(pro);
            }
            for (IDataEntityProperty pro : proList) {
                if (!(pro instanceof ISimpleProperty)) continue;
                dynamicObject.getDataEntityState().setDirty((ISimpleProperty)pro, false);
            }
        }
    }

    public static boolean releaseMutex(String entityID, String op, List pkList) {
        if (StringUtils.isEmpty((String)entityID) || StringUtils.isEmpty((String)op)) {
            return false;
        }
        if (pkList == null) {
            return true;
        }
        int pkListSize = pkList.size();
        if (pkListSize <= 0) {
            return true;
        }
        for (int index = 0; index < pkListSize; ++index) {
            boolean releaseResult;
            String pk;
            Object pkObj = pkList.get(index);
            String string = pk = pkObj == null ? null : pkObj.toString();
            if (StringUtils.isEmpty((String)pk) || (releaseResult = MutexHelper.release((String)entityID, (String)op, (String)pk))) continue;
            return false;
        }
        return true;
    }

    public static boolean isEmptyList(List list) {
        if (list == null) {
            return true;
        }
        return list.size() == 0;
    }

    public static void setBizChanged(DynamicObject doDE, String propName, boolean isChanged) {
        int refIDPropOrdinal;
        IDataEntityProperty refIDProp;
        BasedataProp bpTmp;
        if (doDE == null || StringUtils.isEmpty((String)propName)) {
            return;
        }
        DataEntityState desTmp = doDE.getDataEntityState();
        if (desTmp == null) {
            return;
        }
        DynamicObjectType dotTmp = doDE.getDynamicObjectType();
        if (dotTmp == null) {
            return;
        }
        DynamicProperty dpTmp = dotTmp.getProperty(propName);
        if (dpTmp == null) {
            return;
        }
        int propOrdinal = dpTmp.getOrdinal();
        if (propOrdinal < 0) {
            return;
        }
        desTmp.setBizChanged(propOrdinal, isChanged);
        BasedataProp basedataProp = bpTmp = dpTmp instanceof BasedataProp ? (BasedataProp)dpTmp : null;
        if (bpTmp != null && (refIDProp = bpTmp.getRefIdProp()) != null && (refIDPropOrdinal = refIDProp.getOrdinal()) > 0) {
            desTmp.setBizChanged(refIDPropOrdinal, isChanged);
        }
    }

    public static void filedTip(IFormView formView, String field, String tip) {
        if (field == null || StringUtils.isEmpty((String)field)) {
            return;
        }
        FieldTip fieldTip = new FieldTip();
        fieldTip.setFieldKey(field);
        if (tip == null || StringUtils.isEmpty((String)tip)) {
            fieldTip.setSuccess(true);
        } else {
            fieldTip.setTip(tip);
        }
        formView.showFieldTip(fieldTip);
    }

    public static <T> Map deepClone(Map obj) {
        HashMap clonedObj = new HashMap();
        clonedObj.putAll(obj);
        return clonedObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> Stack deepClone(Stack obj) {
        Object clonedObj = null;
        ByteArrayOutputStream baos = null;
        ObjectOutputStream oos = null;
        ByteArrayInputStream bais = null;
        ObjectInputStream ois = null;
        try {
            baos = new ByteArrayOutputStream();
            oos = new ObjectOutputStream((OutputStream)baos);
            oos.writeObject(obj);
            bais = new ByteArrayInputStream(baos.toByteArray());
            ois = new ObjectInputStream((InputStream)bais);
            clonedObj = ois.readObject();
        }
        catch (Exception e) {
            logger.warn((Throwable)e);
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                }
            }
            if (oos != null) {
                try {
                    oos.close();
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                }
            }
            if (bais != null) {
                try {
                    bais.close();
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                }
            }
            if (ois != null) {
                try {
                    ois.close();
                }
                catch (IOException e) {
                    logger.warn((Throwable)e);
                }
            }
        }
        return (Stack)clonedObj;
    }

    public static boolean checkPermission(String appid, String formId, String permissionItemId) {
        long userId = Long.parseLong(RequestContext.get().getUserId());
        int result = PermissionServiceHelper.checkPermission((Long)userId, (Long)RequestContext.get().getOrgId(), (String)appid, (String)formId, (String)permissionItemId);
        return result == 1;
    }

    public static DataSet loadCacheDatas(Long snapshotschemeid, Long hisEntryId, String etStr, String selectFields, QFilter[] filters, String orderBys) {
        if (snapshotschemeid != null && snapshotschemeid != 0L) {
            MMCSnapDataVisitor visitor = new MMCSnapDataVisitor();
            return visitor.localFastDataVisit(snapshotschemeid, hisEntryId, etStr, selectFields, filters, orderBys);
        }
        return null;
    }

    public static DataSet loadCacheDatas(Long snapshotschemeid, String etStr, String selectFields, QFilter[] filters) {
        if (snapshotschemeid != null && snapshotschemeid != 0L) {
            MMCSnapDataVisitor visitor = new MMCSnapDataVisitor();
            return visitor.localFastDataVisit(snapshotschemeid, null, etStr, selectFields, filters, null);
        }
        return null;
    }

    public static String getMdsSysConfig(String configkey, String defvalue) {
        QFilter qfilter = new QFilter("id", "=", (Object)1286763671371907072L);
        DynamicObjectCollection entrys = QueryServiceHelper.query((String)"mds_sysconfig", (String)"entryentity.key,entryentity.value", (QFilter[])new QFilter[]{qfilter});
        if (entrys != null) {
            for (DynamicObject dObject : entrys) {
                if (!configkey.equalsIgnoreCase(dObject.getString("entryentity.key"))) continue;
                return dObject.getString("entryentity.value");
            }
        }
        return defvalue;
    }

    public static boolean isNotEmpty(CharSequence string) {
        return string != null && string.length() > 0;
    }

    public static boolean isEmpty(CharSequence string) {
        return string == null || string.length() == 0;
    }

    public static boolean isNotBlank(CharSequence string) {
        return string != null && !MDSUtils.containsOnlyWhitespaces(string);
    }

    public static boolean containsOnlyWhitespaces(CharSequence string) {
        int size = string.length();
        for (int i = 0; i < size; ++i) {
            char c = string.charAt(i);
            if (MDSUtils.isWhitespace(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhitespace(char c) {
        return c <= ' ';
    }

    public static String getMetaDataFieldType(DynamicProperty dynamicProperty) {
        return BillFieldEntityHelper.getMetaDataFieldType((DynamicProperty)dynamicProperty);
    }
}

