/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;

public class MdsLoadOfferingUtil {
    private static final List<String> categoryCodeList = new ArrayList<String>();
    private static final List<String> categoryList = new ArrayList<String>();
    private static int categorySize = 0;
    private static boolean isExt = false;

    public static Map<String, DynamicObject> loadMaterial(Set<String> materialidSet) {
        DynamicObjectCollection dynamicObjectCollection;
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        if (materialidSet == null || materialidSet.isEmpty()) {
            return result;
        }
        QFilter filter = new QFilter("number", "in", materialidSet);
        String selectFields = "number,offeringcode.number,offeringcode.group,offeringcode.name,baseunit.name";
        if (MdsLoadOfferingUtil.isExt()) {
            selectFields = selectFields + ",hihn_color";
        }
        if ((dynamicObjectCollection = QueryServiceHelper.query((String)"bd_material", (String)selectFields, (QFilter[])new QFilter[]{filter})) == null || dynamicObjectCollection.isEmpty()) {
            return result;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String key = dynamicObject.getString("number");
            result.put(key, dynamicObject);
        }
        return result;
    }

    public static Map<String, Stack<String>> loadMaterialRelProductGroup(Map<String, DynamicObject> materialMap) {
        HashMap<String, Stack<String>> result = new HashMap<String, Stack<String>>();
        for (DynamicObject dynamicObject : materialMap.values()) {
            String groupId = dynamicObject.getString("offeringcode.group");
            if (!StringUtils.isNotEmpty((String)groupId) || "0".equals(groupId)) continue;
            result.put(groupId, new Stack());
        }
        if (result.isEmpty()) {
            return result;
        }
        Map<String, DynamicObject> productGroup = MdsLoadOfferingUtil.loadAllProductGroup();
        Set entrySet = result.entrySet();
        block1: for (Map.Entry entry : entrySet) {
            DynamicObject groupObj;
            String productGroupId;
            String parent = productGroupId = (String)entry.getKey();
            Stack productGroupStack = (Stack)entry.getValue();
            while (StringUtils.isNotEmpty((String)parent) && !"0".equals(parent) && (groupObj = productGroup.get(parent)) != null) {
                String name = groupObj.getString("name");
                parent = groupObj.getString("parent");
                productGroupStack.push(name);
                if (productGroupStack.size() <= 5) continue;
                continue block1;
            }
        }
        return result;
    }

    private static Map<String, DynamicObject> loadAllProductGroup() {
        HashMap<String, DynamicObject> result = new HashMap<String, DynamicObject>();
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"bd_productgroup", (String)"id,number,name,parent,category", null);
        if (dynamicObjectCollection == null || dynamicObjectCollection.isEmpty()) {
            return result;
        }
        for (DynamicObject dynamicObject : dynamicObjectCollection) {
            String key = dynamicObject.getString("id");
            result.put(key, dynamicObject);
        }
        return result;
    }

    public static List<String> getCategoryList() {
        return categoryList;
    }

    public static int getCategorySize() {
        return categorySize;
    }

    public static boolean isExt() {
        return isExt;
    }

    public static List<String> getCategoryCodeList() {
        return categoryCodeList;
    }

    static {
        categoryList.add("BG");
        categoryList.add(ResManager.loadKDString((String)"\u4ea7\u54c1\u7ebf", (String)"MdsLoadOfferingUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        categoryList.add(ResManager.loadKDString((String)"\u4ea7\u54c1\u57df", (String)"MdsLoadOfferingUtil_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        categoryList.add(ResManager.loadKDString((String)"\u4ea7\u54c1\u65cf", (String)"MdsLoadOfferingUtil_2", (String)"mmc-mds-common", (Object[])new Object[0]));
        categoryList.add(ResManager.loadKDString((String)"\u4ea7\u54c1\u7cfb\u5217", (String)"MdsLoadOfferingUtil_3", (String)"mmc-mds-common", (Object[])new Object[0]));
        categorySize = categoryList.size();
        categoryCodeList.add("Consumers BUnit BG");
        categoryCodeList.add("Product Line");
        categoryCodeList.add("Product Area");
        categoryCodeList.add("Product Family");
        categoryCodeList.add("Product Series");
        DynamicObject bd_material = ORM.create().newDynamicObject("bd_material");
        DataEntityPropertyCollection properties = bd_material.getDataEntityType().getProperties();
        for (IDataEntityProperty pro : properties) {
            if (!"hihn_color".equals(pro.getName())) continue;
            isExt = true;
        }
    }
}

