/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.algo.input.DataSetInput;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.AlgoX;
import kd.bos.algox.DataSetX;
import kd.bos.algox.GroupReduceFunction;
import kd.bos.algox.Grouper;
import kd.bos.algox.JobSession;
import kd.bos.algox.MapFunction;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.GridConfigurationRow;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.impl.FcDataToPlanDataTask;
import kd.mmc.mds.common.impl.PlanDataToFcDataTask;
import kd.mmc.mds.common.plandata.PlanDataFieldsSetter;
import kd.mmc.mds.common.util.DateUtil;
import kd.mmc.mds.mservice.algox.MonthTransformMapFunction;
import kd.mmc.mds.mservice.algox.PlanDataConvergeReduceGroupFunction;
import kd.mmc.mds.mservice.algox.PlanDataSeqReduceGroupFunction;
import kd.mmc.mds.mservice.algox.WeekTransformMapFunction;
import org.apache.commons.collections4.MapUtils;

public class PlanDataToFcDataTranUtil {
    private static Log log = LogFactory.getLog(PlanDataToFcDataTranUtil.class);
    private static DBRoute pur = new DBRoute("pur");
    private static String CO_MDS_PLANDATA = "mds_plandata";
    private static String CO_QTY = "qty";
    private static String CO_DATEENTITY = "dateentity";
    private static String CO_FIELDKEY = "fieldkey";
    private static String CO_TARGETDATE = "targetdate";
    private static String CO_SEQ = "seq";
    private static String CO_DELIVERYCOLUMN = "deliverycolumn";
    private static String CO_ENTRYENTITY = "entryentity";
    private static ORM neworm = ORM.create();
    private static ThreadLocal<Map<String, Object>> nodeSpanListThreadLocal = new ThreadLocal();

    public static boolean checkSyncStatusPlanData(String version) {
        boolean isSuccess = true;
        String selectField = "syncresult";
        QFilter filter = new QFilter("version.number", "=", (Object)version);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObjectCollection plandatas = QueryServiceHelper.query((String)"mds_syncplanlog", (String)selectField, (QFilter[])filters);
        for (DynamicObject plandata : plandatas) {
            String syncresult = plandata.getString("syncresult");
            if (!"C".equals(syncresult)) continue;
            isSuccess = false;
        }
        return isSuccess;
    }

    public static void tranPlanDataToFcDataByTask(String version, Object logid) {
        RequestContext recon = RequestContext.get();
        PlanDataToFcDataTask planDataToFcDataTask = new PlanDataToFcDataTask(version, logid, recon);
        boolean result = planDataToFcDataTask.process();
        if (!result) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u5212\u6570\u636e\u540c\u6b65\u5931\u8d25\u3002", (String)"PlanDataToFcDataTranUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
    }

    public static void tranPlanDataToFcDataStatus(String version) {
        log.info("\u5f00\u59cb\u66f4\u65b0\u7248\u672c:" + version + "\u7684\u72b6\u6001");
        String selectField = "billstatus,enablestatus";
        QFilter filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject plandata = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)selectField, (QFilter[])filters);
        selectField = "billstatus,enablestatus";
        filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        filters = new QFilter[]{filter};
        DynamicObject fcdata = BusinessDataServiceHelper.loadSingle((String)"mds_data", (String)selectField, (QFilter[])filters);
        if (fcdata != null) {
            fcdata.set("billstatus", plandata.get("billstatus"));
            fcdata.set("enablestatus", (Object)plandata.getString("enablestatus"));
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{fcdata});
            log.info("\u7ed3\u675f\u66f4\u65b0\u7248\u672c:" + version + "\u7684\u72b6\u6001\uff0c\u5355\u636e\u72b6\u6001\u4e3a\uff1a" + plandata.get("billstatus"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<Long> queryAllMaterialInfo(String version) {
        String sqlfc = "select fmaterialid from t_mds_fcdatadtlent where fid in (select fid from t_mds_fcdata where ffcvrnnum in (select fid from t_mds_vrds where fnumber = ? ))";
        DataSet fcdatasetData = DB.queryDataSet((String)"queryFcData", (DBRoute)pur, (String)sqlfc, (Object[])new Object[]{version});
        String sqlplan = "select fmaterialid from t_mds_fcdatatsentry where fid in (select fid from t_mds_fcdatats where ffcvrnnum in (select fid from t_mds_vrds where fnumber = ? ))";
        DataSet plandatasetData = DB.queryDataSet((String)"queryPlanData", (DBRoute)pur, (String)sqlplan, (Object[])new Object[]{version});
        HashSet<Long> materialSet = new HashSet<Long>();
        Iterator iteratorfc = fcdatasetData.iterator();
        try {
            while (iteratorfc.hasNext()) {
                Row row = (Row)iteratorfc.next();
                Long materialid = row.getLong("fmaterialid");
                materialSet.add(materialid);
            }
        }
        finally {
            fcdatasetData.close();
        }
        Iterator iteratorplandata = plandatasetData.iterator();
        try {
            while (iteratorplandata.hasNext()) {
                Row row = (Row)iteratorplandata.next();
                Long materialid = row.getLong("fmaterialid");
                materialSet.add(materialid);
            }
        }
        finally {
            plandatasetData.close();
        }
        return materialSet;
    }

    public static void tranFcDataToPlanDataByTask(String version, Object logid) {
        RequestContext recon = RequestContext.get();
        FcDataToPlanDataTask fcDataToPlanDataTask = new FcDataToPlanDataTask(version, logid, recon);
        boolean result = fcDataToPlanDataTask.process();
        if (!result) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8ba1\u5212\u6570\u636e\u540c\u6b65\u5931\u8d25\u3002", (String)"PlanDataToFcDataTranUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
    }

    public static void tranFcDataToPlanDataByAlgoX(String version, Map<Long, String> dateMap) {
        log.info("\u7248\u672c:" + version + ",\u5f00\u59cb\u521d\u59cb\u5316\u7269\u6599\u7f13\u5b58");
        QFilter vrdsFilter = new QFilter("number", "=", (Object)version);
        DynamicObject mds_vrds = BusinessDataServiceHelper.loadSingleFromCache((String)"mds_vrds", (QFilter[])new QFilter[]{vrdsFilter});
        String cycletype = mds_vrds.getString("cytype");
        String dayofweek = mds_vrds.getString("dayofweek");
        String vertype = mds_vrds.getString("vertype");
        QFilter filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        DynamicObject plandata = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)"id", (QFilter[])new QFilter[]{filter});
        DynamicObject mds_data = BusinessDataServiceHelper.loadSingle((String)"mds_data", (String)"id", (QFilter[])new QFilter[]{filter});
        long plandataId = plandata.getLong("id");
        Map<String, String> backFieldRelAlias = PlanDataFieldsSetter.getBackFieldRelAlias(vertype);
        backFieldRelAlias.put("datenode", "fdatenode");
        backFieldRelAlias.put("fcqty", "ffcqty");
        String queryField = backFieldRelAlias.entrySet().stream().map(o -> " detailentity." + (String)o.getKey() + " as " + (String)o.getValue() + " ").collect(Collectors.joining(" , "));
        DataSet queryMainData = QueryServiceHelper.queryDataSet((String)"queryFcData", (String)"mds_data", (String)queryField, (QFilter[])new QFilter[]{new QFilter("id", "=", mds_data.getPkValue()).and("detailentity.materialid", "!=", (Object)0L).and("detailentity.datenode", "is not null", null)}, null);
        JobSession session = AlgoX.createSession((String)"PlanDataToFcDataTranUtil", (String)"tranFcDataToPlanDataByAlgoX");
        DataSetInput dataSetInput = new DataSetInput(queryMainData);
        DataSetX dataSetX = session.fromInput((Input)dataSetInput);
        if ("1".equals(cycletype)) {
            dataSetX = dataSetX.map((MapFunction)new WeekTransformMapFunction(dataSetX.getRowMeta(), "fdatenode", dayofweek));
        } else if ("3".equals(cycletype)) {
            dataSetX = dataSetX.map((MapFunction)new MonthTransformMapFunction(dataSetX.getRowMeta(), "fdatenode", dayofweek));
        }
        List<String> uniqueKeyAlias = PlanDataFieldsSetter.getSyncFieldsAlias(vertype);
        ArrayList<String> groupAlias = new ArrayList<String>(uniqueKeyAlias);
        groupAlias.add("fdatenode");
        Grouper grouper = dataSetX.groupBy(groupAlias.toArray(new String[0]));
        dataSetX = grouper.sum("ffcqty");
        RowMeta rowMeta = dataSetX.getRowMeta();
        Grouper grouper2 = dataSetX.groupBy(uniqueKeyAlias.toArray(new String[0]));
        dataSetX = grouper2.reduceGroup((GroupReduceFunction)new PlanDataConvergeReduceGroupFunction(rowMeta, dateMap, uniqueKeyAlias.toArray(new String[0]), Long.valueOf(plandataId)));
        dataSetX = dataSetX.orderBy(uniqueKeyAlias.toArray(new String[0]));
        dataSetX = dataSetX.reduceGroup((GroupReduceFunction)new PlanDataSeqReduceGroupFunction(dataSetX.getRowMeta(), "fseq"));
        DataSetOutput output = new DataSetOutput(dataSetX.getRowMeta());
        String outputId = output.getId();
        dataSetX.output((Output)output);
        session.commit(30, TimeUnit.MINUTES);
        DataSet dataSet = session.readDataSet(outputId);
        String insertSql = PlanDataToFcDataTranUtil.buildInsertSql(dataSet.getRowMeta());
        try (TXHandle h1 = TX.required();){
            try {
                String clearSql = "delete from t_mds_fcdatatsentry where fid=?";
                DB.execute((DBRoute)pur, (String)clearSql, (Object[])new Object[]{plandata.getPkValue()});
                PlanDataToFcDataTranUtil.insertToFcdatatsentry(dataSet, insertSql);
            }
            catch (Throwable e) {
                h1.markRollback();
                throw e;
            }
        }
    }

    private static void insertToFcdatatsentry(DataSet dataSet, String insertSql) {
        RowMeta meta = dataSet.getRowMeta();
        Field[] fields = meta.getFields();
        ArrayList<Object[]> paramsList = new ArrayList<Object[]>(16);
        for (Row row : dataSet) {
            ArrayList<Object> params = new ArrayList<Object>(16);
            for (Field field : fields) {
                params.add(row.get(field.getAlias()));
            }
            paramsList.add(params.toArray(new Object[0]));
            if (paramsList.size() < 10000) continue;
            PlanDataToFcDataTranUtil.dBexecuteBatch(pur, insertSql, paramsList);
            paramsList.clear();
        }
        if (paramsList.size() > 0) {
            DB.executeBatch((DBRoute)pur, (String)insertSql, paramsList);
        }
    }

    private static void dBexecuteBatch(DBRoute pur, String insertSql, List<Object[]> paramsList) {
        DB.executeBatch((DBRoute)pur, (String)insertSql, paramsList);
    }

    private static String buildInsertSql(RowMeta rowMeta) {
        Field[] fields;
        String sql = "insert into t_mds_fcdatatsentry (%s) values (%s)";
        StringBuilder fieldSql = new StringBuilder();
        StringBuilder paramsSql = new StringBuilder();
        for (Field field : fields = rowMeta.getFields()) {
            if (fieldSql.length() > 0) {
                fieldSql.append(",");
                paramsSql.append(",");
            }
            fieldSql.append(field.getName());
            paramsSql.append("?");
        }
        return String.format(sql, fieldSql.toString(), paramsSql.toString());
    }

    public static void tranFcDataToPlanDataByDim(String version) {
        String[] uniquekey = PlanDataToFcDataTranUtil.getUniqueKeyByVersionInfo(version);
        PlanDataToFcDataTranUtil.updatePlanDataHeadInfo(version);
        Map<Long, String> dateMap = PlanDataToFcDataTranUtil.updatePlanDateEntryInfo(version);
        PlanDataToFcDataTranUtil.tranFcDataToPlanDataByAlgoX(version, dateMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updatePlanDataByTask(String version, String[] uniquekey) {
        log.info("\u7248\u672c:" + version + ",\u5f00\u59cb\u521d\u59cb\u5316\u7269\u6599\u7f13\u5b58");
        PlanDataToFcDataTranUtil.buildCacheMaterial(version);
        QFilter filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject mdsdata = BusinessDataServiceHelper.loadSingle((String)"mds_data", (String)PlanDataToFcDataTranUtil.getHeadSelectField(), (QFilter[])filters);
        String queryMainSql = "select fmaterialid,fdatenode,ffcqty,fprodorg,fplangp,fremark from T_MDS_FCDATADTLENT where fid in (?) ";
        DataSet queryMainData = DB.queryDataSet((String)"queryFcData", (DBRoute)pur, (String)queryMainSql, (Object[])new Object[]{mdsdata.getPkValue()});
        Iterator iteratorMain = queryMainData.iterator();
        StringBuilder newuniquekey = new StringBuilder();
        HashMap<String, JSONArray> newUniqueMap = new HashMap<String, JSONArray>();
        try {
            while (iteratorMain.hasNext()) {
                newuniquekey.setLength(0);
                Row row = (Row)iteratorMain.next();
                for (int n = 0; n < uniquekey.length - 1; ++n) {
                    newuniquekey.append(row.getLong(uniquekey[n]));
                    if (n == uniquekey.length - 2) continue;
                    newuniquekey.append('#');
                }
                JSONObject obj = new JSONObject();
                obj.put("MATERIALID", row.get("fmaterialid"));
                obj.put("PRODORG", row.get("fprodorg"));
                obj.put("REMARK", row.get("fremark"));
                obj.put("DATENODE", (Object)row.getDate("fdatenode"));
                obj.put("QTY", row.get("ffcqty"));
                obj.put("PLANGP", row.get("fplangp"));
                if (newUniqueMap.get(newuniquekey.toString()) == null) {
                    JSONArray addList = new JSONArray();
                    addList.add((Object)obj);
                    newUniqueMap.put(newuniquekey.toString(), addList);
                    continue;
                }
                ((JSONArray)newUniqueMap.get(newuniquekey.toString())).add((Object)obj);
            }
        }
        finally {
            queryMainData.close();
        }
        log.info("\u7248\u672c:" + version + ",\u5f00\u59cb\u51c6\u5907\u66f4\u65b0\u65b0\u8868\u5355\u636e\u4f53");
        String selectField = "entryentity,dateentity.seq,dateentity.fieldkey,dateentity.targetdate,dateentity.deliverycolumn,fcvrnnum.cytype,fcvrnnum.dayofweek";
        String editField = "entryentity.edituser,entryentity.editcreatedate,entryentity.entrymodifier,entryentity.editdate";
        filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        filters = new QFilter[]{filter};
        DynamicObject dateplandata = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)selectField, (QFilter[])filters);
        HashMap<String, Date> fieldKey = new HashMap<String, Date>();
        for (DynamicObject obj : dateplandata.getDynamicObjectCollection(CO_DATEENTITY)) {
            fieldKey.put(obj.getString("fieldkey"), obj.getDate("targetdate"));
        }
        DynamicObject plandata = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)(selectField + "," + PlanDataToFcDataTranUtil.getDetailSelectField(fieldKey) + "," + editField), (QFilter[])filters);
        String cycletype = plandata.getString("fcvrnnum.cytype");
        String dayofweek = plandata.getString("fcvrnnum.dayofweek");
        DynamicObjectCollection entrys = plandata.getDynamicObjectCollection(CO_ENTRYENTITY);
        entrys.clear();
        int index = 0;
        DynamicObjectCollection dateentry = plandata.getDynamicObjectCollection(CO_DATEENTITY);
        HashMap<Long, String> dateMap = new HashMap<Long, String>();
        for (DynamicObject obj : dateentry) {
            Date entrydate = obj.getDate("targetdate");
            dateMap.put(entrydate.getTime(), obj.getString("fieldkey"));
        }
        for (JSONArray list : newUniqueMap.values()) {
            if ("1".equals(cycletype)) {
                list = PlanDataToFcDataTranUtil.convergeWeekData(list, dayofweek);
            }
            if (list == null) continue;
            DynamicObject entry = entrys.addNew();
            entry.set("seq", (Object)(++index));
            PlanDataToFcDataTranUtil.buildPlanDataEntryEntity(dateMap, entry, list);
        }
        nodeSpanListThreadLocal.remove();
        log.info("\u7248\u672c:" + version + ",\u8c03\u7528\u7cfb\u7edf\u65b9\u6cd5\u4fdd\u5b58\u6570\u636e\u5f00\u59cb");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plandata});
        log.info("\u7248\u672c:" + version + ",\u8c03\u7528\u7cfb\u7edf\u65b9\u6cd5\u4fdd\u5b58\u6570\u636e\u7ed3\u675f");
    }

    public static void buildPlanDataEntryEntity(Map<Long, String> dateMap, DynamicObject entry, JSONArray list) {
        BigDecimal qty;
        Comparable<Date> date;
        JSONObject value = list.getJSONObject(0);
        entry.set("material", value.get("MATERIALID"));
        Object baseunit = ((Map)nodeSpanListThreadLocal.get().get("material")).get(value.get("MATERIALID"));
        entry.set("baseunit", baseunit);
        entry.set("prodorg", value.get("PRODORG"));
        entry.set("remark", value.get("REMARK"));
        entry.set("plangp", value.get("PLANGP"));
        HashMap<Long, BigDecimal> qtyMap = new HashMap<Long, BigDecimal>();
        for (int n = 0; n < list.size(); ++n) {
            JSONObject jsonobj = list.getJSONObject(n);
            date = jsonobj.getDate("DATENODE");
            qty = jsonobj.getBigDecimal("QTY");
            if (qtyMap.get(((Date)date).getTime()) != null) {
                qty = ((BigDecimal)qtyMap.get(((Date)date).getTime())).add(qty);
                qtyMap.put(((Date)date).getTime(), qty);
                continue;
            }
            qtyMap.put(((Date)date).getTime(), qty);
        }
        for (Map.Entry obj : qtyMap.entrySet()) {
            date = (Long)obj.getKey();
            qty = obj.getValue() == null ? BigDecimal.ZERO : (BigDecimal)obj.getValue();
            entry.set(dateMap.get(date), (Object)qty);
        }
        entry.set("edituser", (Object)RequestContext.get().getCurrUserId());
        entry.set("editcreatedate", (Object)new Date());
        entry.set("entrymodifier", (Object)RequestContext.get().getCurrUserId());
        entry.set("editdate", (Object)new Date());
    }

    public static Map<Long, String> updatePlanDateEntryInfo(String version) {
        QFilter filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject obj = BusinessDataServiceHelper.loadSingle((String)"mds_data", (String)PlanDataToFcDataTranUtil.getHeadSelectField(), (QFilter[])filters);
        String queryMainSql = "select fdatenode from T_MDS_FCDATADTLENT where fid = ? ";
        DataSet queryMainData = DB.queryDataSet((String)"queryFcData", (DBRoute)pur, (String)queryMainSql, (Object[])new Object[]{obj.getPkValue()});
        Iterator iteratorMain = queryMainData.iterator();
        Set<Date> dateSet = new HashSet<Date>();
        while (iteratorMain.hasNext()) {
            Row row = (Row)iteratorMain.next();
            Date targetdate = row.getDate("fdatenode");
            dateSet.add(targetdate);
        }
        String selectField = "entryentity,dateentity.seq,dateentity.fieldkey,dateentity.targetdate,dateentity.deliverycolumn,fcvrnnum.cytype,fcvrnnum.dayofweek";
        filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        filters = new QFilter[]{filter};
        DynamicObject plandata = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)selectField, (QFilter[])filters);
        String cycletype = plandata.getString("fcvrnnum.cytype");
        String dayofweek = plandata.getString("fcvrnnum.dayofweek");
        if ("1".equals(cycletype)) {
            dateSet = PlanDataToFcDataTranUtil.getAllMonday(dateSet);
            List<Date> dateList = new ArrayList<Date>(16);
            dateList.addAll(dateSet);
            dateList = DateUtil.getMondaysOffset(dateList, dayofweek);
            dateSet.clear();
            dateSet.addAll(dateList);
        } else if ("3".equals(cycletype)) {
            dateSet = PlanDataToFcDataTranUtil.getAllMonthFirst(dateSet);
            List<Date> dateList = new ArrayList<Date>(16);
            dateList.addAll(dateSet);
            dateList = DateUtil.getMonthOffset(dateList, dayofweek);
            dateSet.clear();
            dateSet.addAll(dateList);
        }
        log.info("\u7248\u672c:" + version + ",\u5f00\u59cb\u540c\u6b65\u65e5\u671f\u5bf9\u7167\u5173\u7cfb");
        return PlanDataToFcDataTranUtil.updateDistributionLocation(dateSet, plandata);
    }

    private static Set<Date> getAllMonday(Set<Date> dateList) {
        HashSet<Date> mondaySet = new HashSet<Date>(100);
        for (Date date : dateList) {
            Date monday = DateUtil.getTheWeekStart(date, 2);
            mondaySet.add(monday);
        }
        return mondaySet;
    }

    private static Set<Date> getAllMonthFirst(Set<Date> dateList) {
        HashSet<Date> monthFirstSet = new HashSet<Date>(100);
        for (Date date : dateList) {
            Date firstCurrentMonth = DateUtil.findFirstCurrentMonth(date);
            monthFirstSet.add(firstCurrentMonth);
        }
        return monthFirstSet;
    }

    private static JSONArray convergeWeekData(JSONArray list, String dayofweek) {
        if (list == null) {
            return list;
        }
        HashMap<String, JSONObject> resultMap = new HashMap<String, JSONObject>();
        JSONArray resultList = new JSONArray();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        for (int i = 0; i < list.size(); ++i) {
            JSONObject oldDate = list.getJSONObject(i);
            Object dateObj = oldDate.get((Object)"DATENODE");
            String materialid = MapUtils.getString((Map)oldDate, (Object)"MATERIALID", (String)"");
            String prodorg = MapUtils.getString((Map)oldDate, (Object)"PRODORG", (String)"");
            if (!(dateObj instanceof Date)) continue;
            Date monday = DateUtil.getTheWeekStart((Date)dateObj, 2);
            monday = DateUtil.getMondayOffset(monday, dayofweek);
            String dateStr = dateFormat.format(monday);
            String key = materialid + "#" + prodorg + "#" + dateStr;
            Map newData = (Map)resultMap.get(key);
            if (newData == null) {
                oldDate.put("DATENODE", (Object)monday);
                resultMap.put(key, oldDate);
                continue;
            }
            Object qtyObj = oldDate.get((Object)"QTY");
            Object newQtyObj = newData.get("QTY");
            if (!(qtyObj instanceof BigDecimal)) continue;
            if (newQtyObj != null) {
                newData.put("QTY", ((BigDecimal)qtyObj).add((BigDecimal)newQtyObj));
                continue;
            }
            newData.put("QTY", qtyObj);
        }
        resultList.addAll(resultMap.values());
        return resultList;
    }

    private static void buildCacheMaterial(String version) {
        if (nodeSpanListThreadLocal.get() == null) {
            QFilter[] qfilters = PlanDataToFcDataTranUtil.buildCacheMaterialFilter(version);
            DataSet colls = QueryServiceHelper.queryDataSet((String)"PlanDataToFcDataTranUtil", (String)"bd_material", (String)"id,number,baseunit.id", (QFilter[])qfilters, null);
            HashMap valueMap = new HashMap();
            HashMap<Long, Long> materialMap = new HashMap<Long, Long>();
            for (Row obj : colls) {
                Long materialid = obj.getLong("id");
                Long baseunitid = obj.getLong("baseunit.id");
                materialMap.put(materialid, baseunitid);
            }
            valueMap.put("material", materialMap);
            nodeSpanListThreadLocal.set(valueMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static QFilter[] buildCacheMaterialFilter(String version) {
        HashSet<Long> idSet = new HashSet<Long>();
        String datasql = "select fmaterialid from t_mds_fcdatadtlent where fid in (select fid from t_mds_fcdata where ffcvrnnum in  (select fid from t_mds_vrds where fnumber = ?))";
        DataSet fcds = DB.queryDataSet((String)"queryFcPlanData", (DBRoute)pur, (String)datasql, (Object[])new Object[]{version});
        Iterator iterator = fcds.iterator();
        try {
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                Long materialid = row.getLong("fmaterialid");
                idSet.add(materialid);
            }
        }
        finally {
            fcds.close();
        }
        QFilter filter = new QFilter("id", "in", idSet);
        QFilter[] qfilters = new QFilter[]{filter};
        return qfilters;
    }

    public static void updateFCDataHeadInfo(String version) {
        QFilter filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject mdsdata = BusinessDataServiceHelper.loadSingle((String)"mds_data", (String)PlanDataToFcDataTranUtil.getHeadSelectField(), (QFilter[])filters);
        DynamicObject headInfo = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)PlanDataToFcDataTranUtil.getHeadSelectField(), (QFilter[])filters);
        if (mdsdata != null) {
            mdsdata.set("invaldate", (Object)headInfo.getDate("invaldate"));
            mdsdata.set("org", (Object)headInfo.getLong("org.id"));
            mdsdata.set("billstatus", (Object)headInfo.getString("billstatus"));
            mdsdata.set("enablestatus", (Object)headInfo.getString("enablestatus"));
            SaveServiceHelper.update((DynamicObject)mdsdata);
        } else {
            DynamicObject newobj = ORM.create().newDynamicObject("mds_data");
            newobj.set("fcvrnnum", (Object)headInfo.getLong("fcvrnnum.id"));
            newobj.set("invaldate", (Object)headInfo.getDate("invaldate"));
            newobj.set("org", (Object)headInfo.getLong("org.id"));
            newobj.set("billstatus", (Object)headInfo.getString("billstatus"));
            newobj.set("enablestatus", (Object)headInfo.getString("enablestatus"));
            newobj.set("billno", (Object)headInfo.getString("fcvrnnum.number"));
            newobj.set("creator", (Object)RequestContext.get().getUserId());
            newobj.set("createtime", (Object)Calendar.getInstance().getTime());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newobj});
        }
    }

    public static void updatePlanDataHeadInfo(String version) {
        QFilter filter = new QFilter("fcvrnnum.number", "=", (Object)version);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject sourcedata = BusinessDataServiceHelper.loadSingle((String)"mds_data", (String)PlanDataToFcDataTranUtil.getHeadSelectField(), (QFilter[])filters);
        DynamicObject targetdata = BusinessDataServiceHelper.loadSingle((String)"mds_plandata", (String)PlanDataToFcDataTranUtil.getHeadSelectField(), (QFilter[])filters);
        if (targetdata != null) {
            targetdata.set("invaldate", (Object)sourcedata.getDate("invaldate"));
            targetdata.set("org", (Object)sourcedata.getLong("org.id"));
            targetdata.set("billstatus", (Object)sourcedata.getString("billstatus"));
            targetdata.set("enablestatus", (Object)sourcedata.getString("enablestatus"));
            targetdata.set("modifier", (Object)RequestContext.get().getCurrUserId());
            targetdata.set("modifytime", (Object)Calendar.getInstance().getTime());
            SaveServiceHelper.update((DynamicObject)targetdata);
        } else {
            DynamicObject newobj = ORM.create().newDynamicObject("mds_plandata");
            newobj.set("fcvrnnum", (Object)sourcedata.getLong("fcvrnnum.id"));
            newobj.set("invaldate", (Object)sourcedata.getDate("invaldate"));
            newobj.set("org", (Object)sourcedata.getLong("org.id"));
            newobj.set("billstatus", (Object)sourcedata.getString("billstatus"));
            newobj.set("enablestatus", (Object)sourcedata.getString("enablestatus"));
            newobj.set("billno", (Object)sourcedata.getString("fcvrnnum.number"));
            newobj.set("creator", (Object)RequestContext.get().getCurrUserId());
            newobj.set("createtime", (Object)Calendar.getInstance().getTime());
            newobj.set("modifier", (Object)RequestContext.get().getCurrUserId());
            newobj.set("modifytime", (Object)Calendar.getInstance().getTime());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{newobj});
        }
    }

    public static String[] getUniqueKeyByVersionInfo(String version) {
        String[] resultArrays = null;
        String selectField = "vertype";
        QFilter filter = new QFilter("number", "=", (Object)version);
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject plandata = BusinessDataServiceHelper.loadSingle((String)"mds_vrds", (String)selectField, (QFilter[])filters);
        String metadatakey = plandata.getString("vertype");
        if ("1".equals(metadatakey) || "0".equals(metadatakey) || "2".equals(metadatakey)) {
            List<String> uniqueKeyList = PlanDataFieldsSetter.getUniqueKeyAlias(metadatakey);
            uniqueKeyList.add("fdatenode");
            resultArrays = uniqueKeyList.toArray(new String[0]);
        } else if ("mds_data".equals(metadatakey)) {
            resultArrays = new String[]{"materialid_id", "prodorg_id", "fdatenode"};
        }
        return resultArrays;
    }

    public static String[] getUniqueKey(DynamicObject obj) {
        String[] resultArrays = null;
        String metadatakey = obj.getDataEntityType().getName();
        if ("mds_mdsplandata".equals(metadatakey)) {
            resultArrays = new String[]{"materialid", "prodorg", "datenode"};
        } else if ("mds_forecastplandata".equals(metadatakey)) {
            resultArrays = new String[]{"materialid", "datenode"};
        } else if ("mds_dpsplandata".equals(metadatakey)) {
            resultArrays = new String[]{"materialid", "datenode"};
        } else if ("mds_data".equals(metadatakey)) {
            resultArrays = new String[]{"materialid_id", "prodorg_id", "datenode"};
        }
        return resultArrays;
    }

    public static String getUniqueValue(DynamicObject obj, String[] keys) {
        StringBuilder sbStr = new StringBuilder();
        for (String key : keys) {
            if (key.equals("datenode")) {
                Date date = obj.getDate(key);
                String datekey = String.valueOf(date.getTime());
                sbStr.append(datekey);
                continue;
            }
            sbStr.append(obj.getLong(key)).append('@');
        }
        return sbStr.toString();
    }

    public static String getDetailSelectField(Map<String, Date> fieldKey) {
        String selectField = PlanDataToFcDataTranUtil.getFixColumnField();
        selectField = selectField + "," + PlanDataToFcDataTranUtil.getFlexColumnField(fieldKey);
        return selectField;
    }

    public static String getHeadSelectField() {
        return "fcvrnnum.id,fcvrnnum.number,fcvrnnum.cytype,org.id,billstatus,invaldate,enablestatus,modifier,modifytime";
    }

    public static String getFlexColumnField(Map<String, Date> fieldKey) {
        Set<String> keys = fieldKey.keySet();
        StringBuilder sbStr = new StringBuilder();
        int index = 0;
        for (String key : keys) {
            if (index < keys.size() - 1) {
                sbStr.append("entryentity.").append(key).append(',');
            } else {
                sbStr.append("entryentity.").append(key);
            }
            ++index;
        }
        return sbStr.toString();
    }

    public static String getFixColumnField() {
        return "entryentity.seq,entryentity.material,entryentity.baseunit,entryentity.prodorg,entryentity.plangp,entryentity.remark,entryentity.summary";
    }

    public static List<GridConfigurationRow> getFixColumn() {
        ArrayList<GridConfigurationRow> rows = new ArrayList<GridConfigurationRow>(100);
        String[] fixcolumns = new String[]{"material", "materialname", "baseunit", "prodorg", "offering", "level0", "level1", "level2", "level3", "level4", "plangp", "cycletyped", "remark", "level1edit", "offeringedit", "mdsuser", "spdt", "edituser", "editcreatedate", "entrymodifier", "editdate", "remark", "summary", "hisqty1", "hisqty2", "hisqty3", "hisqty4", "hisqty5", "hisqty6", "hisqty7", "hisqty8", "hisqty9"};
        ArrayList<String> list = new ArrayList<String>(16);
        list.addAll(Arrays.asList(fixcolumns));
        for (String fixcolumn : fixcolumns = list.toArray(new String[0])) {
            GridConfigurationRow gridrow = new GridConfigurationRow();
            gridrow.setFieldKey(fixcolumn);
            if ("prodorg".equals(fixcolumn) || "material".equals(fixcolumn) || "materialname".equals(fixcolumn) || "baseunit".equals(fixcolumn) || "summary".equals(fixcolumn)) {
                gridrow.setFreeze(true);
            }
            rows.add(gridrow);
        }
        return rows;
    }

    public static List<GridConfigurationRow> getFixColumn(String formId) {
        if (StringUtils.isEmpty((CharSequence)formId)) {
            return PlanDataToFcDataTranUtil.getFixColumn();
        }
        ArrayList<GridConfigurationRow> rows = new ArrayList<GridConfigurationRow>(128);
        List<String> fixColumns = PlanDataFieldsSetter.getAllFields(formId);
        List<String> freezeFixColumns = PlanDataFieldsSetter.getFreezeFields(formId);
        if (fixColumns.size() == 0) {
            return PlanDataToFcDataTranUtil.getFixColumn();
        }
        for (String fixColumn : fixColumns) {
            GridConfigurationRow gridRow = new GridConfigurationRow();
            gridRow.setFieldKey(fixColumn);
            if (freezeFixColumns.contains(fixColumn)) {
                gridRow.setFreeze(true);
            }
            rows.add(gridRow);
        }
        return rows;
    }

    public static Map<Long, String> updateDistributionLocation(Set<Date> dates, DynamicObject plandata) {
        HashMap<Long, String> dateMap = new HashMap<Long, String>(16);
        List<EntityItem<?>> items = PlanDataToFcDataTranUtil.getMetaCategoryField();
        ArrayList<String> metaQtyField = new ArrayList<String>();
        HashMap dateEntityMap = new HashMap();
        ArrayList<Date> resultDate = new ArrayList<Date>();
        for (EntityItem<?> item : items) {
            String key = item.getKey();
            if (!key.contains(CO_QTY)) continue;
            metaQtyField.add(key);
        }
        DynamicObjectCollection colls = plandata.getDynamicObjectCollection(CO_DATEENTITY);
        colls.clear();
        ArrayList<Date> listDate = new ArrayList<Date>();
        listDate.addAll(dates);
        Collections.sort(listDate, new Comparator<Date>(){

            @Override
            public int compare(Date o1, Date o2) {
                return o1.compareTo(o2);
            }
        });
        for (Date date : listDate) {
            if (dateEntityMap.containsKey(date)) continue;
            resultDate.add(date);
        }
        int index = 0;
        for (Date date : resultDate) {
            String fieldkey = (String)metaQtyField.get(0);
            DynamicObject newObj = colls.addNew();
            newObj.set(CO_SEQ, (Object)(++index));
            newObj.set(CO_FIELDKEY, (Object)fieldkey);
            newObj.set(CO_TARGETDATE, (Object)date);
            newObj.set(CO_DELIVERYCOLUMN, (Object)Boolean.FALSE);
            metaQtyField.remove(fieldkey);
            dateMap.put(date.getTime(), fieldkey);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{plandata});
        return dateMap;
    }

    public static List<EntityItem<?>> getMetaCategoryField() {
        try {
            String entityId = MetadataDao.getIdByNumber((String)CO_MDS_PLANDATA, (MetaCategory)MetaCategory.Entity);
            EntityMetadata xEntityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)entityId, (MetaCategory)MetaCategory.Entity);
            List items = xEntityMetadata.getItems();
            return items;
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8be5\u5b9e\u4f53\u5bf9\u8c61\u7684\u5143\u6570\u636e\u5df2\u5931\u6548\u6216\u5f03\u7528\uff0c\u7cfb\u7edf\u65e0\u6cd5\u8bfb\u53d6\u8be5\u5143\u6570\u636e\u3002", (String)"PlanDataToFcDataTranUtil_1", (String)"mmc-mds-common", (Object[])new Object[0]));
        }
    }
}

