/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.schedule.executor.JobClient;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.util.CalcuColumns;

public class PlanExecCommonUtil {
    private static final Logger logger = Logger.getLogger(PlanExecCommonUtil.class.getName());
    public static final String CO_DAYSOFMON = "daysofmon";
    public static final String CO_DAYSOFWEEK = "daysofweek";
    public static final String CO_REPEATTYPE = "repeattype";
    public static final String CO_REPEAT = "repeat";
    public static final String CO_RUNNINGTYPE = "runningtype";
    public static final String CO_PREDTIME = "predtime";
    public static final String CO_LOSEDATE = "losedate";
    public static final String CO_STATUS = "status";
    public static final String CO_ENABLE = "enable";
    public static final String CO_PLANID = "planid";
    public static final String CO_TOOLBAR = "toolbarap";
    public static final String CO_SUSPEND = "suspend";
    public static final String CO_CALCULATESETTING = "calculatesetting";
    public static final String CO_HIDDEN = "hidden";
    public static final String CO_ID = "id";
    public static final String CO_MDS_PLANEXEC = "mds_planexec";
    public static final String CO_DPS_PLANEXEC = "mds_dpsplanexec";
    public static final String CO_NUMBER = "number";
    public static final String CO_EXE = "tasktype";
    public static final String BASE_TASK = "kd.mmc.mds.formplugin.basedata.task.BaseCalcRunningTask";
    protected static final List<String> propList = new ArrayList<String>();
    public static final String KEY_MATERIALID = "materialid";
    public static final String KEY_MATERIALNAME = "materialname";
    private static String classNameTask;

    public static Map<String, Object> getSetParamsByScheme(DynamicObject scheme, String hd) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(CO_HIDDEN, hd);
        params.put(CO_ID, scheme.getPkValue());
        params.put(CO_DAYSOFWEEK, scheme.get(CO_DAYSOFWEEK));
        params.put(CO_DAYSOFMON, scheme.get(CO_DAYSOFMON));
        params.put(CO_RUNNINGTYPE, scheme.get(CO_RUNNINGTYPE));
        params.put(CO_REPEATTYPE, scheme.get(CO_REPEATTYPE));
        params.put(CO_REPEAT, scheme.get(CO_REPEAT));
        params.put(CO_PREDTIME, scheme.get(CO_PREDTIME) == null ? Integer.valueOf(-1) : scheme.get(CO_PREDTIME));
        params.put(CO_LOSEDATE, scheme.get(CO_LOSEDATE));
        params.put(CO_STATUS, scheme.get(CO_STATUS));
        return params;
    }

    public static JobInfo initJobInfo(DynamicObject task, int calsType, String uniquekey) {
        String reqId = task.getString(uniquekey);
        Boolean repeat = task.getBoolean(CO_REPEAT);
        String jobNum = "JOB-" + reqId;
        JobInfo jobInfo = new JobInfo();
        HashMap<String, Object> params = new HashMap<String, Object>();
        DynamicObject obj = task.getDynamicObject("rplancal");
        params.put("billno", obj.getPkValue());
        if (repeat == null || !repeat.booleanValue()) {
            params.put(CO_REPEAT, Boolean.FALSE);
        } else {
            params.put(CO_REPEAT, Boolean.TRUE);
        }
        params.put(CO_EXE, calsType);
        params.put("schemeid", task.getPkValue());
        jobInfo.setId(jobNum);
        jobInfo.setNumber(jobNum);
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u7b97\u4f5c\u4e1a%s", (String)"PlanExecCommonUtil_0", (String)"mmc-mds-common", (Object[])new Object[0]), reqId));
        jobInfo.setJobType(JobType.BIZ);
        jobInfo.setRunConcurrently(true);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        String className = CalcuColumns.getTaskId();
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setTaskClassname(BASE_TASK);
        jobInfo.setAppId("mds");
        jobInfo.setParams(params);
        return jobInfo;
    }

    public static PlanInfo initPlanInfo(String jobId, DynamicObject task) {
        PlanInfo planInfo = new PlanInfo();
        String reqId = task.getString(CO_NUMBER);
        String rt = task.getString(CO_RUNNINGTYPE);
        Date losd = task.getDate(CO_LOSEDATE);
        String planNum = "PLAN-" + reqId;
        planInfo.setNumber(planNum);
        planInfo.setJobId(jobId);
        CalcuColumns.setLostdate(planInfo, losd);
        Integer pred = task.getInt(CO_PREDTIME);
        Calendar starttime = CalcuColumns.getStarttime(pred, rt);
        planInfo.setStartTime(starttime);
        planInfo.setName(String.format(ResManager.loadKDString((String)"\u9884\u6d4b\u8ba1\u7b97\u8ba1\u5212%s", (String)"PlanExecCommonUtil_1", (String)"mmc-mds-common", (Object[])new Object[0]), reqId));
        task.set("jobid", (Object)jobId);
        String repeattype = task.getString(CO_REPEATTYPE);
        if (rt.equals("0")) {
            task.set(CO_ENABLE, (Object)"B");
        } else {
            task.set(CO_ENABLE, (Object)"A");
        }
        task.set(CO_ENABLE, (Object)"B");
        if (!task.getBoolean(CO_REPEAT)) {
            planInfo.setRepeatMode(RepeatModeEnum.NONE);
            return planInfo;
        }
        if (CalcuColumns.isWeek(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
            String daysExp = task.getString(CO_DAYSOFWEEK);
            planInfo.setWeekdaysExp(daysExp);
            planInfo.setPeriod(1);
        } else {
            planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
            String daysExp = task.getString(CO_DAYSOFMON);
            planInfo.setDaysExp(daysExp);
            planInfo.setPeriod(1);
        }
        return planInfo;
    }

    public static void runImediatly(DynamicObject bill, Object schemeid) {
        JobInfo jobInfo = new JobInfo();
        String jobId = bill.getString(CO_NUMBER);
        jobInfo.setId(jobId);
        jobInfo.setName(ResManager.loadKDString((String)"DPSSite\u8fd0\u7b97", (String)"PlanExecCommonUtil_2", (String)"mmc-mds-common", (Object[])new Object[0]));
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        boolean connc = true;
        jobInfo.setRunConcurrently(connc);
        String className = PlanExecCommonUtil.getTaskId();
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setTaskClassname(classNameTask);
        jobInfo.setAppId("mds");
        if (schemeid != null) {
            DynamicObject schemebill = BusinessDataServiceHelper.loadSingle((Object)schemeid, (String)CO_DPS_PLANEXEC);
            schemebill.set(CO_STATUS, (Object)CalcuColumns.Billstatus.PLAN.getCode());
            schemebill.set(CO_ENABLE, (Object)CalcuColumns.CalcStatus.RUNNING.getCode());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{schemebill});
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("DPSSiteSchemeID", bill.getLong(CO_ID));
        params.put("DPSSiteExecID", schemeid);
        jobInfo.setParams(params);
        boolean isLock = CalcuColumns.createLock("mds_siteschemedef", "update", String.valueOf(bill.getLong(CO_ID)));
        if (!isLock) {
            return;
        }
        JobClient.dispatch((JobInfo)jobInfo);
    }

    public static String getTaskId() {
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)CO_NUMBER, (QFilter[])new QFilter[]{new QFilter("classname", "=", (Object)classNameTask)});
        if (taskname == null) {
            return null;
        }
        return String.valueOf(taskname.getPkValue());
    }

    static {
        propList.add(CO_NUMBER);
        propList.add(CO_ID);
        propList.add("pkid");
        propList.add("execlogeentry.id");
        classNameTask = "kd.mmc.mds.common.dspsite.DPSSiteHandlerTask";
    }
}

