/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.util;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.dataentity.SingleORM;
import kd.bos.param.ParameterUtils;

public class SliceUtil {
    private static final Log logger = LogFactory.getLog(SliceUtil.class);

    public static <T extends Collection<?>> List<T> slice(T src, int sliceCount) {
        int start;
        if (src == null) {
            return Collections.emptyList();
        }
        if (sliceCount <= 0) {
            throw new IllegalArgumentException("Param sliceCount can not less than or equals zero.");
        }
        int srcSize = src.size();
        if (srcSize <= sliceCount) {
            return Collections.singletonList(src);
        }
        Object[] array = src.toArray();
        int sliceTotal = (srcSize + sliceCount - 1) / sliceCount;
        ArrayList<Collection> result = new ArrayList<Collection>();
        for (int i = 0; i < sliceTotal && (start = i * sliceCount) != array.length; ++i) {
            int end = (i + 1) * sliceCount - 1 >= array.length ? array.length : (i + 1) * sliceCount;
            Object[] cp = Arrays.copyOfRange(array, start, end);
            try {
                Collection r = (Collection)src.getClass().newInstance();
                r.addAll(Arrays.asList(cp));
                result.add(r);
                continue;
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return result;
    }

    public static Long getDateLong(Date mdate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        String s = sdf.format(mdate);
        Date date = null;
        try {
            date = sdf.parse(s);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
        if (date == null) {
            return null;
        }
        return date.getTime();
    }

    public static int getSliceCount() {
        int paramValue = 100;
        String appId = "0MBB4=9D3YI9";
        String paramKey = "slice";
        Object obj = SliceUtil.getAppParma(appId, paramKey);
        paramValue = obj == null ? 100 : (Integer)obj;
        return paramValue;
    }

    public static Object getAppParma(String appid, String paramKey) {
        String sql = "select fdata from t_bas_sysparameter a where a.fparamid in (SELECT fid FROM T_BAS_SYSPARACONSOLE WHERE FAPPID=? AND FENABLED='1')";
        ArrayList<SqlParameter> params = new ArrayList<SqlParameter>();
        params.add(new SqlParameter("FAPPID", 12, (Object)appid));
        DynamicObjectCollection existData = SingleORM.query((DynamicObjectType)null, (String)sql, (Object[])params.toArray(new SqlParameter[params.size()]));
        DynamicObject obj = ParameterUtils.serializeToDataEntity((DynamicObjectCollection)existData, (String)"mds_dpsparam");
        return obj.get(paramKey);
    }

    public static boolean isStartAlgo() {
        String appId = "0MBB4=9D3YI9";
        String paramKey = "startalgo";
        Object obj = SliceUtil.getAppParma(appId, paramKey);
        Object paramValue = obj == null ? Boolean.FALSE : obj;
        return (Boolean)paramValue;
    }

    public static void main(String[] args) {
    }

    public static void sortBigDecimal(List<JSONObject> resultList, final String getField) {
        Collections.sort(resultList, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                BigDecimal a1Qty = o1.getBigDecimal(getField);
                BigDecimal a2Qty = o2.getBigDecimal(getField);
                return a2Qty.compareTo(a1Qty);
            }
        });
    }

    public static void sortComposeColl(List<JSONObject> resultList, final String field1, final String field2) {
        Collections.sort(resultList, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                if (o1.getDate(field1).compareTo(o2.getDate(field1)) == 0) {
                    return o2.getBigDecimal(field2).compareTo(o1.getBigDecimal(field2));
                }
                return o1.getDate(field1).compareTo(o2.getDate(field1));
            }
        });
    }

    public static void sortComposeCollPriority(List<JSONObject> resultList, final String field0, final String field1, final String field2) {
        Collections.sort(resultList, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                if (o1.getInteger(field0).compareTo(o2.getInteger(field0)) == 0) {
                    if (o1.getDate(field1).compareTo(o2.getDate(field1)) == 0) {
                        return o2.getBigDecimal(field2).compareTo(o1.getBigDecimal(field2));
                    }
                    return o1.getDate(field1).compareTo(o2.getDate(field1));
                }
                return o1.getInteger(field0).compareTo(o2.getInteger(field0));
            }
        });
    }

    public static void sortLong(List<JSONObject> resultList, final String getField) {
        Collections.sort(resultList, new Comparator<JSONObject>(){

            @Override
            public int compare(JSONObject o1, JSONObject o2) {
                Long date1 = o1.getLong(getField);
                Long date2 = o2.getLong(getField);
                return date1.compareTo(date2);
            }
        });
    }
}

