/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.common.weekroll;

import com.alibaba.fastjson.JSONObject;
import java.lang.constant.Constable;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.JobDispatcher;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.api.PlanInfo;
import kd.bos.schedule.api.RepeatModeEnum;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.thread.ThreadLifeCycleManager;
import kd.bos.threads.ThreadPools;
import kd.mmc.mds.common.setoff.SetOffCommonUtil;
import kd.mmc.mds.common.util.CalcuColumns;
import kd.mmc.mds.common.weekroll.WeekrollMain;

public class WeekrollExecUtil {
    private static final String CO_PLANID = "planid";
    private static final String COL_JOBID = "jobid";
    public static final String BASE_TASK = "kd.mmc.mds.common.weekroll.WeekrollTask";
    public static final String CO_BASENUMBER = "number";
    private static final Log logger = LogFactory.getLog(WeekrollExecUtil.class);
    private static final String[] MONTHDAY = new String[]{"m1", "m2", "m3", "m4", "m5", "m6", "m7", "m8", "m9", "m10", "m11", "m12", "m13", "m14", "m15", "m16", "m17", "m18", "m19", "m20", "m21", "m22", "m23", "m24", "m25", "m26", "m27", "m28", "m29", "m30", "m31"};
    private static final String[] WEEKDAY = new String[]{"day7", "day1", "day2", "day3", "day4", "day5", "day6"};
    public static final String CO_RUNNINGTYPE = "runningtype";

    public static void exec(Long weekrollid, Boolean runatonce) {
        ThreadPools.executeOnceIncludeRequestContext((String)"WeekrollExecUtil", (Runnable)ThreadLifeCycleManager.wrapRunnable(() -> {
            WeekrollMain romain = new WeekrollMain();
            romain.execWeekRoll(weekrollid, runatonce);
        }));
    }

    public static String getTaskId(String className) {
        DynamicObject taskname = BusinessDataServiceHelper.loadSingle((String)"sch_taskdefine", (String)CO_BASENUMBER, (QFilter[])new QFilter[]{new QFilter("classname", "=", (Object)className)});
        if (taskname == null) {
            return null;
        }
        return String.valueOf(taskname.getPkValue());
    }

    public static String createJob(Long weekrollid, JSONObject parseObject) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setTaskClassname(BASE_TASK);
        jobInfo.setJobType(JobType.BIZ);
        HashMap<String, Constable> scheduleParams = new HashMap<String, Constable>();
        String jobNum = "weekrollwork-" + SetOffCommonUtil.getDateString();
        jobInfo.setName(String.format(ResManager.loadKDString((String)"\u5468\u6eda\u52a8\u4f5c\u4e1a%s", (String)"WeekrollExecUtil_2", (String)"mmc-mds-common", (Object[])new Object[0]), weekrollid.toString()));
        jobInfo.setNumber(jobNum);
        scheduleParams.put("weekrollid", weekrollid);
        scheduleParams.put("runatonce", Boolean.valueOf(false));
        jobInfo.setParams(scheduleParams);
        jobInfo.setRunByOrgId(RequestContext.get().getOrgId());
        jobInfo.setRunByUserId(RequestContext.get().getCurrUserId());
        jobInfo.setRunByLang(Lang.get());
        jobInfo.setRunConcurrently(true);
        String className = WeekrollExecUtil.getTaskId(BASE_TASK);
        if (className != null) {
            jobInfo.setTaskDefineId(className);
        }
        jobInfo.setAppId("mds");
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createJob", new Object[]{jobInfo});
        return String.valueOf(obj);
    }

    public static Date getLostdate(Date lostdate) {
        Calendar lc = Calendar.getInstance();
        if (lostdate == null) {
            lc.set(1, 2099);
            lc.set(2, 11);
            lc.set(5, 31);
        } else {
            lc.setTime(lostdate);
            lc.add(5, 1);
        }
        return SetOffCommonUtil.formatDate(lc.getTime());
    }

    public static String createPlan(String jobId, JSONObject parseObject) {
        int i;
        PlanInfo planInfo = new PlanInfo();
        String losds = parseObject.getString("losedate");
        String planNum = "weekrollplan-" + SetOffCommonUtil.getDateString();
        planInfo.setNumber(planNum);
        planInfo.setJobId(jobId);
        Date lostdate = null;
        if (!"-1".equals(losds)) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                lostdate = WeekrollExecUtil.getLostdate(format.parse(parseObject.getString("losedate")));
            }
            catch (Exception e) {
                logger.warn((Throwable)e);
            }
        } else {
            lostdate = WeekrollExecUtil.getLostdate(null);
        }
        Integer pred = parseObject.getInteger("predtime");
        Calendar starttime = CalcuColumns.getStarttime(pred, "1");
        planInfo.setStartTime(starttime);
        planInfo.setName(String.format(ResManager.loadKDString((String)"\u5468\u6eda\u52a8\u8ba1\u5212%s", (String)"WeekrollExecUtil_3", (String)"mmc-mds-common", (Object[])new Object[0]), SetOffCommonUtil.getDateString()));
        Calendar endTime = Calendar.getInstance();
        endTime.set(5, starttime.get(5) + 1);
        planInfo.setEndTime(endTime);
        String repeattype = parseObject.getString("repeattype");
        Boolean isrept = parseObject.getBoolean("repeat");
        if (!isrept.booleanValue()) {
            planInfo.setRepeatMode(RepeatModeEnum.NONE);
        } else if ("0".equals(repeattype)) {
            planInfo.setRepeatMode(RepeatModeEnum.ByWeeks);
            i = 0;
            HashSet<String> daysExp = new HashSet<String>(10);
            for (String ditem : WEEKDAY) {
                ++i;
                if (!parseObject.getBooleanValue(ditem)) continue;
                daysExp.add(String.valueOf(i));
            }
            String string = String.join((CharSequence)",", daysExp);
            planInfo.setWeekdaysExp(string);
            planInfo.setPeriod(1);
        } else {
            planInfo.setRepeatMode(RepeatModeEnum.ByMonths);
            i = 0;
            HashSet<String> monthExp = new HashSet<String>(32);
            for (String ditem : MONTHDAY) {
                ++i;
                if (!parseObject.getBooleanValue(ditem)) continue;
                monthExp.add(String.valueOf(i));
            }
            String string = String.join((CharSequence)",", monthExp);
            planInfo.setDaysExp(string);
            planInfo.setPeriod(1);
        }
        DispatchService service = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)"bos");
        Object obj = service.invoke("kd.bos.service.ServiceFactory", JobDispatcher.class.getSimpleName(), "createPlan", new Object[]{planInfo});
        try {
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)obj, (String)"sch_schedule", (String)"endtime");
            dynamicObject.set("endtime", (Object)lostdate);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dynamicObject});
        }
        catch (Exception exception) {
            logger.warn((Throwable)exception);
        }
        return String.valueOf(obj);
    }

    public static String getExecfiledName(String exestr, String dfield) {
        if (exestr.indexOf(43) >= 0 || exestr.indexOf(45) >= 0 || exestr.indexOf(42) >= 0 || exestr.indexOf(47) >= 0) {
            StringBuilder sBuilder = new StringBuilder();
            sBuilder.append("tmpexe");
            sBuilder.append(dfield);
            return sBuilder.toString();
        }
        return exestr;
    }
}

