/*
 * Decompiled with CFR 0.152.
 */
package kd.mmc.mds.formplugin;

import java.math.BigDecimal;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.entity.datamodel.events.BizDataEventArgs;
import kd.bos.entity.operate.DefaultEntityOperate;
import kd.bos.form.control.ProgressBar;
import kd.bos.form.control.Toolbar;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.ItemClickListener;
import kd.bos.form.control.events.ProgressEvent;
import kd.bos.form.control.events.ProgresssListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.operate.MutexHelper;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.mmc.mds.common.util.CalcuColumns;

public class DPSPlanExecEditPlugin
extends AbstractFormPlugin
implements ProgresssListener {
    private static final DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache("planexecnumber");

    public void createNewData(BizDataEventArgs e) {
        this.getPageCache().put("newOrgValue", String.valueOf(RequestContext.get().getOrgId()));
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
        super.beforeClosed(e);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        if (progressBar != null) {
            progressBar.addProgressListener((ProgresssListener)this);
        }
        Toolbar tb = (Toolbar)this.getView().getControl("tbmain");
        tb.addItemClickListener((ItemClickListener)this);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        if (args.getSource() instanceof DefaultEntityOperate) {
            DefaultEntityOperate operate = (DefaultEntityOperate)args.getSource();
            String operatekey = operate.getOperateKey();
            DynamicObject destobj = this.getModel().getDataEntity();
            if ("calculating".equals(operatekey)) {
                boolean createLock;
                long id = (Long)this.getModel().getValue("id");
                if (id == 0L) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u4fdd\u5b58\uff0c\u518d\u8fdb\u884c\u8fd0\u7b97\u3002", (String)"DPSPlanExecEditPlugin_0", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                this.getView().setVisible(Boolean.FALSE, new String[]{"bar_save"});
                DynamicObject scheme = destobj.getDynamicObject("dpssitescheme");
                if (scheme != null && !(createLock = MutexHelper.require((String)"mds_siteschemedef", (Object)scheme.getPkValue(), (String)"modify", (boolean)true, (StringBuilder)new StringBuilder(ResManager.loadKDString((String)"\u6570\u636e\u88ab\u9501\u5b9a\u3002", (String)"DPSPlanExecEditPlugin_1", (String)"mmc-mds-formplugin", (Object[])new Object[0]))))) {
                    args.setCancel(true);
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u5206\u914d\u65b9\u6848\u6b63\u5728\u88ab\u5176\u4ed6\u8fd0\u7b97\u65b9\u6848\u4f7f\u7528\uff0c\u7a0d\u540e\u8bf7\u91cd\u8bd5\u3002", (String)"DPSPlanExecEditPlugin_2", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                    return;
                }
                String enable = this.getModel().getDataEntity().getString("enable");
                if (!"".equals(enable) && !"A".equals(enable)) {
                    ORM orm = ORM.create();
                    DynamicObject targetobj = orm.newDynamicObject("mds_dpsplanexec");
                    targetobj.set("dpssitescheme", destobj.get("dpssitescheme"));
                    targetobj.set("createorg", destobj.get("createorg"));
                    targetobj.set("number", (Object)this.getUnRepeatNumber(targetobj));
                    targetobj.set("creator", (Object)RequestContext.get().getCurrUserId());
                    targetobj.set("createtime", (Object)new Date());
                    targetobj.set("modifier", (Object)RequestContext.get().getCurrUserId());
                    targetobj.set("modifytime", (Object)new Date());
                    targetobj.set("calculatepro", (Object)0);
                    this.getModel().createNewData((Object)targetobj);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{targetobj});
                } else {
                    if (this.getModel().getDataEntity().get("dpssitescheme") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u4f9b\u5e94\u7ec4\u7ec7\u5206\u914d\u65b9\u6848\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DPSPlanExecEditPlugin_3", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    if (this.getModel().getDataEntity().get("createorg") == null) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u521b\u5efa\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"DPSPlanExecEditPlugin_4", (String)"mmc-mds-formplugin", (Object[])new Object[0]));
                        return;
                    }
                    DynamicObject obj = this.getModel().getDataEntity(true);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
                }
            }
        }
    }

    public synchronized String getUnRepeatNumber(DynamicObject targetobj) {
        DynamicObject dataInfo = targetobj;
        Long orgId = RequestContext.get().getOrgId();
        String newNum = CodeRuleServiceHelper.getNumber((String)"mds_dpsplanexec", (DynamicObject)dataInfo, null);
        while (this.getCacheString(newNum) != null) {
            newNum = CodeRuleServiceHelper.readNumber((String)"mds_dpsplanexec", (DynamicObject)dataInfo, (String)String.valueOf(orgId));
        }
        cache.put(newNum, (Object)newNum);
        return newNum;
    }

    private String getCacheString(String newNum) {
        return (String)cache.get(newNum);
    }

    public void afterCreateNewData(EventObject e) {
        this.getModel().getDataEntity().set("predtime", (Object)-1);
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        if ("calculating".equals(args.getOperateKey())) {
            this.getView().invokeOperation("refresh");
            DynamicObjectCollection colls = this.getModel().getDataEntity().getDynamicObjectCollection("treeentryentity");
            colls.clear();
            this.getView().updateView("treeentryentity");
            progressBar.stop();
            progressBar.setPercent(0);
            progressBar.start();
        }
    }

    public void itemClick(ItemClickEvent evt) {
        switch (evt.getItemKey()) {
            case "suspend": {
                this.termination();
                break;
            }
        }
    }

    private void termination() {
        DynamicObject obj = this.getModel().getDataEntity();
        if (obj.getPkValue() == null || obj.getLong("id") == 0L) {
            return;
        }
        Object[] objs = new DynamicObject[]{obj};
        if (CalcuColumns.isEmpty((Object[])objs)) {
            return;
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Long process = this.queryProgress();
        this.getModel().setValue("calculatepro", (Object)process);
        DynamicObjectCollection colls = this.getModel().getDataEntity().getDynamicObjectCollection("treeentryentity");
        ProgressBar progressBar = (ProgressBar)this.getControl("progressbarap");
        progressBar.setPercent(process.intValue());
        this.getModel().setDataChanged(false);
    }

    private int getParentTreeSize(DynamicObjectCollection dyn) {
        int index = 0;
        for (DynamicObject obj : dyn) {
            if (obj.getLong("treeentryentity.pid") != 0L) continue;
            ++index;
        }
        return index;
    }

    public void onProgress(ProgressEvent arg0) {
        arg0.setProgress(this.queryProgress().intValue());
        DynamicObjectCollection colls = this.getModel().getDataEntity().getDynamicObjectCollection("treeentryentity");
        HashSet<Long> entrysetid = new HashSet<Long>();
        for (DynamicObject obj : colls) {
            entrysetid.add(obj.getLong("id"));
        }
        String selectHeadField = "calculatepro,startdate,enddate,summin,";
        String selectEntryField = "treeentryentity.id,treeentryentity.entrytreedetailmsg,treeentryentity.entrytreeresult,treeentryentity.entrytreeoperatmin,treeentryentity.entrytreename,treeentryentity.pid,treeentryentity.entrytreeseq";
        Object pkvalue = this.getModel().getDataEntity().getPkValue();
        QFilter qfilter = new QFilter("id", "=", pkvalue);
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)"mds_dpsplanexec", (String)(selectHeadField + selectEntryField), (QFilter[])new QFilter[]{qfilter});
        TableValueSetter vs = new TableValueSetter(new String[0]);
        int row = 0;
        for (int n = 0; n < dyn.size(); ++n) {
            DynamicObject obj = (DynamicObject)dyn.get(n);
            Long entryid = obj.getLong("treeentryentity.id");
            if (entrysetid.contains(entryid)) continue;
            vs.set("id", (Object)entryid, row);
            vs.set("entrytreedetailmsg", (Object)obj.getString("treeentryentity.entrytreedetailmsg"), row);
            vs.set("entrytreeresult", (Object)obj.getString("treeentryentity.entrytreeresult"), row);
            vs.set("entrytreeoperatmin", (Object)obj.getBigDecimal("treeentryentity.entrytreeoperatmin"), row);
            vs.set("entrytreename", (Object)obj.getString("treeentryentity.entrytreename"), row);
            vs.set("pid", (Object)obj.getLong("treeentryentity.pid"), row);
            vs.set("entrytreeseq", (Object)obj.getLong("treeentryentity.entrytreeseq"), row);
            ++row;
        }
        ((AbstractFormDataModel)this.getModel()).batchCreateNewEntryRow("treeentryentity", vs);
        if (dyn.size() > 0) {
            DynamicObject obj = (DynamicObject)dyn.get(0);
            this.getModel().getDataEntity().set("calculatepro", (Object)this.queryProgress());
            this.getModel().getDataEntity().set("startdate", (Object)obj.getDate("startdate"));
            this.getModel().getDataEntity().set("enddate", (Object)obj.getDate("enddate"));
            this.getModel().getDataEntity().set("summin", (Object)obj.getBigDecimal("summin"));
            this.getView().updateView("calculatepro");
            this.getView().updateView("startdate");
            this.getView().updateView("enddate");
            this.getView().updateView("summin");
        }
    }

    private Long queryProgress() {
        QFilter qfilter = new QFilter("id", "=", this.getModel().getValue("id"));
        String orderSeq = "treeentryentity.pid asc";
        Long pre = 0L;
        DynamicObjectCollection dyn = QueryServiceHelper.query((String)"mds_dpsplanexec", (String)"enable,processcount,treeentryentity.pid,treeentryentity.entrytreeseq", (QFilter[])new QFilter[]{qfilter}, (String)orderSeq);
        if (dyn.size() > 0) {
            DynamicObject obj = (DynamicObject)dyn.get(0);
            Integer processcount = obj.getInt("processcount") == 0 ? 0 : obj.getInt("processcount");
            String enable = obj.getString("enable");
            this.getModel().setValue("enable", (Object)enable);
            int count = this.getParentTreeSize(dyn);
            double tmpcount = processcount == 0 ? 0.0 : (double)count / (double)processcount.intValue();
            BigDecimal doublePre = BigDecimal.valueOf(tmpcount);
            doublePre = doublePre.multiply(new BigDecimal(100));
            pre = doublePre.setScale(0, 1).longValue();
            if ((enable.equals("A") || enable.equals("B")) && pre > 0L) {
                pre = pre - 1L;
            }
            this.getModel().setDataChanged(false);
        }
        return pre;
    }
}

